<?php
/**
 * Plugin Name: WooCommerce Delivery Time
 * Plugin URI: https://prowcplugins.com/downloads/woocommerce-delivery-time/
 * Description: Allow customers pick time for delivery when shipping
 * Version: 3.2.2
 * Author: ProWCPlugins
 * Author URI: https://prowcplugins.com
 *
 * @package WooCommerce Delivery Time
 */

register_activation_hook( __FILE__, 'wdt_check_php_version' );

/**
 * Display notice for old PHP version.
 */
function wdt_check_php_version() {
	if ( version_compare( phpversion(), '5.4', '<' ) ) {
		die( esc_html__( 'WooCommerce Delivery Time requires PHP version 5.4+. Please contact your host and ask them to upgrade.', 'wdt' ) );
	}
}

add_action( 'plugins_loaded', 'wdt_init' );

/**
 * Load plugin files.
 */
function wdt_init() {
	if ( ! class_exists( 'WooCommerce' ) ) {
		return;
	}

	require 'vendor/autoload.php';

	$url = plugin_dir_url( __FILE__ );

	$plugins = new WDTCore\Plugins();
	$plugins->init();

	$core_url = new WDTCore\Url( $url, __DIR__ );

	// Plugin settings.
	$settings = new WDT\Settings(
		'woocommerce-delivery-time',
		'wdt',
		'<a href="https://prowcplugins.com/docs/woocommerce-delivery-time/?utm_source=settings_page&utm_medium=link&utm_campaign=docs_link" target="_blank">' . __( 'See documentation', 'woocommerce-delivery-time' ) . ' &rarr;</a>',
		$core_url->base_url() . '/assets'
	);
	$settings->init();

	$assets = new WDT\Assets(
		$url,
		'wdt',
		$settings,
		$core_url
	);

	$formatter = new WDTCore\Formatter( $settings );

	// Register plugin shortcodes.
	$shortcodes = new WDT\Shortcodes( 'wdt', $assets, $settings, $formatter );
	$shortcodes->init();

	// Handle output and save data on checkout page.
	$checkout = new WDT\Checkout( $settings, $formatter, $shortcodes );
	$checkout->init();

	// Add delivery time to emails & templates.
	$template = new WDTCore\Template( $settings, $shortcodes );
	$template->init();

	if ( is_admin() ) {
		// Show and edit delivery time in the admin.
		$order_details = new WDTCore\OrderDetails( $settings, $shortcodes, $checkout );
		$order_details->init();

		// Show delivery time in the admin columns.
		$admin_column = new WDTCore\AdminColumn( $shortcodes, '_delivery_time' );
		$admin_column->init();

		if ( defined( 'DOING_AJAX' ) ) {
			$shipments = new WDTCore\Shipments( $settings );
			$shipments->init();
		}
	}
}
