<?php 
if( function_exists('acf_add_local_field_group') ):

acf_add_local_field_group(array(
	'key' => 'group_569653f31f73f',
	'title' => 'WooCommerce Shipping Tracking - Estimated shipping for products',
	'fields' => array(
		array(
			'key' => 'field_5696545e0dfc0',
			'label' => 'Estimation rules',
			'name' => 'wcst_shippings',
			'type' => 'repeater',
			'instructions' => '<ol>
<li>Configure estimated rules by selecting product and/or categories, dispatch days and other options.</li>
<li>Dates are computed according the current WordPress time zone setting. Make sure it is syncronized to your local time by checking the <strong>Settings</strong> -> <strong>General</strong> -> <strong>Timezone</strong> option</li>
<li>If <strong> no products, categories or tags are selected</strong> the estimated rules will be assigned to all the products</li>
<li>Please note that you can define multiple rules for same products/categories. Priority goest Top-Bottom, so Lower rules will have <strong>HIGHER</strong> priority </li>
</ol>',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'collapsed' => 'field_569654b40dfc1',
			'min' => 0,
			'max' => 0,
			'layout' => 'row',
			'button_label' => 'Add rule',
			'sub_fields' => array(
				array(
					'key' => 'field_569654b40dfc1',
					'label' => 'Name / id',
					'name' => 'wcst_name_id',
					'type' => 'text',
					'instructions' => '',
					'required' => 1,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'maxlength' => '',
					'placeholder' => '',
					'prepend' => '',
					'append' => '',
					'readonly' => 0,
					'disabled' => 0,
				),
				array(
					'key' => 'field_5697d924cd8c4',
					'label' => 'Products',
					'name' => 'wcst_products',
					'type' => 'post_object',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'post_type' => array(
						0 => 'product',
						1 => 'product_variation',
					),
					'taxonomy' => array(
					),
					'allow_null' => 1,
					'multiple' => 1,
					'return_format' => 'id',
					'ui' => 1,
				),
				array(
					'key' => 'field_59cb4ff3b3454',
					'label' => 'Tags',
					'name' => 'wcst_tags',
					'type' => 'taxonomy',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'taxonomy' => 'product_tag',
					'field_type' => 'multi_select',
					'allow_null' => 1,
					'add_term' => 0,
					'save_terms' => 0,
					'load_terms' => 0,
					'return_format' => 'id',
					'multiple' => 0,
				),
				array(
					'key' => 'field_5697d952cd8c5',
					'label' => 'Categories',
					'name' => 'wcst_categories',
					'type' => 'taxonomy',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'taxonomy' => 'product_cat',
					'field_type' => 'multi_select',
					'multiple' => 0,
					'allow_null' => 1,
					'return_format' => 'id',
					'add_term' => 1,
					'load_terms' => 0,
					'save_terms' => 0,
				),
				array(
					'key' => 'field_5698b3440f660',
					'label' => 'Children categories',
					'name' => 'wcst_children_categories',
					'type' => 'radio',
					'instructions' => 'If at least one category has been selected, you can assign the estimation rule also to children categories items',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'layout' => 'vertical',
					'choices' => array(
						'selected_only' => 'Apply to selected categories only',
						'all_children' => 'Apply to selected categories and all its children',
					),
					'default_value' => 'selected_only',
					'other_choice' => 0,
					'save_other_choice' => 0,
					'allow_null' => 0,
					'return_format' => 'value',
				),
				array(
					'key' => 'field_569660bfddfa1',
					'label' => 'Dispatch / Shipment days',
					'name' => 'wcst_working_days',
					'type' => 'checkbox',
					'instructions' => 'Days in which you dispatch items to courier for shippment. The estimated shipment day will be the first day available according to the Cut-off hour, Day delay value and the configured Holidays.',
					'required' => 1,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'layout' => 'vertical',
					'choices' => array(
						1 => 'Monday',
						2 => 'Tuesday',
						3 => 'Wednesday',
						4 => 'Thrusday',
						5 => 'Friday',
						6 => 'Saturday',
						0 => 'Sunday',
					),
					'default_value' => array(
					),
					'allow_custom' => 0,
					'save_custom' => 0,
					'toggle' => 0,
					'return_format' => 'value',
				),
				array(
					'key' => 'field_56966147ddfa2',
					'label' => 'Cut-off hour',
					'name' => 'wcst_day_cut_off_hour',
					'type' => 'number',
					'instructions' => '<p>If an order is placed before this hour it will be dispatched to courier within the same day (if the current day is a <strong>working day</strong>), othewise it will be	dispatched on the next avaiable date.</p><p>&nbsp;</p>
<p>Possible values: 0 - 23</p>',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '48',
						'class' => '',
						'id' => '',
					),
					'default_value' => 0,
					'placeholder' => '',
					'prepend' => '',
					'append' => '',
					'min' => 0,
					'max' => 23,
					'step' => '',
				),
				array(
					'key' => 'field_5697d86fcd8c3',
					'label' => 'Dispatch delay (expressed in days)',
					'name' => 'wcst_days_delay',
					'type' => 'number',
					'instructions' => '<p>If specified, the estimated date will be computed starting from the first dispatch day avaiable after the configured delay. </p><p>
<strong>Note:</strong> Today will be considered as starting date if it is a <strong>working day</strong> and cut-off hour has not been past, otherwise it will be conisder the next valid working day.</p>',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '48',
						'class' => '',
						'id' => '',
					),
					'default_value' => 0,
					'placeholder' => '',
					'prepend' => '',
					'append' => '',
					'min' => 0,
					'max' => 30,
					'step' => 1,
				),
				array(
					'key' => 'field_5ede01dfa8917',
					'label' => 'Dispatch delay: consider also not "Shipment days"',
					'name' => 'wcst_consider_non_working_days_as_dispatch_delay',
					'type' => 'true_false',
					'instructions' => 'Days not included among the "Shipment days" will be considered to compute the next available dispatch date. <strong>Note:</strong> the next available dispatch date will be <strong>always</strong> a working day.',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'default_value' => 0,
					'ui' => 1,
					'ui_on_text' => '',
					'ui_off_text' => '',
				),
				array(
					'key' => 'field_5b1e21ce0c0f4',
					'label' => 'Elastic date?',
					'name' => 'wcst_elastic_date',
					'type' => 'true_false',
					'instructions' => 'By default the plugin will show the next available date. Using elastic date option, the plugin will show a date range in which the products will be shipped.',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'default_value' => 0,
					'ui' => 1,
					'ui_on_text' => '',
					'ui_off_text' => '',
				),
				array(
					'key' => 'field_5b1e22080c0f5',
					'label' => 'Days span',
					'name' => 'wcst_elastic_date_day_offset',
					'type' => 'number',
					'instructions' => 'This is the days span in which the products will be shipped starting from the first available date. <strong>Note:</strong> The end date will be the first day available computed as the start date plus the day range considering the <i>Holidays / Non working days</i> and <i>Dispatch / Shipment day</i> options.',
					'required' => 1,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_5b1e21ce0c0f4',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => 1,
					'placeholder' => '',
					'prepend' => '',
					'append' => '',
					'min' => 1,
					'max' => '',
					'step' => 1,
				),
				array(
					'key' => 'field_56966171ddfa3',
					'label' => 'Holidays / Non working days',
					'name' => 'wcst_non_working_days',
					'type' => 'repeater',
					'instructions' => 'Special days in which shipment cannot take place.',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'min' => 0,
					'max' => 0,
					'layout' => 'table',
					'button_label' => 'Add Row',
					'collapsed' => '',
					'sub_fields' => array(
						array(
							'key' => 'field_56966190ddfa4',
							'label' => 'Day',
							'name' => 'wcst_day',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'multiple' => 0,
							'allow_null' => 0,
							'choices' => array(
								1 => '1',
								2 => '2',
								3 => '3',
								4 => '4',
								5 => '5',
								6 => '6',
								7 => '7',
								8 => '8',
								9 => '9',
								10 => '10',
								11 => '11',
								12 => '12',
								13 => '13',
								14 => '14',
								15 => '15',
								16 => '16',
								17 => '17',
								18 => '18',
								19 => '19',
								20 => '20',
								21 => '21',
								22 => '22',
								23 => '23',
								24 => '24',
								25 => '25',
								26 => '26',
								27 => '27',
								28 => '28',
								29 => '29',
								30 => '30',
								31 => '31',
							),
							'default_value' => array(
							),
							'ui' => 0,
							'ajax' => 0,
							'placeholder' => '',
							'return_format' => 'value',
							'disabled' => 0,
							'readonly' => 0,
						),
						array(
							'key' => 'field_569661cdddfa5',
							'label' => 'Month',
							'name' => 'wcst_month',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'multiple' => 0,
							'allow_null' => 0,
							'choices' => array(
								1 => '1',
								2 => '2',
								3 => '3',
								4 => '4',
								5 => '5',
								6 => '6',
								7 => '7',
								8 => '8',
								9 => '9',
								10 => '10',
								11 => '11',
								12 => '12',
							),
							'default_value' => array(
							),
							'ui' => 0,
							'ajax' => 0,
							'placeholder' => '',
							'return_format' => 'value',
							'disabled' => 0,
							'readonly' => 0,
						),
					),
				),
			),
		),
	),
	'location' => array(
		array(
			array(
				'param' => 'options_page',
				'operator' => '==',
				'value' => 'acf-options-estimated-shipping-for-products',
			),
		),
	),
	'menu_order' => 0,
	'position' => 'normal',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => '',
	'active' => true,
	'description' => '',
));

endif;
?>