<?php
use Automattic\WooCommerce\Utilities\OrderUtil;
use Automattic\WooCommerce\Internal\DataStores\Orders\CustomOrdersTableController;

class WCST_OrderPage
{
	
	var $track;
	function __construct() 
	{
		add_action( 'add_meta_boxes', array( &$this, 'woocommerce_metaboxes' ) );
		add_action( 'woocommerce_process_shop_order_meta', array( &$this, 'woocommerce_process_shop_ordermeta' ), 10, 2 ); //99: using 99 info are not embedded into emails
		add_action( 'woocommerce_process_shop_order_meta', array( &$this, 'late_order_meta_processing' ), 99, 2 ); //just used to swich order status 
		//add_action( 'admin_menu', array( &$this, 'ship_select_menu')); 
	
	}
	
	function woocommerce_process_shop_ordermeta( $post_id, $post ) 
	{
		$wcst_order_model = new WCST_Order();
		$wcst_order_model->save_shippings_info_metas( $post_id, $_POST);	
	}
	function late_order_meta_processing( $post_id, $post ) 
	{
		$wcst_order_model = new WCST_Order();
		$wcst_order_model->late_order_meta_processing( $post_id, $_POST);	
	}

	function woocommerce_metaboxes() 
	{
		global $wcst_html_helper;
		
		$screen = wc_get_container()->get( CustomOrdersTableController::class )->custom_orders_table_usage_is_enabled()
		? wc_get_page_screen_id( 'shop-order' )
		: 'shop_order';


		add_meta_box( 'woocommerce-order-ship', esc_html__('Tracking Code', 'woocommerce-shipping-tracking'), array( &$wcst_html_helper, 'render_shipping_companies_tracking_info_configurator_widget' ), $screen, 'side', 'high');

	}
		
	function ship_select_menu(){
		
		if (!function_exists('current_user_can') || !current_user_can('manage_options') )
		return;
			
	}
} 
?>