<?php 
class WCST_OrderTable
{
	function __construct() 
	{
		//HPOS 
		add_action( 'woocommerce_shop_order_list_table_custom_column', array($this, 'add_tacking_info_to_column'),10, 2 ); 
		add_filter( 'woocommerce_shop_order_list_table_columns', array($this, 'add_tracking_column'), 15 ); 
		add_action('woocommerce_order_list_table_restrict_manage_orders', array( &$this,'add_uploads_select_box_filter'), 10, 2); 
		add_filter('woocommerce_order_list_table_prepare_items_query_args', array( &$this,'filter_order_list_query'), 10, 2);
		add_filter('woocommerce_order_table_search_query_meta_keys', array( &$this,'woocommerce_shop_order_search_tracking_number'));
		//
		add_filter( 'woocommerce_shop_order_search_fields', array( &$this, 'woocommerce_shop_order_search_tracking_number') );
		add_action( 'manage_edit-shop_order_columns', array( &$this, 'add_tracking_column'), 20, 1 );							 //Same for HPOS
		add_action( 'manage_shop_order_posts_custom_column', array( &$this, 'add_tacking_info_to_column'), 10,2);				 //Same for HPOS
		add_filter( 'manage_edit-product_columns', array(&$this, 'add_estimated_column'),15 );		
		add_action( 'manage_product_posts_custom_column', array(&$this, 'add_estimation_info_to_column'), 10, 2 );
		add_action('restrict_manage_posts', array( &$this,'add_uploads_select_box_filter'));									 //Slightly modified for HPOS
		add_filter('parse_query',array( &$this,'filter_query_by_shipping_company')); 											 //For HPOS managed by filter_order_list_query
	
	}
	public function add_uploads_select_box_filter($order_type = "shop_order", $which = "top")
	{
		global $typenow, $wp_query, $wcst_html_helper; 
		$current_page = $typenow ? $typenow : $order_type;
		if ($current_page=='shop_order') 
		{
			$selected = isset($_GET['wcst_filter_by_shipping_company']) && $_GET['wcst_filter_by_shipping_company'] ? $_GET['wcst_filter_by_shipping_company']:"none";
			 ?>
			<select name="wcst_filter_by_shipping_company" >
				<option value="none" <?php if($selected == "none") echo 'selected="selected"';?>><?php esc_html_e('Select a shipping company', 'woocommerce-shipping-tracking') ?></option>
				<?php $wcst_html_helper->generic_shipping_comanies_dropdown_options($selected); ?>
			</select>
			<?php
		}
	}
	//HPOS
	public function filter_order_list_query($query) 
	{
		global $wcuf_upload_field_model;
		if(wcst_get_value_if_set($_GET,'wcst_filter_by_shipping_company', "none") != 'none' && wcst_get_value_if_set($query, 'type', false) == 'shop_order')
		{
			 $conditions = array(
				 'relation' => 'OR',
				  array(
					'key' => '_wcst_order_trackurl',
					'compare' => '=',
					/*'compare' => 'NOT NULL',
					 'type' => 'CHAR' , */
					 'value' => $_GET['wcst_filter_by_shipping_company']
				  ),
				   array(
					'key' => '_wcst_additional_companies',
					'compare' => 'LIKE',
					 'value' => serialize('_wcst_order_trackurl').serialize($_GET['wcst_filter_by_shipping_company'])
				  )
			  );
			$query['meta_query'][] = $conditions;
		}
		return $query;
	}
	public function filter_query_by_shipping_company($query) 
	{
		global $pagenow;
		$qv = &$query->query_vars;
		if ($pagenow=='edit.php' && 
		    isset($qv['post_type']) && $qv['post_type']=='shop_order' && isset($_GET['wcst_filter_by_shipping_company']) && $_GET['wcst_filter_by_shipping_company'] != 'none') 
		{
			 $qv['meta_query'][] = 
				array(
				 'relation' => 'OR',
				  array(
					'key' => '_wcst_order_trackurl',
					'compare' => '=',
					/*'compare' => 'NOT NULL',
					 'type' => 'CHAR' , */
					 'value' => $_GET['wcst_filter_by_shipping_company']
				  ),
				   array(
					'key' => '_wcst_additional_companies',
					'compare' => 'LIKE',
					 'value' => serialize('_wcst_order_trackurl').serialize($_GET['wcst_filter_by_shipping_company'])
				  )
			  );
			 // wcst_var_dump( $qv['meta_query']);
		}
	}
	function woocommerce_shop_order_search_tracking_number( $search_fields ) 
	{

		$search_fields[] = '_wcst_order_trackno';
		$search_fields[] = '_wcst_additional_companies';
		$search_fields[] = '_wcst_order_trackname';
		return $search_fields;
	}
	//Order list columns
	function add_tracking_column($columns){ 
	
		wp_enqueue_style('wcst-info-tracking-box',  WCST_PLUGIN_PATH.'/css/wcst_orders_list.css');
		$columns["wcst_tracking_number"] = esc_html__('Tracking Number', 'woocommerce-shipping-tracking');
		
		return $columns;
		
	}
	//Order list columns
	function add_tacking_info_to_column($column, $order_id)
	{ 
		global $post, $woocommerce, $the_order, $wcst_product_model, $wcst_order_model;
			
			$order = wc_get_order($order_id); 
				
			switch ( $column ) 
			{
				case "wcst_tracking_number" :
					
					$order_meta = $wcst_order_model->get_order_meta(WCST_Order::get_id($order)); 
					if(isset($order_meta['_wcst_order_trackno']) && isset($order_meta['_wcst_order_trackurl']) && isset($order_meta['_wcst_order_trackname']))
					{
					 	$this->admin_shipping_details_to_column($order_meta, $order);
					}
					if(isset($order_meta['_wcst_additional_companies']))
					{
												//old wc versions
						$additiona_companies = is_string($order_meta['_wcst_additional_companies'][0]) ? unserialize($order_meta['_wcst_additional_companies'][0]) : $order_meta['_wcst_additional_companies'];
						$this->admin_additional_shipping_details_to_column($additiona_companies, $order);
					}
				break; 
				
				
			}
			
	}
	//Product list columns
	function add_estimated_column($columns){ 
	
		$columns["wcst_estimated_rule_name"] = esc_html__('Est. shipping rule', 'woocommerce-shipping-tracking');
		
		return $columns;
		
	}
	//Product list columns
	function add_estimation_info_to_column( $column, $post_id ) 
	{ 
		global $post, $woocommerce, $the_order, $wcst_product_model;
	
			switch ( $column ) 
			{
					
				case "wcst_estimated_rule_name":
					$rule = $wcst_product_model->get_estimation_shippment_rule($post_id);
					if(isset($rule))
						echo '<a class="" target="_blank" href="'.admin_url().'admin.php?page=acf-options-estimated-shipping-configurator">'.
								$rule['name_id'].
								'</a></br>';
					break;
				
			}
			
	}
		
	function admin_shipping_details_to_column($order_meta , $order)
	{
		global  $wcst_shipping_company_model;
	
		$company_slug = $order_meta['_wcst_order_trackurl'][0] != null && $order_meta['_wcst_order_trackurl'][0] != 'NOTRACK' ? $order_meta['_wcst_order_trackurl'][0] : false;
		$urltrack = isset($order_meta['_wcst_order_track_http_url'][0]) ? $order_meta['_wcst_order_track_http_url'][0] : "#";
		$shipping_traking_num = $order_meta['_wcst_order_trackno'][0] ? $order_meta['_wcst_order_trackno'][0] : '' ;
		$original_tracking_url = $company_slug && $shipping_traking_num != "" ? $wcst_shipping_company_model->get_original_company_tracking_url($company_slug, $shipping_traking_num, $urltrack): "";
		$date_format = get_option( 'date_format' );
		$time_format = get_option( 'time_format' );
		
		if(strpos($shipping_traking_num, "###") !== false)
		{
			$split_result = explode('###', $shipping_traking_num);
			$shipping_traking_num = $split_result[1];
		}
		else if(strpos($shipping_traking_num, ",") !== false)
		{
			$split_result = explode(',', $shipping_traking_num);
			$shipping_traking_num = $split_result[0];
		}
	
		if ($company_slug !== false) 
		{ 	 ?>
			<div class="wcst_tracking_info_box"><STRONG><?php 
				echo $order_meta['_wcst_order_trackname'][0];
			?></STRONG><br/>
			<?php if($order_meta['_wcst_order_trackno'][0]): ?>
				<a target="_blank" href="<?php echo $urltrack;?>">#<?php echo $shipping_traking_num; ?></a>
			<?php endif; ?>
			<?php if($original_tracking_url): ?>
				<div class="wcst-original-link-wrapper">
					<strong><?php esc_html_e('Courier', 'woocommerce-shipping-tracking') ?></strong>
					<a target="_blank" href="<?php echo $original_tracking_url;?>"><?php esc_html_e('Tracking page', 'woocommerce-shipping-tracking') ?></a>
				</div>
			<?php endif; ?>
			<?php if(isset($order_meta['_wcst_order_dispatch_date'][0]) && $order_meta['_wcst_order_dispatch_date'][0]): ?>
				<br/>
				<?php echo esc_html__('On: ','').date_i18n($date_format." ".$time_format, strtotime($order_meta['_wcst_order_dispatch_date'][0]));
			endif; ?>
			</div>
		<?php } 
		
	}
	function admin_additional_shipping_details_to_column($additiona_companies , $order)
	{
		global  $wcst_shipping_company_model;
		$date_format = get_option( 'date_format' );
		$time_format = get_option( 'time_format' );
		
		foreach($additiona_companies as $order_meta)
		{
			$company_slug = $order_meta['_wcst_order_trackurl'] != null && $order_meta['_wcst_order_trackurl'] != 'NOTRACK' ?  $order_meta['_wcst_order_trackurl'] : false;
			$urltrack = isset($order_meta['_wcst_order_track_http_url']) ? $order_meta['_wcst_order_track_http_url'] : "#";
			$shipping_traking_num = $order_meta['_wcst_order_trackno'] ? $order_meta['_wcst_order_trackno'] : '' ;
			$original_tracking_url = $company_slug && $shipping_traking_num != "" ? $wcst_shipping_company_model->get_original_company_tracking_url($company_slug, $shipping_traking_num, $urltrack): "";
			
			if(strpos($shipping_traking_num, "###") !== false)
			{
				$split_result = explode('###', $shipping_traking_num);
				$shipping_traking_num = $split_result[1];
			}
			else if(strpos($shipping_traking_num, ",") !== false)
			{
				$split_result = explode(',', $shipping_traking_num);
				$shipping_traking_num = $split_result[0];
			}
			if ($company_slug ) 
			{ ?>
				<div class="wcst_tracking_info_box"><STRONG><?php 
					echo $order_meta['_wcst_order_trackname'];
				?></STRONG><br/>
				<?php if($order_meta['_wcst_order_trackno']): ?>
					<a target="_blank" href="<?php echo $urltrack;?>">#<?php echo $shipping_traking_num; ?></a>
				<?php endif; ?>
				<?php if($original_tracking_url): ?>
					<div class="wcst-original-link-wrapper">
						<strong><?php esc_html_e('Courier', 'woocommerce-shipping-tracking') ?></strong>
						<a target="_blank" href="<?php echo $original_tracking_url;?>"><?php esc_html_e('Tracking page', 'woocommerce-shipping-tracking') ?></a>
					</div>
				<?php endif; ?>
				<?php if(isset($order_meta['_wcst_order_dispatch_date']) && $order_meta['_wcst_order_dispatch_date']): ?>
					<br/>
					<?php echo esc_html__('On: ','').date_i18n($date_format." ".$time_format, strtotime($order_meta['_wcst_order_dispatch_date']));
				endif; ?>
				</div>
			<?php } 
		}
		
	}
}
?>