<?php 
class WCST_QuickAssignPage
{
	public function __construct(){}
	
	private function save_data()
	{
		global $wcst_order_model, $wcst_email_model;
		$wcst_order_model->save_shippings_info_metas($_POST['order_id'], $_POST, $_POST['merge_existing_data'] == 'yes' ? true : false);
		$order =  wc_get_order($_POST['order_id']); // new WC_Order($_POST['order_id']);
		
		if($_POST['order_status'] != 'no')
		{
			$order->update_status($_POST['order_status']);
		}
		if($_POST['order_action'] != 'do_not_resend_emails')
		{
			 $wcst_email_model->force_status_email_sending($_POST['order_action'], $order);
		}
	}
	public static function force_dequeue_scripts($enqueue_styles)
	{
		if ( class_exists( 'woocommerce' ) && isset($_GET['page']) && $_GET['page'] == 'wcst-quick-assign') 
		{
			global $wp_scripts;
			$wp_scripts->queue = array();
			WCST_QuickAssignPage::enqueue_scripts();

		} 
	}
	public static function enqueue_scripts()
	{
		if ( class_exists( 'woocommerce' ) && isset($_GET['page']) && $_GET['page'] == 'wcst-quick-assign') 
		{
			wp_enqueue_script('jquery') ;
			wp_enqueue_script('jquery-ui-core') ;
			wp_enqueue_script('jquery-ui-slider') ;
			wp_enqueue_script('jquery-ui-progressbar');
			
		}
	}
	public function render_page()
	{
		if(isset($_POST) && isset($_POST['order_id']))
		{
			$this->save_data();
			echo '<div id="message" class="updated">'.esc_html__('Shipping info added', 'woocommerce-shipping-tracking').'</div>';
		}
		
		global $wcst_html_helper;
		wp_enqueue_style( 'wcst-common', WCST_PLUGIN_PATH.'/css/wcst_common.css');
		wp_enqueue_style( 'wcst-admin', WCST_PLUGIN_PATH.'/css/wcst_options.css');
		wp_enqueue_style( 'wcst-admin-quick-assign', WCST_PLUGIN_PATH.'/css/wcst_quick_assign.css');
		wp_enqueue_style( 'wcst-select2-style',  WCST_PLUGIN_PATH.'/css/select2/select2.css' ); 

			
		wp_register_script('wcst-quick-assing-load-orders', WCST_PLUGIN_PATH.'/js/wcst_quick_assign_load_orders.js', array('jquery'));	
		$js_options = array(
				'security' => wp_create_nonce('wcst_get_order_selector'),
				'ajaxurl' =>  admin_url( 'admin-ajax.php' ),
				'loading_text' =>  esc_html__('Loading...','woocommerce-shipping-tracking')
			);
				
		wp_localize_script( 'wcst-quick-assing-load-orders', 'wcst', $js_options );	
		
		//to enqueue native selectWoo: wp_enqueue_script('selectWoo');	
		wp_enqueue_script( 'select2', WCST_PLUGIN_PATH.'/js/select2/select2.min.js', array('jquery') ); 			
		wp_enqueue_script( 'wcst-quick-assing-load-orders' ); 	
		
		?>
		<div class="wrap white-box">
		<form action="" method="post" >
			<h1 ><?php esc_html_e('Quick assign: how it works?', 'woocommerce-shipping-tracking');?></h1>
			<p><?php esc_html_e('In this section in just 3 step you can easily assign one or more shipping tracking info to an order. NOTE: older order info will be overwritten. Leave empty to clear an order shipping info data.', 'woocommerce-shipping-tracking');?></p>
			<h2 class="wcst_section_title"><?php esc_html_e('1. Select order', 'woocommerce-shipping-tracking');?></h2>
			<p><?php esc_html_e('You can search by order id, order date, user id, billing email and billing/shipping first and last name', 'woocommerce-shipping-tracking');?></p>
			<select class="js-data-orders-ajax" id="wcst_select2_order_id" name="order_id" required="required"> </select>
			
			<label style="margin-top:15px"><?php esc_html_e('Merge tracking info with the existing one?','woocommerce-shipping-tracking'); ?></label>
			<p><?php esc_html_e('If "Yes" option is selected, the existing order shipping trackin info (if any) will be merged with the one inserted now.', 'woocommerce-shipping-tracking');?></p>
			<select name="merge_existing_data">
				<option value="yes"><?php esc_html_e('Yes', 'woocommerce-shipping-tracking');?></option>
				<option value="no"><?php esc_html_e('No', 'woocommerce-shipping-tracking');?></option>
			</select>
			
			<h2 class="wcst_section_title"><?php esc_html_e('2. Assign a shipping', 'woocommerce-shipping-tracking');?></h2>
			<?php $wcst_html_helper->render_shipping_companies_tracking_info_configurator_widget(); ?>
		
			<h2 class="wcst_section_title"><?php esc_html_e('3. Change order status?', 'woocommerce-shipping-tracking');?></h2>
			<p><?php esc_html_e('Note that if the order hits for the first time a status, a notification email will be send automatically to the user', 'woocommerce-shipping-tracking');?></p>
			<select id="wcst_select_order_status" name="order_status" required="required"> 
			<option value="no"><?php esc_html_e('Leave unchanged', 'woocommerce-shipping-tracking');?></option>
			<?php foreach(wc_get_order_statuses() as $code => $status): ?>
					<option value="<?php echo $code; ?>"><?php echo $status; ?></option>
			<?php endforeach; ?>
			</select>
			<p>
			<label><?php esc_html_e('Resend order emails? (useful to force email sending if an order already hitted a status)', 'woocommerce-shipping-tracking');?></label>
			<select name="order_action">
					<option value="do_not_resend_emails"><?php esc_html_e('No', 'woocommerce-shipping-tracking');?></option>
					<option value="send_email_new_order"><?php esc_html_e('New order', 'woocommerce-shipping-tracking');?></option>
					<option value="send_email_cancelled_order"><?php esc_html_e('Cancelled order', 'woocommerce-shipping-tracking');?></option>
					<option value="send_email_customer_processing_order"><?php esc_html_e('Processing order', 'woocommerce-shipping-tracking');?></option>
					<option value="send_email_customer_completed_order"><?php esc_html_e('Completed order', 'woocommerce-shipping-tracking');?></option>
					<option value="send_email_customer_refunded_order"><?php esc_html_e('Refunded order', 'woocommerce-shipping-tracking');?></option>
					<option value="send_email_customer_invoice"><?php esc_html_e('Customer invoice', 'woocommerce-shipping-tracking');?></option>					
				
			</select>
			</p>
									
			<p class="submit">
						<input type="submit" value="Save Changes" class="button-primary" name="Submit">
					</p>
			</form>
		</div>
		<?php
	}
}
?>