<?php 
class WCST_ExtraDelivery
{
	public function __construct()
	{
		//Attach new info
		add_action( 'woocommerce_after_checkout_billing_form', array( &$this, 'add_additional_form_checkout_page' ), 10, 1 ); //Checkout page
		
		//After Checkout
		add_action('woocommerce_checkout_order_processed', array( &$this, 'save_additional_shipping_info_after_checkout' )); //After checkout
		
		add_action( 'woocommerce_admin_order_data_after_billing_address', array( &$this,'after_shipping_address_meta_box_admin_order_page')); //Order details
		add_action( 'woocommerce_process_shop_order_meta', array( &$this, 'on_save_order_details_admin_order_page' ), 5, 2 );//save order	
		
		//Order details page
		add_action( 'woocommerce_order_details_after_order_table', array( &$this, 'add_order_details_page_addon' ) );
		
		//Email
		add_action('woocommerce_email_after_order_table', array( &$this, 'woocommerce_include_extra_fields_in_emails' ), 10, 5);
	}
	
	private function  enqueue_scripts($options, $min_date)
	{
		$wpml_helper = new WCST_Wpml();
		$options = new WCST_Option();
		$general_options = $options->get_general_options();
		$date_format = isset($general_options['date_format']) ? $general_options['date_format'] : "dd/mm/yyyy";
		$lang_code = str_replace("_formal", "", $wpml_helper->get_current_locale());
		$lang_code = $lang_code."_".strtoupper($lang_code);
		$messages_and_options = $options->get_checkout_options();
		
		wp_enqueue_style('van-datepicker-default', WCST_PLUGIN_PATH.'/css/datepicker/default.css');   
		wp_enqueue_style('van-datepicker-date-default', WCST_PLUGIN_PATH.'/css/datepicker/default.date.css');   
		wp_enqueue_style('van-datepicker-time-default', WCST_PLUGIN_PATH.'/css/datepicker/default.time.css');  
		wp_enqueue_style('wcst-delivery-date', WCST_PLUGIN_PATH.'/css/wcst_delivery_date.css');  
		
		wp_enqueue_script('van-picker', WCST_PLUGIN_PATH.'/js/datepicker/picker.js', array( 'jquery' ));
		wp_enqueue_script('van-datepicker', WCST_PLUGIN_PATH.'/js/datepicker/picker.date.js', array( 'jquery' ));
		wp_enqueue_script('van-timepicker', WCST_PLUGIN_PATH.'/js/datepicker/picker.time.js', array( 'jquery' ));
		if(wcst_file_exists(WCST_PLUGIN_ABS_PATH.'js/datepicker/translations/'.$lang_code.'.js'))
			wp_enqueue_script('van-datepicker-localization', WCST_PLUGIN_PATH.'/js/datepicker/translations/'.$lang_code.'.js');			
		wp_register_script('wcst-frontend-delivery-date', WCST_PLUGIN_PATH.'/js/wcst-frontend-delivery-date.js', array( 'jquery' ));
		
		$js_options = array(
			'just_one_date_field' => isset($messages_and_options['options']['just_one_date_field']) ? 'true' : 'false',
			'delivery_excluded_dates' => isset($messages_and_options['options']['delivery_date_to_exclude']) ? $messages_and_options['options']['delivery_date_to_exclude'] : false,
			'current_year' => date("Y"),
			'delivery_min_day' => $min_date['day'],
			'delivery_min_month' => $min_date['month'],
			'delivery_min_year' => $min_date['year'],
			'date_error_message' => esc_html__('Check start and end date. Start date cannot be greater than end.','woocommerce-shipping-tracking'),
			'time_error_message' => esc_html__('Check start and end time. Start time cannot be greater than end.','woocommerce-shipping-tracking'),
			'secondary_error_message' => esc_html__('Check secondary start and end time. Start time cannot be greater than end.','woocommerce-shipping-tracking'),
			'date_format' => $date_format,
			'time_range_start_hour' => isset($messages_and_options['options']['time_range_start_hour']) ? $messages_and_options['options']['time_range_start_hour'] :  0,
			'time_range_start_minute' => isset($messages_and_options['options']['time_range_start_minute']) ? $messages_and_options['options']['time_range_start_minute']  :  0,
			'time_range_end_hour' => isset($messages_and_options['options']['time_range_end_hour']) ? $messages_and_options['options']['time_range_end_hour'] :  23,
			'time_range_end_minute' => isset($messages_and_options['options']['time_range_end_minute']) ? $messages_and_options['options']['time_range_end_minute'] :  59,
			'time_secondary_range_start_hour' => isset($messages_and_options['options']['time_secondary_range_start_hour']) ? $messages_and_options['options']['time_secondary_range_start_hour'] :  0,
			'time_secondary_range_start_minute' => isset($messages_and_options['options']['time_secondary_range_start_minute']) ? $messages_and_options['options']['time_secondary_range_start_minute'] :  0,
			'time_secondary_range_end_hour' => isset($messages_and_options['options']['time_secondary_range_end_hour']) ? $messages_and_options['options']['time_secondary_range_end_hour'] :  23,
			'time_secondary_range_end_minute' => isset($messages_and_options['options']['time_secondary_range_end_minute']) ? $messages_and_options['options']['time_secondary_range_end_minute'] :  59
		);
		wp_localize_script( 'wcst-frontend-delivery-date', 'wcst', $js_options );
		wp_enqueue_script( 'wcst-frontend-delivery-date' );
	}
	public function add_order_details_page_addon( $order )
	{
		global $wcst_time_model;
		$this->save_post_data(WCST_Order::get_id($order));
		$options = new WCST_Option();
		$order_model = new WCST_Order();
		$delivery_info = $order_model->get_delivery_and_times(WCST_Order::get_id($order));
		$messages_and_options = $options->get_checkout_options();
		$show_on_order_details_page = isset($messages_and_options['options']['show_on_order_details_page']) ? true : false;
		
		$general_options = $options->get_general_options();
		$date_format = isset($general_options['date_format']) ? $general_options['date_format'] : "dd/mm/yyyy";
		
		//Retrieve min delivery date 
		$min_date = $this->get_min_delivery_date(false, WCST_Order::get_id($order));
		
		if($show_on_order_details_page)
		{
			$this->enqueue_scripts($messages_and_options, $min_date);
			if(file_exists ( get_theme_file_path()."/woocommerce-shipping-tracking/template/order_details_extra_delivery_info.php" ))
				include get_theme_file_path()."/woocommerce-shipping-tracking/template/order_details_extra_delivery_info.php";
			else
				include WCST_PLUGIN_ABS_PATH.'template/order_details_extra_delivery_info.php';
		}
	}
	
	public function add_additional_form_checkout_page($checkout)
	{
		$options = new WCST_Option();
		$messages_and_options = $options->get_checkout_options();
		$show_on_checkout_page = isset($messages_and_options['options']['show_on_checkout_page']) ? true : false;
		
		//Retrieve min delivery date 
		$min_date = $this->get_min_delivery_date();
		$general_options = $options->get_general_options();
		$date_format = isset($general_options['date_format']) ? $general_options['date_format'] : "dd/mm/yyyy";
		
		if($show_on_checkout_page)
		{
			$this->enqueue_scripts($messages_and_options, $min_date);
			if(file_exists ( get_theme_file_path()."/woocommerce-shipping-tracking/template/checkout_form.php" ))
				include get_theme_file_path()."/woocommerce-shipping-tracking/template/checkout_form.php";
			else
				include WCST_PLUGIN_ABS_PATH.'template/checkout_form.php';
		}
	}
	private function get_min_delivery_date($is_checkout = true, $order_id = 0)
	{
		global $wcst_product_model,$wcst_time_model;
		$min_date = null;
		
		//Retrieve min delivery date 
		if($is_checkout)
			foreach(WC()->cart->get_cart( ) as $item)
			{
				$estimated_date = $wcst_time_model->get_available_date($wcst_product_model->get_estimation_shippment_rule($item['product_id']), true);	
				$min_date = !isset($min_date) || $min_date > $estimated_date ? $estimated_date : $min_date;
			}
		else
		{
			$wc_order = wc_get_order($order_id); 
			$products = $wc_order->get_items();
			foreach($products as $item)
			{
				$order_item_id = $item->get_product_id();
				$estimated_date = $wcst_time_model->get_available_date($wcst_product_model->get_estimation_shippment_rule($order_item_id), true);
				$min_date = !isset($min_date) || $min_date > $estimated_date ? $estimated_date : $min_date;
			}
		}
		$result = isset($min_date) ? $min_date : new DateTime();
		$result = $result->modify('+1 day'); //Shipping rate
		
		return array('day' => $result->format("j"), 'month' => $result->format("n")-1, 'year' => $result->format("Y"));
	}
	public function after_shipping_address_meta_box_admin_order_page($order)
	{
		global $post;
		$options = new WCST_Option();
		$order_model = new WCST_Order();
		$order_id = $order->get_id();
		$delivery_info = $order_model->get_delivery_and_times($order_id);
		$messages_and_options = $options->get_checkout_options();
		
		wp_enqueue_style('wcst-datepicker-default', WCST_PLUGIN_PATH.'/css/datepicker/default.css');   
		wp_enqueue_style('wcst-datepicker-date-default', WCST_PLUGIN_PATH.'/css/datepicker/default.date.css');   
		wp_enqueue_style('wcst-datepicker-time-default', WCST_PLUGIN_PATH.'/css/datepicker/default.time.css');  
		wp_enqueue_style('wcst-order-detail-ui', WCST_PLUGIN_PATH.'/css/wcst_admin_order_details_page.css');  
		
		wp_enqueue_script('wcst-ui-picker', WCST_PLUGIN_PATH.'/js/datepicker/picker.js', array( 'jquery' ));
		wp_enqueue_script('wcst-ui-datepicker', WCST_PLUGIN_PATH.'/js/datepicker/picker.date.js', array( 'jquery' ));
		wp_enqueue_script('wcst-ui-timepicker', WCST_PLUGIN_PATH.'/js/datepicker/picker.time.js', array( 'jquery' ));
		wp_enqueue_script('wcst-order-datail-delivery-date', WCST_PLUGIN_PATH.'/js/wcst-order-datail-delivery-date.js', array( 'jquery' ));
		
		$general_options = $options->get_general_options();
		$date_format = isset($general_options['date_format']) ? $general_options['date_format'] : "dd/mm/yyyy";
		
		{
			if(isset($messages_and_options['options']['date_range']))
			{
				?>
				<p class="wcst_extra_delivery_row form-row form-row-wide">
					<strong><?php esc_html_e('Delivery date range: ', 'woocommerce-shipping-tracking');  ?></strong><br/>
					<input type="text" class="wcst_input_date" name="wcst_delivery[date_start_range]" value="<?php if(isset($delivery_info['date_start_range'])) echo $delivery_info['date_start_range']; ?>"></input>
					<input type="text" class="wcst_input_date" name="wcst_delivery[date_end_range]" value="<?php if(isset($delivery_info['date_end_range'])) echo $delivery_info['date_end_range']; ?>"></input>
				</p>
				<?php
			}
			if(isset($messages_and_options['options']['time_range']))
			{
				?>
				<p class="wcst_extra_delivery_row  form-row form-row-wide">
					<strong><?php esc_html_e('Delivery time range: ', 'woocommerce-shipping-tracking'); ?></strong><br/>
					<input type="text" class="wcst_input_time" name="wcst_delivery[time_start_range]" value="<?php if(isset($delivery_info['time_start_range'])) echo $delivery_info['time_start_range']; ?>"></input>
					<input type="text" class="wcst_input_time" name="wcst_delivery[time_end_range]" value="<?php if(isset($delivery_info['time_end_range'])) echo $delivery_info['time_end_range']; ?>"></input>
				</p>
				<?php
			}
			if(isset($messages_and_options['options']['time_range']) && isset($messages_and_options['options']['time_secondary_range']))
			{
				?>
				<p class="wcst_extra_delivery_row form-row form-row-wide">
					<strong><?php  esc_html_e('Delivery secondary time range: ', 'woocommerce-shipping-tracking'); ?></strong><br/>
					<input type="text" class="wcst_input_time" name="wcst_delivery[time_secondary_start_range]" value="<?php if(isset($delivery_info['time_secondary_start_range'])) echo $delivery_info['time_secondary_start_range']; ?>"></input>
					<input type="text" class="wcst_input_time" name="wcst_delivery[time_secondary_end_range]" value="<?php if(isset($delivery_info['time_secondary_end_range'])) echo $delivery_info['time_secondary_end_range']; ?>"></input>
				</p>
				<?php
			}
		}
	}
	
	public function save_additional_shipping_info_after_checkout($order_id)
	{
		if(defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) 
		  return $order_id;
	 
		$this->save_post_data($order_id);
	}
	public function on_save_order_details_admin_order_page( $order_id, $post )
	{
		$this->save_post_data($order_id);
	}
	private function save_post_data($order_id)
	{
		if(isset($_POST['wcst_delivery']))
		{
			$order_model = new WCST_Order();
			$order_model->save_delivery_date_and_time($order_id, $_POST['wcst_delivery']);
		}
	}
	public function woocommerce_include_extra_fields_in_emails($order, $sent_to_admin = false, $plain_text = "", $email = null)
	{
		if(!isset($order))
			return;
		
		$order_model = new WCST_Order();
		$delivery_info = $order_model->get_delivery_and_times(WCST_Order::get_id($order));
		
		if(!empty($delivery_info))
		{
			if(file_exists ( get_theme_file_path()."/woocommerce-shipping-tracking/template/email_extra_delivery_info.php" ))
				include get_theme_file_path()."/woocommerce-shipping-tracking/template/email_extra_delivery_info.php";
			else
				include WCST_PLUGIN_ABS_PATH.'template/email_extra_delivery_info.php';
		}
	}
}
?>