<?php 
$email_message_additional = "";
$messages = $options_model->get_messages( null, $lang );
	
if($order_meta['_wcst_order_trackurl'][0] != 'NOTRACK')
{
	$shipping_traking_num = $order_meta['_wcst_order_trackno'][0];
	if(strpos($shipping_traking_num, "###") !== false)
	{
		$split_result = explode('###', $shipping_traking_num);
		$shipping_traking_num = implode(", ",$split_result);
	}
	else if(strpos($shipping_traking_num, ",") !== false)
	{
		$split_result = explode(',', $shipping_traking_num);
		$shipping_traking_num = implode(", ",$split_result);
	}
		
	$dispatch_date = isset($order_meta['_wcst_order_dispatch_date'][0]) ? $order_meta['_wcst_order_dispatch_date'][0] : esc_html__( 'N/A', 'woocommerce' ) ;
	$dispatch_date = $wcst_time_model->format_data($dispatch_date);
	$custom_text = isset($order_meta['_wcst_custom_text'][0]) ? $order_meta['_wcst_custom_text'][0] : "";
	$shipping_company_name = $order_meta['_wcst_order_trackurl'][0] == 'NOTRACK' ? "" : $shipping_company_name;
	$associated_products = wcst_get_value_if_set($order_meta, array('_wcst_associated_product'), array());
	$original_urltrack = $wcst_shipping_company_model->get_original_company_tracking_url($order_meta['_wcst_order_trackurl'][0], $shipping_traking_num, $urltrack);
	
	$email_message = (!isset($messages['wcst_mail_message']) || $messages['wcst_mail_message'] == "") ? nl2br($default_message_email):nl2br($messages['wcst_mail_message']);
	$email_message = str_replace(array("[shipping_company_name]","[company_name]"), $shipping_company_name, $email_message);
	$email_message = str_replace("[url_track]", $urltrack, $email_message);
	$email_message = str_replace("[original_url_track]", $original_urltrack, $email_message);
	$email_message = str_replace("[order_id]", $order->get_order_number(), $email_message);
	//conditional
	$email_message = WCST_Shortcodes::check_if_conditional_no_tracking_url_text_has_to_be_removed($email_message, $urltrack == "" || $urltrack == "#");
		
	$email_message = str_replace("[tracking_number]", $shipping_traking_num, $email_message);
	$email_message = str_replace("[dispatch_date]", $dispatch_date, $email_message);
	$email_message = str_replace("[custom_text]", $custom_text, $email_message);
	$email_message = str_replace(array("[track_shipping_in_site]","[shipping_timeline]"), "", $email_message);
	$email_message = str_replace("[order_url]", $order_details_page_url, $email_message);
	
	//associated products 
	$associated_products_names = array();
	foreach($order->get_items() as $order_item)
	{
		if(in_array($order_item->get_id(), $associated_products))
		{
			$attributes = $wcst_product_model->get_order_variation_attribute_value_and_name($order_item->get_product());
			$associated_products_names[] = $order_item->get_name()." ".$attributes;
		}
	}
	$email_message = str_replace("[associated_products]", implode(", ", $associated_products_names), $email_message);

}
else 
	$email_message = "";

//Active email notification
if(!empty($tracking_code_to_show_on_email) && !isset($tracking_code_to_show_on_email["default"]))
	$email_message = "";

if($order_meta_additional_shippings)
{
	foreach($order_meta_additional_shippings as $index => $additional_shipping)
	{
		
		//Active email notification
		if(!empty($tracking_code_to_show_on_email) && !isset($tracking_code_to_show_on_email[$index]))
			continue;
		
		//no code
		if($additional_shipping['_wcst_order_trackurl'] == 'NOTRACK')
			continue;
		
		
		$email_message_additional .= (!isset($messages['wcst_mail_message_additional_shippings']) || $messages['wcst_mail_message_additional_shippings'] == "") ? nl2br($default_message_additional_email):nl2br($messages['wcst_mail_message_additional_shippings']);
		$urltrack = $additional_shipping['_wcst_order_trackno'];
		$original_urltrack= $urltrack;
		if(strpos($urltrack, "###") !== false)
		{
			$split_result = explode('###', $urltrack);
			$urltrack = implode(", ",$split_result);
		}
		else if(strpos($urltrack, ",") !== false)
		{
			$split_result = explode(',', $urltrack);
			$urltrack = implode(", ",$split_result);
		}
		$dispatch_date = isset($additional_shipping['_wcst_order_dispatch_date']) ? $additional_shipping['_wcst_order_dispatch_date'] : "" ;
		$dispatch_date = $wcst_time_model->format_data($dispatch_date);
		$shipping_company_name =  $additional_shipping['_wcst_order_trackname'];
		$shipping_traking_num = $additional_shipping['_wcst_order_track_http_url'];
		$custom_text = isset($additional_shipping['_wcst_custom_text']) ? $additional_shipping['_wcst_custom_text'] : "";
		$associated_products = wcst_get_value_if_set($additional_shipping, array('_wcst_associated_product'), array());
		$original_http_tracking_url = $wcst_shipping_company_model->get_original_company_tracking_url($additional_shipping['_wcst_order_trackurl'], $original_urltrack, $shipping_traking_num);
		
		$email_message_additional = str_replace(array("[additional_shipping_company_name]","[company_name]"), $shipping_company_name, $email_message_additional);
		$email_message_additional = str_replace(array("[additional_shipping_tracking_number]","[tracking_number]"), $urltrack, $email_message_additional);
		$email_message_additional = str_replace(array("[additional_shipping_url_track]","[url_track]"), $shipping_traking_num, $email_message_additional);
		$email_message_additional = str_replace("[original_url_track]", $original_http_tracking_url, $email_message_additional);
		$email_message_additional = str_replace("[order_id]", $order->get_order_number(), $email_message_additional);
		$email_message_additional = str_replace(array("[additional_order_url]","[order_url]"), $order_details_page_url, $email_message_additional);		
		$email_message_additional = str_replace(array("[additional_track_shipping_in_site]","[additional_shipping_timeline]", "[shipping_timeline]"), "", $email_message_additional);
		//conditional
		$email_message_additional = WCST_Shortcodes::check_if_conditional_no_tracking_url_text_has_to_be_removed($email_message_additional, $shipping_traking_num == "" || $shipping_traking_num == "#");
		
		$email_message_additional = isset($dispatch_date) && $dispatch_date != "" && !empty($dispatch_date) ? str_replace(array("[additional_dispatch_date]","[dispatch_date]"), $dispatch_date, $email_message_additional): str_replace(array("[additional_dispatch_date]","[dispatch_date]"), "", $email_message_additional);
		$email_message_additional = isset($dispatch_date) && $dispatch_date != "" && !empty($dispatch_date) ? str_replace(array("[dispatch_date]"), $dispatch_date, $email_message_additional): str_replace("[dispatch_date]", "", $email_message_additional);
		$email_message_additional = isset($custom_text) && $custom_text != "" && !empty($custom_text) ? str_replace(array("[additional_custom_text]","[custom_text]"), $custom_text, $email_message_additional) : str_replace(array("[additional_custom_text]","[custom_text]"), "", $email_message_additional);
	
		//associated products 
		$associated_products_names = array();
		foreach($order->get_items() as $order_item)
		{
			if(in_array($order_item->get_id(), $associated_products))
			{
				$attributes = $wcst_product_model->get_order_variation_attribute_value_and_name($order_item->get_product());
				$associated_products_names[] = $order_item->get_name()." ".$attributes;
			}
		}
		$email_message_additional = str_replace(array("[additional_associated_products]","[associated_products]"), implode(", ", $associated_products_names), $email_message_additional);
	}
}
echo '<div class="tracking-box" style="display:block; margin-bottom:20px; border: 1px solid #dedede; padding: 20px;  border-radius: 3px;">';
echo $email_message.$email_message_additional;
echo '</div>';
?>
	
				