<?php

class OTWBMVCExtendAddonClass{

	private $has_vc = false;
	
	function __construct(){
		
		$this->otwBMQuery = new OTWBMQuery();
		$this->otwDispatcher = new OTWDispatcher();
		$this->otwCSS = new OTWCss();
		
		add_action( 'init', array( $this, 'integrateWithVC' ) );
		
		add_shortcode( 'otw_bm_vc', array( $this, 'renderShortcode' ) );
		
	}
	
	public function renderShortcode( $params ){
	
		if( isset( $params['otw_blog_list'] ) && intval( $params['otw_blog_list'] ) ){
			return do_shortcode( '[otw-bm-list id="'.esc_attr( $params['otw_blog_list'] ).'"]' );
		}
	}
	
	public function integrateWithVC(){
		// Check if Visual Composer is installed
		if ( defined( 'WPB_VC_VERSION' ) ) {
			$this->has_vc = true;
		}
		
		if( $this->has_vc ){
			
			$lists = $this->otwBMQuery->getLists();
			
			$options = array( esc_html__( '--select list--', 'otw_bm' ) => '' );
			
			if( isset($lists['otw-bm-list'] ) && is_array($lists['otw-bm-list'] ) ){
				foreach( $lists['otw-bm-list'] as $optionData ){
					if( isset( $optionData['id'] ) ){
						$options[ $optionData['list_name'] ] = $optionData['id'];
					}
				}
			}
			
			vc_map( array(
				"name" => esc_html__("Blog Manager", 'otw_bm'),
				"description" => esc_html__("Select a post list created with Blog Manager plugin", 'otw_bm'),
				"base" => "otw_bm_vc",
				"class" => "",
				"controls" => "full",
				"icon" => plugins_url() . DS . OTW_BM_PATH . DS .'assets'. DS .'img'. DS .'menu_icon.png', // or css class name which you can reffer in your css file later. Example: "vc_extend_my_class"
				"category" => esc_html__('Blog Manager', 'otw_bm'),
				"params" => array(
					array(
						'type' => 'dropdown',
						'holder' => 'div',
						'class' => '',
						'heading' => esc_html__( 'Blog list', 'otw_bm'),
						'param_name' => 'otw_blog_list',
						'value' => $options,
						'description' => esc_html__( 'Description for blog list.', 'otw_bm')
					)
				)
			) );
		}
	}
} 
new OTWBMVCExtendAddonClass();