<?php
/**
 * Class Used to interface with the DB
 */

if( !class_exists('OTWBMQuery') ) {

class OTWBMQuery {

  public $listOptions = null;
  
  public $sticky_posts = array();

  public function __construct() {}

  /**
   * Get POSTS based on the selected options for a list
   * @param $options array()
   * @param $page - int - Used for paged results
   * @return array()
   */
  public function getPosts ( $options = array(), $page = null, $only_sticky = false ) {
    $otw_bm_posts = array();

    if( !empty( $options ) ) {
    
      if( isset( $options['enable_sticky_posts'] ) && ( $options['enable_sticky_posts'] == 'yes' ) && !$only_sticky ){
      
    		$initial_options = $options;
    		$initial_page = $page;
      }
      
      $this->listOptions = $options;

      $template   = $options['template'];
      $categories = $options['categories'];
      $tags       = $options['tags'];
      $authors    = $options['users'];
      $order      = explode('_', $options['posts_order']);
      $exclude_categories = array();
      $exclude_tags = array();
      $exclude_authors = array();

	if( $authors == '-1' ){
		$authors = '';
	}
	
	$categoriesAll = false;
	$tagsAll = false;
	$authorsAll = false;


      ( !empty( $categories ) )? $categoriesArray = explode(',', $categories) : $categoriesArray = '';
      ( !empty( $tags ) )? $tagsArray = explode(',', $tags) : $tagsArray = '';
      ( empty($options['cat-tag-relation']) )? $catTagRelation = 'OR' : $catTagRelation = $options['cat-tag-relation'];
      ( !empty( $authors ) )? $authorsArray = explode(',', $authors) : $authorsArray = '';
	
	//if all selected
	if( isset( $options['all_categories'] ) && !empty( $options['all_categories'] ) ){
		
		$categoriesArray = array();
		$categoriesAll = true;
	}
	//if all selected
	if( isset( $options['all_tags'] ) && !empty( $options['all_tags'] ) ){
		
		$tagsArray = array();
		$tagsAll = true;
	}
	
	//if all selected
	if( isset( $options['all_users'] ) && !empty( $options['all_users'] ) ){
		
		$authorsArray = array();
		$authorsAll = true;
	}
	
	if( isset( $options['exclude_categories'] ) && strlen( trim( $options['exclude_categories'] ) ) && is_array( $categoriesArray ) && count( $categoriesArray ) ){
		
		$exclude_categories = explode( ',', $options['exclude_categories'] );
		
		if( count( $exclude_categories ) ){
			
			$tmpCategoriesArray = $categoriesArray;
			
			foreach( $tmpCategoriesArray as $tmpKey => $tmpCat ){
				
				if( in_array( $tmpCat, $exclude_categories ) ){
					unset( $categoriesArray[ $tmpKey ] );
				}
			}
		}
		if( !count( $categoriesArray ) ){
			$categoriesArray = array( 0 );
		}
	}elseif( isset( $options['exclude_categories'] ) && strlen( trim( $options['exclude_categories'] ) ) && ( !is_array( $categoriesArray ) || !count( $categoriesArray ) ) ){
		
		$exclude_categories = explode( ',', $options['exclude_categories'] );
		
		
	}
	
	if( isset( $options['exclude_tags'] ) && strlen( trim( $options['exclude_tags'] ) ) && is_array( $tagsArray ) && count( $tagsArray ) ){
		$exclude_tags = explode( ',', $options['exclude_tags'] );
		
		if( count( $exclude_tags ) ){
			
			$tmpTagsArray = $tagsArray;
			
			foreach( $tmpTagsArray as $tmpKey => $tmpCat ){
				
				if( in_array( $tmpCat, $exclude_tags ) ){
					unset( $tagsArray[ $tmpKey ] );
				}
			}
		}
		if( !count( $tagsArray ) ){
			$tagsArray = array( 0 );
		}
	}elseif( isset( $options['exclude_tags'] ) && strlen( trim( $options['exclude_tags'] ) ) && ( !is_array( $tagsArray ) || !count( $tagsArray ) ) ){
		
		$exclude_tags = explode( ',', $options['exclude_tags'] );
	}
	
	if( isset( $options['exclude_users'] ) && strlen( trim( $options['exclude_users'] ) ) && is_array( $authorsArray ) && count( $authorsArray ) ){
		
		$exclude_authors = explode( ',', $options['exclude_users'] );
		
		if( count( $exclude_authors ) ){
			
			$tmpAuthorsArray = $authorsArray;
			
			foreach( $tmpAuthorsArray as $tmpKey => $tmpCat ){
				
				if( in_array( $tmpCat, $exclude_authors ) ){
					unset( $authorsArray[ $tmpKey ] );
				}
			}
		}
		if( !count( $authorsArray ) ){
			$authorsArray = array( 0 );
		}
		
	}elseif( isset( $options['exclude_users'] ) && strlen( trim( $options['exclude_users'] ) ) && ( !is_array( $authorsArray ) || !count( $authorsArray ) ) ){
	
		$exclude_authors = explode( ',', $options['exclude_users'] );
	}
	
      // Code Use to get only posts with attachment
      $metaQuery = null;
      $sliderArray = array(
        'slider', '3-column-carousel', '4-column-carousel', '5-column-carousel',
        '2-column-carousel-wid', '3-column-carousel-wid', '4-column-carousel-wid',
        '1-3-mosaic', '1-4-mosaic', 'horizontal-layout'
      );
      if( in_array( $options['template'] , $sliderArray) ) {
        $metaQuery = array(
            'relation' => 'OR',
            array(
              'key' => '_thumbnail_id'
            ),
            array(
              'key'     => 'otw_bm_meta_data',
              'compare' => 'EXISTS'
            )
        );
      }

      // Used for pagination
      $currentPage = ( !empty($page) ) ? $page : 1;

      if( $template == 'timeline' ) {
        // If we have a timeline Layout we need to ignore the selected Order Options and use custom ones.
        $order[0] = 'date';
        $order[1] = 'DESC';
      }

      if( !empty($options['posts_limit']) ) {
	    //add_filter( 'post_limits', array($this, 'filterLimit'), 10, 2);
	    //$options['posts_limit_page'] = $this->listOptions['posts_limit'];
      }

      // For more information about the query, visit: http://codex.wordpress.org/Class_Reference/WP_Query
      $queryBM = array(
        'meta_query'      => $metaQuery,
        'post_status'     => 'publish',
        'posts_per_page'  => $options['posts_limit_page'],
        'paged'           => $currentPage,
        'orderby'         => $order[0], //Order Field
        'order'           => $order[1], // Order Value (ASC, DESC)
        'tax_query'       => array(
          'relation'      => $catTagRelation,
        ),
      );
	if( isset( $options['exclude_current_post'] ) && ( $options['exclude_current_post'] == 'yes' ) ){
		
		global $post;
		
		if( isset( $post->ID ) && $post->ID ){
			
			$queryBM['post__not_in'] = array( $post->ID );
		}
		
	}
	
	//at first place ignore the sticky posts
	if( isset( $options['enable_sticky_posts'] ) && ( $options['enable_sticky_posts'] == 'yes' ) && !$only_sticky ){
		
		$sticky = get_option( 'sticky_posts' );
		
		if( count( $sticky ) ){
			
			$queryBM['ignore_sticky_posts'] = 1;
		
			if( !isset( $queryBM['post__not_in'] ) ){
				$queryBM['post__not_in'] = array();
			}
			foreach( $sticky as $s_id ){
				$queryBM['post__not_in'][] = $s_id;
			}
			
		}
		
	}elseif( isset( $options['enable_sticky_posts'] ) && ( $options['enable_sticky_posts'] == 'yes' ) && $only_sticky ){
		
		$sticky = get_option( 'sticky_posts' );
		
		if( count( $sticky ) ){
			
			$queryBM['ignore_sticky_posts'] = 1;
			
			$queryBM['post__in'] = array();
			
			foreach( $sticky as $s_id ){
				$queryBM['post__in'][] = $s_id;
			}
			
		}
		
	}
	
	if( is_array( $categoriesArray ) && count( $categoriesArray ) ){
		
		$queryBM['category__in']    = $categoriesArray;
		
	}elseif( is_array( $exclude_categories ) && count( $exclude_categories ) ){
		
		$queryBM['category__not_in'] = $exclude_categories;
		
	}elseif( $categoriesAll ){
		
		$taxonomy_terms = get_terms( 'category', array( 'hide_empty' => 0, 'fields' => 'ids' ) );
		
		$queryBM['category__in'] = $taxonomy_terms;
	}
	
	//tags
	if( is_array( $tagsArray ) && count( $tagsArray ) ){
		
		$queryBM['tag__in'] = $tagsArray;
		
	}elseif( is_array( $exclude_tags ) && count( $exclude_tags ) ){
		
		$queryBM['tag__not_in'] = $exclude_tags;
		
	}elseif( $tagsAll ){
		
		$taxonomy_terms = get_terms( 'post_tag', array( 'hide_empty' => 0, 'fields' => 'ids' ) );
		
		$queryBM['tag__in'] = $taxonomy_terms;
		
	}
	
	if( is_array( $authorsArray ) && count( $authorsArray ) ){
		
		if( empty( $options['author-relation'] ) || ( $options['author-relation'] !== 'or' ) ){
			$queryBM['author__in'] = $authorsArray;
		}else{
			$this->listOptions['authorsArray'] = $authorsArray;
			add_filter( 'posts_where', array( $this, 'addORAuthors' ) );
		}
		
	}elseif( is_array( $exclude_authors ) && count( $exclude_authors ) ){
		
		if( empty( $options['author-relation'] ) || ( $options['author-relation'] !== 'or' ) ){
			$queryBM['author__not_in'] = $exclude_authors;
		}else{
			
			$this->listOptions['authorsArray'] = false;
			$this->listOptions['excludeAuthorsArray'] = $exclude_authors;
			add_filter( 'posts_where', array( $this, 'addORAuthors' ) );
		}
		
	}elseif( $authorsAll ){
		
		$authorsArray = get_users( array( 'fields' => 'ids' ) );
		
		if( empty( $options['author-relation'] ) || ( $options['author-relation'] !== 'or' ) ){
			$queryPM['author__in'] = $authorsArray;
		}else{
			$this->listOptions['authorsArray'] = $authorsArray;
			add_filter( 'posts_where', array( $this, 'addORAuthors' ) );
		}
	}
	
	if( isset( $options['enable_sticky_posts'] ) && ( $options['enable_sticky_posts'] == 'yes' ) && $only_sticky ){
		//no need any limitations
		$queryBM['posts_per_page'] = -1;
		
	}elseif( isset( $options['enable_sticky_posts'] ) && ( $options['enable_sticky_posts'] == 'yes' ) && !$only_sticky ){
		//no need any limitations
		$queryBM['posts_per_page'] = -1;
		wp_reset_query();
		$queryBM = $this->_fx_query_filter( $queryBM );
		$otw_bm_posts = new WP_Query( $queryBM );
		
	}else{
		
		if( !empty($options['posts_limit_skip']) ){
		
			$querySKIP = $queryBM;
			unset( $querySKIP['posts_per_page'] );
			unset( $querySKIP['paged'] );
			add_filter( 'post_limits', array($this, 'filterSkipLimit'), 10, 2);
			
			wp_reset_query();
			
			$otw_bm_post_skip_ids = new WP_Query( $querySKIP );
			
			remove_filter('post_limits', array($this, 'filterSkipLimit'), 10, 2);
			
			if( isset( $otw_bm_post_skip_ids->posts ) && count( $otw_bm_post_skip_ids->posts ) ) {
				$skip_post_ids = array();
				
				foreach( $otw_bm_post_skip_ids->posts as $skip_post_data ){
					$skip_post_ids[ $skip_post_data->ID ] = $skip_post_data->ID;
				}
				
				$queryBM['post__not_in'] = $skip_post_ids;
			}
		}
		
		if( !empty($options['posts_limit']) ) {
			
			$queryID = $queryBM;
			
			unset( $queryID['posts_per_page'] );
			unset( $queryID['paged'] );
			
			add_filter( 'post_limits', array($this, 'filterLimit'), 10, 2);
			
			wp_reset_query();
			$otw_bm_post_ids = new WP_Query( $queryBM );
			remove_filter('post_limits', array($this, 'filterLimit'), 10, 2);
			
			if( isset( $otw_bm_post_ids->posts ) && count( $otw_bm_post_ids->posts ) ) {
				
				$post_ids = array();
				
				foreach( $otw_bm_post_ids->posts as $post_data ){
					$post_ids[ $post_data->ID ] = $post_data->ID;
				}
				
				$queryBM['post__in'] = $post_ids;
				
				wp_reset_query();
				
				$queryBM = $this->_fx_query_filter( $queryBM );
				
				$otw_bm_posts = new WP_Query( $queryBM );
			} else {
				$otw_bm_posts = $otw_bm_post_ids;
			}
		} else {
			
			wp_reset_query();
			$queryBM = $this->_fx_query_filter( $queryBM );
			$otw_bm_posts = new WP_Query( $queryBM );
		}
	}
    }

	if( isset( $options['enable_sticky_posts'] ) && ( $options['enable_sticky_posts'] == 'yes' ) && !$only_sticky ){
		
		$non_sticky_posts = $otw_bm_posts->posts;
		
		if( $initial_options['posts_limit_page'] > 0 ){
			$initial_options['posts_limit_page'] = -1;
		}
		$sticky_posts = $this->getPosts( $initial_options, $initial_page, true );
		
		if( count( $sticky_posts->posts ) )
		{
			$post_ids = array();
			$skipped_posts = array();
			foreach( $sticky_posts->posts as $s_post )
			{
				$add_post = true;
				
				if( isset( $options['posts_limit_skip'] ) && $options['posts_limit_skip'] && $options['posts_limit_skip'] > count( $skipped_posts ) ){
					$skipped_posts[ $s_post->ID ] = $s_post->ID;
					$add_post = false;
				}elseif( isset( $options['posts_limit_page'] ) && $options['posts_limit_page'] && count( $post_ids ) >= $options['posts_limit_page'] ){
				//	$add_post = false;
				}
				if( isset( $options['posts_limit'] ) && $options['posts_limit'] && count( $post_ids ) >= $options['posts_limit'] ){
					$add_post = false;
				}
				
				if( $add_post ){
					$post_ids[ $s_post->ID ] = $s_post->ID;
				}
			}
			foreach( $non_sticky_posts as $s_post )
			{
				$add_post = true;
				
				if( isset( $options['posts_limit_skip'] ) && $options['posts_limit_skip'] && $options['posts_limit_skip'] > count( $skipped_posts ) ){
					$skipped_posts[ $s_post->ID ] = $s_post->ID;
					$add_post = false;
				}elseif( isset( $options['posts_limit_page'] ) && $options['posts_limit_page'] && count( $post_ids ) >= $options['posts_limit_page'] ){
				//	$add_post = false;
				}
				if( isset( $options['posts_limit'] ) && $options['posts_limit'] && count( $post_ids ) >= $options['posts_limit'] ){
					$add_post = false;
				}
				
				if( $add_post ){
					$post_ids[ $s_post->ID ] = $s_post->ID;
				}
			}
			if( !count( $post_ids ) ){
				$queryBM['post__in'] = array( ' ' );
				$queryBM['post__not_in'] = array();
			}else{
				$queryBM['post__in'] = array_keys( $post_ids );
				$queryBM['post__not_in'] = array();
			}
			wp_reset_query();
			
			if( !$queryBM['posts_per_page'] ){
				$queryBM['posts_per_page'] = -1;
			}
			
			$queryBM = $this->_fx_query_filter( $queryBM );
			
			$otw_bm_posts = new WP_Query( $queryBM );
			
			$this->sticky_posts = get_option( 'sticky_posts' );
			
			//add the current order so it does not change when order by stickness
			if( count( $otw_bm_posts->posts ) ){
				
				$initial_order = 0;
				foreach( $otw_bm_posts->posts as $sp_key => $sp_data ){
					
					$otw_bm_posts->posts[ $sp_key ]->_otw_initial_order = $initial_order;
					$initial_order++;
				}
				uasort( $otw_bm_posts->posts, array( $this, '_sort_by_stickness' ) );
			}
			
			if( isset( $options['posts_limit_page'] ) && ( $options['posts_limit_page'] > 1 ) ){
				
				$ordred_ids = array();
				foreach( $otw_bm_posts->posts as $s_post ){
					$ordred_ids[ $s_post->ID ] = $s_post->ID;
				}
				wp_reset_query();
				$queryBM['posts_per_page'] = $options['posts_limit_page'];
				$queryBM['post__in'] = array_keys( $ordred_ids );
				$queryBM['orderby'] = 'post__in';
				$queryBM['order'] = 'ASC';
				$otw_bm_posts = new WP_Query( $queryBM );
			}
		}
		
	}elseif( !is_object( $otw_bm_posts ) ){
		wp_reset_query();
		$queryBM = $this->_fx_query_filter( $queryBM );
		$otw_bm_posts = new WP_Query( $queryBM );
	}
	
	if( !empty( $options['author-relation'] ) && ( $options['author-relation'] === 'or' ) ){
		remove_filter( 'posts_where', array( $this, 'addORAuthors' ) );
	}
	
	return $otw_bm_posts;
    
  }
  
	public function _sort_by_stickness( $a, $b ){
	
		if( in_array( $a->ID, $this->sticky_posts ) && !in_array( $b->ID, $this->sticky_posts ) ){
			return -1;
		}
		elseif( !in_array( $a->ID, $this->sticky_posts ) && in_array( $b->ID, $this->sticky_posts ) ){
			return 1;
		}
		
		if( $a->_otw_initial_order > $b->_otw_initial_order ){
			return 1;
		}elseif( $a->_otw_initial_order > $b->_otw_initial_order ){
			return -1;
		}
		
		return 0;
	}

	public function addORAuthors( $query ){
		
		global $wpdb, $authors;
		
		$query = str_replace( "\n", " ", $query );
		
		if( !empty( $this->listOptions['authorsArray'] ) ){
			
			if( preg_match( "/AND (\(.*term_taxonomy_id.*\)) AND/", $query, $matches ) ){
			
				$query = str_replace( $matches[1], '('.$matches[1]." OR {$wpdb->posts}.post_author IN (".implode( ',', $this->listOptions['authorsArray'] ).' ) ) ', $query );
			}else{
				$query .= " AND {$wpdb->posts}.post_author IN (".implode( ',', $this->listOptions['authorsArray'] ).") ";
			}
			
		}elseif( !empty( $this->listOptions['excludeAuthorsArray'] ) ){
			
			if( preg_match( "/AND (\(.*term_taxonomy_id.*\)) AND/", $query, $matches ) ){
			
				$query = str_replace( $matches[1], '('.$matches[1]." OR {$wpdb->posts}.post_author NOT IN (".implode( ',', $this->listOptions['excludeAuthorsArray'] ).' ) ) ', $query );
			}else{
				$query .= " AND {$wpdb->posts}.post_author NOT IN (".implode( ',', $this->listOptions['excludeAuthorsArray'] ).") ";
			}
		}
		
		return $query;
	}
	
	public function _fx_query_filter( $queryBM ){
		
		if( isset( $queryBM['post__in'] ) && count( $queryBM['post__in'] ) && isset( $queryBM['post__not_in'] ) && count( $queryBM['post__not_in'] ) ){
			
			$queryBM['post__in'] = array_diff( $queryBM['post__in'] , $queryBM['post__not_in'] );
			$queryBM['post__not_in'] = array();
			
			if( !count( $queryBM['post__in'] ) ){
				
				$queryBM['post__in'] = array( ' ' );
			}
			
		}
		
		if( !$queryBM['posts_per_page'] ){
			$queryBM['posts_per_page'] = -1;
		}
		
		return $queryBM;
	}
  public function filterLimit( $limit, $query ) {
     return 'LIMIT 0, '. $this->listOptions['posts_limit'];
  }
  
  public function filterSkipLimit( $limit, $query ) {
     return 'LIMIT 0, '. $this->listOptions['posts_limit_skip'];
  }

  /**
   * Get a list of all the item in the DB
   * @return array()
   */
  public function getLists () {
    $otw_lists = get_option( 'otw_bm_lists' );

    return $otw_lists;
  }

  /**
   * Get a specific item based on it's ID
   * @param $id - int
   * @return array()
   */
  public function getItemById ( $id = null ) {
  
	global $otw_bm_factory_object, $otw_bm_plugin_id;
	
	if( is_object( $otw_bm_factory_object ) ){
		
		return $otw_bm_factory_object->pv_method( $otw_bm_plugin_id, $id );
	}
	return null;
  }

  /**
   * Get All Categories That have content and prepare the content for Select2 jQuery plugin use
   * @return array()
   */
  public function select2Categories () {
    $categories = get_categories( array( 'hide_empty' => 0 ) );
    $catCount = 0;
    $categoriesData = '';
    foreach( $categories as $category ):
      $categoriesData[$catCount]['id'] = $category->term_id;
      $categoriesData[$catCount]['text'] = $category->name;
      $catCount++;
    endforeach;

    return array(
      'categories'  => $categoriesData,
      'count'       => $catCount
    );
  }

  /**
   * Get All Tags That have content and prepare the content for Select2 jQuery plugin use
   * @return array()
   */
  public function select2Tags () {
    $tags = get_tags( array( 'hide_empty' => 0 ) );
    $tagCount = 0;
    $tagsData = '';
    foreach( $tags as $tag ):
      $tagsData[$tagCount]['id'] = $tag->term_id;
      $tagsData[$tagCount]['text'] = $tag->name;
      $tagCount++;
    endforeach;

    return array(
      'tags'  => $tagsData,
      'count' => $tagCount
    );
  }

  /**
   * Get All Users and prepare the content for Select2 jQuery plugin use
   * @return array()
   */
  public function select2Users () {
    $users = get_users();
    $userCount = 0;
    $usersData = '';
    foreach( $users as $user):
      $usersData[$userCount]['id'] = $user->data->ID;
      $usersData[$userCount]['text'] = $user->data->user_login;
      $userCount++;
    endforeach;

    return array(
      'users' => $usersData,
      'count' => $userCount
    );
  }

  /**
   * Get All Page and prepare the content for Select2 jQuery plugin use
   * @return array()
   */
  public function select2Pages () {
    $pages = get_pages();
    $pageCount = 0;
    $pagesData = '';
    foreach( $pages as $page ):
      $pagesData[$pageCount]['id'] = $page->ID;
      $pagesData[$pageCount]['text'] = $page->post_title;
      $pageCount++;
    endforeach;

    return array(
      'pages' => $pagesData,
      'count' => $pageCount
    );
  }


}

} // End if class exists