<?php

/*******************************************************************************
 
 Functions to work with slider options
 
********************************************************************************/


// keep list with all sliders under this option in database
define('ES_SLIDER_LIST', 'everslider_sliders');
	
if( false === get_option( ES_SLIDER_LIST ) ) {
	add_option( ES_SLIDER_LIST, array(), '', true );
}

// settings for every slider will be stored in database with this prefix
define('ES_SLIDER_PREFIX', 'everslider_options_');


/**
* Function to get list of sliders
* 
* @return array Array( slider_id => slider_option_name )
*/

function everslider_get_slider_list(){
	return array_keys( get_option( ES_SLIDER_LIST ) );
}


/**
* Function to get options for specific slider
*
* @param string $slider_id Slider id
* @return mixed Array with slider options. False if slider with this id does not exist
*/

function everslider_get_slider_options( $slider_id ) {
	$slider_list = get_option( ES_SLIDER_LIST );
	if ( $slider_id === '' || !isset($slider_list[$slider_id]) ) return false;
	return get_option( $slider_list[$slider_id] );
}


/**
* Function to add new slider with options
*
* @param string $slider_id Slider id
* @param array $options Options
* @return bool False if slider with this id already exist. Otherwise true
*/

function everslider_add_slider_options( $slider_id, $options ) {
	$slider_list = get_option( ES_SLIDER_LIST );
	if( $slider_id === '' || isset($slider_list[$slider_id]) ) return false;
	$slider_list[$slider_id] = ES_SLIDER_PREFIX . $slider_id;
	update_option( ES_SLIDER_LIST, $slider_list);
	return update_option( ES_SLIDER_PREFIX . $slider_id, $options );
}


/**
* Function to update slider options
*
* @param string $slider_id Slider id
* @param array $options Options
* @return mixed False if slider does not exist. Otherwise true
*/

function everslider_update_slider_options( $slider_id, $options ) {
	$slider_list = get_option( ES_SLIDER_LIST );
	if ( $slider_id === '' || !isset( $slider_list[$slider_id]) ) return false;
	return update_option( ES_SLIDER_PREFIX . $slider_id, $options );
}


/**
* Function to remove slider with options
*
* @param string $slider_id Slider id
* @return bool False if slider does not exist. Otherwise true
*/

function everslider_delete_slider_options( $slider_id ) {
	$slider_list = get_option( ES_SLIDER_LIST );
	if ( $slider_id === '' || !isset( $slider_list[$slider_id]) ) return false; 
	unset( $slider_list[$slider_id] );
	update_option( ES_SLIDER_LIST, $slider_list );
	return delete_option( ES_SLIDER_PREFIX . $slider_id );
}

?>