<?php 

/********************************************************************************

	Add custom post type for Everslider slides (carousel items) and custom
	taxonomy to group slides

********************************************************************************/


/**
* Register custom slides post type
*/

function everslider_register_slides_post_type(){		
	$labels =  array(
		'name' => __('Slides','everslider'),
		'singular_name' => __('Slide','everslider'),
		'menu_name' => __('Slides','everslider'),
		'all_items' => __('All Slides','everslider'),
		'add_new' => __('Add New','everslider'),
		'add_new_item' => __('Add New Slide','everslider'),
		'edit_item' => __('Edit Slide','everslider'),
		'new_item' => __('New Slide','everslider'),
		'view_item' => __('View Slide','everslider'),
		'search_items' => __('Search Slides','everslider'),
		'not_found' => __('No slides found','everslider'),
		'not_found_in_trash' => __('No slides found in Trash','everslider'),
		'parent_item_colon' => ''
	);
	
	$args = array(
		'labels' => $labels,
		'public' => true,
		'exclude_from_search' => true,
		'publicly_queryable' => false,
		'show_ui' => true,
		'show_in_menu' => true,
		'show_in_nav_menus' => false,
		'supports' => array('title', 'editor', 'author', 'thumbnail', 'excerpt', 'custom-fields'),
		'description' => 'Post type to create carousel items for Everslider plugin'
	);
	
	// check if slides post type is enabled
	if( get_option('everslider_post_type') ) {
		register_post_type('es-slide', $args);
	}
}

add_action('init', 'everslider_register_slides_post_type');


/**
* Register taxonomy for slides post type
*/

function everslider_register_slides_taxonomy(){		
	$labels = array(
		'name' => __('Groups','everslider'),
		'singular_name' => __('Group','everslider'),
		'menu_name' => __('Groups','everslider'),
		'all_items' => __('All Groups','everslider'),
		'edit_item' => __('Edit Group','everslider'),
		'view_item' => __('View Group','everslider'),
		'update_item' => __('Update Group','everslider'),
		'add_new_item' => __('Add New Group','everslider'),
		'new_item_name' => __('New Group Name','everslider'),
		'parent_item' => __('Parent Group','everslider'),
		'parent_item_colon' => __('Parent Group:','everslider'),
		'search_items' => __('Search Groups','everslider'),
		'popular_items' => __('Popular Groups','everslider')
	);
	
	$args = array(
		'labels' => $labels, 
		'public' => true, 
		'hierarchical' => true, 
		'show_ui' => true,
		'show_in_menu' => true,
		'show_in_nav_menus' => false,
		'show_tagcloud' => false
	);
	
	// check if slides post type is enabled
	if( get_option('everslider_post_type') ) {
		register_taxonomy('es-group', array('es-slide'), $args);
	}
}

add_action('init', 'everslider_register_slides_taxonomy');


/** 
* Function to add custom columns to slide post type
*/

function everslider_slides_add_custom_columns($columns){
	unset($columns['author'], $columns['date']);
	$columns = array_merge($columns, array(
		'featured-image' => __('Featured Image','everslider'),
		'groups' => __('Groups','everslider'),
		'author' => __('Author','everslider'),
		'date' => __('Date','everslider')
	));
	return $columns;
}

add_filter('manage_es-slide_posts_columns', 'everslider_slides_add_custom_columns');


/**
* Function to output custom columns for slide post type
*/

function everslider_slides_display_custom_column($column_name, $post_ID){
	if($column_name === 'featured-image') {
		$attachment_id = get_post_thumbnail_id($post_ID);
		if($attachment_id) {
			$thumb_url = wp_get_attachment_image_src($attachment_id, 'thumbnail');
			echo '<img width="60" height="60" src="' . $thumb_url[0] . '" alt="" />';
		} else {
			echo __('No image','everslider');
		}
	} elseif ($column_name === 'groups') {
		$post_terms = wp_get_post_terms($post_ID, 'es-group', array('fields' => 'names'));
		if( empty($post_terms) ) 
			$post_terms = array(__('-','everslider'));
		echo implode(', ', $post_terms);
	}
}

add_filter('manage_es-slide_posts_custom_column', 'everslider_slides_display_custom_column', 10, 2);


/**
* Add support for "post-thumbnails" if current theme does not support it
*/

function everslider_add_post_thumbnails_support(){
	if( !current_theme_supports('post-thumbnails') ) {
		add_theme_support('post-thumbnails');
	}
}

add_action('after_setup_theme', 'everslider_add_post_thumbnails_support');

?>