/**
 * Everslider - Responsive jQuery Carousel Plugin
 * http://plugins.gravitysign.com/everslider
 * Copyright (c) 2013 Roman Yurchuk
 * Version 1.5.1
*/

(function($){function getVendorProperty(name){var property=false,prefix=["Webkit","Moz","O","ms"];var test=document.createElement("div");if(typeof test.style[name]==="string"){property=name}else{var name_u=name.charAt(0).toUpperCase()+name.substr(1);for(var p in prefix){if(typeof test.style[prefix[p]+name_u]==="string"){property=prefix[p]+name_u;break}}}test=null;return property}function getVendorPrefix(){var prefix={WebkitTransition:"-webkit-",MozTransition:"-moz-",msTransition:"-ms-",OTransition:"-o-",transition:""};if(/(Safari|Chrome)/.test(navigator.userAgent)){return prefix.WebkitTransition}return prefix[getVendorProperty("transition")]}function checkTransform3D(){var support=false,test=document.createElement("div");var transform=getVendorProperty("transform");test.style[transform]="rotateY(45deg)";if(test.style[transform]!==""){support=true}test=null;return support}function getPixelOffset(element,cssok){var transform=getVendorProperty("transform");var position={left:0,top:0};if(transform&&cssok){var matrix=element.css(transform);if(matrix.indexOf("matrix")===0){matrix=matrix.split("(")[1].split(")")[0].split(/,\s*/);position.left=parseInt(matrix[4],10);position.top=parseInt(matrix[5],10)}}else{position=element.position()}return position}var transition=getVendorProperty("transition");var transform=getVendorProperty("transform");var cssprefix=getVendorPrefix();var transform3d=checkTransform3D();function translate(element,pixels,animate){if(typeof animate==="object"){var property=cssprefix+"transform";setTransition(element,property,animate.duration,animate.easing,animate.delay,animate.complete);if(pixels===getPixelOffset(element,true).left){animate.complete.call(element,property)}}if(transform3d){element.css(transform,"translate3d("+parseInt(pixels,10)+"px, 0px, 0px)")}else{element.css(transform,"translate("+parseInt(pixels,10)+"px, 0px)")}}function setTransition(element,properties,duration,easing,delay,complete){var easing_map={linear:"linear",swing:"cubic-bezier(.02,.01,.47,1)",easeOutCubic:"cubic-bezier(.215,.61,.355,1)",easeInOutCubic:"cubic-bezier(.645,.045,.355,1)",easeInCirc:"cubic-bezier(.6,.04,.98,.335)",easeOutCirc:"cubic-bezier(.075,.82,.165,1)",easeInOutCirc:"cubic-bezier(.785,.135,.15,.86)",easeInExpo:"cubic-bezier(.95,.05,.795,.035)",easeOutExpo:"cubic-bezier(.19,1,.22,1)",easeInOutExpo:"cubic-bezier(1,0,0,1)",easeInQuad:"cubic-bezier(.55,.085,.68,.53)",easeOutQuad:"cubic-bezier(.25,.46,.45,.94)",easeInOutQuad:"cubic-bezier(.455,.03,.515,.955)",easeInQuart:"cubic-bezier(.895,.03,.685,.22)",easeOutQuart:"cubic-bezier(.165,.84,.44,1)",easeInOutQuart:"cubic-bezier(.77,0,.175,1)",easeInQuint:"cubic-bezier(.755,.05,.855,.06)",easeOutQuint:"cubic-bezier(.23,1,.32,1)",easeInOutQuint:"cubic-bezier(.86,0,.07,1)",easeInSine:"cubic-bezier(.47,0,.745,.715)",easeOutSine:"cubic-bezier(.39,.575,.565,1)",easeInOutSine:"cubic-bezier(.445,.05,.55,.95)",easeInBack:"cubic-bezier(.6,-.28,.735,.045)",easeOutBack:"cubic-bezier(.175, .885,.32,1.275)",easeInOutBack:"cubic-bezier(.68,-.55,.265,1.55)"};var event_map={transition:"transitionend",OTransition:"oTransitionEnd otransitionend",WebkitTransition:"webkitTransitionEnd",MozTransition:"transitionend"};properties=properties.split(/\s+/);duration=(parseInt(duration,10)/1000||0)+"s";easing=easing_map[easing]||easing_map.swing;if(typeof delay==="function"){complete=delay;delay=0}delay=(parseInt(delay,10)/1000||0)+"s";complete=complete||$.noop;var transition_tmp=element.css(transition);element.bind(event_map[transition],function(e){var event=e.originalEvent;if(event.target===this){complete.call(element,event.propertyName);$(this).css(transition,transition_tmp).unbind(e)}e.stopPropagation()});var string="";for(var n=0;n<properties.length;n++){string+=properties[n]+" "+duration+" "+easing+" "+delay+", "}element.css(transition,string.slice(0,-2))}function Slider(container,settings){this.offset=0;this.visible=0;this.lock=false;this.timer=0;this.api={};this.settings=settings;this.container=$(container);this.list=this.container.find("ul.es-slides");this.total=this.list.children("li").length;this.slide=this.list.children("li:first-child");this.cssok=getVendorProperty("transition")&&this.settings.useCSS;var self=this;if(this.total===0){return null}if(this.settings.moveSlides==="auto"){this.settings.moveSlides=9999}else{this.settings.moveSlides=parseInt(this.settings.moveSlides,10)||1}this.settings.itemWidth=parseInt(this.settings.itemWidth,10)||0;if(this.settings.itemWidth>0){this.list.children().css("width",this.settings.itemWidth)}this.settings.itemHeight=parseInt(this.settings.itemHeight,10)||0;if(this.settings.itemHeight>0){this.list.children().css("height",this.settings.itemHeight)}if(this.settings.itemMargin!==false){this.list.children().css("margin-right",parseInt(this.settings.itemMargin,10)||0)}if(!this.settings.itemKeepRatio){this.list.children().css({height:"auto"})}this.slide_width=this.slide.width();this.slide_margin=parseInt(this.slide.css("margin-right"),10)||0;this.slide_ratio=this.slide.height()/this.slide.width();if(this.settings.maxVisible>0){var max_width=this.settings.maxVisible*(this.slide_width+this.slide_margin)-this.slide_margin;this.container.css("max-width",max_width)}else{this.container.css("max-width",this.settings.maxWidth)}if(this.settings.mode==="carousel"){var cloned_before=this.list.children().clone(true),cloned_after=this.list.children().clone(true);this.list.prepend(document.createComment(" END CLONED ")).prepend(cloned_before).prepend(document.createComment(" BEGIN CLONED "));this.list.append(document.createComment(" BEGIN CLONED ")).append(cloned_after).append(document.createComment(" END CLONED "));this.offset=this.total;this.total=this.total*3;var p=this.offset*(this.slide_width+this.slide_margin);if(this.cssok){translate(this.list,-p)}else{this.list.css("left",-p)}}if(this.settings.ticker&&this.settings.mode!=="normal"){this.enableTicker()}if(this.settings.navigation){this.container.append(['<div class="es-navigation">','<a href="" class="es-prev">'+this.settings.prevNav+"</a>",'<a href="" class="es-next">'+this.settings.nextNav+"</a>","</div>"].join("\n"));this.updateNavigation(this.offset);this.container.find(".es-prev").click(function(e){self.slidePrevious();e.preventDefault()}).end().find(".es-next").click(function(e){self.slideNext();e.preventDefault()}).end()}if(this.settings.pagination&&this.settings.mode!=="carousel"){this.container.append('<div class="es-pagination"></div>')}if(this.settings.touchSwipe){this.enableTouchSwipe()}if(this.settings.mouseWheel){this.enableMouseWheel()}if(this.settings.keyboard){this.enableKeyboard()}$(window).bind("resize",function(){window.clearTimeout(self.timer);self.timer=window.setTimeout(function(){self.resizeSlides()},self.settings.fitDelay)}).trigger("resize");$.extend(this.api,{slideNext:function(){self.slideNext()},slidePrevious:function(){self.slidePrevious()},isSliding:function(){return self.isSliding()},getVisibleSlides:function(){return self.getVisibleSlides()},tickerPause:function(){if("tickerPause" in self){self.tickerPause()}},tickerPlay:function(){if("tickerPlay" in self){self.tickerPlay()}}});this.container.data("everslider",this.api);this.container.bind("everslider",function(e,method){if(method in self.api){self.api[method]()}e.stopPropagation()});window.setTimeout(function(){self.container.addClass("es-slides-ready");self.getVisibleSlides().addClass("es-after-slide");if(typeof self.settings.slidesReady==="function"){self.settings.slidesReady.call(self.container.get(0),self.api)}},parseInt(this.settings.fitDelay,10)+parseInt(this.settings.fitDuration,10))}Slider.prototype.slideNext=function(){if(this.lock){return}this.slideOffset(this.getOffset("next"))};Slider.prototype.slidePrevious=function(){if(this.lock){return}this.slideOffset(this.getOffset("prev"))};Slider.prototype.isSliding=function(){return this.lock};Slider.prototype.getVisibleSlides=function(){return this.list.children().slice(this.offset,this.offset+this.visible)};Slider.prototype.getOffset=function(direction){var slide_limit=Math.min(this.settings.moveSlides,this.visible);if(direction==="prev"){if(this.settings.mode==="carousel"&&this.offset===0){var p=this.total/3*(this.slide.width()+this.slide_margin);if(this.cssok){if(this.settings.effect!=="fade"){translate(this.list,-p)}}else{if(this.settings.effect!=="fade"){this.list.css("left",-p)}}return this.total/3-slide_limit}else{if(this.settings.mode==="circular"&&this.offset===0){return this.total-this.visible}else{return this.offset-(this.offset>slide_limit?slide_limit:this.offset)}}}if(direction==="next"){var left=this.total-(this.offset+this.visible);if(this.settings.mode==="carousel"&&left===0){var p=(this.offset-this.total/3)*(this.slide.width()+this.slide_margin);if(this.cssok){if(this.settings.effect!=="fade"){translate(this.list,-p)}}else{if(this.settings.effect!=="fade"){this.list.css("left",-p)}}return this.offset-this.total/3+slide_limit}else{if(this.settings.mode==="circular"&&left===0){return 0}else{return this.offset+(left>slide_limit?slide_limit:left)}}}};Slider.prototype.slideOffset=function(offset){if(offset===this.offset){return}var self=this,adjustment=false;var unlock=function(){self.lock=false;self.offset=offset;if(!adjustment){self.syncContainerHeight();self.list.children(".es-after-slide").removeClass("es-after-slide");self.getVisibleSlides().removeClass("es-before-slide").addClass("es-after-slide").trigger("es-after-slide");if(typeof self.settings.afterSlide==="function"){self.settings.afterSlide.call(self.container.get(0),self.getVisibleSlides())}}};this.lock=true;if(this.offset===-1){adjustment=true}var pixel_offset=offset*(this.slide.width()+this.slide_margin);if(this.cssok){if(this.settings.effect==="fade"&&!adjustment){var now_visible=this.getVisibleSlides();var next_visible=this.list.children().slice(offset,offset+this.visible);$.each(now_visible,function(n){setTransition($(this),"opacity",self.settings.fadeDuration,self.settings.fadeEasing,self.settings.fadeDelay*n,function(){if(n<self.visible-1){return}next_visible.css("opacity",0);translate(self.list,-pixel_offset,{duration:0,easing:"linear",delay:15,complete:function(){$.each(next_visible,function(n){setTransition($(this),"opacity",self.settings.fadeDuration,self.settings.fadeEasing,self.settings.fadeDelay*n,function(){if(n<self.visible-1){return}now_visible.add(next_visible).css("opacity","");unlock()});$(this).css("opacity",1)})}})});$(this).css("opacity",0)})}else{translate(this.list,-pixel_offset,{duration:this.settings.slideDuration,easing:this.settings.slideEasing,delay:this.settings.slideDelay,complete:unlock})}}else{if(this.settings.effect==="fade"&&!adjustment){var now_visible=this.getVisibleSlides();var next_visible=this.list.children().slice(offset,offset+this.visible);$.each(now_visible,function(n){$(this).stop().delay(self.settings.fadeDelay*n).animate({opacity:0},self.settings.fadeDuration,self.settings.fadeEasing,function(){if(n<self.visible-1){return}next_visible.css("opacity",0);self.list.delay(10).queue(function(){$(this).css("left",-pixel_offset).dequeue();$.each(next_visible,function(n){$(this).stop().delay(self.settings.fadeDelay*n).animate({opacity:1},self.settings.fadeDuration,self.settings.fadeEasing,function(){if(n<self.visible-1){return}now_visible.add(next_visible).css("opacity","");unlock()})})})})})}else{this.list.stop().delay(this.settings.slideDelay).animate({left:-pixel_offset},this.settings.slideDuration,this.settings.slideEasing,unlock)}}if(this.settings.pagination&&this.settings.mode!=="carousel"){var slide_limit=Math.min(this.settings.moveSlides,this.visible);var active_page=Math.ceil(offset/slide_limit);this.container.find(".es-pagination a:eq("+active_page+")").addClass("es-active").siblings().removeClass("es-active")}this.updateNavigation(offset);if(!adjustment){this.list.children().slice(offset,offset+this.visible).not(".es-after-slide").addClass("es-before-slide").trigger("es-before-slide")}if(!adjustment&&typeof this.settings.beforeSlide==="function"){this.settings.beforeSlide.call(this.container.get(0),this.getVisibleSlides())}};Slider.prototype.resizeSlides=function(){this.lock=true;this.visible=this.container.width()/(this.slide_width+this.slide_margin);if(this.visible%1===0||this.visible%1<0.5){this.visible=Math.floor(this.visible)>0?Math.floor(this.visible):1}else{this.visible=Math.ceil(this.visible)}var width=(this.container.width()+this.slide_margin)/this.visible-this.slide_margin;var height=this.slide_ratio*width;var size={width:Math.round(width)};if(this.settings.itemKeepRatio){size.height=Math.round(height)}if(this.offset>0){if(this.offset+this.visible>this.total){this.offset=this.total-this.visible}var pixel_offset=this.offset*(width+this.slide_margin);if(this.cssok){translate(this.list,-pixel_offset)}else{this.list.css("left",-pixel_offset)}}var self=this;var duration=this.settings.fitDuration;var easing=this.settings.fitEasing;var unlock=function(){self.lock=false;self.syncContainerHeight()};this.list.children().each(function(){if(self.cssok){if($(this).width()===Math.round(width)){unlock()}else{setTransition($(this),"width height",duration,easing,unlock);$(this).css(size)}}else{$(this).stop().animate(size,duration,easing,unlock)}});this.updatePagination()};Slider.prototype.syncContainerHeight=function(){if(this.settings.syncHeight&&!this.settings.itemKeepRatio){var max_height=0;$.each(this.getVisibleSlides(),function(){if($(this).height()>max_height){max_height=$(this).height()}});var duration=this.settings.syncHeightDuration,easing=this.settings.syncHeightEasing;if(this.cssok){setTransition(this.container,"height",duration,easing);this.container.css("height",max_height)}else{this.container.stop().animate({height:max_height},duration,easing)}}};Slider.prototype.updatePagination=function(){if(!this.settings.pagination||this.settings.mode==="carousel"){return}var self=this;var slide_limit=Math.min(this.settings.moveSlides,this.visible);var total_pages=Math.ceil(this.total*2/(slide_limit+this.visible));var pagination=this.container.find(".es-pagination").empty();for(var i=0;i<total_pages;i++){$('<a href="#">'+i+"</a>").click((function(index){return function(e){if(self.lock){return}var offset=Math.min(index*slide_limit,self.total-self.visible);self.slideOffset(offset);e.preventDefault()}})(i)).appendTo(pagination)}var active_page=Math.ceil(this.offset/slide_limit);pagination.find("a:eq("+active_page+")").addClass("es-active").siblings().removeClass("es-active")};Slider.prototype.updateNavigation=function(offset){if(this.settings.navigation&&this.settings.mode==="normal"){var navigation=this.container.find(".es-navigation a");navigation.removeClass("es-first es-last");if(offset===0){navigation.filter(".es-prev").addClass("es-first")}if(offset===this.total-this.visible){navigation.filter(".es-next").addClass("es-last")}}};Slider.prototype.enableTouchSwipe=function(){var self=this,swipe=false;var touch_x=0,touch_y=0,pixel_offset=0;var swipeStart=function(e){var event=e;if(e.type.indexOf("touch")===0){event=e.originalEvent.changedTouches[0]}if(!self.lock){swipe=true;touch_x=event.pageX;touch_y=event.pageY;pixel_offset=getPixelOffset(self.list,self.cssok).left;self.container.bind("mousemove touchmove",swipeMove);self.container.addClass("es-swipe-grab")}};var swipeMove=function(e){var event=e;if(e.type.indexOf("touch")===0){event=e.originalEvent.changedTouches[0]}var swipe_x=event.pageX-touch_x;var swipe_y=event.pageY-touch_y;if(Math.abs(swipe_x)<self.settings.swipeThreshold){if(self.settings.effect==="slide"){if(self.cssok){translate(self.list,pixel_offset+swipe_x)}else{self.list.css("left",pixel_offset+swipe_x)}}}else{var swipe_direction=(swipe_x>0)?"prev":"next";var offset=self.getOffset(swipe_direction);self.offset=(offset===self.offset)?-1:self.offset;self.slideOffset(offset);self.container.unbind("mousemove touchmove",swipeMove)}if(!self.settings.swipePage){e.preventDefault()}};var swipeEnd=function(){if(swipe){if(!self.lock&&pixel_offset!==getPixelOffset(self.list,self.cssok).left){var offset=self.offset;self.offset=-1;self.slideOffset(offset)}self.container.unbind("mousemove touchmove",swipeMove);swipe=false;self.container.removeClass("es-swipe-grab")}};this.container.bind("mousedown touchstart",swipeStart);$("body").bind("mouseup touchend touchcancel",swipeEnd);this.container.bind("dragstart",function(e){e.preventDefault()})};Slider.prototype.enableMouseWheel=function(){if(typeof $.fn.mousewheel!=="function"){return}var self=this;this.container.bind("mousewheel",function(e,delta){if(delta>0){self.slidePrevious()}else{self.slideNext()}e.preventDefault()})};Slider.prototype.enableKeyboard=function(){var self=this;$(document).bind("keydown",function(e){if(e.which===39){self.slideNext()}else{if(e.which===37){self.slidePrevious()}}})};Slider.prototype.enableTicker=function(){var self=this,first_run=true,ticker_timer,timeout;var delay=0,duration=0,ticker_timeout=parseInt(this.settings.tickerTimeout,10);if(this.settings.effect==="fade"){delay=parseInt(this.settings.fadeDelay,10);duration=parseInt(this.settings.fadeDuration,10)}else{delay=parseInt(this.settings.slideDelay,10);duration=parseInt(this.settings.slideDuration,10)}this.tickerPlay=function(){this.container.find(".es-ticker a").hide().filter(".es-pause").show();if(first_run){timeout=ticker_timeout}else{if(self.settings.effect==="fade"){timeout=((self.visible-1)*delay+self.visible*duration)+ticker_timeout}else{timeout=(delay+duration)+ticker_timeout}}window.clearInterval(ticker_timer);ticker_timer=window.setInterval(function(){self.slideNext();if(first_run){first_run=false;self.tickerPlay()}},timeout)};this.tickerPause=function(){this.container.find(".es-ticker a").hide().filter(".es-play").show();window.clearInterval(ticker_timer);first_run=true};this.container.append('<div class="es-ticker"></div>');$('<a href="#" class="es-play">'+this.settings.tickerPlay+"</a>").click(function(e){self.tickerPlay();e.preventDefault()}).appendTo(this.container.find(".es-ticker"));$('<a href="#" class="es-pause">'+this.settings.tickerPause+"</a>").click(function(e){self.tickerPause();e.preventDefault()}).appendTo(this.container.find(".es-ticker"));if(this.settings.tickerHover){var hover_timer=0;this.container.hover(function(){window.clearTimeout(hover_timer);hover_timer=window.setTimeout(function(){self.tickerPause()},self.settings.tickerHoverDelay)},function(){window.clearTimeout(hover_timer);hover_timer=window.setTimeout(function(){self.tickerPlay()},self.settings.tickerHoverDelay)})}this.tickerPause();if(this.settings.tickerAutoStart){this.tickerPlay()}};$.fn.everslider=function(c){var s=$.extend({mode:"normal",effect:"slide",useCSS:true,itemWidth:false,itemHeight:false,itemMargin:false,itemKeepRatio:true,maxWidth:"100%",maxVisible:0,moveSlides:1,slideDelay:0,slideDuration:500,slideEasing:"swing",fadeDelay:200,fadeDuration:500,fadeEasing:"swing",fitDelay:300,fitDuration:200,fitEasing:"swing",syncHeight:false,syncHeightDuration:200,syncHeightEasing:"swing",navigation:true,nextNav:"<span>Next</span>",prevNav:"<span>Previous</span>",pagination:true,touchSwipe:true,swipeThreshold:50,swipePage:false,mouseWheel:false,keyboard:false,ticker:false,tickerTimeout:2000,tickerAutoStart:true,tickerPlay:"<span>Play</span>",tickerPause:"<span>Pause</span>",tickerHover:false,tickerHoverDelay:300,slidesReady:function(){},beforeSlide:function(){},afterSlide:function(){}},c);return this.each(function(){new Slider(this,s)})}})(jQuery);