/**
* jQuery fallback for CSS3 transitions in templates.css
*/

jQuery(document).ready(function($){
	// get IE version or false if browser is not IE
	function isIE(){
		var ua = navigator.userAgent;
		var m = ua.match(/MSIE (\d+[\.\d]*)/);		
		if(m != null) {
			return parseFloat(m[1]);
		}		
		return false;
	}
		
	// if we have CSS3 compliant browser, stop here!
	if (!isIE() || isIE() >= 10) 
		return;
	
	// "Default" template
	$('.es-default-template .es-image').hover(function(){
		$('img', this).fadeTo(500, 0.5);
	}, function(){
		$('img', this).fadeTo(500, 1);
	}).find('img').css('opacity', 1);
	
	// "Basic" template
	$('.es-basic-template .es-slide-inner').hover(function(){
		$('img', this).stop().fadeTo(500, 0.5);
	}, function(){
		$('img', this).stop().fadeTo(500, 0.8);
	}).find('img').css('opacity', 0.8);
	$('.es-basic-template .es-slides > li').bind('es-before-slide', function(){
		$('.es-title, .es-groups', this).hide();
	}).bind('es-after-slide', function(){
		$('.es-title, .es-groups', this).fadeIn(300);
	});
	
	// "Photo" template
	$('.es-photo-template .es-slides > li').bind('es-before-slide', function(){
		$('.es-caption, .es-meta', this).css({'opacity':0, 'margin-left':20});
	}).bind('es-after-slide', function(){
		$('.es-caption, .es-meta', this).animate({'opacity':1, 'margin-left':0}, 300);
	});
	
});	
