<?php

/**
* Predefined HTML templates for carousel items as $templates array. Below you can find a list of 
* placeholders that you can use in html markup. They will be replaced with actual post info when carousel
* is being generated
*
* %id%, %author%, %content%, %title%, %excerpt%, %comments_number%, %comments_link%, %date%, 
* %date_modified%, %permalink%, %slug%, %image%, %image_src%, %image_title%, %image_alt%, %image_caption%, 
* %image_description%, %groups%, %tags%, %{taxonomy}% and %meta_{key}%
*/

$templates = array();


/** "Default" slide template */

$templates['default'] = <<<TMPL
<div class="es-slide-inner">
	<div class="es-image">
		<a href="%permalink%" title="%title%">%image%</a>
	</div>
	<div class="es-content">
		<div class="es-title">
			<a href="%permalink%">%title%</a>
		</div>
		<div class="es-excerpt">%excerpt%</div>
	</div>
</div>
TMPL;


/** "Basic" slide template */

$templates['basic'] = <<<TMPL
<div class="es-slide-inner">
	<div class="es-overlay">
		<div class="es-title"><a href="%permalink%">%title%</a></div>
		<span class="es-groups">%groups%</span>
	</div>
	%image%
</div>
TMPL;


/** "Photo" slide template */

$templates['photo'] = <<<TMPL
<div class="es-slide-inner">
	<div class="es-meta">%date% / %author%</div>
	<div class="es-caption">
		<a href="%permalink%">%title%</a>
	</div>
	%image%
</div>
TMPL;

?>