<?php 
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

if (!class_exists('VC_PW_carousel')) {
	class VC_PW_carousel  {
		public  $pw_title,
				$pw_query,
				$pw_link_target,
				$pw_post_layout,
				
				$pw_carousel_min_slides,
				$pw_carousel_slide_width,
				
				$pw_teasr_layout_img,
				$pw_image_thumb_size,
				$pw_excerpt_length,
				$pw_carousel_pre_view,
				$pw_skin_type,
				$pw_grid_skin_effect,
				$pw_image_effect,
				$pw_show_zoom_icon,
				$pw_show_link_icon,
				$pw_show_overlay,
				$pw_icon_type,
				$pw_icon_effect,
				$pw_speed,
				$pw_slider_hide_pagination_control,
				$pw_slider_hide_prev_next_buttons,
				$pw_slider_loop,
				$pw_slider_autoplay,
				$pw_hide_date,
				$pw_date_format,
				
				$pw_back_color,
				
				$pw_title_font_family,
				$pw_title_font_size,
				$pw_link_color,
				$pw_link_hover_color,
				$pw_meta_font_family,
				$pw_meta_font_size,
				$pw_meta_color,
				$pw_excerpt_font_family,
				$pw_excerpt_font_size,
				$pw_excerpt_color,
				$pw_readmore_type,
				$pw_readmore_translate,
				
				$pw_hide_author,
				$pw_hide_tags,
				$pw_hide_num_comment,
				$pw_car_id;
		
		function __construct($pw_title,
							$pw_query,
							$pw_link_target,
							$pw_post_layout,
							$pw_carousel_min_slides,
							$pw_carousel_slide_width,
							$pw_teasr_layout_img,
							$pw_image_thumb_size,
							$pw_excerpt_length,
							$pw_carousel_pre_view,
							$pw_skin_type,
							$pw_grid_skin_effect,
							$pw_image_effect,
							$pw_show_zoom_icon,
							$pw_show_link_icon,
							$pw_show_overlay,
							$pw_icon_type,
							$pw_icon_effect,
							$pw_speed,
							$pw_slider_hide_pagination_control,
							$pw_slider_hide_prev_next_buttons,
							$pw_slider_loop,
							$pw_slider_autoplay,
							$pw_hide_date,
							$pw_date_format,
							
							$pw_back_color,
							
							$pw_title_font_family,
							$pw_title_font_size,
							$pw_link_color,
							$pw_link_hover_color,
							$pw_meta_font_family,
							$pw_meta_font_size,
							$pw_meta_color,
							$pw_excerpt_font_family,
							$pw_excerpt_font_size,
							$pw_excerpt_color,
							$pw_readmore_type,
							$pw_readmore_translate,
							$pw_hide_author,
							$pw_hide_tags,
							$pw_hide_num_comment	
						) {
			
			$this->pw_title=$pw_title;
			$this->pw_query=$pw_query;
			$this->pw_link_target=$pw_link_target;
			$this->pw_post_layout=$pw_post_layout;
			
			
			$this->pw_carousel_min_slides=$pw_carousel_min_slides;
			$this->pw_carousel_slide_width=$pw_carousel_slide_width;
			
			$this->pw_carousel_pre_view=$pw_carousel_pre_view;
			$this->pw_teasr_layout_img=$pw_teasr_layout_img;
			$this->pw_image_thumb_size=$pw_image_thumb_size;
			$this->pw_excerpt_length=$pw_excerpt_length;
			$this->pw_skin_type=$pw_skin_type;
			$this->pw_grid_skin_effect = $pw_grid_skin_effect;
			$this->pw_image_effect=$pw_image_effect;
			$this->pw_show_zoom_icon=$pw_show_zoom_icon;
			$this->pw_show_link_icon=$pw_show_link_icon;
			$this->pw_show_overlay=$pw_show_overlay;
			$this->pw_icon_type=$pw_icon_type;
			$this->pw_icon_effect=$pw_icon_effect;
			$this->pw_speed=$pw_speed;
			$this->pw_slider_hide_pagination_control=$pw_slider_hide_pagination_control;
			$this->pw_slider_hide_prev_next_buttons=$pw_slider_hide_prev_next_buttons;
			$this->pw_slider_loop=$pw_slider_loop;
			$this->pw_slider_autoplay=$pw_slider_autoplay;
			$this->pw_hide_date=$pw_hide_date;
			$this->pw_date_format=$pw_date_format;
			

			$this->pw_back_color = $pw_back_color;
			
			
			$this->pw_title_font_family=$pw_title_font_family;
			$this->pw_title_font_size=($pw_title_font_size==0 ? 14:$pw_title_font_size);
			$this->pw_link_color = $pw_link_color;
			$this->pw_link_hover_color = $pw_link_hover_color;
			$this->pw_meta_font_family=$pw_meta_font_family;
			$this->pw_meta_font_size=($pw_meta_font_size==0 ? 12:$pw_meta_font_size);
			$this->pw_meta_color = $pw_meta_color;
			$this->pw_excerpt_font_family=$pw_excerpt_font_family;
			$this->pw_excerpt_font_size=($pw_excerpt_font_size==0 ? 11:$pw_excerpt_font_size);
			$this->pw_excerpt_color = $pw_excerpt_color;
			$this->pw_readmore_type = $pw_readmore_type;
			$this->pw_readmore_translate = $pw_readmore_translate;
			
			$this->pw_hide_author=$pw_hide_author;
			$this->pw_hide_tags=$pw_hide_tags;
			$this->pw_hide_num_comment=$pw_hide_num_comment;

			$this->pw_front_end();
			
			$this->pl_carousel_custom_font();
			$this->pl_carousel_custom_color();
			
			//die($this->pw_hide_author.$this->pw_hide_tags.$this->pw_hide_num_comment);
		}
		
		function pw_front_end()
		{
			global $VCExtendAddonClass_CAROUSEL,$output;
			wp_enqueue_style('pw-pl-slider-style');
			wp_enqueue_script( 'pw-pl-slider-script');
			
			//$loop=$this->pw_query;
			$grid_link = $grid_layout_mode = $title = $filter= '';
			$posts = array();
			//if(empty($loop)) return;
			//$this->getLoop($loop);
			//$my_query = $this->pw_query;
			//$args = $this->loop_args;*/
			$img_id=array();
			$output = '';
			$this->pw_car_id = $rand_id = rand(3000,4000);
			 
			$paged = 1;
			$query=$this->pw_query;
			$query=explode('|',$query);
			
			$query_posts_per_page=10;
			$query_post_type='post';
			$query_meta_key='';
			$query_orderby='date';
			$query_order='ASC';
			
			$query_by_id='';
			$query_by_id_not_in='';
			$query_by_id_in='';
			
			$query_categories='';
			$query_cat_not_in='';
			$query_cat_in='';
		
			$query_tags='';
			$query_tags_in='';
			$query_tags_not_in='';
			
			$query_author='';
			$query_author_in='';
			$query_author_not_in='';
			
			$query_tax_query='';
			
			
			
			
			foreach($query as $query_part)
			{
				$q_part=explode(':',$query_part);
				switch($q_part[0])
				{
					case 'post_type':
						$query_post_type=explode(',',$q_part[1]);
					break;
					
					case 'size':
						$query_posts_per_page=($q_part[1]=='All' ? -1:$q_part[1]);
					break;
					
					case 'order_by':
						
						$query_meta_key='';
						$query_orderby='';
						
						$public_orders_array=array('ID','date','author','title','modified','rand','comment_count','menu_order');
						if(in_array($q_part[1],$public_orders_array))
						{
							$query_orderby=$q_part[1];
						}else
						{
							$query_meta_key=$q_part[1];
							$query_orderby='meta_value_num';
						}
						
					break;
					
					case 'order':
						$query_order=$q_part[1];
					break;
					
					case 'by_id':
						$query_by_id=explode(',',$q_part[1]);
						$query_by_id_not_in=array();
						$query_by_id_in=array();
						foreach($query_by_id as $ids)
						{
							if($ids<0)
							{
								$query_by_id_not_in[]=abs($ids);
							}else
							{
								$query_by_id_in[]=$ids;
							}
						}
					break;
					
					case 'categories':
						$query_categories=explode(',',$q_part[1]);
						$query_cat_not_in=array();
						$query_cat_in=array();
						foreach($query_categories as $cat)
						{
							if($cat<0)
							{
								$query_cat_not_in[]=abs($cat);
							}else
							{
								$query_cat_in[]=$cat;
							}
						}
					break;
					
					case 'tags':
						$query_tags=explode(',',$q_part[1]);
						$query_tags_not_in=array();
						$query_tags_in=array();
						foreach($query_tags as $tags)
						{
							if($tags<0)
							{
								$query_tags_not_in[]=abs($tags);
							}else
							{
								$query_tags_in[]=$tags;
							}
						}
					break;
					
					case 'authors':
						$query_author=explode(',',$q_part[1]);
						$query_author_not_in=array();
						$query_author_in=array();
						foreach($query_author as $author)
						{
							if($tags<0)
							{
								$query_author_not_in[]=abs($author);
							}else
							{
								$query_author_in[]=$author;
							}
						}
						
					break;

					case 'tax_query':
						$all_tax=get_object_taxonomies( $query_post_type );
						
						
						
						

						$tax_query=array();
						$query_tax_query=array('relation' => 'OR');
						foreach ( $all_tax as $tax ) {
							
							
							
							
							$values=$tax;
							$query_taxs_in=array();
							$query_taxs_not_in=array();
							
							$query_taxs=explode(',',$q_part[1]);
							foreach($query_taxs as $taxs)
							{
								
								if($taxs<0)
								{
									$query_taxs_not_in[]=abs($taxs);
								}else
								{
									$query_taxs_in[]=$taxs;
								}
							}
							
							
							
							

							if(count($query_taxs_not_in)>0)
							{
								$query_tax_query[]=array(
									'taxonomy' => $tax,
									'field'    => 'id',
									'terms'    => $query_taxs_not_in,
									'operator' => 'NOT IN',
								);
							}else if(count($query_taxs_in)>0)
							{
								$query_tax_query[]=array(
									'taxonomy' => $tax,
									'field'    => 'id',
									'terms'    => $query_taxs_in,
									'operator' => 'IN',
								);
							}
							
							
							
							
							//break;
						}	
						
						
						/*$query_tax_query=array(
							'relation' => 'AND',
							$tax_query,
						);*/
						//die(print_r($query_tax_query));
					break;
				}
			}
			 
			$query_final=array('post_type' => $query_post_type,
						'post_status'=>'publish',
						'posts_per_page'=>$query_posts_per_page,
						'meta_key' => $query_meta_key,
						'orderby' => $query_orderby,
						'order' => $query_order,
						'paged'=>$paged,
						
						'post__in'=>$query_by_id_in,
						'post__not_in'=>$query_by_id_not_in,
						
						'category__in'=>$query_cat_in,
						'category__not_in'=>$query_cat_not_in,
						
						'tag__in'=>$query_tags_in,
						'tag__not_in'=>$query_tags_not_in,
						
						'author__in'=>$query_author_in,
						'author__not_in'=>$query_author_not_in,
						
						'tax_query'=>$query_tax_query
					 ); 
			$my_query = new WP_Query($query_final);	
			 
			 
			$car_direction = $this->pw_post_layout=='horizontal_carousel' ? 'pl-hor' : 'pl-ver' ;
			$output .= '<h2 class="pl-itemtitle">'.$this->pw_title.'</h2>';
			$output .= '<div style="position: relative;left: 50%;top: 25%;width: 30px;">
						<i class="fa fa-circle-o-notch fa-spin fa-2x" id="loadin-i"></i>
					</div><ul class="pl-bxslider pl-car-car  pl-carousel-layout" id="slider_'.$rand_id.'" style="visibility:hidden">';
			
			$img_counter = 0;
			$images='';
			$contents='';
			while ( $my_query->have_posts() ) {
				$my_query->the_post(); // Get post from query
				$post = new stdClass(); // Creating post object.
				$post->id = get_the_ID();
				$post->link = get_permalink($post->id);
				//$this->setLinkTarget($this->pw_link_target);

				$img_id[]=get_post_meta( $post->id , '_thumbnail_id' ,true );
				
				$post_thumbnail = wpb_getImageBySize(array( 'post_id' => $post->id, 'thumb_size' => $this->pw_image_thumb_size ));
				$current_img_large = $post_thumbnail['thumbnail'];
				$current_img_full = wp_get_attachment_image_src( $img_id[$img_counter++] , 'full' );
				
				$post_type = get_post_type( $post->id );
				$post_taxonomies = get_object_taxonomies($post_type);
				$tax_counter = 0;
				
				if ($this->pw_skin_type=='pl-gridskin-one'){
					$output .= '<li class="pl-col">
							<div class="pl-car-item">';
					$post_orders = explode(',',$this->pw_teasr_layout_img);
						foreach ( $post_orders as $order ){
							$order_type = explode('|',$order);
							switch ($order_type[0]){
							case 'image':
										$output .= '<div class="pl-itemcnt">
												<div class="pl-thumbcnt '. $this->pw_image_effect .'">
													<a href="'. $post->link .'" target="'. $this->pw_link_target  .'" >'.$current_img_large.'</a>';
													
													if(isset($this->pw_show_overlay) && $this->pw_show_overlay=='no')
													{
														$output .= '
														<div class="pl-overally fadein-eff">
															<div class="pl-icon-cnt '. $this->pw_icon_effect.' '.$this->pw_icon_type.'">';
																if (isset($this->pw_show_zoom_icon) && ($this->pw_show_zoom_icon=='no')){
																	$output .= '<a href="'. $current_img_full[0] .'" class="pl-zoom-icon example-image" data-lightbox="image-set"></a>';
																}
																if (isset($this->pw_show_link_icon) && ($this->pw_show_link_icon=='no')){
																	$output .= '<a href="'. $post->link .'" class="pl-link-icon" target="'. $this->pw_link_target  .'" ></a>';
																}
															$output .= '</div><!--pl-icon-cnt -->
														</div><!-- pl-overally -->';
													}
												$output .= '		
												</div><!-- pl-thumbcnt -->
											</div><!--pl-itemcnt -->';
										 break;
							case 'title':
										$output .= '<div class="pl-detailcnt">
													<h4 class="pl-title left-txt">';
													if (isset($this->pw_hide_date) && ($this->pw_hide_date=='off')){
														$output .= '<span class="pl-date">'. get_the_date($this->pw_date_format).'</span>';
													}
													$output .= '<a target="'. $this->pw_link_target  .'" href="'. $post->link .'">'. get_the_title().'</a></h4>
												</div>';
										
											 
										if($this->pw_hide_tags!='yes' || $this->pw_hide_author!='yes'){
											$output.='		
											 <div class="pl-detailcnt">';
											 
											 if($this->pw_hide_author!='yes')
												{
													$output.='	
														<div class="pl-postmeta">
															<i class="fa fa-pencil"></i>'.get_the_author().'</div>';
												}
												if($this->pw_hide_tags!='yes')
												{
												
													$output .= pw_get_post_meta($post->id , $post_taxonomies);
												}
											$output .='</div>';	
										}
										
										
										break;
							case 'text':
										$output .= '<div class="pl-detailcnt">
													<p class="pl-text left-txt">'. $VCExtendAddonClass_CAROUSEL->excerpt(get_the_excerpt(),$this->pw_excerpt_length).'</p>';
													
													
													if($this->pw_hide_num_comment!='yes'){
														$output.='<div class="pl-postcomment"><a href="'. get_comments_link() .'"><i class="fa fa-comments"></i>'.get_comments_number( '0', '1', '% responses' ).'</a></div>';
													}
													
											$output.='			
														
											  </div>';
										break;
							case 'link':
										$output .= '<div class="pl-detailcnt">
													<a class="'.$this->pw_readmore_type.'" href="'. $post->link .'" target="'. $this->pw_link_target .'" >'.$this->pw_readmore_translate.'<i class="fa fa-angle-right"></i></a>
											  </div>';
										break;
							}//end switch
						}//end foreach
				   $output .=  '</div></li>';
				}//end if
				else if ($this->pw_skin_type=='pl-gridskin-two'){
					$output .= '
						<li class="pl-col">
							<div class="pl-car-item">
								<div class="pl-view '.$this->pw_grid_skin_effect.'">
									'.$current_img_large.'
									<div class="pl-mask">
										<h4><a href="'. $post->link .'" target="'. $this->pw_link_target  .'">'. get_the_title().'</a></h4>
										<p>'. $VCExtendAddonClass_CAROUSEL->excerpt(get_the_excerpt(),$this->pw_excerpt_length).'</p>';
											if ($this->pw_grid_skin_effect=='pl-gst-effect-1' || $this->pw_grid_skin_effect=='pl-gst-effect-2' || $this->pw_grid_skin_effect=='pl-gst-effect-3' || $this->pw_grid_skin_effect=='pl-gst-effect-4' ){
												$output.='<a class="pl-permalink" href="'. $post->link .'" target="'. $this->pw_link_target  .'" >'.$this->pw_readmore_translate.'<i class="fa fa-arrow-circle-right"></i></a>';
											}
											else {
												$output .= '<a class="link-hoverset2" href="'. $post->link .'" target="'. $this->pw_link_target  .'" >'.$this->pw_readmore_translate.'</a>';
											}
									$output.='
									</div>
								</div>
							</div>
						</li><!--col -->
						';
				}//end elseif
				
			}
			wp_reset_query();
			$output .= '</ul>';
			$output .="<script type='text/javascript'>
                jQuery(window).load(function() {
					jQuery('#loadin-i').remove();	
					jQuery('#slider_" . $rand_id ."').css('visibility','visible');
                    slider" . $rand_id ." =
					 jQuery('#slider_" . $rand_id ."').bxSlider({ 
						  mode : '".($this->pw_post_layout=='vertical_carousel' ? 'vertical' : 'horizontal' )."' ,
						  touchEnabled : true ,
						  adaptiveHeight : true ,
						  slideMargin : 10 , 
						  wrapperClass : 'pl-bx-wrapper pl-car-car ' ,
						  infiniteLoop:".($this->pw_slider_loop=='yes'?'true':'false') .",
						  pager:".($this->pw_slider_hide_pagination_control=='yes'?'false':'true').",
						  controls:".($this->pw_slider_hide_prev_next_buttons=='yes'?'false':'true').",".
						  ($this->pw_post_layout=='horizontal_carousel' ? 'slideWidth:'.$this->pw_carousel_slide_width.',' : 'slideWidth:5000,' ).
						  ($this->pw_post_layout=='horizontal_carousel' ? 'minSlides:'.$this->pw_carousel_min_slides.',' : 'minSlides:'.$this->pw_carousel_pre_view.',' )."
						  maxSlides: ". $this->pw_carousel_pre_view.",
						  moveSlides: 1,
						  auto: ".($this->pw_slider_autoplay=='yes'?'true':'false') .",
						  pause : ". $this->pw_speed."	,
						  autoHover  : true , 
 						  autoStart: true
					 });
					 jQuery('.pl-bx-wrapper .pl-bx-controls-direction a').click(function(){
						  slider" . $rand_id .".startAuto();
					 });
					 jQuery('.pl-bx-pager a').click(function(){
						 var i = jQuery(this).data('slide-index');
            			 slider" . $rand_id .".goToSlide(i);
						 slider" . $rand_id .".stopAuto();
						 restart=setTimeout(function(){
							slider" . $rand_id .".startAuto();
							},1000);
						 return false;
					 });
					 
                });	
            </script>";
		}
		
		function pl_carousel_custom_font() {
			wp_enqueue_style('pw-pl-custom-font-family', PW_PS_PL_URL_CAROUSEL . '/css/custom.css', array() , null); 
			
			$imported_font = $title_family = $meta_family = $excerpt_family = array('inherit'); 
	
			if ($this->pw_title_font_family!='inherit') {
				$imported_font[] = $this->pw_title_font_family; 
				$title_family = explode(':',str_replace('+',' ',$this->pw_title_font_family));
			} 
			if ($this->pw_meta_font_family!='inherit') {
				$imported_font[] = $this->pw_meta_font_family; 
				$meta_family = explode(':',str_replace('+',' ',$this->pw_meta_font_family));
			} 
			if ($this->pw_excerpt_font_family!='inherit') {
				$imported_font[] = $this->pw_excerpt_font_family; 
				$excerpt_family = explode(':',str_replace('+',' ',$this->pw_excerpt_font_family));
			} 
			$imported_font= array_filter(array_unique($imported_font));
			$sep='|';$font_family='';
			foreach ( $imported_font as $font ){
				if ($font_family==''){$sep='';}
				if ($font!='inherit')
					$font_family .= $sep . $font;
				$sep='|';
			}
			$custom_css='';
			if (($font_family!='inherit') && ($font_family!='')){
				$custom_css .= '
						@import url(http://fonts.googleapis.com/css?family='. $font_family.');';
			}
			
			wp_add_inline_style( 'pw-pl-custom-font-family', $custom_css );
		}
		function pl_carousel_custom_color() {
			
			wp_enqueue_style('pw-pl-custom-style', PW_PS_PL_URL_CAROUSEL . '/css/custom.css', array() , null); 
			
			
			$imported_font = $title_family = $meta_family = $excerpt_family = array('inherit'); 
	
			if ($this->pw_title_font_family!='inherit') {
				$imported_font[] = $this->pw_title_font_family; 
				$title_family = explode(':',str_replace('+',' ',$this->pw_title_font_family));
			} 
			if ($this->pw_meta_font_family!='inherit') {
				$imported_font[] = $this->pw_meta_font_family; 
				$meta_family = explode(':',str_replace('+',' ',$this->pw_meta_font_family));
			} 
			if ($this->pw_excerpt_font_family!='inherit') {
				$imported_font[] = $this->pw_excerpt_font_family; 
				$excerpt_family = explode(':',str_replace('+',' ',$this->pw_excerpt_font_family));
			} 
			$imported_font= array_filter(array_unique($imported_font));
			$sep='|';$font_family='';
			foreach ( $imported_font as $font ){
				if ($font_family==''){$sep='';}
				if ($font!='inherit')
					$font_family .= $sep . $font;
				$sep='|';
			}
			
			$box_back_color = $this->pw_back_color;
			$link_color = $this->pw_link_color;
			$link_hover_color = $this->pw_link_hover_color;
			$meta_color = $this->pw_meta_color;
			$excerpt_color = $this->pw_excerpt_color;
			
			
			$custom_css = '
				#slider_'.$this->pw_car_id.' .pl-title , #slider_'.$this->pw_car_id.' .pl-mask h4 {
					';
					$custom_css .=($this->pw_title_font_family!='inherit')?'font-family:"'.$title_family[0].'";':'';
					$custom_css .='  
					font-size:'.$this->pw_title_font_size.'px;
				}
				#slider_'.$this->pw_car_id.' .pl-title .pl-date ,#slider_'.$this->pw_car_id.' .pl-postmeta {
					';
					$custom_css .=($this->pw_meta_font_family!='inherit')?'font-family:"'.$meta_family[0].'";':'';
					$custom_css .='  
					font-size:'.$this->pw_meta_font_size.'px;
				}
				#slider_'.$this->pw_car_id.' .pl-text ,  #slider_'.$this->pw_car_id.' .pl-mask p{
					';
					$custom_css .=($this->pw_excerpt_font_family!='inherit')?'font-family:"'.$excerpt_family[0].'";':'';
					$custom_css .='  
					font-size:'.$this->pw_excerpt_font_size.'px;
				}
				
				
				#slider_'.$this->pw_car_id.' li{ 
					background : '.$box_back_color.';
				}
				#slider_'.$this->pw_car_id.' .pl-title a , #slider_'.$this->pw_car_id.' .pl-detailcnt .pl-permalink-t2 , #slider_'.$this->pw_car_id.' .pl-mask h4 a {
					color : '.$link_color.';
				} 
					#slider_'.$this->pw_car_id.' .pl-title a:hover ,  #slider_'.$this->pw_car_id.' .pl-detailcnt .pl-permalink-t2:hover , #slider_'.$this->pw_car_id.' .pl-permalink:hover , #slider_'.$this->pw_car_id.' .pl-postcomment a:hover , #slider_'.$this->pw_car_id.' .pl-mask h4 a:hover  {
						color : '.$link_hover_color.';
					} 
				#slider_'.$this->pw_car_id.' .pl-title .pl-date , #slider_'.$this->pw_car_id.' .pl-permalink  {
					background : '.$link_hover_color.';
				} 
				#slider_'.$this->pw_car_id.' .pl-postmeta , #slider_'.$this->pw_car_id.' .pl-postmeta a ,  #slider_'.$this->pw_car_id.' .pl-postcomment a{
					color : '.$meta_color.';
				}
				#slider_'.$this->pw_car_id.' .pl-postmeta a:hover   { 
					background:'.$link_hover_color.'; 
					color:#fff;
				}
				#slider_'.$this->pw_car_id.' .pl-permalink{ 
					border:1px solid '.$link_hover_color.' ;
				}
				#slider_'.$this->pw_car_id.' .pl-text , #slider_'.$this->pw_car_id.' .pl-text span , #slider_'.$this->pw_car_id.' .pl-mask p ,#slider_'.$this->pw_car_id.' .pl-mask p span{
					color : '.$excerpt_color.';
				}
				
				
				';
			
			wp_add_inline_style( 'pw-pl-custom-style', $custom_css );
		}		
	}	
}
	
?>
