<?php 
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

if (!class_exists('VC_PW_slider')) {
	class VC_PW_slider{
		public  $pw_title,
				$pw_query,
				$pw_link_target,
				$pw_excerpt_length,
				$pw_speed,
				$pw_image_thumb_size,
				$pw_slider_caption_type,
				$pw_slider_type,
				$pw_slider_elastic_animation,
				$pw_slider_height,
				$pw_slider_hide_pagination_control,
				$pw_slider_hide_prev_next_buttons,
				$pw_slider_loop,
				$pw_slider_autoplay,
				$pw_hide_date,
				$pw_date_format,
				$pw_hide_excerpt,
				$pw_hide_readmore,
				$pw_readmore_translate,
				$pw_slider_overlay_background,
				
				
				$pw_title_font_family,
				$pw_slider_link_fontsize,
				$pw_link_color,
				$pw_link_hover_color,
				$pw_excerpt_font_family,
				$pw_slider_excerpt_fontsize,
				$pw_excerpt_color,
				$pw_imgcar_id;
				
		function __construct($pw_title,
						$pw_query,
						$pw_link_target,
						$pw_excerpt_length,
						$pw_speed,
						$pw_image_thumb_size,
						$pw_slider_caption_type,
						$pw_slider_type,
						$pw_slider_elastic_animation,
						$pw_slider_height,
						$pw_slider_hide_pagination_control,
						$pw_slider_hide_prev_next_buttons,
						$pw_slider_loop,
						$pw_slider_autoplay,
						$pw_hide_date,
						$pw_date_format,
						$pw_hide_excerpt,
						$pw_hide_readmore,
						$pw_readmore_translate,
						$pw_slider_overlay_background,
						
						$pw_title_font_family,
						$pw_slider_link_fontsize,
						$pw_link_color,
						$pw_link_hover_color,
						$pw_excerpt_font_family,
						$pw_slider_excerpt_fontsize,
						$pw_excerpt_color) {
							
			$this->pw_title=$pw_title;
			$this->pw_query=$pw_query;
			$this->pw_link_target=$pw_link_target;
			$this->pw_excerpt_length=$pw_excerpt_length;
			$this->pw_slider_hide_pagination_control=$pw_slider_hide_pagination_control;
			$this->pw_slider_hide_prev_next_buttons=$pw_slider_hide_prev_next_buttons;
			$this->pw_slider_loop=$pw_slider_loop;
			$this->pw_slider_autoplay=$pw_slider_autoplay;
			$this->pw_slide_speed=$pw_speed;
			$this->pw_image_thumb_size=$pw_image_thumb_size;
			$this->pw_slider_caption_type=$pw_slider_caption_type;
			$this->pw_slider_type=$pw_slider_type;
			$this->pw_slider_elastic_animation=$pw_slider_elastic_animation;
			$this->pw_hide_date=$pw_hide_date;
			$this->pw_date_format=$pw_date_format;
			$this->pw_hide_excerpt=$pw_hide_excerpt;
			$this->pw_hide_readmore=$pw_hide_readmore;
			$this->pw_readmore_translate=$pw_readmore_translate	;
			$this->pw_slider_overlay_background=$pw_slider_overlay_background;
			
			$this->pw_slider_height=$pw_slider_height;
			$this->pw_title_font_family=$pw_title_font_family;
			$this->pw_slider_link_fontsize=$pw_slider_link_fontsize;
			$this->pw_link_color = $pw_link_color;
			$this->pw_link_hover_color = $pw_link_hover_color;
			$this->pw_excerpt_font_family=$pw_excerpt_font_family;
			$this->pw_slider_excerpt_fontsize=$pw_slider_excerpt_fontsize;
			$this->pw_excerpt_color=$pw_excerpt_color;

			$this->pw_front_end();
			$this->pl_imgcarousel_custom_font();
			$this->pl_imgcarousel_custom_color();
		}
		
		function pw_front_end()
		{
			global $VCExtendAddonClass_CAROUSEL,$output;
			wp_enqueue_style('pw-pl-slider-style');
			
			wp_enqueue_script( 'pw-pl-slider-script');
			$loop=$this->pw_query;
			$grid_link = $grid_layout_mode = $title = $filter= '';
			$posts = array();
			//if(empty($loop)) return;
			//$this->getLoop($loop);
			//$my_query = $this->query;
			//$args = $this->loop_args;
			$img_id=array();
			$output = "";	
			$elastic_paging="";		
			$this->pw_imgcar_id = $rand_id = rand(1000,2000);
			 
			$output = ''; 
			$paged = 1;
			$query=$this->pw_query;
			$query=explode('|',$query);
			
			$query_posts_per_page=10;
			$query_post_type='post';
			$query_meta_key='';
			$query_orderby='date';
			$query_order='ASC';
			
			$query_by_id='';
			$query_by_id_not_in='';
			$query_by_id_in='';
			
			$query_categories='';
			$query_cat_not_in='';
			$query_cat_in='';
		
			$query_tags='';
			$query_tags_in='';
			$query_tags_not_in='';
			
			$query_author='';
			$query_author_in='';
			$query_author_not_in='';
			
			$query_tax_query='';
			
			
			
			
			foreach($query as $query_part)
			{
				$q_part=explode(':',$query_part);
				switch($q_part[0])
				{
					case 'post_type':
						$query_post_type=explode(',',$q_part[1]);
					break;
					
					case 'size':
						$query_posts_per_page=($q_part[1]=='All' ? -1:$q_part[1]);
					break;
					
					case 'order_by':
						
						$query_meta_key='';
						$query_orderby='';
						
						$public_orders_array=array('ID','date','author','title','modified','rand','comment_count','menu_order');
						if(in_array($q_part[1],$public_orders_array))
						{
							$query_orderby=$q_part[1];
						}else
						{
							$query_meta_key=$q_part[1];
							$query_orderby='meta_value_num';
						}
						
					break;
					
					case 'order':
						$query_order=$q_part[1];
					break;
					
					case 'by_id':
						$query_by_id=explode(',',$q_part[1]);
						$query_by_id_not_in=array();
						$query_by_id_in=array();
						foreach($query_by_id as $ids)
						{
							if($ids<0)
							{
								$query_by_id_not_in[]=abs($ids);
							}else
							{
								$query_by_id_in[]=$ids;
							}
						}
					break;
					
					case 'categories':
						$query_categories=explode(',',$q_part[1]);
						$query_cat_not_in=array();
						$query_cat_in=array();
						foreach($query_categories as $cat)
						{
							if($cat<0)
							{
								$query_cat_not_in[]=abs($cat);
							}else
							{
								$query_cat_in[]=$cat;
							}
						}
					break;
					
					case 'tags':
						$query_tags=explode(',',$q_part[1]);
						$query_tags_not_in=array();
						$query_tags_in=array();
						foreach($query_tags as $tags)
						{
							if($tags<0)
							{
								$query_tags_not_in[]=abs($tags);
							}else
							{
								$query_tags_in[]=$tags;
							}
						}
					break;
					
					case 'authors':
						$query_author=explode(',',$q_part[1]);
						$query_author_not_in=array();
						$query_author_in=array();
						foreach($query_author as $author)
						{
							if($tags<0)
							{
								$query_author_not_in[]=abs($author);
							}else
							{
								$query_author_in[]=$author;
							}
						}
						
					break;

					case 'tax_query':
						$all_tax=get_object_taxonomies( $query_post_type );
						
						
						
						

						$tax_query=array();
						$query_tax_query=array('relation' => 'OR');
						foreach ( $all_tax as $tax ) {
							
							
							
							
							$values=$tax;
							$query_taxs_in=array();
							$query_taxs_not_in=array();
							
							$query_taxs=explode(',',$q_part[1]);
							foreach($query_taxs as $taxs)
							{
								
								if($taxs<0)
								{
									$query_taxs_not_in[]=abs($taxs);
								}else
								{
									$query_taxs_in[]=$taxs;
								}
							}
							
							
							
							

							if(count($query_taxs_not_in)>0)
							{
								$query_tax_query[]=array(
									'taxonomy' => $tax,
									'field'    => 'id',
									'terms'    => $query_taxs_not_in,
									'operator' => 'NOT IN',
								);
							}else if(count($query_taxs_in)>0)
							{
								$query_tax_query[]=array(
									'taxonomy' => $tax,
									'field'    => 'id',
									'terms'    => $query_taxs_in,
									'operator' => 'IN',
								);
							}
							
							
							
							
							//break;
						}	
						
						
						/*$query_tax_query=array(
							'relation' => 'AND',
							$tax_query,
						);*/
						//die(print_r($query_tax_query));
					break;
				}
			}
			 
			$query_final=array('post_type' => $query_post_type,
						'post_status'=>'publish',
						'posts_per_page'=>$query_posts_per_page,
						'meta_key' => $query_meta_key,
						'orderby' => $query_orderby,
						'order' => $query_order,
						'paged'=>$paged,
						
						'post__in'=>$query_by_id_in,
						'post__not_in'=>$query_by_id_not_in,
						
						'category__in'=>$query_cat_in,
						'category__not_in'=>$query_cat_not_in,
						
						'tag__in'=>$query_tags_in,
						'tag__not_in'=>$query_tags_not_in,
						
						'author__in'=>$query_author_in,
						'author__not_in'=>$query_author_not_in,
						
						'tax_query'=>$query_tax_query
					 ); 
			 $my_query = new WP_Query($query_final);	
			
			$output .= '<h2 class="pl-itemtitle">'.$this->pw_title.'</h2>';
			$output .='<div class="perspective">';
			if ($this->pw_slider_type=='bxslider')
				$output .= '<ul class="pl-bxslider pl-slider-car pl-slider-layout" id="imgslider_'.$rand_id.'" >';
			if ($this->pw_slider_type=='elastic'){
				$output .='<div class="pl-ei-slider" id="imgslider_'.$rand_id.'">
                   			 <ul class="pl-ei-slider-large">';
				$elastic_paging = '<ul class="pl-ei-slider-thumbs">
                        <li class="pl-ei-slider-element">Current</li>';
			}
			
			$img_counter = 0;
			while ( $my_query->have_posts() ) {
				$my_query->the_post(); // Get post from query
				$post = new stdClass(); // Creating post object.
				$post->id = get_the_ID();
				$post->link = get_permalink($post->id);
				$img_id[]=get_post_meta( $post->id , '_thumbnail_id' ,true );
				$post_thumbnail = wpb_getImageBySize(array( 'post_id' => $post->id, 'thumb_size' => $this->pw_image_thumb_size ));
				$current_img_large = $post_thumbnail['thumbnail'];
				
				if ($this->pw_slider_type=='bxslider'){
					$output .= '<li>
									<a href="'. $post->link .'" title="'.get_the_title().'"  >'.$current_img_large.'</a>
									<div class="pl-caption '.$this->pw_slider_caption_type.'">
										<div class="pl-cap-title">';
										if (isset($this->pw_hide_date) && ($this->pw_hide_date=='off')){
											$output .= '<span class="pl-sliderdate">'. get_the_date($this->pw_date_format).'</span>';
										}
										$output .= '<a href="'.$post->link.'" target="'.$this->pw_link_target.'">'.get_the_title().'</a></div>';
										if ($this->pw_hide_excerpt!='yes')
											$output .='<div class="pl-cap-desc">'.$VCExtendAddonClass_CAROUSEL->excerpt(get_the_excerpt(),$this->pw_excerpt_length).'</div>';
										if ($this->pw_hide_readmore!='yes')
											$output .='<a class="pl-permalink-t2" href="'. $post->link .'" target="'. $this->pw_link_target  .'" >'.$this->pw_readmore_translate.'<i class="fa fa-angle-right"></i></a>
									</div>';
					$output .= '</li>';
				}
				else if ($this->pw_slider_type=='elastic'){
					$output .= '<li>
									<a href="'. $post->link .'" title="'.get_the_title().'" >'.$current_img_large.'</a>
									<div class="ei-title">
									<h2><div class="pl-cap-title">';
									if (isset($this->pw_hide_date) && ($this->pw_hide_date=='off')){
										$output .= '<span class="pl-sliderdate pl-elasticdate">'. get_the_date($this->pw_date_format).'</span>';
									}
									$output .= '<a href="'.$post->link.'" target="'.$this->pw_link_target.'">'.get_the_title().'</a></div></h2>';
				
					if ($this->pw_hide_excerpt!='yes')				
									$output .='<h3><div class="pl-cap-desc pl-elasticdesc">'.$VCExtendAddonClass_CAROUSEL->excerpt(get_the_excerpt(),$this->pw_excerpt_length).'</div></h3>';
									
								$output .='</div>
								</li>';
					$elastic_paging .= '<li><a href="#"></a>'.$current_img_large.'</li>';
				}
			}
			$output .= '</ul>';
			
			if ($this->pw_slider_type=='elastic'){
					$elastic_paging .= '</ul>';//pagination end;
				$output .= $elastic_paging;
				$output .='</div>';
				 
			}
			$output .='</div><!--perspective -->';
			wp_reset_query();
			if ($this->pw_slider_type=='bxslider'){
				$output .="<script type='text/javascript'>
			  
					jQuery(document).ready(function() {
						slider" . $rand_id ." =
						 jQuery('#imgslider_" . $rand_id ."').bxSlider({ 
							  mode : 'horizontal' ,
							  touchEnabled : true ,
							  adaptiveHeight : true ,
							  slideMargin : 10 , 
							  wrapperClass : 'pl-bx-wrapper pl-car-car ' ,
							  infiniteLoop:".($this->pw_slider_loop=='yes'?'true':'false') .",
							  pager:".($this->pw_slider_hide_pagination_control=='yes'?'false':'true').",
							  controls:".($this->pw_slider_hide_prev_next_buttons=='yes'?'false':'true').",
							  minSlides: 1,
							  maxSlides: 1,
							  moveSlides: 1,
							  auto: ".($this->pw_slider_autoplay=='yes'?'true':'false') .",
							  pause : ". $this->pw_slide_speed.",
							  autoHover  : true , 
							  autoStart: true
						 });
						 jQuery('.pl-bx-wrapper .pl-bx-controls-direction a').click(function(){
							  slider" . $rand_id .".startAuto();
						 });
						 jQuery('.pl-bx-pager a').click(function(){
							 var i = jQuery(this).data('slide-index');
							 slider" . $rand_id .".goToSlide(i);
							 slider" . $rand_id .".stopAuto();
							 restart=setTimeout(function(){
								slider" . $rand_id .".startAuto();
								},1000);
							 return false;
						 });
					});	
				</script>";	
			}
			else if ($this->pw_slider_type=='elastic'){
				$output .="<script type='text/javascript'>
					jQuery(document).ready(function() {
						 jQuery('#imgslider_" . $rand_id ."').eislideshow({ 
							animation			: '".$this->pw_slider_elastic_animation."',
							autoplay			: true,
							slideshow_interval	: ".$this->pw_slide_speed.",
							speed          		: 800,
							titlesFactor		: 0.60,
							titlespeed          : 1000,
							thumbMaxWidth       : 100
						 });
						 
						 
					});	
				</script>";	
			}
			
		}
		
		function pl_imgcarousel_custom_font() {
			wp_enqueue_style('pw-pl-custom-font-family', PW_PS_PL_URL_CAROUSEL . '/css/custom.css', array() , null); 
			
			$imported_font = $title_family = $meta_family = $excerpt_family = array('inherit'); 
	
			if ($this->pw_title_font_family!='inherit') {
				$imported_font[] = $this->pw_title_font_family; 
				$title_family = explode(':',str_replace('+',' ',$this->pw_title_font_family));
			} 
			
			if ($this->pw_excerpt_font_family!='inherit') {
				$imported_font[] = $this->pw_excerpt_font_family; 
				$excerpt_family = explode(':',str_replace('+',' ',$this->pw_excerpt_font_family));
			} 
			$imported_font= array_filter(array_unique($imported_font));
			$sep='|';$font_family='';
			foreach ( $imported_font as $font ){
				if ($font_family==''){$sep='';}
				if ($font!='inherit')
					$font_family .= $sep . $font;
				$sep='|';
			}
			$custom_css='';
			if (($font_family!='inherit') && ($font_family!='')){
				$custom_css .= '
						@import url(http://fonts.googleapis.com/css?family='. $font_family.');';
			}
			
			wp_add_inline_style( 'pw-pl-custom-font-family', $custom_css );
		}
		function pl_imgcarousel_custom_color() {
			
				wp_enqueue_style('pw-pl-custom-style', PW_PS_PL_URL_CAROUSEL . '/css/custom.css', array() , null); 
				
				$imported_font = $title_family = $excerpt_family = array('inherit'); 
	
				if ($this->pw_title_font_family!='inherit') {
					$imported_font[] = $this->pw_title_font_family; 
					$title_family = explode(':',str_replace('+',' ',$this->pw_title_font_family));
				} 
				if ($this->pw_excerpt_font_family!='inherit') {
					$imported_font[] = $this->pw_excerpt_font_family; 
					$excerpt_family = explode(':',str_replace('+',' ',$this->pw_excerpt_font_family));
				} 
				$imported_font= array_filter(array_unique($imported_font));
				$sep='|';$font_family='';
				foreach ( $imported_font as $font ){
					if ($font_family==''){$sep='';}
					if ($font!='inherit')
						$font_family .= $sep . $font;
					$sep='|';
				}
			
				$pl_overlay_back = $this->pw_slider_overlay_background;
				$pl_link_fontsize = $this->pw_slider_link_fontsize.'px ';
				$pl_excerpt_fontsize =$this->pw_slider_excerpt_fontsize.'px ';
				$pl_link_color =$this->pw_link_color;
				$pl_link_color_hover =$this->pw_link_hover_color;
				$pl_excerpt_color =$this->pw_excerpt_color;
				
				$custom_css = '
				
					#imgslider_'.$this->pw_imgcar_id.' .pl-cap-title  {
						';
						$custom_css .=($this->pw_title_font_family!='inherit')?'font-family:"'.$title_family[0].'";':'';
						$custom_css .='  
						font-size:'.$this->pw_slider_link_fontsize.'px;
					}
					
					#imgslider_'.$this->pw_imgcar_id.' .pl-cap-desc{
						';
						$custom_css .=($this->pw_excerpt_font_family!='inherit')?'font-family:"'.$excerpt_family[0].'";':'';
						$custom_css .='  
						font-size:'.$this->pw_slider_excerpt_fontsize.'px;
					}
					
					
					#imgslider_'.$this->pw_imgcar_id.' .pl-caption , #imgslider_'.$this->pw_imgcar_id.' .ei-title .pl-cap-desc.pl-elasticdesc , #imgslider_'.$this->pw_imgcar_id.' .ei-title .pl-cap-title{
						background : '.$pl_overlay_back.';
					}
					#imgslider_'.$this->pw_imgcar_id.' .pl-caption .pl-cap-title .pl-sliderdate , #imgslider_'.$this->pw_imgcar_id.' .ei-title h2 .pl-sliderdate{
						background: '.$pl_link_color_hover.';
					}
					#imgslider_'.$this->pw_imgcar_id.' .pl-caption .pl-cap-title a , #imgslider_'.$this->pw_imgcar_id.' .ei-title h2 a , #imgslider_'.$this->pw_imgcar_id.' .ei-title h2 span{
						color: '.$pl_link_color.';
						font-size:'.$pl_link_fontsize.'!important;
					}
					#imgslider_'.$this->pw_imgcar_id.' .ei-title h2 span{
						font-size:'.$pl_link_fontsize.'!important;
					}
						#imgslider_'.$this->pw_imgcar_id.' .pl-caption .pl-cap-title a:hover, #imgslider_'.$this->pw_imgcar_id.' .ei-title h2 a:hover{
							color:'.$pl_link_color_hover.';
						}
					#imgslider_'.$this->pw_imgcar_id.' .pl-caption .pl-cap-desc , #imgslider_'.$this->pw_imgcar_id.' .pl-caption .pl-cap-desc span , #imgslider_'.$this->pw_imgcar_id.' .ei-title h3 .pl-cap-desc , #imgslider_'.$this->pw_imgcar_id.' .ei-title h3 .pl-cap-desc span	{
						color: '.$pl_excerpt_color.';
						font-size: '.$pl_excerpt_fontsize.';
					}
					#imgslider_'.$this->pw_imgcar_id.' .pl-caption  a.pl-permalink-t2{
						color: '.$pl_link_color.';
					}
						#imgslider_'.$this->pw_imgcar_id.' .pl-caption  a.pl-permalink-t2:hover{
							color: '.$pl_link_color_hover.';
						}
					#imgslider_'.$this->pw_imgcar_id.'.pl-ei-slider{ height:'.$this->pw_slider_height.'px!important;}
					';
				
				wp_add_inline_style( 'pw-pl-custom-style', $custom_css );
			}		
		
	}	
}
	
?>
