<?php
$paged = max(1, (isset($_GET['paged']) ? (int) $_GET['paged'] : 0));
$keyword = isset($_GET['keyword']) ? $_GET['keyword'] : '';
$order = (isset($_GET['order']) and $_GET['order'] == 'DESC') ? 'DESC' : 'ASC';
$orderby = (isset($_GET['orderby']) and in_array($_GET['orderby'], ['ID', 'title'])) ? $_GET['orderby'] : 'title';
$args = [
    'post_type' => $superposttype,
    's' => $keyword,
    'order' => $order,
    'orderby' => $orderby,
    'paged' => $paged
];
$loop = new WP_Query($args);
if (count($loop->posts)) {
    $orderR = ($order == 'DESC') ? 'ASC' : 'DESC';
    $nameUrl = admin_url("admin.php?page={$superpage}&keyword=" . urlencode(esc_attr($keyword)) . '&orderby=title&order=' . $orderR . '&paged=1');
    $idUrl = admin_url("admin.php?page={$superpage}&keyword=" . urlencode(esc_attr($keyword)) . '&orderby=ID&order=' . $orderR . '&paged=1');
?>
    <p class="search-box supercarousel-listing-search">
    <form action="<?php echo admin_url('admin.php'); ?>">
        <input type="hidden" name="page" value="<?php echo $superpage; ?>" />
        <input type="search" id="post-search-input" name="keyword" value="<?php echo esc_attr($keyword); ?>" />
        <input type="hidden" name="paged" value="1" />
        <input type="submit" id="search-submit" class="button" value="Search">
    </form>
    </p>
    <table class="superlisting">
        <thead>
            <tr>
                <th class="su_id">
                    <a href="<?php echo $idUrl; ?>">
                        #<?php _e('ID', 'supercarousel'); ?>
                        <?php
                        if ($orderby == 'ID') {
                            echo ($orderR == 'ASC') ? '<span class="dashicons dashicons-arrow-down"></span>' : '<span class="dashicons dashicons-arrow-up"></span>';
                        }
                        ?>
                    </a>
                </th>
                <th>
                    <a href="<?php echo $nameUrl; ?>">
                        <?php _e('Name', 'supercarousel'); ?>
                        <?php
                        if ($orderby == 'title') {
                            echo ($orderR == 'ASC') ? '<span class="dashicons dashicons-arrow-down"></span>' : '<span class="dashicons dashicons-arrow-up"></span>';
                        }
                        ?>
                    </a>
                </th>
                <?php
                if ($superposttype == 'supercarousel') {
                ?>
                    <th class="su_shortcode"><?php _e('Short Code', 'supercarousel'); ?></th>
                <?php
                } else if ($superposttype == 'supercontent') {
                ?>
                    <th class="su_shortcode"><?php _e('Categories', 'supercarousel'); ?></th>
                <?php
                }
                ?>
                <th class="su_action"><?php _e('Manage', 'supercarousel'); ?></th>
                <th class="su_action"><?php _e('Delete', 'supercarousel'); ?></th>
            </tr>
        </thead>
        <tbody>
            <?php
            foreach ($loop->posts as $row) {
                $editurl = "admin.php?page={$superpage}&act=edit&id=" . $row->ID;
            ?>
                <tr>
                    <td><?php echo $row->ID; ?></td>
                    <td class="su_name">
                        <a href="<?php echo $editurl; ?>"><?php echo $row->post_title; ?></a>
                    </td>
                    <?php
                    if ($superposttype == 'supercarousel') {
                    ?>
                        <td class="su_shortcode">
                            <input type="text" class="supercarousel_shortcode_ip" readonly="" value="[supercarousel slug='<?php echo $row->post_name; ?>']" onclick="this.select();" onfocus="this.select();" />
                        </td>
                    <?php
                    } else if ($superposttype == 'supercontent') {
                    ?>
                        <td>
                            <?php
                            echo SuperCarousel_Common::get_super_content_categories($row->ID);
                            ?>
                        </td>
                    <?php
                    }
                    ?>
                    <td class="su_action"><a href="<?php echo $editurl; ?>"><span class="dashicons dashicons-edit"></span></a></td>
                    <td class="su_action"><a href="javascript:void(0);" onclick="SupercarouselCommon.delete_supercarousel('<?php echo $row->ID; ?>');"><span class="dashicons dashicons-dismiss"></span></a></td>
                </tr>
            <?php
            }
            ?>
        </tbody>
    </table>
    <div class="su_paging">
        <?php
        $args = array(
            'base' => '%_%',
            'format' => '?paged=%#%',
            'total' => $loop->max_num_pages,
            'current' => $paged,
            'show_all' => false,
            'end_size' => 1,
            'mid_size' => 2,
            'prev_next' => true,
            'prev_text' => __('<span class="dashicons dashicons-arrow-left-alt2"></span>'),
            'next_text' => __('<span class="dashicons dashicons-arrow-right-alt2"></span>'),
            'type' => 'plain',
            'add_args' => false,
            'add_fragment' => '',
            'before_page_number' => '',
            'after_page_number' => ''
        );
        echo paginate_links($args);
        ?>
    </div>
<?php
} else {
?>
    <h1 class="centered">No Records Found</h1>
<?php
}
?>