<?php
/**
 * bullet-list.php
 * Template part for the WP Post Modules Plugin
 *
 * @version 3.3.0
 * All variables coming from parent file wp-post-modules.php
 */
	$out = '';
	$protocol = is_ssl() ? 'https' : 'http';
	$id = 'wppm-ajax-posts-' . $GLOBALS['wppm_ajax_container_count'];
	if ( $sc_btn ) {
		$sc = wppm_vc_get_sc( $atts );
	}

	$out = sprintf( '%s%s<ul%s%s class="wppm bullet-list%s%s%s%s%s">',
		$ajaxnav || $ajaxloadmore ? sprintf( '<div id="%s" class="wppm-ajax-posts%s" data-params=\'%s\' data-maxposts="%s">', $id, ' wppm_custom_css_' . $wppm_css_count, json_encode( $atts, JSON_FORCE_OBJECT ), $custom_query->found_posts ) : '',
		( $sc_btn && is_user_logged_in() && ( current_user_can( 'edit_pages' ) || current_user_can( 'edit_posts' ) ) ) ? '<a href="#" class="wppm-get-sc" data-val="' . esc_attr( $sc ) . '">' . esc_attr__( 'Get Shortcode', 'wppm' ) . '</a>' : '',
		$enable_schema ? ' itemscope="itemscope" itemtype="' . $protocol . '://schema.org/Blog"' : '',
		$ajaxnav ? ' id="' . $id . '-sub-1"' : '',
		$vc_class,
		! ( $ajaxnav || $ajaxloadmore ) ? ' wppm_custom_css_' . $wppm_css_count : '',
		$hsize ? ' fs-' . esc_attr( $hsize ) : '',
		$hfontweight ? ' fw-' . esc_attr( $hfontweight ) : '',
		$xclass ? ' ' . esc_attr( $xclass ) : ''
	);

	// Main loop
	while ( $custom_query->have_posts() ) :
		$custom_query->the_post();
		global $multipage;
		$multipage = 0;

		// Set post title
		$title = wppm_generate_title( $hsource, $h_cust_field_key, $h_length, $h_meta_box );

		// Post classes
		$post_id = get_the_ID();
		$post_class_obj = get_post_class( $post_id );
		$post_classes = 'wppm-post ';
		if ( isset( $post_class_obj ) && is_array( $post_class_obj ) ) {
			$post_classes .= implode( ' ', $post_class_obj );
		}
		if ( is_sticky( $post_id ) ) {
			$post_classes .= ' sticky';
		}

		// List type module style
		$format = apply_filters( 'wppm_bullet_list_output', '<li%7$s%8$s id="post-%1$s" class="%2$s"><%5$s%8$s class="entry-title"><a href="%3$s" title="%4$s">%9$s</a></%5$s></li>' );

		$out .= sprintf ( $format,
			get_the_id(),
			$post_classes,
			esc_url( get_permalink() ),
			wp_strip_all_tags( $title ),
			sanitize_text_field( $htag ),
			$enable_schema && $container_type != '' ? ' itemscope itemtype="' . $protocol . '://schema.org/' . esc_attr( $container_type ) . '"' : '',
			$enable_schema && $container_prop != '' ? ' itemprop="' . esc_attr( $container_prop ) . '"' : '',
			$enable_schema && $heading_prop != '' ? ' itemprop="' . esc_attr( $heading_prop ) . '"' : '',
			$title
		);

	endwhile;

	if ( $ajaxnav ) {
		$out .= sprintf( '</ul><div class="wppm-ajax-nav"><a class="prev-link disabled" href="#">%s</a> <a class="next-link" href="#">%s</a>%s</div></div>',
			__( 'Prev', 'wppm' ),
			__( 'Next', 'wppm' ),
			$nav_status ? '<span class="nav-status" data-format="' . esc_attr( $nav_status_text ) . '"></span>' : ''
		);
	}
	elseif ( $ajaxloadmore ) {
		$out .= sprintf( '</ul><div class="wppm-ajax-loadmore"><div class="wppm-loading-spinner"></div><a class="wppm-more-link" href="#">%s</a></div></div>',
			esc_attr( $loadmore_text )
		);
	}
	else {
		$out .= '</ul>';
	}
	echo $out;