<?php
/**
 * slider.php
 * Template part for the WP Post Modules Plugin
 *
 * @since 1.0.0
 * @version 3.3.0
 *
 * All variables coming from parent file wp-post-modules.php
 */

 	$out = '';
	$count = 0;
	$protocol = is_ssl() ? 'https' : 'http';
	if ( $sc_btn ) {
		$sc = wppm_vc_get_sc( $atts );
	}

	$params = array(
		'items'				=> esc_attr( $items ),
		'loop'				=> esc_attr( $loop ),
		'margin'			=> esc_attr( $margin ),
		'margin_mobile'		=> esc_attr( $margin_mobile ),
		'autoplay'			=> esc_attr( $autoplay ),
		'timeout'			=> esc_attr( $timeout ),
		'autoheight'		=> esc_attr( $autoheight ),
		'nav'				=> esc_attr( $nav ),
		'dots'				=> esc_attr( $dots ),
		'speed'				=> esc_attr( $speed ),
		'animatein'			=> esc_attr( $animatein ),
		'animateout'		=> esc_attr( $animateout ),
		'stagepadding'		=> esc_attr( $stagepadding )
	);

	$json = json_encode( $params, JSON_FORCE_OBJECT );

	$slider_id = 'slider-' . rand( 2, 400000 );
	$out = sprintf( '<div%s class="wppm wppm-%s%s%s%s%s%s%s%s%s%s%s%s owl-wrap posts-slider clearfix%s%s%s%s" data-params=\'%s\'><div class="owl-carousel owl-loading" id="%s">%s',
		$enable_schema ? ' itemscope="itemscope" itemtype="' . $protocol . '://schema.org/Blog"' : '',
		$template,
		(int)$content_padding != 20 ? ' pad-' . esc_attr( $content_padding ) : '',
		' ' . esc_attr( $sub_type ),
		( 'list' == $template && $mobile_wide ) ? ' mobile-wide' : '',
		( 'list' == $template ) ? ' gutter-' . esc_attr( $gutter_grid ) : '',
		'list' == $template ? ' split-' . esc_attr( $list_split ) : '',
		( 'list' == $template && $circle_img == 'true' ) ? ' circle-img' : '',
		'list' == $template ? ' ' . esc_attr( $list_sep ) : '',
		'list' == $template ? ( $content_left ? ' content-left' : '' ) : '',
		'list' == $template ? ' list-gutter-' . esc_attr( $gutter_list ) : '',
		$counter ? ' count-enabled' : '',
		( 'grid' == $template && ( $sub_type_grid == 's3' || $sub_type_grid == 's4' ) ) ? ' split-' . esc_attr( $grid_split ) : '',
		$vc_class,
		! ( $ajaxnav || $ajaxloadmore ) ? ' wppm_custom_css_' . $wppm_css_count : '',
		'inherit' != $meta_align ? ' meta-' . esc_attr( $meta_align ) : '',
		$xclass ? ' ' . esc_attr( $xclass ) : '',
		$json,
		$slider_id,
		( $sc_btn && is_user_logged_in() && ( current_user_can( 'edit_pages' ) || current_user_can( 'edit_posts' ) ) ) ? '<a href="#" class="wppm-get-sc" data-val="' . esc_attr( $sc ) . '">' . esc_attr__( 'Get Shortcode', 'wppm' ) . '</a>' : ''
	);

	// Main loop
	while ( $custom_query->have_posts() ) :
		$custom_query->the_post();
		global $multipage;
		$multipage = 0;

		// Set post title
		$title = wppm_generate_title( $hsource, $h_cust_field_key, $h_length, $h_meta_box );

		// Post classes
		$post_id = get_the_ID();
		$post_class_obj = get_post_class( $post_id );
		$post_classes = 'wppm-post ';

		// Post classes
		if ( isset( $post_class_obj ) && is_array( $post_class_obj ) ) {
			$post_classes .= implode( ' ', $post_class_obj );
		}
		if ( is_sticky( $post_id ) ) {
			$post_classes .= ' sticky';
		}

		/**
		 * Overlay content classes
		 * Overlay position, gradient type etc.
		 */
		$post_classes .= $content_pos != '' ? ' content-' . esc_attr( $content_pos ) : '';
		$post_classes .= $overlay_style != '' ? ' overlay-' . esc_attr( $overlay_style ) : '';
		$post_classes .= $show_overlay != '' ? ' show-' . esc_attr( $show_overlay ) : '';
		$post_classes .= $image_effect != '' || $image_effect != 'none' ? ' img-' . esc_attr( $image_effect ) : '';

		// Get excerpt based on chosen source
		$excerpt_text = wppm_generate_excerpt( $psource, $allowed_tags, $content_filter, $cust_field_key, $excerpt_length, $meta_box );

		$excerpt = ( $hide_excerpt == 'true' ) ? ''
					: sprintf( '<%1$s%2$s class="post-text%3$s">%4$s</%1$s>',
						$ptag,
						$enable_schema && $excerpt_prop != '' ? ' itemprop="' . esc_attr( $excerpt_prop ) . '"' : '',
						$psize ? ' fs-' . esc_attr( $psize ) : '',
						$excerpt_text
					);

		// User defined post meta
		$user_meta = '';
		$rows = array( 'row_1' => '', 'row_2' => '', 'row_3' => '', 'row_4' => '' );
		$metas = wppm_custom_meta();
		if ( $custom_meta ) {
			$user_meta = sprintf( '<span class="entry-meta custom-format">' . rawurldecode( base64_decode( strip_tags( $meta_format ) ) ) . '</span>', $metas['author'], $metas['date'], $metas['date_modified'], $metas['categories'], $metas['comments'], $metas['permalink'] );
		}

		else { // Generate post meta
			$meta_args = array(
				'template'	=> 'grid',
				'date_format' => $date_format,
				'enable_schema' => $enable_schema,
				'hide_cats' => $hide_cats,
				'hide_reviews' => $hide_reviews,
				'hide_date' => $hide_date,
				'hide_author' => $hide_author,
				'show_avatar' => $show_avatar,
				'hide_views' => $hide_views,
				'hide_comments' => $hide_comments,
				'ext_link'	=> $ext_link,
				'readmore' => $readmore,
				'readmore_text' => $readmore_text,
				'readmore_link_src' 	=> $readmore_link_src,
				'readmore_cust_link' 	=> $readmore_cust_link,
				'readmore_target_blank' => $readmore_target_blank,
				'publisher_logo' => $publisher_logo,
				'excerpt_length' => $excerpt_length,
				'sharing' => $sharing,
				'share_style' => $share_style,
				'share_btns' => $share_btns,

				// Schema props
				'datecreated_prop'		=> $datecreated_prop,
				'datemodified_prop'		=> $datemodified_prop,
				'publisher_type'		=> $publisher_type,
				'publisher_prop'		=> $publisher_prop,
				'publisher_name'		=> $publisher_name,
				'publisher_logo'		=> $publisher_logo,
				'authorbox_type'		=> $authorbox_type,
				'authorbox_prop'		=> $authorbox_prop,
				'authorname_prop'		=> $authorname_prop,
				'authoravatar_prop'		=> $authoravatar_prop,
				'category_prop'			=> $category_prop,
				'commentcount_prop'		=> $commentcount_prop,
				'commenturl_prop'		=> $commenturl_prop
			);

			$rows = wppm_meta( $meta_args );
		}

		// Image resizing
		$img = '';
		$no_image_class = '';
		$thumblink = '';
		// Show video embed if available
		if ( 'video' == get_post_format() && $show_embed ) {
			$content = apply_filters( 'the_content', get_the_content() );
			$video = false;

			// Only get video from the content if a playlist isn't present.
			if ( false === strpos( $content, 'wp-playlist-script' ) ) {
				$video = get_media_embedded_in_content( $content, array( 'video', 'object', 'embed', 'iframe' ) );
			}

			if ( is_array( $video ) && isset( $video[0] ) ) {
				if ( preg_match("/wp-video-shortcode/", $video[0]) ) {
					$thumblink = '<div class="post-img">' . $video[0] . '</div>';
				}
				else {
					$thumblink = '<div class="post-img"><div class="embed-wrap">' . $video[0] . '</div></div>';
				}
			}

		}

		// Show post thumbnail if available
		if ( has_post_thumbnail() && ! $hide_thumbnail && '' === $thumblink ) {

			$src = wp_get_attachment_url( get_post_thumbnail_id() );
			$img = wppm_image_resize( $src, $imgwidth, $imgheight, $imgcrop, $imgquality, $imgcolor, $imggrayscale );
			// Get dominant color from image
			if ( 'autobg' == $overlay_style ) {
				$pallet = wppm_get_color_pallet( $src, array( 8, 4 ) );
				$dc = wppm_get_dominant_color( $pallet );
			}

			$format_icon = '';

			if ( ( 'video' == get_post_format() || 'gallery' == get_post_format() ) && ! $hide_post_format_icon && ! $hide_thumbnail ) {
				$format_icon = '<div class="' . get_post_format() . '-overlay"></div>';
			}

			if ( $use_native_thumbs ) {
				$thumblink = sprintf( apply_filters( 'wppm_slider_thumbnail', '<div%5$s class="post-img%7$s"><a href="%1$s" title="%2$s">%3$s%4$s</a>%6$s</div>' ),
					esc_url( get_permalink() ),
					esc_attr( $title ),
					$enable_schema ? get_the_post_thumbnail( get_the_id(), $imgsize, array( 'itemprop' => 'url', 'class' => $img_xclass ? 'wppm-img ' . $img_xclass : 'wppm-img' ) ) : get_the_post_thumbnail( get_the_id(), $imgsize, array( 'class' => $img_xclass ? 'wppm-img ' . $img_xclass : 'wppm-img' ) ),
					$format_icon,
					$enable_schema ? ' itemprop="image" itemscope itemtype="' . $protocol . '://schema.org/ImageObject"' : '',
					$enable_captions && get_the_post_thumbnail_caption() ? '<p class="wp-caption-text">' . get_the_post_thumbnail_caption() . '</p>' : '',
					$enable_captions && get_the_post_thumbnail_caption() ? ' has-caption' : ''
				);
			}
			else {
				$thumblink = sprintf( apply_filters( 'wppm_slider_thumbnail_bfi', '<div%5$s class="post-img%8$s"><a href="%1$s" title="%2$s"><img%6$s class="wppm-img%9$s" src="%3$s" alt="%2$s" title="%2$s"/>%4$s</a>%7$s</div>' ),
					esc_url( get_permalink() ),
					esc_attr( $title ),
					$img,
					$format_icon,
					$enable_schema ? ' itemprop="image" itemscope itemtype="' . $protocol . '://schema.org/ImageObject"' : '',
					$enable_schema ? ' itemprop="url"' : '',
					$enable_captions && get_the_post_thumbnail_caption() ? '<p class="wp-caption-text">' . get_the_post_thumbnail_caption() . '</p>' : '',
					$enable_captions && get_the_post_thumbnail_caption() ? ' has-caption' : '',
					$img_xclass ? ' ' . esc_attr( $img_xclass ) : ''
				);
			}
		} // has post thumbnail
		else {
			$no_image_class = ' no-image';
		}

		// Portfolio type module style
		if ( ( 'portfolio' == $template ) ) {
			$format = apply_filters( 'wppm_portfolio_output', '<article%10$s%11$s class="%1$s"><div class="tile-wrap">%18$s%2$s<div class="tile-content%15$s"%16$s><div class="tile-overlay">%3$s<%9$s%12$s class="entry-title%13$s%14$s"><a href="%4$s" title="%17$s">%5$s</a></%9$s>%6$s%7$s%8$s</div></div></div></article>' );
			if ( has_post_thumbnail() ) {
				$out .= sprintf ( $format,
					$post_classes,
					$thumblink,
					( $custom_meta && $meta_pos == '1' ) ? $user_meta : $rows['row_1'],
					esc_url( get_permalink() ),
					esc_attr( $title ),
					( $custom_meta && $meta_pos == '2' ) ? $user_meta : ( $readmore ? $rows['row_2'] : '' ),
					$excerpt,
					( $custom_meta && $meta_pos == '3' ) ? $user_meta : $rows['row_3'],
					sanitize_text_field( $htag ),
					$enable_schema && $container_type != '' ? ' itemscope itemtype="' . $protocol . '://schema.org/' . esc_attr( $container_type ) . '"' : '',
					$enable_schema && $container_prop != '' ? ' itemprop="' . esc_attr( $container_prop ) . '"' : '',
					$enable_schema && $heading_prop != '' ? ' itemprop="' . esc_attr( $heading_prop ) . '"' : '',
					$hsize ? ' fs-' . esc_attr( $hsize ) : '',
					$hfontweight ? ' fw-' . esc_attr( $hfontweight ) : '',
					( 'autobg' == $overlay_style && 'true' == $dc['dark_text'] ) ? ' text-dark' : '',
					( 'autobg' == $overlay_style ) ? ' style="background-color: rgba(' . $dc['rgb'] . ',.9);"' : '',
					esc_attr( $title ),
					$clickable_tile ? sprintf( '<a href="%1$s" class="overlay-link" title="%2$s"><span class="screen-reader-text">%2$s</span></a>', esc_url( get_permalink() ), esc_attr( $title ) ) : ''
				);
			}
		}

		// List type module style
		elseif ( 'list' == $template ) {
			$format = apply_filters( 'wppm_list_output', '<div%12$s%13$s id="post-%1$s" class="%2$s%3$s">%4$s<div class="post-content">%5$s<%11$s%14$s class="entry-title%15$s"><a href="%6$s" title="%16$s">%7$s</a></%11$s>%8$s%9$s%10$s</div></div>' );

			$out .= sprintf ( $format,
				get_the_id(),
				$post_classes,
				$no_image_class,
				$thumblink != '' ? '<div class="post-img-wrap">' . $thumblink . '</div>' : '',
				( $custom_meta && $meta_pos == '1' ) ? $user_meta : $rows['row_1'],
				esc_url( get_permalink() ),
				esc_attr( $title ),
				( $custom_meta && $meta_pos == '2' ) ? $user_meta : ( $readmore ? $rows['row_2'] : '' ),
				$excerpt,
				( $custom_meta && $meta_pos == '3' ) ? $user_meta : $rows['row_3'],
				sanitize_text_field( $htag ),
				$enable_schema && $container_type != '' ? ' itemscope itemtype="' . $protocol . '://schema.org/' . esc_attr( $container_type ) . '"' : '',
				$enable_schema && $container_prop != '' ? ' itemprop="' . esc_attr( $container_prop ) . '"' : '',
				$enable_schema && $heading_prop != '' ? ' itemprop="' . esc_attr( $heading_prop ) . '"' : '',
				$hsize ? ' fs-' . esc_attr( $hsize ) : '',
				esc_attr( $title )
			);
		}

		elseif ( 'teaser' == $template ) {
			// Category link
			$cats = get_the_category();
			$cat_link = '<a class="cat-link cat-' . $cats[0]->slug . '" href="' . get_category_link( $cats[0]->cat_ID ) . '">' . $cats[0]->cat_name . '</a><span class="cat-sep"></span>';
			$format = apply_filters( 'wppm_teaser_output', '<article%8$s%9$s id="post-%1$s" class="%2$s%3$s">%4$s<%7$s%10$s class="entry-title%11$s%12$s"><a href="%5$s" title="%13$s">%6$s</a></%7$s>%10$s</article>' );

			$out .= sprintf ( $format,
				get_the_id(),
				$post_classes,
				'',
				$cat_link,
				esc_url( get_permalink() ),
				esc_attr( $title ),
				sanitize_text_field( $htag ),
				$enable_schema && $container_type != '' ? ' itemscope itemtype="' . $protocol . '://schema.org/' . esc_attr( $container_type ) . '"' : '',
				$enable_schema && $container_prop != '' ? ' itemprop="' . esc_attr( $container_prop ) . '"' : '',
				$enable_schema && $heading_prop != '' ? ' itemprop="' . esc_attr( $heading_prop ) . '"' : '',
				$hsize ? ' fs-' . esc_attr( $hsize ) : '',
				$hfontweight ? ' fw-' . esc_attr( $hfontweight ) : '',
				esc_attr( $title )
			);
		}

		else { // Grid style slider

			// Clearing floats depending upon number of columns
			$clear_class = ( 0 == ( ( $count ) % $columns ) ) ? ' first-grid' : '';

			if ( $sub_type == 's2' || $sub_type == 's3' ) {
				$format = apply_filters( 'wppm_grid_s2_output', '<article%12$s%13$s id="post-%1$s" class="%2$s%3$s">%5$s<%11$s%14$s class="entry-title%15$s"><a href="%6$s" title="%17$s">%7$s</a></%11$s>%8$s%4$s%9$s%10$s</article>' );
			}

			elseif ( $sub_type == 's4' ) {
				$format = apply_filters( 'wppm_grid_s4_output', '<article%12$s%13$s id="post-%1$s" class="%2$s%3$s">%5$s<%11$s%14$s class="entry-title%15$s"><a href="%6$s" title="%17$s">%7$s</a></%11$s>%4$s%8$s%9$s%10$s</article>' );
			}

			else {
				$format = apply_filters( 'wppm_grid_s1_output', '<article%12$s%13$s id="post-%1$s" class="%2$s%3$s">%4$s<div class="post-content">%5$s<%11$s%14$s class="entry-title%15$s%16$s"><a href="%6$s" title="%17$s">%7$s</a></%11$s>%8$s%9$s%10$s</div></article>' );
			}

			$out .= sprintf ( $format,
				get_the_id(),
				$post_classes,
				$clear_class,
				$thumblink,
				( $custom_meta && $meta_pos == '1' ) ? $user_meta : $rows['row_1'],
				esc_url( get_permalink() ),
				esc_attr( $title ),
				( $custom_meta && $meta_pos == '2' ) ? $user_meta : ( $readmore ? $rows['row_2'] : '' ),
				$excerpt,
				( $custom_meta && $meta_pos == '3' ) ? $user_meta : $rows['row_3'],
				sanitize_text_field( $htag ),
				$enable_schema && $container_type != '' ? ' itemscope itemtype="' . $protocol . '://schema.org/' . esc_attr( $container_type ) . '"' : '',
				$enable_schema && $container_prop != '' ? ' itemprop="' . esc_attr( $container_prop ) . '"' : '',
				$enable_schema && $heading_prop != '' ? ' itemprop="' . esc_attr( $heading_prop ) . '"' : '',
				$hsize ? ' fs-' . esc_attr( $hsize ) : '',
				$hfontweight ? ' fw-' . esc_attr( $hfontweight ) : '',
				esc_attr( $title )
			);

			$count++;
		} // Grid Module

	endwhile;

	$out .= '</div></div>';

	echo $out;