<?php
/**
 * teaser.php
 * Template part for the WP Post Modules Plugin
 *
 * @since 2.0.0
 * @version 3.3.0
 *
 * All variables coming from parent file wp-post-modules.php
 */
	$out = '';
	$count = 0;
	$ad_count = 1;
	$protocol = is_ssl() ? 'https' : 'http';
	$id = 'wppm-ajax-posts-' . $GLOBALS['wppm_ajax_container_count'];
	$ad_list = vc_param_group_parse_atts( $ad_list );

	if ( $sc_btn ) {
		$sc = wppm_vc_get_sc( $atts );
	}

	$out = sprintf( '%s<div%s%s class="wppm wppm-grid%s wppm-teaser clearfix%s%s%s%s%s%s%s%s">%s',
		$ajaxnav || $ajaxloadmore ? sprintf( '<div id="%s" class="wppm-ajax-posts%s" data-params=\'%s\' data-maxposts="%s">', $id, ' wppm_custom_css_' . $wppm_css_count, json_encode( $atts, JSON_FORCE_OBJECT ), $custom_query->found_posts ) : '',
		$enable_schema ? ' itemscope="itemscope" itemtype="' . $protocol . '://schema.org/Blog"' : '',
		$ajaxnav ? ' id="' . $id . '-sub-1"' : '',
		' columns-' . esc_attr( $columns ),
		' ' . esc_attr( $sub_type ),
		$masonry ? ' masonry-enabled' : '',
		( $sub_type == 's3' || $sub_type == 's4' ) ? ' split-' . esc_attr( $grid_split ) : '',
		' gutter-' . esc_attr( $gutter_grid ),
		$vc_class,
		! ( $ajaxnav || $ajaxloadmore ) ? ' wppm_custom_css_' . $wppm_css_count : '',
		$counter ? ' count-enabled' : '',
		$xclass ? ' ' . esc_attr( $xclass ) : '',
		( $sc_btn && is_user_logged_in() && ( current_user_can( 'edit_pages' ) || current_user_can( 'edit_posts' ) ) ) ? '<a href="#" class="wppm-get-sc" data-val="' . esc_attr( $sc ) . '">' . esc_attr__( 'Get Shortcode', 'wppm' ) . '</a>' : ''
	);

	// Main loop
	while ( $custom_query->have_posts() ) :
		$custom_query->the_post();
		global $multipage;
		$multipage = 0;

		// Set post title
		$title = wppm_generate_title( $hsource, $h_cust_field_key, $h_length, $h_meta_box );

		// Post classes
		$post_id = get_the_ID();
		$post_class_obj = get_post_class( $post_id );
		$post_classes = 'wppm-post ';
		if ( isset( $post_class_obj ) && is_array( $post_class_obj ) ) {
			$post_classes .= implode( ' ', $post_class_obj );
		}
		if ( is_sticky( $post_id ) ) {
			$post_classes .= ' sticky';
		}

		// Get excerpt based on chosen source
		$excerpt_text = wppm_generate_excerpt( $psource, $allowed_tags, $content_filter, $cust_field_key, $excerpt_length, $meta_box );
		$excerpt = ( $hide_excerpt == 'true' ) ? ''
					: sprintf( '<%1$s%2$s class="post-text%3$s">%4$s</%1$s>',
						$ptag,
						$enable_schema && $excerpt_prop != '' ? ' itemprop="' . esc_attr( $excerpt_prop ) . '"' : '',
						$psize ? ' fs-' . esc_attr( $psize ) : '',
						$excerpt_text
					);

		// User defined post meta
		$user_meta = '';
		$rows = array( 'row_1' => '', 'row_2' => '', 'row_3' => '', 'row_4' => '' );
		$metas = wppm_custom_meta();
		if ( $custom_meta ) {
			$user_meta = sprintf( '<span class="entry-meta custom-format">' . rawurldecode( base64_decode( strip_tags( $meta_format ) ) ) . '</span>', $metas['author'], $metas['date'], $metas['date_modified'], $metas['categories'], $metas['comments'], $metas['permalink'] );
		}

		else { // Generate post meta
			$meta_args = array(
				'template'	=> 'grid',
				'date_format' => $date_format,
				'enable_schema' => $enable_schema,
				'hide_cats' => $hide_cats,
				'hide_reviews' => $hide_reviews,
				'hide_date' => $hide_date,
				'hide_author' => $hide_author,
				'show_avatar' => $show_avatar,
				'hide_views' => $hide_views,
				'hide_comments' => $hide_comments,
				'ext_link'	=> $ext_link,
				'readmore' => $readmore,
				'readmore_text' => $readmore_text,
				'readmore_link_src' 	=> $readmore_link_src,
				'readmore_cust_link' 	=> $readmore_cust_link,
				'readmore_target_blank' => $readmore_target_blank,
				'publisher_logo' => $publisher_logo,
				'excerpt_length' => $excerpt_length,
				'sharing' => $sharing,
				'share_style' => $share_style,
				'share_btns' => $share_btns,

				// Schema props
				'datecreated_prop'		=> $datecreated_prop,
				'datemodified_prop'		=> $datemodified_prop,
				'publisher_type'		=> $publisher_type,
				'publisher_prop'		=> $publisher_prop,
				'publisher_name'		=> $publisher_name,
				'publisher_logo'		=> $publisher_logo,
				'authorbox_type'		=> $authorbox_type,
				'authorbox_prop'		=> $authorbox_prop,
				'authorname_prop'		=> $authorname_prop,
				'authoravatar_prop'		=> $authoravatar_prop,
				'category_prop'			=> $category_prop,
				'commentcount_prop'		=> $commentcount_prop,
				'commenturl_prop'		=> $commenturl_prop
			);

			$rows = wppm_meta( $meta_args );
		}

		// Clearing floats depending upon number of columns
		$clear_class = ( 0 == ( ( $count ) % $columns ) ) ? ' first-grid' : '';

		// Category link
		$cats = get_the_category();
		$cat_link = '<a class="cat-link cat-' . $cats[0]->slug . '" href="' . get_category_link( $cats[0]->cat_ID ) . '">' . $cats[0]->cat_name . '</a><span class="cat-sep"></span>';

		$format = apply_filters( 'wppm_teaser_output', '<article%8$s%9$s id="post-%1$s" class="%2$s%3$s">%4$s<%7$s%10$s class="entry-title%11$s%12$s"><a href="%5$s" title="%6$s">%13$s</a></%7$s>%10$s</article>' );

		$out .= sprintf ( $format,
			get_the_id(),
			$post_classes,
			$clear_class,
			$cat_link,
			esc_url( get_permalink() ),
			wp_strip_all_tags( $title ),
			sanitize_text_field( $htag ),
			$enable_schema && $container_type != '' ? ' itemscope itemtype="' . $protocol . '://schema.org/' . esc_attr( $container_type ) . '"' : '',
			$enable_schema && $container_prop != '' ? ' itemprop="' . esc_attr( $container_prop ) . '"' : '',
			$enable_schema && $heading_prop != '' ? ' itemprop="' . esc_attr( $heading_prop ) . '"' : '',
			$hsize ? ' fs-' . esc_attr( $hsize ) : '',
			$hfontweight ? ' fw-' . esc_attr( $hfontweight ) : '',
			$title
		);

		$count++;

		// Show ads only if ad offset is set
		if ( '' != $ad_offset || intval( $ad_offset ) > 0 ) {
			if ( ( $count >= ( intval( $ad_offset ) * $ad_count ) ) && $count % ( intval( $ad_offset ) * $ad_count ) == 0 ) {
				if ( isset( $ad_list ) && is_array( $ad_list ) && isset( $ad_list[$ad_count - 1]['ad_code'] ) ) {
					$out .= do_shortcode( rawurldecode( $ad_list[ $ad_count - 1 ]['ad_code'] ) );
					$ad_count++;
				}
			}
		}

	endwhile;

	if ( $ajaxnav ) {
		$out .= sprintf( '</div><div class="wppm-loading-spinner"></div><div class="wppm-ajax-nav"><a class="prev-link disabled" href="#">%s</a> <a class="next-link" href="#">%s</a>%s</div></div>',
			__( 'Prev', 'wppm' ),
			__( 'Next', 'wppm' ),
			$nav_status ? '<span class="nav-status" data-format="' . esc_attr( $nav_status_text ) . '"></span>' : ''
		);
	}
	elseif ( $ajaxloadmore ) {
		$out .= sprintf( '</div><div class="wppm-ajax-loadmore"><div class="wppm-loading-spinner"></div><a class="wppm-more-link" href="#">%s</a></div></div>',
			esc_attr( $loadmore_text )
		);
	}
	else {
		$out .= '</div>';
	}

	echo $out;