<?php
// View of Country wise Statistics
function pa_include_country_performance( $current, $country_stats ) {
	?>
	<div class="analytify_general_status analytify_status_box_wraper">
		<div class="analytify_status_header">
			<h3><?php esc_html_e( 'Top Countries by Sales', 'wp-analytify-edd' ); ?></h3>
		</div>

		<div class="analytify_status_body">
			<?php
			if ( ! empty( $country_stats['rows'] ) ) {
				$code           = '';
				$lowest_number  = 0;
				$highest_number = $country_stats['aggregations']['ecommercePurchases'];

				if ( $highest_number > 0 ) {
					?>
					<script>
					jQuery(document).ready(function ($) {

					// configure for module loader
					require.config({
						paths: {
							echarts: 'js/dist/'
						}
					});

					// use
					require(
						[
						'echarts',
						'echarts/chart/map', // require the specific chart type
						],

						function (ec) {
							// Initialize after dom ready
							const geographic_stats_graph = ec.init( document.getElementById('analytify_geographic_stats_graph' ) );

							const geographic_stats_graph_option = {
								tooltip : {
									trigger: 'item',
									formatter : function( params, ticket, callback ) {
										let value = (params.value + '').split('.');

										if ( value[0]  != '-' ) {
										value = value[0];
										} else {
										value = 0;
										}
										let revenue = '';
										if ( null == params.data.revenue ) {
										revenue = 0 ;
										} else {
										revenue = params.data.revenue;
										}
										return  params.name + '<br />' + 'No of sales : ' + value + '<br /> Revenue : ' + String( "<?php echo edd_currency_symbol(); ?>") + ' ' + revenue  ;
									}
								},
								toolbox: {
									show : false,
									orient : 'horizontal',
									x: 'right',
									y: '10',
									feature : {
										restore : { show: true },
										saveAsImage : { show: true }
									}
								},
								dataRange: {
									min: <?php echo $lowest_number; ?>,
									max: <?php echo $highest_number; ?>,
									text: ['High','Low'],
									realtime: true,
									calculable : true,
									color: ['#ff5252','#ffbc00','#448aff']
								},
								series : [
									{
										name: '<?php esc_html_e( 'Geographic Stats', 'wp-analytify-edd' ); ?>',
										type: 'map',
										mapType: 'world',
										roam: 'move',
										scrollwheel: false,
										mapLocation: {
											y : 60
										},
										itemStyle:{
											emphasis:{label:{show:true}}
										},
										data:[
											<?php foreach ( $country_stats['rows'] as $country ) : ?>
											{name : '<?php echo $country['country'] == 'United States' ? 'United States of America' : $country['country']; ?>', value : <?php echo $country['ecommercePurchases']; ?>, revenue : '<?php echo number_format( $country['purchaseRevenue'], 2 ); ?>'},
											<?php endforeach; ?>
										]
									}
								]
							};

							// Load data into the ECharts instance
							geographic_stats_graph.setOption( geographic_stats_graph_option );

							window.onresize = function () {
								geographic_stats_graph.resize();
							}
						}
					);
					});

					</script>
					<div class="analytify_txt_center analytify_graph_wraper">
						<div id="analytify_geographic_stats_graph" style="height:600px"></div>
					</div>
					<?php
				}
				?>
				<div class="analytify_clearfix">
					<table class="analytify_data_tables analytify_border_th_tp">
						<thead>
							<tr>
								<th class="analytify_txt_left"><?php esc_html_e( 'Top Countries', 'wp-analytify-edd' ); ?></th>
								<th class="analytify_value_row"><?php esc_html_e( 'No. of Sales', 'wp-analytify-edd' ); ?></th>
								<th class="analytify_value_row"><?php esc_html_e( 'Revenue', 'wp-analytify-edd' ); ?></th>
							</tr>
						</thead>
						<tbody>
							<?php
							foreach ( $country_stats['rows'] as $row ) {
								?>
									<tr>
										<td><span class="<?php echo pretty_class( $row['country'] ); ?> analytify_flages"></span> <?php echo $row['country']; ?></td>
										<td class="analytify_txt_center"><?php echo $row['ecommercePurchases']; ?></td>
										<td class="analytify_txt_center"><?php echo edd_currency_symbol() . number_format( $row['purchaseRevenue'], 2 ); ?></td>
									</tr>
								<?php
							}
							?>
						</tbody>
					</table>
				</div>
				<?php
			} else {
				$current->no_records();
			}
			?>
		</div>
	</div>
	<?php
}
