<?php


/**
 *  View of List Performance.
 *
 * @param  object $current Analytify Free Objext.
 * @param  object $stats   Contains stats that are fetch from google.
 *
 * @since  1.0.0
 */
function pa_include_edd_lists_performance( $current, $stats ) {

	if ( isset( $stats['rows'] ) && isset( $stats['rows'][0][0] ) ) {
	    $famous = $stats['rows'][0][0]; }
	    ?>
	    <div class="analytify_general_status analytify_status_box_wraper">
	      <div class="analytify_status_header">
	        <h3><?php esc_html_e( 'Product lists Analysis', 'wp-analytify-edd' ); ?></h3>
	      </div>
	      <div class="analytify_status_body">

	        <table class="analytify_data_tables">
						<thead>
							<tr>
								<th class="wd_1">
									#
								</th>
								<th>
									<?php esc_html_e( 'List Name', 'wp-analytify-edd' ); ?>
								</th>
								<th>
									<?php esc_html_e( 'Product List Views', 'wp-analytify-edd' ); ?>
								</th>
								<th class="">
									<?php esc_html_e( 'Product List Clicks', 'wp-analytify-edd' ); ?>
								</th>
								<th class="">
									<?php esc_html_e( 'Product List CTR', 'wp-analytify-edd' ); ?>
								</th>
								<th class="">
									<?php esc_html_e( 'Product Adds to Cart', 'wp-analytify-edd' ); ?>
								</th>
								<th class="">
									<?php esc_html_e( 'Product Checkouts', 'wp-analytify-edd' ); ?>
								</th>
								<th class="">
									<?php esc_html_e( 'Unique Purchases', 'wp-analytify-edd' ); ?>
								</th>
								<th class="">
									<?php esc_html_e( 'Product Revenue', 'wp-analytify-edd' ); ?>
								</th>
							</tr>
						</thead>
	          <tbody>

	            <?php if ( ! empty( $stats['rows'] ) ) {
	              $i = 0;
	              foreach ( $stats['rows'] as $stat ) {
	                $i++;
	                ?>
									<tr>
										<td>
											<?php echo $i; ?>
										</td>
										<td>
											<?php echo $stat[0]; ?>
										</td>
										<td class="analytify_txt_center">
											<?php echo $stat[1]; ?>
										</td>
										<td class="analytify_txt_center">
											<?php echo $stat[2]; ?>
										</td>
										<td>
											<?php $percent_quantity = number_format( $stat[3], 2 );?>
											<?php echo $percent_quantity; ?> %
											<span class="analytify_bar_graph">
												<span style="width: <?php echo $percent_quantity ?>%;"></span>
											</span>
										</td>
										<td class="analytify_txt_center">
											<?php echo $stat[4]; ?>
										</td>
										<td class="analytify_txt_center">
											<?php echo $stat[5]; ?>
										</td>
										<td class="analytify_txt_center">
											<?php echo $stat[6]; ?>
										</td>
										<td class="analytify_txt_center">
											<?php echo edd_currency_symbol() . number_format( $stat[7], 2 ); ?>
										</td>
									</tr>
	                <?php
	              }
	            } else { ?>
	              <tr>
	                <td class="analytify_td_error_msg" colspan="9">
	                  <?php $current->no_records(); ?>
	                </td>
	              </tr>
	              <?php }
	              ?>
	            </tbody>
	          </table>
	        </div>
	        <div class="analytify_status_footer">

	          <?php if ( isset( $stat[0] ) ) : ?>
	            <span class="analytify_info_stats">
	              <?php
	              echo sprintf( esc_html__( 'Did you know the big Revenue generated from Product List in your store is %1$s %2$s %3$s', 'wp-analytify-edd' ), '<strong>' , $famous , '</strong>' );
	              ?>
	            </span>
	          <?php endif; ?>

	        </div>
	      </div>
<?php } ?>
