<?php

/**
*  Show Measuring ROI
*
* @param  object $current Analytify Free Objext.
* @param  object $stats   Contains stats that are fetch from google.
*
* @since  1.0.0
*/
function pa_include_edd_measuring_roi( $current, $stats ) {

  if ( isset( $stats['rows'] ) && isset( $stats['rows'][0][0] ) ) {
      $famous = $stats['rows'][0][0]; }

      // var_dump($stats['rows']);

      ?>
      <div class="analytify_general_status analytify_status_box_wraper">
        <div class="analytify_status_header">
          <h3><?php esc_html_e( 'Measuring ROI', 'wp-analytify-edd' ); ?></h3>
        </div>
        <div class="analytify_status_body">

          <table class="analytify_data_tables wp_analytify_paginated">
            <thead>
              <tr>
                <th class="wd_1">
                  #
                </th>
                <th>
                  <?php esc_html_e( 'Source/Medium', 'wp-analytify-edd' ); ?>
                </th>
                <th>
                  <?php esc_html_e( 'Sessions', 'wp-analytify-edd' ); ?>
                </th>
                <th >
                  <?php esc_html_e( 'Bounce Rate', 'wp-analytify-edd' ); ?>
                </th>
                <th >
                  <?php esc_html_e( 'Transactions', 'wp-analytify-edd' ); ?>
                </th>
                <th >
                  <?php esc_html_e( 'Transactions Revenue', 'wp-analytify-edd' ); ?>
                </th>
              </tr>
            </thead>
            <tbody>
              <?php if ( ! empty( $stats['rows'] ) ) {
                $i = 0;
                foreach ( $stats['rows'] as $stat ) {
                  $i++;
                  ?>
                  <tr>
                    <td>
                      <?php echo $i; ?>
                    </td>
                    <td>
                      <?php echo $stat[0] ; ?>
                    </td>
                    <td class="analytify_txt_center">
                      <?php echo WPANALYTIFY_Utils::pretty_numbers( $stat[1] ) ; ?>
                    </td>
                    <td class="analytify_txt_center">
                      <?php echo WPANALYTIFY_Utils::pretty_numbers( $stat[2] ) . '%'; ?>
                    </td>
                    <td class="analytify_txt_center">
                      <?php echo $stat[3]; ?>
                    </td>
                    <td class="analytify_txt_center">
                      <?php echo edd_currency_symbol() . number_format( $stat[4], 2 ); ?>
                    </td>
                  </tr>
                  <?php
                }
              } else { ?>
                <tr>
                  <td class='analytify_td_error_msg' colspan='6'>
                    <?php $current->no_records(); ?>
                  </td>
                </tr>
                <?php
              }
              ?>
            </tbody>
          </table>
          <!-- <script>
            jQuery(document).ready(function($) {
              wp_analytify_paginated();
            });
          </script> -->
        </div>
        <div class="analytify_status_footer">
          <span class="analytify_info_stats">
            <?php

            if ( isset( $stat[0] ) ) :

              echo sprintf( esc_html__( 'Did you know the famous Source of Sale is %1$s %2$s %3$s', 'wp-analytify-edd' ), '<strong>' , $famous , '</strong>' );

              else :

                esc_html_e( 'List of all the sources of sale.', 'wp-analytify-edd' );

              endif;

              ?>
            </span>
	           <div class="wp_analytify_pagination"></div>
          </div>
        </div>
    <?php } ?>
