<?php

/**
 * Plugin Name: Analytify Easy Digital Downloads
 * Plugin URI: https://analytify.io/add-ons/easy-digital-downloads/?utm_source=analytify-edd&utm_medium=plugin-uri
 * Description: This Add-on will track the e-commerce behavior of users, digital Sales, Transactions and Revenues in Google Analytics and Displays Stats in a unique and intuitive way which is very understandable even for non-technical WordPress users.
 * Version: 5.0.4
 * Author: Analytify
 * Author URI: https://analytify.io/?utm_source=analytify-edd&utm_medium=author-uri
 *
 * License: GPLv2+
 *
 * Text Domain: wp-analytify-edd
 * Domain Path: /languages
 */


if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

update_option( 'analytify_edd_license_status', 'valid' );
      update_option( 'analytify_edd_license_key' , 'B5E0B5F8DD8689E6ACA49DD6E6E1A930' );

define( 'EDD_ANALYTIFY_PLUGIN_DIR', dirname( __FILE__ ) );

add_action( 'plugins_loaded', 'analytify_edd_instance', 20 );


function analytify_edd_instance() {
	$prevent = false;

	// check for analytify
	if ( ! file_exists( WP_PLUGIN_DIR . '/wp-analytify-pro/wp-analytify-pro.php' ) ) {
		add_action( 'admin_notices', 'wpa_edd_install_analytify_pro' );
		$prevent = true;
	} elseif ( ! class_exists( 'WP_Analytify_Pro_Base' ) ) {
		add_action( 'admin_notices', 'wpa_edd_active_analytify_pro' );
		$prevent = true;
	} elseif ( ! file_exists( WP_PLUGIN_DIR . '/easy-digital-downloads/easy-digital-downloads.php' ) && ! file_exists( WP_PLUGIN_DIR . '/easy-digital-downloads-pro/easy-digital-downloads.php' ) ) {
		add_action( 'admin_notices', 'install_edd' );
		$prevent = true;
	} elseif ( ! class_exists( 'Easy_Digital_Downloads' ) ) {
		add_action( 'admin_notices', 'active_edd' );
		$prevent = true;
	}

	if ( $prevent ) {
		add_action( 'admin_enqueue_scripts', 'wpa_edd_notices_scripts' );
		return;
	}

	include_once EDD_ANALYTIFY_PLUGIN_DIR . '/wp-analytify-edd-class.php';
	new WP_Analytify_Edd();

}

/**
 * Admin notices scripts.
 */
function wpa_edd_notices_scripts() {
	wp_enqueue_style( 'analytify-edd-notices', plugins_url( 'assets/css/notices.css', __FILE__ ), '', false );
}

function wpa_edd_install_analytify_pro() {
	// $class   = 'notice notice-error is-dismissible';
	// printf( '<div class="%1$s"><p>%2$s</p></div>', $class, $message );
	$message = __( '<strong>Attention:</strong> Please install Analytify Pro to use Analytify for Easy Digital Downloads addon.', 'wp-analytify-edd' );

	wp_analytify_edd_tracking_notice( $message, 'wp-analytify-danger' );
}

function wpa_edd_active_analytify_pro() {
	// $class   = 'notice notice-error is-dismissible';
	// printf( '<div class="%1$s"><p>%2$s</p></div>', $class, $message );
	$message = __( '<strong>Attention:</strong> Please active Analytify Pro to use Analytify for Easy Digital Downloads addon.', 'wp-analytify-edd' );

	wp_analytify_edd_tracking_notice( $message, 'wp-analytify-danger' );
}

function install_edd() {
	$message = __( '<strong>Attention:</strong> Analytify for Easy Digital Downloads addon works with Easy Digital Downloads plugin, Please install Easy Digital Downloads plugin.', 'wp-analytify-edd' );

	wp_analytify_edd_tracking_notice( $message, 'wp-analytify-danger' );
}

function active_edd() {
	$message = __( '<strong>Attention:</strong> Analytify for Easy Digital Downloads addon works with Easy Digital Downloads plugin, Please activate Easy Digital Downloads plugin.', 'wp-analytify-edd' );

	wp_analytify_edd_tracking_notice( $message, 'wp-analytify-danger' );
}

/**
 * Add custom admin notice
 *
 * @param  string $message Custom Message
 * @param  string $class wp-analytify-success,wp-analytify-danger
 */
function wp_analytify_edd_tracking_notice( $message, $class ) {
	echo '<div class="wp-analytify-notification ' . $class . '">
	<a class="" href="#" aria-label="Dismiss the welcome panel"></a>
	<div class="wp-analytify-notice-logo">
	<img src="' . plugins_url( 'assets/img/logo.svg', __FILE__ ) . '" alt="analytify logo">
	</div>
	<div class="wp-analytify-notice-discription">
	<p>' . $message . '</p>
	</div>
	</div>';
}

/**
 * Load TextDoamin
 *
 * @since 1.0.2
 */
function wp_analytify_edd_load_text_domain() {
	$plugin_dir = basename( dirname( __FILE__ ) );
	load_plugin_textdomain( 'wp-analytify-edd', false, $plugin_dir . '/languages/' );
}
add_action( 'init', 'wp_analytify_edd_load_text_domain' );


/**
 * Helper function for translation.
 */
if ( ! function_exists( 'analytify__' ) ) {
	/**
	 * Wrapper for __() gettext function.
	 *
	 * @param  string $string     Translatable text string
	 * @param  string $textdomain Text domain, default: wp-analytify
	 * @return void
	 */
	function analytify__( $string, $textdomain = 'wp-analytify' ) {
		return __( $string, $textdomain );
	}
}
if ( ! function_exists( 'analytify_e' ) ) {
	/**
	 * Wrapper for _e() gettext function.
	 *
	 * @param  string $string     Translatable text string
	 * @param  string $textdomain Text domain, default: wp-analytify
	 * @return void
	 */
	function analytify_e( $string, $textdomain = 'wp-analytify' ) {
		echo __( $string, $textdomain );
	}
}
