<?php
class Analytify_Pro_Blocks {

	private static $obj;

	/**
	 * Private constructor for singliton class.
	 * 
	 */
	private final function __construct() {

		$this->enqueue_scripts();

	}

	/**
	 * Create instance for class.
	 * 
	 */
	public static function get_instance() {

		if ( ! isset( self::$obj ) ) { 
			self::$obj = new Analytify_Pro_Blocks(); 
		} 
			
		return self::$obj; 
	} 

	/**
	 * Enqueue wp scripts.
	 * 
	 */
	private function enqueue_scripts() {

		// add_action( 'enqueue_block_editor_assets', array( $this, 'enqueue_block_editor_assets_cb' ) );
		add_action( 'init', array( $this, 'analytify_shortcode_block_init' ) );

	}

	public function analytify_shortcode_block_init() {
		register_block_type( ANALYTIFY_PRO_ROOT_PATH . '/assets/blocks' );
	}

	/**
	 * Add transpiled blocks scripts.
	 * 
	 */
	function enqueue_block_editor_assets_cb($screen) {
		
		global $current_screen;

		$allowed_posts_types = $GLOBALS['WP_ANALYTIFY']->settings->get_option( 'show_analytics_post_types_back_end', 'wp-analytify-admin', array() );

		// Prevent on post types that are not allowed.
		if ( ! in_array( $current_screen->post_type, $allowed_posts_types ) ) {
			return;
		}

		wp_enqueue_script(
			'analytify-blocks-editor',
			plugins_url( 'assets/js/blocks.js', dirname( __FILE__ ) ),
			array( 'wp-i18n', 'wp-element', 'wp-blocks', 'wp-components', 'wp-editor', 'wp-edit-post' ),
			ANALYTIFY_PRO_VERSION
		);

		wp_localize_script( 'analytify-blocks-editor', 'analytify_blocks_editor', array(
			'reporting_mod' => method_exists( 'WPANALYTIFY_Utils', 'get_ga_mode' ) && 'ga4' === WPANALYTIFY_Utils::get_ga_mode() ? 'ga4' : 'ga3',
		) );

		wp_enqueue_style(
			'analytify-blocks-editor',
			plugins_url( 'assets/css/blocks.css', dirname( __FILE__ ) ),
			null,
			ANALYTIFY_PRO_VERSION
		);
	}

}

// Create Analytify_Pro_Blocks Instance.
Analytify_Pro_Blocks::get_instance();