<?php
/**
 * This file is reponsible for including settings sections and tabs
 *
 * @package wp-analytify-pro
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

function analytify_google_ads_settings_tab( $tabs ) {
	$ads_tab = array(
		array(
			'id'       => 'analytify-google-ads-tracking',
			'title'    => __( 'Google Ads Tracking', 'wp-analytify-pro' ),
			'desc'     => __( 'Track your Google Ads Conversions', 'wp-analytify-pro' ),
			'priority' => '0',
		),
	);

	return array_merge( $tabs, $ads_tab );
}

add_filter( 'wp_analytify_pro_setting_tabs', 'analytify_google_ads_settings_tab', 20, 1 );


function analytify_google_ads_setting_fields( $fields ) {

		$pro_fields = array();

		$pro_fields['analytify-google-ads-tracking'][] = array(
			'name'  => 'ads_conversion_tracking',
			'label' => __( 'Turn on Google Ads Tracking', 'wp-analytify-pro' ),
			'desc'  => __( 'Requires integration of your Google Analytics and Google Ads account.', 'wp-analytify-pro' ),
			'type'  => 'checkbox',
		);

		$pro_fields['analytify-google-ads-tracking'][] = array(
			'name'              => 'ads_conversion_id',
			'label'             => __( 'Conversion ID', 'wp-analytify-pro' ),
			'desc'              => __( 'Add your Google Ads Conversion ID. Format eg: AW-123456789', 'wp-analytify-pro' ),
			'type'              => 'text',
			'sanitize_callback' => 'sanitize_text_field',
		);

		$pro_fields['analytify-google-ads-tracking'][] = array(
			'name'              => 'ads_conversion_label',
			'label'             => __( 'Conversion Label', 'wp-analytify-pro' ),
			'desc'              => __( 'Add your Google Ads Conversion Label.', 'wp-analytify-pro' ),
			'type'              => 'text',
			'sanitize_callback' => 'sanitize_text_field',
		);

		return array_merge( $fields, $pro_fields );
}

add_filter( 'wp_analytify_pro_setting_fields', 'analytify_google_ads_setting_fields', 20, 1 );
