<?php
// Display World Map at front-side.
function pa_include_worldmap( $current, $worldmap_stats ) {
  ?>
  <div class="data_boxes">
    <div class="data_boxes_title"><?php echo _e( 'Top Countries', 'wp-analytify'); ?> <div class="arrow_btn"></div></div>
    <div class="data_container">
      <?php
      if ( ! empty( $worldmap_stats["rows"] ) ) {
        // Load the Google Charts library (recommended approach)
        wp_enqueue_script( 'google-charts', 'https://www.gstatic.com/charts/loader.js');
        ?>
        <div id="wm_chart_div" style="width: 600px; height: 450px; margin:0 auto;" ></div>

        <script>
          google.charts.load('visualization', '1', {packages: ['geochart']});
          google.charts.setOnLoadCallback(drawRegionsMap);

          function drawRegionsMap() {
            var data = google.visualization.arrayToDataTable([
              ['Country', 'Visitors'],
              <?php
                foreach ( $worldmap_stats["rows"] as $c_stats ) {
                  echo "['" . $c_stats['country'] . "', " . $c_stats['sessions'] . "],";
                }
              ?>
            ]);

            var options = {displayMode: 'regions'};
            var formatter = new google.visualization.NumberFormat({fractionDigits: 0});
            formatter.format(data, 1);

            var chart = new google.visualization.GeoChart(document.getElementById('wm_chart_div'));
            chart.draw(data, options);
          }
        </script>
      <?php } ?>
    </div>
  </div>
  <?php
}
