<?php
// Exit, if access file directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Track WooCommerce Email Events.
 *
 * @since 3.0
 */
class Analytify_Woo_Email_Tracking {

	private $emails;

	/**
	 * Constructor method.
	 */
	public function __construct() {

		add_action( 'woocommerce_after_template_part', array( $this, 'add_track_image' ), 10, 4 );
		add_filter( 'wp_analytify_pro_setting_fields', array( $this, 'add_settings' ), 20, 1 );
	}

	/**
	 *	Add tracking script in email.
	 *
	 * @param string $template_name Template name.
	 * @param array  $args          Arguments. (default: array).
	 * @param string $template_path Template path. (default: '').
	 * @param string $default_path  Default path. (default: '').
	 */
	public function add_track_image( $template_name, $template_path, $located, $args = array() ) {

		// Return if not an email template or is plain email template.
		if ( strpos( $template_name, 'emails/' ) === false || strpos( $template_name, 'emails/plain/' ) !== false ) {
			return;
		}

		$is_tracking_enabbled = $GLOBALS['WP_ANALYTIFY']->settings->get_option( 'woo_email_tracking','wp-analytify-advanced', 'off' );

		// Return, if tracking is not enabled.
		if ( $is_tracking_enabbled == 'off' ) {
			return;
		}

		$tracking_id = WP_ANALYTIFY_FUNCTIONS::get_UA_code();

		// Return, if profile is not selected.
		if ( ! $tracking_id ) {
			return;
		}

		$email = $this->get_email_by_template_html_path( $template_name );

		if ( ! $email ) {
			return;
		}

		// Return, if order is not type of WC Order.
		if ( ! isset( $args['order'] ) || ! $args['order'] instanceof WC_Order ) {
			return;
		}

		$cid = get_post_meta( $args['order']->get_id(), 'analytify_woo_cid', true );
		$uid = $args['order']->get_customer_id();

		if ( null !== $uid && ! $GLOBALS['WPAnalytifyWooCommerce']->is_tracking_is_enabled_for_user( $uid ) ) {
			return;
		}

		$url   = 'https://www.google-analytics.com/collect?';
		$query = urldecode(
			http_build_query(
				array(
					'v'   => 1,
					'tid' => $tracking_id,
					'cid' => $cid,
					'uid' => $uid,
					't'   => 'event',
					'ec'  => 'Tracking by Analytify Woo Emails',
					'ea'  => 'open',
					'el'  => urlencode( $email->title ),
					'dp'  => urlencode( '/emails/' . sanitize_title( $email->title ) ),
					'dt'  => urlencode( $email->title ),
				),
				'',
				'&'
			)
		);

		printf( '<img src="%s" alt="" />', $url . $query );

	}

	/**
	 * Get the email by path.
	 *
	 */
	private function get_email_by_template_html_path( $template_path ) {

		$found_email = null;

		foreach ( $this->get_emails() as $email ) {

			if ( $template_path === $email->template_html ) {

				$found_email = $email;
				break;
			}
		}

		return $found_email;
	}

	/**
	 * Get all emails thats send to user.
	 *
	 */
	public function get_emails() {

		if ( ! isset( $this->emails ) ) {

			$wc_emails    = WC_Emails::instance();
			$all_emails   = $wc_emails->get_emails();
			$track_emails = array();

			// only track customer emails
			if ( ! empty( $all_emails ) ) {
				foreach ( $all_emails as $key => $email ) {

					$pos = strpos( $email->id, 'customer_' );

					if ( $pos !== false && $pos === 0 ) {
						$track_emails[ $key ] = $email;
					}
				}
			}

			$this->emails = $track_emails;
		}

		return $this->emails;
	}


	/**
	 * Add settings field in advanced tab.
	 *
	 */
	function add_settings( $settings ) {

		$settings['wp-analytify-advanced'][] = array(
			'name'  => 'woo_email_tracking',
			'label' => __( 'WooCommerce Email Tracking', 'wp-analytify-woocommerce' ),
			'desc'  => __( 'Track WooCommerce Email Events.', 'wp-analytify-woocommerce' ),
			'type'  => 'checkbox',
		);

		return $settings;
	}

}

new Analytify_Woo_Email_Tracking();
