<?php
/**
 * Country wise stats view.
 *
 * @param object $current
 * @param object $country_stats
 * @param string $report_url
 * @param string $report_date_range
 * @return void
 */
function pa_include_country_performance( $current, $country_stats, $report_url, $report_date_range ) { 
	
	ob_start();
	?>

  <div class="analytify_general_status analytify_status_box_wraper">
	<div class="analytify_status_header">
	  <h3>
		<?php esc_html_e( 'Top Countries by Engagement', 'wp-analytify-woocommerce' ); ?>
		<a href="#" class="analytify-export-data analytify_tooltip" data-stats-type="top-sales-countries">
			<span class="analytify_tooltiptext"><?php _e( 'Export Top Countries by Engagement', 'wp-analytify-pro' ) ?></span>
		</a>
		<img src="<?php echo admin_url( 'images/spinner.gif' ); ?>" class='analytify-export-loader' style="display:none">
	  </h3>
	</div>
	<div class="analytify_status_body">

	  <?php
		if ( isset( $country_stats['rows'] ) && $country_stats['rows'] > 0 ) :
			$code          = '';
			$higest_number = $country_stats['rows'][0][1];
			// var_dump($country_stats['rows']);
			// $lowest_number = end( $country_stats['rows'] )[1];
			$lowest_number = 0;
			?>

		<script>
		jQuery(document).ready(function ($) {

		  // configure for module loader
		  require.config({
			paths: {
			  echarts: 'js/dist/'
			}
		  });

		  // use
		  require(
			[
			  'echarts',
			  'echarts/chart/map', // require the specific chart type
			],
			function (ec) {
			  // Initialize after dom ready
			  var geographic_stats_graph = ec.init( document.getElementById('analytify_geographic_stats_graph' ) );

			  var geographic_stats_graph_option = {
				tooltip : {
				  trigger: 'item',
				  formatter :  function( params, ticket, callback ) {
					var value = (params.value + '').split('.');

					if ( value[0]  != '-' ) {
					  value = value[0];
					} else {
					  value = 0;
					}
					var revenue = '';
					if ( null == params.data.revenue ) {
					  revenue = 0 ;
					} else {
					  revenue = params.data.revenue;
					}
					return  params.name + '<br />' + 'No of sales : ' + value + '<br /> Revenue : ' + String( "<?php echo get_woocommerce_currency_symbol(); ?>") + ' ' + revenue  ;
				  }
				},
				toolbox: {
				  show : false,
				  orient : 'horizontal',
				  x: 'right',
				  y: '10',
				  feature : {
					restore : { show: true },
					saveAsImage : { show: true }
				  }
				},
				roamController: {
				  show: true,
				  mapTypeControl: {
					'world': true
				  },
				  x: 'right',
				  y: 'bottom'
				},
				dataRange: {
				  min: <?php echo $lowest_number; ?>,
				  max: <?php echo $higest_number; ?>,
				  text:['High','Low'],
				  realtime: true,
				  calculable : true,
				  color: ['#ff5252','#ffbc00','#448aff']
				},
				series : [
				  {
					name: 'Geographic Stats',
					type: 'map',
					mapType: 'world',
					roam: false,
					scaleLimit :{
					  min: 1,
					  max: 10
					},
					scrollwheel: false,
					mapLocation: {
					  y : 60
					},
					itemStyle:{
					  emphasis:{label:{show:true}}
					},
					data:[
					  <?php foreach ( $country_stats['rows'] as $country ) : ?>
					  {name : '<?php echo $country[0] == 'United States' ? 'United States of America' : $country[0]; ?>', value : <?php echo $country[1]; ?>, revenue : '<?php echo number_format( $country[2], 2 ); ?>'},
						<?php endforeach; ?>
					]
				  }
				]
			  };

			  // Load data into the ECharts instance
			  geographic_stats_graph.setOption(geographic_stats_graph_option);


			  window.onresize = function () {
				geographic_stats_graph.resize();
			  }

			}
		  );
		});

		</script>

		<div class="analytify_txt_center analytify_graph_wraper">
		  <div id="analytify_geographic_stats_graph" style="height:600px"></div>
		</div>
		<div class="analytify_clearfix">
		  <table class="analytify_data_tables analytify_border_th_tp">
			<thead>
			  <tr>
				<th class="wd_1">
				#
			  </th>
				<th class="analytify_txt_left"><?php esc_html_e( 'Country Name', 'wp-analytify-woocommerce' ); ?></th>
				<th class="analytify_value_row"><?php esc_html_e( 'No. of Sales', 'wp-analytify-woocommerce' ); ?></th>
				<th class="analytify_value_row"><?php esc_html_e( 'Revenue', 'wp-analytify-woocommerce' ); ?></th>
			  </tr>
			</thead>
			<tbody>

			  <?php $counter = 0; ?>
			  <?php foreach ( $country_stats['rows'] as $key => $country ) : ?>
					<?php $counter++; ?>
				<tr>
				  <td>
					<?php echo $counter; ?>
				  </td>
				  <td><span class="<?php echo pretty_class( $country[0] ); ?> analytify_flages"></span> <?php echo $country[0]; ?></td>
				  <td class="analytify_txt_center"> <?php echo $country[1]; ?></td>
				  <td class="analytify_txt_center"> <?php echo get_woocommerce_currency_symbol() . number_format( $country[2], 2 ); ?></td>
				</tr>
					<?php // if( $counter > 4 ) break ?>
				<?php endforeach; ?>

			</tbody>
		  </table>

		</div>
			<?php
	  else :
			$current->no_records();
	  endif;
		?>

	</div>
	</div>

<?php
	wp_send_json( array( 
		'body' => ob_get_clean()
	) );
}
