<?php
/**
 * Coupons stats view.
 *
 * @param WP_Analytify $wp_analytify
 * @param object $stats
 * 
 * @return void
 */
function wpa_wocommerce_coupons_performance( $wp_analytify, $stats ) {
	?>

    <div class="analytify_general_status analytify_status_box_wraper">
      <div class="analytify_status_header">
	 	<h3>
          <?php esc_html_e( 'Coupons Analysis', 'wp-analytify-woocommerce' ); ?>
          <a href="#" class="analytify-export-data analytify_tooltip" data-stats-type="coupons-analysis">
            <span class="analytify_tooltiptext"><?php _e( 'Export Coupons Analysis', 'wp-analytify-pro' ) ?></span>
          </a>
          <img src="<?php echo admin_url( 'images/spinner.gif' ); ?>" class='analytify-export-loader' style="display:none">
        </h3>
      </div>
      <div class="analytify_status_body">
        <table class="analytify_data_tables">
          <thead>
            <tr>
              <th class="wd_1">
                #
              </th>
              <th>
                <?php esc_html_e( 'Coupon Code', 'wp-analytify-woocommerce' ); ?>
              </th>
              <th>
                <?php esc_html_e( 'Revenue', 'wp-analytify-woocommerce' ); ?>
              </th>
              <th >
                <?php esc_html_e( 'Transactions', 'wp-analytify-woocommerce' ); ?>
              </th>
            </tr>
          </thead>
          <tbody>
            <?php if ( ! empty( $stats['rows'] ) ) {
              $i = 0;
              foreach ( $stats['rows'] as $stat ) {
                $i++;
                ?>
                <tr>
                  <td>
                    <?php echo $i; ?>
                  </td>
                  <td>
                    <?php echo $stat['orderCoupon'] ; ?>
                  </td>
                  <td class="analytify_txt_center">
                    <?php echo get_woocommerce_currency_symbol() . number_format( $stat['purchaseRevenue'], 2 ) ?>
                  </td>
                  <td class="analytify_txt_center">
                    <?php echo $stat['transactions']; ?>
                  </td>
                </tr>
                <?php
              }
            } else { ?>
              <tr>
                <td class="analytify_td_error_msg" colspan="5">
                  <?php $wp_analytify->no_records(); ?>
                </td>
              </tr>
              <?php
            }
            ?>
          </tbody>
        </table>
      </div>
      <div class="analytify_status_footer">
        <span class="analytify_info_stats">
			<?php
			if ( isset( $stats['rows'] ) && isset( $stats['rows'][0]['orderCoupon'] ) ) :
			echo sprintf( esc_html__( 'Did you know the famous Coupon in your store is %1$s %2$s %3$s?', 'wp-analytify-woocommerce' ), '<strong>' , $stats['rows'][0]['orderCoupon'] , '</strong>' );
			else :
			esc_html_e( 'List of all the coupons used at store.', 'wp-analytify-woocommerce' );
			endif;
			?>
		</span>
	</div>
</div>

<?php
}
