<?php
/**
 * List performance view.
 *
 * @param object $current
 * @param object $stats
 * @return void
 */
function wpa_wocommerce_lists_performance( $current, $stats ) {
	?>

    <div class="analytify_general_status analytify_status_box_wraper">
      <div class="analytify_status_header">
	  	<h3>
          <?php esc_html_e( 'Product lists Analysis', 'wp-analytify-woocommerce' ); ?>
          <a href="#" class="analytify-export-data analytify_tooltip" data-stats-type="product-lists-analysis">
            <span class="analytify_tooltiptext"><?php _e( 'Export Product lists Analysis', 'wp-analytify-pro' ) ?></span>
          </a>
          <img src="<?php echo admin_url( 'images/spinner.gif' ); ?>" class='analytify-export-loader' style="display:none">
        </h3>
      </div>
      <div class="analytify_status_body">

        <table class="analytify_data_tables">
          <thead>
            <tr>
              <th class="wd_1">
                #
              </th>
              <th>
                <?php esc_html_e( 'List Name', 'wp-analytify-woocommerce' ); ?>
              </th>
              <th>
                <?php esc_html_e( 'Items Viewed In List', 'wp-analytify-woocommerce' ); ?>
              </th>
              <th class="">
                <?php esc_html_e( 'Items Clicked In List', 'wp-analytify-woocommerce' ); ?>
              </th>
              <th class="">
                <?php esc_html_e( 'Product List CTR', 'wp-analytify-woocommerce' ); ?>
              </th>
              <th class="">
                <?php esc_html_e( 'Items Added To Cart', 'wp-analytify-woocommerce' ); ?>
              </th>
              <th class="">
                <?php esc_html_e( 'Items Checkouts', 'wp-analytify-woocommerce' ); ?>
              </th>
              <th class="">
                <?php esc_html_e( 'Items Purchases', 'wp-analytify-woocommerce' ); ?>
              </th>
              <th class="">
                <?php esc_html_e( 'Product Revenue', 'wp-analytify-woocommerce' ); ?>
              </th>
            </tr>
          </thead>
          <tbody>

            <?php if ( ! empty( $stats['rows'] ) ) {
              $i = 0;
              foreach ( $stats['rows'] as $stat ) {
                $i++;
                ?>
                <tr>
                  <td>
                    <?php echo $i; ?>
                  </td>
                  <td>
                    <?php echo $stat['itemListName']; ?>
                  </td>
                  <td class="analytify_txt_center">
                    <?php echo $stat['itemsViewedInList']; ?>
                  </td>
                  <td class="analytify_txt_center">
                    <?php echo $stat['itemsClickedInList']; ?>
                  </td>
                  <td>
                    <?php $percent_quantity = number_format( $stat['itemListClickThroughRate'], 2 );?>
                    <?php echo $percent_quantity; ?> %
                    <span class="analytify_bar_graph">
                      <span style="width: <?php echo $percent_quantity ?>%;"></span>
                    </span>
                  </td>
                  <td class="analytify_txt_center">
                    <?php echo $stat['itemsAddedToCart']; ?>
                  </td>
                  <td class="analytify_txt_center">
                    <?php echo $stat['itemsCheckedOut']; ?>
                  </td>
                  <td class="analytify_txt_center">
                    <?php echo $stat['itemsPurchased']; ?>
                  </td>
                  <td class="analytify_txt_center">
                    <?php echo get_woocommerce_currency_symbol() . number_format( $stat['itemRevenue'], 2 ) ?>
                  </td>
                </tr>
                <?php
              }
            } else { ?>
              <tr>
                <td class="analytify_td_error_msg" colspan="9">
                  <?php $current->no_records(); ?>
                </td>
              </tr>
              <?php }
              ?>
            </tbody>
          </table>
        </div>
        <div class="analytify_status_footer">

	<?php if ( isset( $stats['rows'][0]['itemListName'] ) ) { ?>
	<span class="analytify_info_stats">
		<?php
		echo sprintf( esc_html__( 'Did you know the big Revenue generated from Product List in your store is %1$s %2$s %3$s?', 'wp-analytify-woocommerce' ), '<strong>', $stats['rows'][0]['itemListName'], '</strong>' );
		?>
	</span>
	<?php } ?>

	</div>
</div>

<?php 
}
