<?php
/**
 * Product performance view.
 *
 * @param object $current
 * @param object $stats
 * @param string $report_url
 * @param string $report_date_range
 * @return void
 */
function pa_include_wocommerce_products( $current, $stats, $report_url, $report_date_range ) {

	if ( isset( $stats['rows'] ) && isset( $stats['rows'][0][0] ) ) {
		$famous = $stats['rows'][0][0];
	} ?>

	<div class="analytify_general_status analytify_status_box_wraper">
		<div class="analytify_status_header">
			<h3>
				<?php esc_html_e( 'Products Performance', 'wp-analytify-woocommerce' ); ?>
				<a href="#" class="analytify-export-data analytify_tooltip" data-stats-type="products-performance">
					<span class="analytify_tooltiptext"><?php _e( 'Export Products Performance', 'wp-analytify-pro' ) ?></span>
				</a>
				<img src="<?php echo admin_url( 'images/spinner.gif' ); ?>" class='analytify-export-loader' style="display:none">
			</h3>
		</div>
		<div class="analytify_status_body">

			<table class="analytify_data_tables wp_analytify_paginated" data-product-per-page="10">
				<thead>
					<tr>
						<th class="wd_1">
							#
						</th>
						<th>
							<?php esc_html_e( 'Name', 'wp-analytify-woocommerce' ); ?>
						</th>
						<th>
							<?php esc_html_e( 'Product Revenue', 'wp-analytify-woocommerce' ); ?>
						</th>
						<th class="">
							<?php esc_html_e( 'Unique Purchases', 'wp-analytify-woocommerce' ); ?>
						</th>
						<th class="">
							<?php esc_html_e( 'Quantity', 'wp-analytify-woocommerce' ); ?>
						</th>
						<th class="">
							<?php esc_html_e( 'Cart-to-Detail Rate', 'wp-analytify-woocommerce' ); ?>
						</th>
						<th class="">
							<?php esc_html_e( 'Buy-to-Detail Rate', 'wp-analytify-woocommerce' ); ?>
						</th>
					</tr>
				</thead>
				<tbody>

					<?php
					if ( ! empty( $stats['rows'] ) ) {
						$i = 0;
						foreach ( $stats['rows'] as $stat ) {
							$i++;
							?>
							<tr>
								<td data-heading="#2">
									<?php echo $i; ?>
								</td>
								<td>
									<?php echo $stat[0]; ?>
								</td>
								<td class="analytify_txt_center">
									<?php echo get_woocommerce_currency_symbol() . number_format( $stat[1], 2 ); ?>
								</td>
								<td class="analytify_txt_center">
									<?php echo $stat[2]; ?>
								</td>
								<td class="analytify_txt_center">
									<?php echo $stat[3]; ?>
								</td>
								<td>
									<?php $percent_quantity = number_format( $stat[4], 2 ); ?>
									<?php echo $percent_quantity; ?> %
									<span class="analytify_bar_graph">
									  <span style="width: <?php echo $percent_quantity; ?>%;"></span>
									</span>
								</td>
								<td>
									<?php $percent_quantity = number_format( $stat[5], 2 ); ?>
									<?php echo $percent_quantity; ?> %
									<span class="analytify_bar_graph">
										<span style="width: <?php echo $percent_quantity; ?>%;"></span>
									</span>
								</td>
							</tr>
							<?php
						}
					} else {
						?>
						<tr>
							<td class="analytify_td_error_msg" colspan="7">
						<?php $current->no_records(); ?>
							</td>
						</tr>
						<?php
					}
					?>
				</tbody>
			</table>
		</div>
		<div class="analytify_status_footer">
			<?php if ( isset( $stat[0] ) ) : ?>
				<span class="analytify_info_stats">
					<?php
					echo sprintf( esc_html__( 'Did you know the most selling product (quantity wise) in your store is %1$s %2$s %3$s?', 'wp-analytify-woocommerce' ), '<strong>', $famous, '</strong>' );
					?>
				</span>
				<div class="wp_analytify_pagination"></div>
			<?php endif; ?>
		</div>
	</div>
<?php } ?>

<script type="text/javascript">
	jQuery(document).ready(function($) {
		wp_analytify_paginated();
	});
</script>
