<?php
if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}

/*
 * Plugin Name: Analytify WooCommerce
 * Plugin URI: https://analytify.io/add-ons/woocommerce/?utm-source=analytify-woo-addon&utm_medium=plugin-uri&utm_campaign=analytify-woo-addon
 * Description: This Add-on will track the e-commerce behavior of users, Digital Sales, Transactions and Revenues in Google Analytics and Displays Stats in a unique and intuitive way which is very understandable even for non-technical WordPress users.
 * Version:  5.1.0
 * Author: Analytify
 * Author URI: https://analytify.io/?utm-source=analytify-woo-addon&utm_medium=author-uri&utm_campaign=analytify-woo-addon
 * Developer: Analytify LLC
 * Developer URI: https://analytify.io/?utm_source=analytify-woo-addon&utm_medium=developer-uri
 * License: GPLv2+
 * Min WP Version: 3.0
 * Max WP Version: 6.4
 * Text Domain: wp-analytify-woocommerce
 * Domain Path: /languages
 * WC requires at least: 2.5
 * WC tested up to: 8.4.0
 */

define('ANALTYIFY_WOOCOMMERCE_VERSION', '5.1.0');
define('ANALYTIFY_WOOCOMMERCE_UPGRADE_PATH', __FILE__);

/**
 * Check WooCommerce plugin installation.
 *
 * @return void
 */
function wpa_check_woo_admin_notice()
{

	$message = __('<strong>Attention:</strong> Analytify for WooCommerce works with WooCommerce plugin, Please activate WooCommerce.', 'wp-analytify-woocommerce');
	wp_analytify_woo_notice($message, 'wp-analytify-danger');
}

/**
 * Check Analytify free plugin installation.
 *
 * @return void
 */
function wpa_check_analytify_admin_notice()
{

	$message = __('<strong>Attention:</strong> Analytify for WooCommerce works with the Analytify plugin. Please activate Analytify.', 'wp-analytify-woocommerce');
	wp_analytify_woo_notice($message, 'wp-analytify-danger');
}
/**
 * Check Analytify pro plugin installation.
 *
 * @return void
 */
function wpa_check_analytify_pro_admin_notice()
{

	$message = __('<strong>Attention:</strong> Analytify for WooCommerce works with the Analytify PRO plugin. Please activate Analytify PRO.', 'wp-analytify-woocommerce');
	wp_analytify_woo_notice($message, 'wp-analytify-danger');
}

/**
 * Action hook for declaring the WooCommerce HPOS compatibility with Analytify WooCommerce.
 */
add_action('before_woocommerce_init', 'wpa_declare_hpos_compatability');

/**
 * Provides the compatibility with WooCommerce HPOS
 *
 * Before HPOS WC relied on on the post and post-meta table structures to store order information.
 *
 * HPOS introduces dedicated tables for data which results in fewer read/write operations and fewer busy tables.
 *
 * HPOS enables e-commerce stores of all shapes and sizes to scale to their maximum potential.
 * 
 * Analytify is Compatible 
 */
function wpa_declare_hpos_compatability()
{

	if (class_exists(\Automattic\WooCommerce\Utilities\FeaturesUtil::class)) {
		\Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility('custom_order_tables', __FILE__, true);

	}
}

/**
 * Load addon.
 *
 * @return void
 */
function load_analytify_woo()
{

	/**
	 * Check for the Main Plugin
	 */
	if (!class_exists('WP_Analytify')) {
		add_action('admin_enqueue_scripts', 'wpa_woo_notices_scripts');
		add_action('admin_notices', 'wpa_check_analytify_admin_notice');
		return;
	}

	/**
	 * Check for the Pro version
	 */
	if (!class_exists('WP_Analytify_Pro')) {
		add_action('admin_enqueue_scripts', 'wpa_woo_notices_scripts');
		add_action('admin_notices', 'wpa_check_analytify_pro_admin_notice');
		return;
	}

	/**
	 * Check for WooCommerce
	 */
	if (!class_exists('WooCommerce')) {
		add_action('admin_enqueue_scripts', 'wpa_woo_notices_scripts');
		add_action('admin_notices', 'wpa_check_woo_admin_notice');
		return;
	}

	// Set to default if tracking mode not set.
	if (!defined('ANALYTIFY_TRACKING_MODE')) {
		define('ANALYTIFY_TRACKING_MODE', 'ga');
	}

	$abspath = dirname(__FILE__);

	include_once $abspath . '/class-wp-analytify-woo.php';

	// Global for backwards compatibility.
	$GLOBALS['WPAnalytifyWooCommerce'] = WP_Analytify_WooCommerce::instance();
}
add_action('plugins_loaded', 'load_analytify_woo', 20);

/**
 * Load TextDomain
 *
 * @since 1.0.2
 */
function wp_analytify_woo_load_text_domain()
{

	$plugin_dir = basename(dirname(__FILE__));
	load_plugin_textdomain('wp-analytify-woocommerce', false, $plugin_dir . '/languages/');
}
add_action('init', 'wp_analytify_woo_load_text_domain');

/**
 * Helper function for translation.
 */
if (!function_exists('analytify__')) {
	/**
	 * Wrapper for __() gettext function.
	 * @param  string $string     Translatable text string
	 * @param  string $textdomain Text domain, default: wp-analytify
	 * @return void
	 */
	function analytify__($string, $textdomain = 'wp-analytify')
	{

		return __($string, $textdomain);
	}
}

if (!function_exists('analytify_e')) {
	/**
	 * Wrapper for _e() gettext function.
	 * @param  string $string     Translatable text string
	 * @param  string $textdomain Text domain, default: wp-analytify
	 * @return void
	 */
	function analytify_e($string, $textdomain = 'wp-analytify')
	{

		echo __($string, $textdomain);
	}
}

/**
 * Add custom admin notice.
 *
 * @param  string $message Custom Message
 * @param  string $class wp-analytify-success,wp-analytify-danger
 */
function wp_analytify_woo_notice($message, $class)
{

	echo '<div class="wp-analytify-notification ' . $class . '">
	<a class="" href="#" aria-label="Dismiss the welcome panel"></a>
	<div class="wp-analytify-notice-logo">
	<img src="' . plugins_url('assets/img/logo.svg', __FILE__) . '" alt="analytify logo">
	</div>
	<div class="wp-analytify-notice-discription">
	<p>' . $message . '</p>
	</div>
	</div>';
}

/**
 * Admin notices scripts.
 */
function wpa_woo_notices_scripts()
{

	wp_enqueue_style('wpa-woo-notices-css', plugins_url('assets/css/notices.css', __FILE__), '', ANALTYIFY_WOOCOMMERCE_VERSION);
}
