<?php

/**
 * Plugin Name: BWL Advanced FAQ Manager
 * Plugin URI: https://1.envato.market/baf-wp
 * Description: A WordPress plugin designed for managing frequently asked questions. With this plugin, you can effortlessly create an unlimited number of FAQ items and seamlessly display them on the front end of your website.
 * Author: Mahbub Alam Khan
 * Version: 2.0.4
 * Author URI: https://codecanyon.net/user/xenioushk
 * WP Requires at least: 6.0+
 * Text Domain: bwl-adv-faq
 * Domain Path: /lang/
 * 
 * 
 * @package BWL Advanced FAQ Manager
 * @author Mahbub Alam Khan
 * @license GPL-2.0+
 * @link https://codecanyon.net/user/xenioushk
 * @copyright 2023 BlueWindLab
 */

// If this file is called directly, abort.
defined('ABSPATH') or die("Unauthorized access");

if (file_exists(dirname(__FILE__) . '/vendor/autoload.php')) {
    require_once dirname(__FILE__) . '/vendor/autoload.php';
}

use BwlFaqManager\Api\Db\BafDbSettings;
use BwlFaqManager\Base\BafAdminHelpers;
use BwlFaqManager\Api\Cpt\BafQuickBulkEdit;
use BwlFaqManager\Api\Metainfo\BafMetaInfo;
use BwlFaqManager\Api\Cpt\BafCustomPostType;
use BwlFaqManager\Api\Cpt\BafCptCustomColumns;
use BwlFaqManager\Api\Noticebox\BafAdminNotice;
use BwlFaqManager\Api\Cpt\BafCptTaxonomyFilters;
use BwlFaqManager\Api\TaxonomySort\BafTaxonomySort;
use BwlFaqManager\Api\ViewsTracker\BafViewsTracker;
use BwlFaqManager\Api\KeyWordsTracker\BafSearchKeywordsTracker;
use BwlFaqManager\Controllers\DashboardWidgets\PluginDashboardWidgets;


if (!class_exists('BWL_Advanced_Faq_Manager')) {

    class BWL_Advanced_Faq_Manager
    {

        public function __construct()
        {
            define("BWL_BAF_PLUGIN_VERSION", "2.0.4");
            define("BWL_BAF_PLUGIN_UPDATER_SLUG", plugin_basename(__FILE__));
            define("BWL_BAF_PLUGIN_PATH", __DIR__);
            define('BWL_BAF_INSTALLATION_TAG', 'baf_installation_' . str_replace('.', '_', BWL_BAF_PLUGIN_VERSION));

            define("BWL_BAF_PLUGIN_CONTROLLER_PATH", __DIR__ . "includes/Controllers/");
            define("BWL_BAF_PLUGIN_VIEWS_PATH", __DIR__ . "/includes/Views/");

            require_once(__DIR__ . '/includes/BafConstants.php');

            $this->includeFiles();

            add_action('wp_enqueue_scripts', [$this, 'bafEnqueueScripts']);
            add_action('admin_enqueue_scripts', [$this, 'bafAdminEnqueueScripts']);
            add_action('plugins_loaded', [$this, 'bafLoadTranslationFile']);
        }

        public function bafEnqueueScripts()
        {

            $bwl_advanced_faq_options = get_option('bwl_advanced_faq_options');

            // Load front end styles & scripts.
            wp_enqueue_style("baf-frontend", plugins_url('assets/styles/frontend.css', __FILE__), [], BWL_BAF_PLUGIN_VERSION);

            /*-- RTL MODE --*/

            if (is_rtl()) {

                wp_enqueue_style('baf-frontend-rtl', plugins_url('assets/styles/frontend_rtl.css', __FILE__), [], BWL_BAF_PLUGIN_VERSION);
            }

            /*-- Introduce Font-Awesome In Version 1.4.9 --*/

            if (isset($bwl_advanced_faq_options['bwl_advanced_fa_status']) && $bwl_advanced_faq_options['bwl_advanced_fa_status'] == "on") {

                wp_enqueue_style('font-awesome', plugins_url('libs/font-awesome/font-awesome.min.css', __FILE__), [], BWL_BAF_PLUGIN_VERSION);
                wp_enqueue_style('font-awesome-shims', plugins_url('libs/font-awesome/v4-shims.min.css', __FILE__), [], BWL_BAF_PLUGIN_VERSION);
            }

            // New Scripts.
            wp_enqueue_script('baf-frontend', plugins_url('assets/scripts/frontend.js', __FILE__), ['jquery'], BWL_BAF_PLUGIN_VERSION, TRUE);

            // Variable access Rules: BafFrontendData.ajaxurl

            wp_localize_script(
                'baf-frontend',
                'BafFrontendData', // javascript end variable.
                BafHelpers::localizeData()
            );
        }

        public function bafAdminEnqueueScripts()
        {

            global $pagenow;

            // Load admin styles & scripts.
            wp_enqueue_style('baf-admin', plugins_url('assets/styles/admin.css', __FILE__), ['wp-color-picker'], BWL_BAF_PLUGIN_VERSION);

            if (is_rtl()) {
                wp_enqueue_style('baf-admin-rtl', plugins_url('assets/styles/admin_rtl.css', __FILE__), [], BWL_BAF_PLUGIN_VERSION);
            }

            // TinyMCE Editor Style.
            wp_register_style('bwl-advanced-faq-editor-style', plugins_url('libs/tinymce/styles/bwl-advanced-faq-editor.css', __FILE__), [], BWL_BAF_PLUGIN_VERSION);
            wp_register_style('bwl-advanced-faq-multiple-select', plugins_url('libs/multiple-select/styles/multiple-select.css', __FILE__), [], BWL_BAF_PLUGIN_VERSION);
            wp_register_script('bwl-advanced-faq-multiple-select', plugins_url('libs/multiple-select/scripts/jquery.multiple.select.js', __FILE__), ['jquery', 'jquery-ui-core', 'jquery-ui-draggable', 'jquery-ui-droppable'], BWL_BAF_PLUGIN_VERSION, TRUE);

            // Chart JS.
            wp_register_script('baf-chart-js', plugins_url('libs/chart-js/scripts/chart.js', __FILE__), ['jquery'], BWL_BAF_PLUGIN_VERSION, TRUE);


            //Enqueue FAQ Admin Script & Style.
            wp_enqueue_style('bwl-advanced-faq-editor-style'); // TinyMCE Editor Overlay.
            wp_enqueue_style('bwl-advanced-faq-multiple-select'); // Enqueue Multiselect Style.
            wp_enqueue_script('bwl-advanced-faq-multiple-select'); // Enqueue Multiselect Script.

            if ($pagenow === 'edit.php' && isset($_GET['post_type']) && $_GET['post_type'] === 'bwl_advanced_faq') {
                wp_enqueue_script('baf-chart-js');
            }

            wp_enqueue_script('baf-admin', plugins_url('assets/scripts/admin.js', __FILE__), ['jquery', 'wp-color-picker', 'jquery-ui-core', 'jquery-ui-draggable', 'jquery-ui-droppable', 'jquery-ui-sortable'], BWL_BAF_PLUGIN_VERSION, TRUE);

            // Variable access Rules: BafFrontendData.ajaxurl
            wp_localize_script(
                'baf-admin',
                'BafAdminData',
                BafAdminHelpers::localizeData()
            );
        }

        public function includeFiles()
        {

            // Commen Functions.
            require_once(__DIR__ . '/includes/BafHelpers.php');

            // Upgrade and Hanlde Custom DataBase Tables.
            new BafDbSettings();

            // Custom Post Type.
            new BafCustomPostType();

            // View Tracker
            new BafViewsTracker();

            // Search Keywords Tracker
            new BafSearchKeywordsTracker();

            if (is_admin()) {

                // Plugin Dasboard Widgets.
                new PluginDashboardWidgets();

                // Plugin Metainfo.
                new BafMetaInfo();

                // Load plugin versioning informations.
                require_once(__DIR__ . '/includes/version-manager.php');

                // Admin panel faq sorting.
                new BafTaxonomySort();

                // Custom Post Types Support. 

                // Load plugin custom columns.
                new BafCptCustomColumns();

                // Load plugin quick and bulk edit settings.
                new BafQuickBulkEdit();

                // Load plugin custom filter by category and tags 
                new BafCptTaxonomyFilters();

                // Load Custom shrotcode editor panel.
                require_once(__DIR__ . '/includes/tinymce/baf_tiny_mce_config.php');

                // Options Panel.
                require_once(__DIR__ . '/includes/settings/options_panel.php'); // Load plugins options panel.
                require_once(__DIR__ . '/includes/settings/options_panel_submenus.php'); // Load Welcome page.

                // Auto Updater Scripts.
                require_once(__DIR__ . '/includes/autoupdater/WpAutoUpdater.php');
                require_once(__DIR__ . '/includes/autoupdater/installer.php');
                require_once(__DIR__ . '/includes/autoupdater/updater.php');
                require_once(__DIR__ . '/includes/autoupdater/baf_update_notifier.php');
                require_once(__DIR__ . '/includes/autoupdater/plugin_purchase_verify.php');

                // Admin Notice.
                new BafAdminNotice();
            } else {

                // Load only Frontend files.
                require_once(__DIR__ . '/includes/baf_theme_generator.php'); // Generate and Load plugin custom themes.

                // Integrate shortcodes
                require_once(__DIR__ . '/includes/shortcodes/baf_faq_list.php'); // Load plugin faq shortcodes.

                require_once(__DIR__ . '/includes/shortcodes/baf_faq_tab.php');
            }

            require_once(__DIR__ . '/includes/shortcodes/baf_external_form.php'); // Load plugin External Faq insertion form shortcodes.

            require_once(__DIR__ . '/includes/baf_rating.php'); // Count FAQ rating.

        }

        /*-- TRANSLATION FILE --*/

        public function bafLoadTranslationFile()
        {
            load_plugin_textdomain('bwl-adv-faq', FALSE, dirname(plugin_basename(__FILE__)) . '/lang/');
        }
    }

    /*-- INTEGRATE WIDGET --*/

    $baf_widgets = ['faqs', 'categories', 'topics'];

    foreach ($baf_widgets as $widget_key => $widget_page) :
        require_once(__DIR__ . '/includes/widgets/baf_' . $widget_page . '.php');
    endforeach;

    /*--INITIALIZATION --*/

    function initBwlAdvancedFaqManager()
    {
        new BWL_Advanced_Faq_Manager();
    }

    add_action('init', 'initBwlAdvancedFaqManager');
}
