<?php

/**
 * @package BwlFaqManager
 */

namespace BwlFaqManager\Api\AjaxHandlers;

// AjaxHandlersApi interface class.

class AjaxHandlersApi

{

  public $ajaxrequests = [];

  public function addAjaxHandlers(array $ajaxrequests)
  {
    $this->ajaxrequests = $ajaxrequests;
    return $this;
  }

  public function register()
  {
    if (!empty($this->ajaxrequests)) {

      foreach ($this->ajaxrequests as $ajaxrequest) {
        add_action("wp_ajax_{$ajaxrequest['tag']}", $ajaxrequest['callback']);
        add_action("wp_ajax_nopriv_{$ajaxrequest['tag']}", $ajaxrequest['callback']);
      }
    }
  }
}