<?php

/**
 * @package BwlFaqManager
 */

namespace BwlFaqManager\Api\DashboardWidgets;

class DashboardWidgetsApi

{

  public $dashWidgets = [];

  public function __construct()
  {
    $this->register();
  }

  public function register()
  {
    add_action('wp_dashboard_setup', [$this, 'registerAllWidgetsBlock']);
  }

  public function addDashWidgets(array $dashWidgets)
  {
    $this->dashWidgets = $dashWidgets;
    return $this;
  }

  public function registerAllWidgetsBlock()
  {
    if (!empty($this->dashWidgets)) {

      foreach ($this->dashWidgets as $widget) {
        // add_action('wp_dashboard_setup', $widget['cb']);

        wp_add_dashboard_widget(
          $widget['slug'],
          $widget['title'],
          $widget['cb']
        );
      }
    }
  }
}