<?php

/**
 * @package BwlFaqManager
 */

namespace BwlFaqManager\Api\KeyWordsTracker;

class BafSearchKeywordsTracker
{
    public function __construct()
    {
        add_action('wp_ajax_baf_track_search_keywords', [$this, 'cbBafSearchKeywordsTracker']);
        add_action('wp_ajax_nopriv_baf_track_search_keywords', [$this, 'cbBafSearchKeywordsTracker']);
    }

    /**
     * @param array $table_data
     * 
     * @return [type]
     */
    public function insertSearchKeywordsData($table_data = [])
    {

        if (empty($table_data)) return "";

        global $wpdb;

        $table_data_type = [
            '%s', // search_keywords
            '%d', // search_result_counts
            '%d', // pageId
            '%s', // ip
            '%s', // like_date_time
        ];

        $wpdb->insert(TABLE_BAF_SEARCH_KEYWORDS_DATA, $table_data, $table_data_type);
    }

    function cbBafSearchKeywordsTracker()
    {

        if (isset($_REQUEST['keywords']) && !empty($_REQUEST['keywords'])) {

            // Retrieve user IP address  

            $ip          = $_SERVER['REMOTE_ADDR'];
            $keywords  = sanitize_text_field($_REQUEST['keywords']);
            $count  = sanitize_text_field($_REQUEST['count']);
            $pageId  = sanitize_text_field($_REQUEST['pageId']);

            $timestamp =  time();

            // Update Data of "baf_likes_data"

            $table_data = [
                'search_keywords' => $keywords,
                'search_result_counts' => $count,
                'post_id' => $pageId,
                'ip' => $ip,
                'search_date_time' => date('Y-m-d H:i:s', $timestamp)
            ];

            $this->insertSearchKeywordsData($table_data);

            $status = 1;
        } else {

            $status = 0;
        }

        $data = [
            'status' => $status
        ];

        echo json_encode($data);

        die();
    }
}

// new BafSearchKeywordsTracker();