<?php

$taxnomyType = $baf_filter_page == 'topics' ? 'topics' : 'category';
$taxnomyTypeText = $baf_filter_page == 'topics' ? 'Topic' : 'Category';

$bafTaxonomyArgs = array(
    'taxonomy' => 'advanced_faq_' . $taxnomyType,
    'hide_empty' => 0,
    'orderby' => 'ID',
    'order' => 'ASC'
);

$bafTaxonomyItems = get_categories($bafTaxonomyArgs);

wp_reset_query();
?>

<label
  for="baf_sort_faq_<?php echo $taxnomyType; ?>"><?php echo esc_html__('FAQ', 'bwl-adv-faq') . ' ' . $taxnomyTypeText ?></label>

<select id="baf_sort_faq_taxonomy" name="baf_sort_faq_taxonomy">

  <option value=""><?php echo esc_html__('Select', 'bwl-adv-faq') . ' ' . $taxnomyTypeText ?></option>
  <?php

    if (!empty($bafTaxonomyItems)) :

        foreach ($bafTaxonomyItems as $item) :

            echo '<option value="' . $item->slug . '" data-term_id="' . $item->term_id . '">' . ucfirst($item->name) . '</option>';

        endforeach;

    endif;

    ?>

</select>

<ul id="bwl_faq_items"></ul>