<?php

add_action('wp_ajax_bafVerifyPurchaseData', 'bafVerifyPurchaseData');

function bafVerifyPurchaseData()
{

  $apiURL = bwlApiUrl();
  $site_url = get_site_url();
  $purchase_code = trim($_REQUEST['purchase_code']);
  $product_id = BWL_BAF_CC_ID;
  $ip = $_SERVER['REMOTE_ADDR'];

  $requestUrl = $apiURL . "wp-json/bwlapi/v1/verify/purchase?purchase_code=$purchase_code&product_id=$product_id&site=$site_url&referer=$ip";

  $apiResponse = wp_remote_get($requestUrl);

  $data = [
    'status' => 0
  ];

  if (is_array($apiResponse) && !is_wp_error($apiResponse) && wp_remote_retrieve_response_code($apiResponse) === 200) {

    $apiData = json_decode(wp_remote_retrieve_body($apiResponse), true); // Get the response body.

    if (isset($apiData['status']) && $apiData['status'] == 1) {

      update_option('baf_purchase_verified', '1');
      update_option('baf_purchase_info', $apiData);
    }

    $data['status'] = $apiData['status'];
    $data['msg'] = $apiData['msg'];
  } else {
    // Request failed or returned an error status code.
    if (is_wp_error($apiResponse)) {
      // Handle WP_Error case.
      $error_message = $apiResponse->get_error_message();
      $data = [
        'msg' => $error_message
      ];
      bwllog($error_message);
    } else {
      // Handle non-200 status codes.
      $status_code = wp_remote_retrieve_response_code($apiResponse);

      $data = [
        'msg' =>  "Request failed with status code: $status_code"
      ];

      bwllog($data);
    }
  }

  echo json_encode($data);

  die();
}


// Remove Data.

add_action('wp_ajax_bafRemoveLicenseData', 'bafRemoveLicenseData');

function bafRemoveLicenseData()
{

  $apiURL = bwlApiUrl();
  $verify_hash = trim($_REQUEST['verify_hash']);

  // For Offline Code Removal.

  if ($verify_hash == "offline") {
    delete_option('baf_purchase_verified');
    delete_option('baf_purchase_info');
    $data['status'] = 1;
    echo json_encode($data);
    die();
  }

  // Remove offline code to API server.

  $requestUrl = $apiURL . "wp-json/bwlapi/v1/verify/remove?verify_hash=$verify_hash";

  $apiResponse = wp_remote_get($requestUrl);

  $data = [
    'status' => 0
  ];

  if (is_array($apiResponse) && !is_wp_error($apiResponse) && wp_remote_retrieve_response_code($apiResponse) === 200) {

    $apiData = wp_remote_retrieve_body($apiResponse); // Get the response body. 

    // bwllog($apiData);

    $apiData = json_decode($apiData, true);

    // bwllog($apiData['msg']);

    if (isset($apiData['status']) && $apiData['status'] == 1) {
      delete_option('baf_purchase_verified');
      delete_option('baf_purchase_info');
    }

    $data['status'] = $apiData['status'];
    $data['msg'] = $apiData['msg'];
  } else {
    // Request failed or returned an error status code.
    if (is_wp_error($apiResponse)) {
      // Handle WP_Error case.
      $error_message = $apiResponse->get_error_message();
      $data = [
        'msg' => $error_message
      ];
      bwllog($error_message);
    } else {
      // Handle non-200 status codes.
      $status_code = wp_remote_retrieve_response_code($apiResponse);

      $data = [
        'msg' =>  "Request failed with status code: $status_code"
      ];

      bwllog($data);
    }
  }

  echo json_encode($data);

  die();
}
