<div class="wrap" id="baf-product-license">

  <h2><?php echo $pluginLicenseData['title'] . " License Page"; ?></h2>

  <div id="loader"></div>

  <?php if ($pluginLicenseData['status'] == 2) { ?>

  <p class="developer-info">

    No license activation is required.

  </p>

  <?php } elseif ($pluginLicenseData['status'] == 0) { ?>

  <div class="license_form_container">
    <h4>
      In order to unlock premium options
      and official support of <?php echo $pluginLicenseData['title'] ?>, you need to activate your copy of the plugin.
    </h4>

    <?php

      if (isset($_GET['bwlverify']) && $_GET['bwlverify'] == "offline") {

        require_once BWL_BAF_PLUGIN_PATH . '/includes/settings/views/tpl_verify_offline.php';
      } else { ?>

    <h3><?php esc_html_e("Add Plugin Purchase Code", "bwl-adv-faq"); ?></h3>
    <form action="#" id="baf_verify_purchase">
      <input type="text" value="" name="purchase_code" id="purchase_code"
        placeholder="<?php esc_html_e("Purchase code", "bwl-adv-faq"); ?>">
      <input type="submit" value="<?php esc_html_e("Active License", "bwl-adv-faq"); ?>" id="verify"
        class="button button-primary">

    </form>

    <p>
      <strong>I have the </strong><a
        href="<?php echo get_admin_url() ?>edit.php?post_type=<?php echo BWL_BAF_CPT; ?>&page=baf-license&bwlverify=offline">offline
        verification code</a>.
    </p>

    <?php } ?>

    <p class="license_form_container__youtube_link" target="_blank">Check this <a href="https://youtu.be/H5TKfT-oWvc"
        title="Learn more about license activation."><span class="dashicons dashicons-youtube"></span>video tutorial</a>
      and learn more about license
      activation. </p>
    <p>
      <strong><?php esc_html_e("Do you need offline verification code or any help?", "bwl-adv-faq"); ?></strong> <a
        href="<?php echo $pluginLicenseData['supportLink']; ?>" target="_blank">
        <?php esc_html_e("Send a message", "bwl-adv-faq"); ?></a>.
    </p>

  </div>

  <?php } elseif ($pluginLicenseData['status'] == 1) { ?>

  <div class="license_info_container">
    <h3><?php esc_html_e("License Information", "bwl-adv-faq"); ?></h3>

    <?php

      $purchaseInfo = $pluginLicenseData['info'];
      $supportRenwalInfo = getRenewalDaysLeft($purchaseInfo['supported_until']);
      $supportRenwalClass = $supportRenwalInfo['status'] == 1 ? "support-valid" : "support-expired";

      ?>

    <ul class="plugin_purchase_info">
      <li><strong><?php esc_html_e("License Type", "bwl-adv-faq"); ?>:</strong>
        <span><?php echo $purchaseInfo['license'] ?></span>
      </li>
      <li><strong><?php esc_html_e("Purchase Date", "bwl-adv-faq"); ?>:</strong>
        <span><?php echo bwlBeautifyDate($purchaseInfo['sold_at']) ?></span>
      </li>
      <li><strong><?php esc_html_e("Support Until", "bwl-adv-faq"); ?>:</strong>
        <span><?php echo bwlBeautifyDate($purchaseInfo['supported_until']) ?></span>
        <span class="<?php echo $supportRenwalClass ?>"><?php echo $supportRenwalInfo['msg']; ?></span>
      </li>
    </ul>

    <button id="baf_remove_license" class="button button-primary"
      data-verify_hash="<?php echo $purchaseInfo['verify_hash'] ?>"><?php esc_html_e("Remove License", "bwl-adv-faq"); ?></button>

    <?php if (getRenewalDaysLeft($purchaseInfo['supported_until'])['status'] == 0) : ?>
    <a href="<?php echo BWL_BAF_CC_URL ?>" class="button button-primary"
      target="_blank"><?php esc_html_e("Renew License", "bwl-adv-faq"); ?></a>
    <?php endif; ?>

  </div>

  <?php

  } else {
    // Do Nothing
  }

  // It will display all the page

  $licenseFaqs = [
    [
      'ques' => "How to download the purchase code?",
      'ans' => "Check <a href=' https://bluewindlab.net/knowledgebase/general/where-i-can-get-the-purchase-code/' target='_blank'>this article</a> for step-by-step instructions."
    ],
    [
      'ques' => "My six-month premium support period has expired. How to extend it?",
      'ans' => "Follow <a href='" . BWL_BAF_CC_URL . "' target='_blank'>this link</a> and click the Renew Support button."
    ],
    [
      'ques' => "I downloaded the plugin from Envato Elements. How can I get the purchase code?",
      'ans' => "Unfortunately, you can not. However, you can use all the features of the plugin without issue. The only exception is that we do not provide customer support if you download the plugin from Envato Elements."
    ],
    [
      'ques' => "Can I get customer support If I download the plugin from Envato Elements?",
      'ans' => "No. To get the author's premium support, please consider purchasing the plugin from <a href='" . BWL_BAF_CC_URL . "' target='_blank'>CodeCanYon</a>."
    ]
  ];


  ?>


  <div class="license_faq_container">
    <h3 class="license_faq_title">License F.A.Q</h3>
    <ul class="license_faqs">

      <?php foreach ($licenseFaqs as $faq) : ?>
      <li>
        <p class="question">
          <?php echo $faq['ques'] ?>
        </p>
        <p class="answer">
          <?php echo $faq['ans'] ?>
        </p>
      </li>
      <?php endforeach; ?>

    </ul>
  </div>

</div>