const ctx = document.getElementById("analyticsChart")

if (ctx) {
  const analyticsData = document.getElementById("analyticsData")

  // Get the values of the data attributes
  const dateGroup = analyticsData.dataset.dategroup
  const totalCounts = analyticsData.dataset.totalcounts
  const label = analyticsData.dataset.filtertype ?? "views"

  const data = {
    labels: dateGroup.split(","),
    datasets: [
      {
        label: label.toUpperCase(),
        // data: [1,2],
        data: totalCounts.split(","),
        borderWidth: 0,
      },
    ],
  }

  new Chart(ctx, {
    type: "bar",
    data: data,
    options: {
      responsive: true,
      plugins: {
        legend: {
          position: "bottom",
        },
        title: {
          display: true,
          // text: "Chart.js Bar Chart",
        },
      },
      scales: {
        y: {
          beginAtZero: true,
        },
      },
    },
  })
}
