;(function ($) {
  $(function () {
    if ($(".bwl_advanced_faq_form").length > 0) {
      // Create Random Number For Captcha.

      function randomNum(maxNum) {
        return Math.floor(Math.random() * maxNum + 1) //return a number between 1 - 10
      }

      /*--  FAQ Submission --*/
      $(".bwl_advanced_faq_form").each(function () {
        // Since: version 1.6.6
        // Check Pre selection status.

        var $this = $(this),
          reset_cat_field = 1

        if ($this.is("[data-sel_cat]")) {
          reset_cat_field = 0
        }

        $this.find("input#title").val("")

        if (reset_cat_field === 1) {
          $this.find("select#cat").val("-1")
        }
      })

      $(".bwl_advanced_faq_form")
        .find("input[type=submit]")
        .on("click", function () {
          var form_submit_button = $(this),
            bwl_advanced_faq_form_id = form_submit_button.attr("bwl_advanced_faq_form_id"),
            form_box_container = $("#" + bwl_advanced_faq_form_id),
            form_field_container = $("#" + bwl_advanced_faq_form_id + " .bwl_advanced_faq_form"),
            reset_cat_field = 1

          if (form_field_container.is("[data-sel_cat]")) {
            reset_cat_field = 0
          }

          var message_box = form_box_container.find(".bwl-faq-form-message-box"),
            title = form_field_container.find("#title"),
            cat = form_field_container.find("#cat"),
            captcha_status = form_field_container.find("#captcha_status")

          if (captcha_status.val() == 1) {
            var num1 = form_field_container.find("#num1")
            var num2 = form_field_container.find("#num2")
            var captcha = form_field_container.find("#captcha")
            var all_fields = $([]).add(title).add(cat).add(captcha)
          } else {
            var all_fields = $([]).add(title).add(cat)
          }

          var bValid = true,
            required_field_msg = "",
            ok_border = "border: 1px solid #EEEEEE",
            error_border = "border: 1px solid #E63F37"

          if ($.trim(title.val()).length < title.data("min_length") || $.trim(title.val()).length > title.data("max_length")) {
            title_bValid = false
            title.attr("style", error_border)
            required_field_msg += " " + title.data("error_msg") + "<br />"
          } else {
            title_bValid = true
            title.attr("style", ok_border)
            required_field_msg += ""
          }

          bValid = bValid && title_bValid

          if ($.trim(cat.val()) == -1) {
            cat_bValid = false
            cat.attr("style", error_border)
            required_field_msg += " " + err_faq_category + "<br />"
          } else {
            cat_bValid = true
            cat.attr("style", ok_border)
            required_field_msg += ""
          }

          bValid = bValid && cat_bValid

          if (captcha_status.val() == 1) {
            if (parseInt($.trim(num1.val())) + parseInt($.trim(num2.val())) != parseInt($.trim(captcha.val()))) {
              captcha_bValid = false
              captcha.attr("style", error_border)
              required_field_msg += " " + err_faq_captcha
            } else {
              captcha_bValid = true
              captcha.attr("style", ok_border)
              required_field_msg += ""
            }

            bValid = bValid && captcha_bValid
          }

          //Alert Message Box For Required Fields.

          if (bValid == false) {
            message_box.html("").addClass("bwl-form-error-box").html(required_field_msg).slideDown("slow")
          }

          if (bValid == true) {
            all_fields.attr("style", ok_border)
            all_fields.addClass("bwl_advanced_faq_disabled_field").attr("disabled", "disabled")
            form_submit_button.addClass("bwl_advanced_faq_disabled_field").attr("disabled", "disabled")
            message_box.html("").removeClass("bwl-form-error-box").addClass("bwl-form-wait-box").html(BafFrontendData.string_please_wait).slideDown("slow")

            $.ajax({
              url: BafFrontendData.ajaxurl,
              type: "POST",
              dataType: "JSON",
              data: {
                action: "bwl_advanced_faq_save_post_data", // action will be the function name,
                title: title.val(),
                cat: cat.val(),
                _baf_form_nonce: form_field_container.find("#_baf_form_nonce").val(),
              },
              success: function (data) {
                if (data.bwl_faq_add_status == 1) {
                  //Reload For New Number.

                  if (captcha_status.val() == 1) {
                    num1.val(randomNum(5))
                    num2.val(randomNum(9))
                  }

                  message_box.removeClass("bwl-form-wait-box").html("").html(BafFrontendData.string_ques_added).addClass("bwl-form-success-box").delay(3000).slideUp("slow")
                  all_fields.val("").removeAttr("disabled").removeClass("bwl_advanced_faq_disabled_field")

                  if (reset_cat_field === 1) {
                    cat.val("-1") //fixed in version 1.6.2 // Update in version 1.6.6
                  }

                  form_submit_button.removeAttr("disabled").removeClass("bwl_advanced_faq_disabled_field")
                } else {
                  message_box.removeClass("bwl-form-wait-box").html("").html(BafFrontendData.string_ques_unable_add).addClass("bwl-form-error-box").delay(3000).slideUp("slow")
                  all_fields.removeAttr("disabled").removeClass("bwl_advanced_faq_disabled_field")
                  form_submit_button.removeAttr("disabled").removeClass("bwl_advanced_faq_disabled_field")
                }
              },
              error: function (xhr, textStatus, e) {
                message_box.removeClass("bwl-form-wait-box").html("").html(BafFrontendData.string_ques_unable_add).addClass("bwl-form-error-box").delay(3000).slideUp("slow")
                all_fields.removeAttr("disabled").removeClass("bwl_advanced_faq_disabled_field")
                form_submit_button.removeAttr("disabled").removeClass("bwl_advanced_faq_disabled_field")
                return
              },
            })
          }

          return false
        })
    }
  })
})(jQuery)
