<?php

 /*------------------------------  Custom Column Section ---------------------------------*/
// After manage text we need to add "custom_post_type" value.

add_filter('manage_posts_columns', 'bkb_custom_column_header' );

 // After manage text we need to add "custom_post_type" value.

add_action('manage_posts_custom_column', 'bkb_display_custom_column', 10, 1);


function bkb_custom_column_header($columns) {

    if (get_post_type() != 'post')
        
        return $columns;

    $columns['cb'] = 'cb';

    $columns['title'] = esc_attr__('KB Title', 'bwl-kb');

    $columns['bkbm_post_views'] = esc_attr__('Views', 'bwl-kb');

    $columns['bkb_like_votes_count'] = esc_attr__('Like', 'bwl-kb');

    $columns['bkb_display_status'] = esc_attr__('Voting Box', 'bwl-kb');

    $columns['bkb_featured_status'] = esc_attr__('Featured', 'bwl-kb');

    return $columns;
}

function bkb_display_custom_column( $column ) {

    // Add A Custom Image Size For Admin Panel.
    
    global $post;
    
    switch ( $column ) { 
            
        case 'bkb_fa_id':

                $bkb_fa_id = ( get_post_meta($post->ID, "bkb_fa_id", true ) == "" ) ? '-' : '<i class="'. get_post_meta($post->ID, "bkb_fa_id", true).'"></i>';  
                echo '<div id="bkbm_post_views-' . $post->ID . '" >'. $bkb_fa_id.'</div>';

        break;    
        
        case 'bkbm_post_views':

                $bkbm_post_views = ( get_post_meta($post->ID, "bkbm_post_views", true ) == "" ) ? 0 : get_post_meta($post->ID, "bkbm_post_views", true);  
                echo '<div id="bkbm_post_views-' . $post->ID . '" >&nbsp;' . $bkbm_post_views . '</div>';

        break;
    
        case 'bkb_featured_status':

                    $bkb_featured_status = ( get_post_meta($post->ID, "bkb_featured_status", true ) == 1 ) ? 1 : 0;
                    
                    if( $bkb_featured_status == 1 ) {
                    
                        $bkb_featured_status_text = esc_attr__('Yes', 'bwl-kb');

                    } else {

                        $bkb_featured_status_text = esc_attr__('No', 'bwl-kb');

                    }

                    echo '<div id="bkb_featured_status-' . $post->ID . '" data-status_code="'.$bkb_featured_status.'">' . $bkb_featured_status_text . '</div>';
                    

        break;
    
        case 'bkb_like_votes_count':

                $like_vote_counter = ( get_post_meta($post->ID, "bkb_like_votes_count", true ) == "" ) ? 0 : get_post_meta($post->ID, "bkb_like_votes_count", true);  
                echo '<div id="bkb_like_votes_count-' . $post->ID . '" >&nbsp;' . $like_vote_counter . '</div>';

        break;
    
        case 'bkb_dislike_votes_count':
        
                $dislike_vote_counter = ( get_post_meta($post->ID, "bkb_dislike_votes_count", true ) == "" ) ? 0 : get_post_meta($post->ID, "bkb_dislike_votes_count", true);  
                echo '<div id="bkb_dislike_votes_count-' . $post->ID . '">&nbsp;' . $dislike_vote_counter . '</div>';
            
        break;
    
        case 'bkb_display_status':
        
                $bkb_display_status = ( get_post_meta($post->ID, "bkb_display_status", true ) == "" ) ? 1 : get_post_meta($post->ID, "bkb_display_status", true);  
                
                if( $bkb_display_status == 2 ) {
                    
                    $bkb_display_status_text = esc_attr__('Closed', 'bwl-kb');
                    
                } else if( $bkb_display_status == 1 ) {
                    
                    $bkb_display_status_text = esc_attr__('Show', 'bwl-kb');
                    
                } else {
                    
                    $bkb_display_status_text = esc_attr__('Hidden', 'bwl-kb');
                    
                }
            
                echo '<div id="bkb_display_status-' . $post->ID . '" data-status_code="'.$bkb_display_status.'">' . $bkb_display_status_text . '</div>';
            
        break;
    
        case 'bkb_feedback':
        
                $bkb_feedback_message_unique_id = 'bkb_feedback_list_'.$post->ID; // so idea is we are going to add post id after vairable name
         
                $prev_bkb_feedback_message = get_post_meta( $post->ID, $bkb_feedback_message_unique_id );
        
                
                if( isset($prev_bkb_feedback_message[0]) ) {
                
                   $prev_bkb_feedback_message_counter = sizeof($prev_bkb_feedback_message[0]);
                
                } else {
                    
                   $prev_bkb_feedback_message_counter = 0; 
                    
                }
//                
                echo '<div id="bkb_dislike_votes_count-' . $post->ID . '" class="bkb_alignment">' . $prev_bkb_feedback_message_counter . '</div>';
            
        break;
        
            
    }
    
}


/*-----------------------------Make Column Sortable ----------------------------------*/

add_filter( 'manage_edit_sortable_columns', 'bkb_sortable_column' );

function bkb_sortable_column( $columns ) {
    $columns['bkbm_post_views'] = 'bkbm_post_views';
    $columns['bkb_like_votes_count'] = 'bkb_like_votes_count';
    $columns['bkb_dislike_votes_count'] = 'bkb_dislike_votes_count';
 
    //To make a column 'un-sortable' remove it from the array
    //unset($columns['date']);
 
    return $columns;
}

add_action( 'pre_get_posts', 'bkb_manage_wp_posts_order', 1 );

function bkb_manage_wp_posts_order( $query ) {
        
   if ( is_admin() && $query->is_main_query() && ( $orderby = $query->get( 'orderby' ) ) ) {

      switch( $orderby ) {
        
         case 'bkbm_post_views':
            $query->set( 'meta_key', 'bkbm_post_views' );
            $query->set( 'orderby', 'meta_value_num' );
            break;
        
         case 'bkb_like_votes_count':
            $query->set( 'meta_key', 'bkb_like_votes_count' );
            $query->set( 'orderby', 'meta_value_num' );
            break;
        
         case 'bkb_dislike_votes_count':
            $query->set( 'meta_key', 'bkb_dislike_votes_count' );
            $query->set( 'orderby', 'meta_value_num' );
            break;

      }

   }

}