<?php

if (!function_exists('bkb_custom_theme')) {

    function bkb_custom_theme()
    {

        /*------------------------------  Default Settings ---------------------------------*/

        $bkb_like_bar_color = '#559900';
        $bkb_dislike_bar_color = '#C9231A';
        $bkb_like_thumb_color = '#559900';
        $bkb_dislike_bar_color = '#C9231A';

        global $bkb_data;

        $custom_theme = '<style type="text/css">';

        // Like Bar Color.

        if (isset($bkb_data['bkb_like_bar_color']) && $bkb_data['bkb_like_bar_color'] != "") {

            $bkb_like_bar_color = $bkb_data['bkb_like_bar_color'];
            $custom_theme .= '.bkb_container .bg-green{ background-color: ' . $bkb_like_bar_color . ';}';
        }

        // Dislike Bar Color.

        if (isset($bkb_data['bkb_dislike_bar_color']) && $bkb_data['bkb_dislike_bar_color'] != "") {
            $bkb_dislike_bar_color = $bkb_data['bkb_dislike_bar_color'];
            $custom_theme .= '.bkb_container .bg-red{ background-color: ' . $bkb_dislike_bar_color . ';}';
        }

        // Like Button Thumb Color.

        if (isset($bkb_data['bkb_like_thumb_color']) && $bkb_data['bkb_like_thumb_color'] != "") {

            $bkb_like_thumb_color = $bkb_data['bkb_like_thumb_color'];
            $custom_theme .= '.bkb_container .btn_like{ color: ' . $bkb_like_thumb_color . ';}';
            $custom_theme .= '.bkb_icon_like_color{ color: ' . $bkb_like_thumb_color . ';}';
        }

        // Dislike Button Text Color.

        if (isset($bkb_data['bkb_dislike_thumb_color']) && $bkb_data['bkb_dislike_thumb_color'] != "") {
            $bkb_dislike_thumb_color = $bkb_data['bkb_dislike_thumb_color'];
            $custom_theme .= '.bkb_container .btn_dislike{ color: ' . $bkb_dislike_thumb_color . ';}';
            $custom_theme .= '.bkb_icon_dislike_color{ color: ' . $bkb_dislike_thumb_color . ';}';
        }


        /*------------------------------ Tipsy ---------------------------------*/

        $bkb_tipsy_bg = "#000000";
        $bkb_tipsy_text_color = "#FFFFFF";

        if (isset($bkb_data['bkb_tipsy_bg']) && $bkb_data['bkb_tipsy_bg'] != "") {
            $bkb_tipsy_bg = $bkb_data['bkb_tipsy_bg'];
        }

        if (isset($bkb_data['bkb_tipsy_text_color']) && $bkb_data['bkb_tipsy_text_color'] != "") {
            $bkb_tipsy_text_color = $bkb_data['bkb_tipsy_text_color'];
        }

        $custom_theme .= '.tipsy-inner{ background: ' . $bkb_tipsy_bg . '; color: ' . $bkb_tipsy_text_color . ';}';




        /*------------------------------ Search Theming ---------------------------------*/

        $bkb_search_results_background = "#2C2C2C";
        $bkb_search_results_color = "#FFFFFF";


        if (isset($bkb_data['bkb_search_results_background']) && $bkb_data['bkb_search_results_background'] != "") {
            $bkb_search_results_background = $bkb_data['bkb_search_results_background'];
        }

        if (isset($bkb_data['bkb_search_results_color']) && $bkb_data['bkb_search_results_color'] != "") {
            $bkb_search_results_color = $bkb_data['bkb_search_results_color'];
        }

        $custom_theme .= 'div.suggestionsBox{ background: ' . $bkb_search_results_background . ';}';
        $custom_theme .= 'div.suggestionList ul li{color: ' . $bkb_search_results_color . ' !important;}';
        $custom_theme .= 'div.suggestionList ul li a{color: ' . $bkb_search_results_color . ' !important;}';
        $custom_theme .= 'div.suggestionList:before{  border-bottom: 7px solid ' . $bkb_search_results_background . ' !important;}';

        /*------------------------------ RTL Support For Search Section ---------------------------------*/

        //        if( isset( $bkb_data['bkb_rtrl_support'] ) && $bkb_data['bkb_rtrl_support'] == 1 ) {

        if (is_rtl()) {

            //Write all custom codes for RTL in here.
            $custom_theme .= 'span.bkbm-btn-clear{ left: 3px;}';
        } else {

            $custom_theme .= 'span.bkbm-btn-clear{ right: 3px;}';
        }

        /*------------------------------ KB List Heading Color  ---------------------------------*/

        $bkb_heading_link_color = "#0074A2";
        $bkb_heading_link_hover_color = "#004F6C";

        if (isset($bkb_data['bkb_heading_link_color']) && $bkb_data['bkb_heading_link_color'] != "") {
            $bkb_heading_link_color = $bkb_data['bkb_heading_link_color'];
        }

        if (isset($bkb_data['bkb_heading_link_hover_color']) && $bkb_data['bkb_heading_link_hover_color'] != "") {
            $bkb_heading_link_hover_color = $bkb_data['bkb_heading_link_hover_color'];
        }

        $custom_theme .= 'h2.bkb-box-style-category-title, span.bkb-icon-container, h2.bwl-kb-category-title a{ color: ' . $bkb_heading_link_color . ' !important;}';
        $custom_theme .= 'div.bkb-box-layout a:hover h2.bkb-box-style-category-title, div.bkb-box-layout a:hover span.bkb-icon-container, h2.bwl-kb-category-title a:hover{ color: ' . $bkb_heading_link_hover_color . '!important;}';


        /*------------------------------ KB Accordion Listing Color  ---------------------------------*/

        $bkb_acc_icon_bg = "#00D793";
        $bkb_acc_icon_color = "#FFFFFF";
        $bkb_acc_content_border_color = "#EEEEEE";
        $bkb_acc_active_icon_bg = "#00D793";

        $bkb_acc_content_bg_color = "#FFFFFF";
        $bkb_acc_icon_border_color = "#EEEEEE";

        if (isset($bkb_data['bkb_acc_icon_bg']) && $bkb_data['bkb_acc_icon_bg'] != "") {

            $bkb_acc_icon_bg = $bkb_data['bkb_acc_icon_bg'];
        }

        if (isset($bkb_data['bkb_acc_icon_color']) && $bkb_data['bkb_acc_icon_color'] != "") {
            $bkb_acc_icon_color = $bkb_data['bkb_acc_icon_color'];
        }

        if (isset($bkb_data['bkb_acc_content_border_color']) && $bkb_data['bkb_acc_content_border_color'] != "") {
            $bkb_acc_content_border_color = $bkb_data['bkb_acc_content_border_color'];
        }

        if (isset($bkb_data['bkb_acc_content_bg_color']) && $bkb_data['bkb_acc_content_bg_color'] != "") {
            $bkb_acc_content_bg_color = $bkb_data['bkb_acc_content_bg_color'];
        }

        if (isset($bkb_data['bkb_acc_icon_border_color']) && $bkb_data['bkb_acc_icon_border_color'] != "") {
            $bkb_acc_icon_border_color = $bkb_data['bkb_acc_icon_border_color'];
        }

        if (isset($bkb_data['bkb_acc_active_icon_bg']) && $bkb_data['bkb_acc_active_icon_bg'] != "") {
            $bkb_acc_active_icon_bg = $bkb_data['bkb_acc_active_icon_bg'];
        }

        $custom_theme .= '.smk_accordion .accordion_in .acc_head .acc_icon_expand { background: ' . $bkb_acc_icon_bg . ' !important; border-color: ' . $bkb_acc_icon_border_color . ' !important;}';
        $custom_theme .= '.smk_accordion .accordion_in.acc_active > .acc_head .acc_icon_expand { background: ' . $bkb_acc_active_icon_bg . ' !important; border-color: ' . $bkb_acc_active_icon_bg . ' !important;}';
        $custom_theme .= '.smk_accordion .accordion_in .acc_head .acc_icon_expand:after { color: ' . $bkb_acc_icon_color . ' !important;}';
        $custom_theme .= '.smk_accordion .accordion_in .acc_content { background: ' . $bkb_acc_content_bg_color . ' !important; }';
        $custom_theme .= '.smk_accordion .accordion_in {border-color: ' . $bkb_acc_content_border_color . ' !important;}';


        /*-----  Carousel Settings ----*/

        $bkb_carousel_theme = "#13B4EF";

        if (isset($bkb_data['bkb_carousel_theme']) && $bkb_data['bkb_carousel_theme'] != "") {

            $bkb_carousel_theme = $bkb_data['bkb_carousel_theme'];

            $custom_theme .= '.bkbm-carousel .owl-nav .owl-prev, .bkbm-carousel .owl-nav .owl-next {color: ' . $bkb_carousel_theme . ' !important;}';
            $custom_theme .= '.bkbm-carousel .owl-dots .active span {background: ' . $bkb_carousel_theme . ' !important;}';
        }

        /*------------------------------ bkb Taxonomy Description Color ---------------------------------*/

        $bkb_category_description_color = "#525252";

        if (isset($bkb_data['bkb_category_description_color']) && $bkb_data['bkb_category_description_color'] != "") {
            $bkb_category_description_color = $bkb_data['bkb_category_description_color'];
        }

        $custom_theme .= 'p.bkb-category-description{ color: ' . $bkb_category_description_color . ' !important;}';


        /*---------------------------- List Layout Theme Settings.-----------------------------------*/

        $bkb_list_text_color = "#2C2C2C";
        $bkb_list_bg = "#EBEBEB";

        $bkb_list_hover_text_color = "#5C5C5C";
        $bkb_list_hover_bg = "#DDDDDD";

        if (isset($bkb_data['bkb_list_text_color']) && $bkb_data['bkb_list_text_color'] != "") {
            $bkb_list_text_color = $bkb_data['bkb_list_text_color'];
        }

        if (isset($bkb_data['bkb_list_bg']) && $bkb_data['bkb_list_bg'] != "") {
            $bkb_list_bg = $bkb_data['bkb_list_bg'];
        }

        if (isset($bkb_data['bkb_list_hover_text_color']) && $bkb_data['bkb_list_hover_text_color'] != "") {
            $bkb_list_hover_text_color = $bkb_data['bkb_list_hover_text_color'];
        }

        if (isset($bkb_data['bkb_list_hover_bg']) && $bkb_data['bkb_list_hover_bg'] != "") {
            $bkb_list_hover_bg = $bkb_data['bkb_list_hover_bg'];
        }

        // Rounded Style.
        // Fixed in version 1.1.2
        $custom_theme .= '.rounded-list li a, .rounded-list li a:before, .rounded-list li a:visited{ background: ' . $bkb_list_bg . '; color: ' . $bkb_list_text_color . ';}';
        $custom_theme .= '.rounded-list li a:before, .rounded-list li a:hover{ background: ' . $bkb_list_hover_bg . '; color: ' . $bkb_list_hover_text_color . ';}';

        // Rectangle Style.
        // Fixed in version 1.1.2
        $custom_theme .= '.rectangle-list li a, .rectangle-list li a:before, .rectangle-list li a:visited{ background: ' . $bkb_list_bg . '; color: ' . $bkb_list_text_color . ';}';
        $custom_theme .= '.rectangle-list li a:before, .rectangle-list li a:hover{ background: ' . $bkb_list_hover_bg . '; color: ' . $bkb_list_hover_text_color . ';}';

        // Iconized Style.
        $custom_theme .= '.iconized-list li a{ color: ' . $bkb_list_text_color . ' !important;}';
        $custom_theme .= '.iconized-list li a:hover{ color: ' . $bkb_list_hover_text_color . ' !important;}';

        // No Style.
        $custom_theme .= '.none-list li a{ color: ' . $bkb_list_text_color . ' !important;}';
        $custom_theme .= '.none-list li a:hover{ color: ' . $bkb_list_hover_text_color . ' !important;}';


        /*---------------------------- Box Layout Text & Background -----------------------------------*/

        $bkb_rounded_box_bg = "#FAFAFA";
        $bkb_rounded_box_text_color = "#2C2C2C";

        $bkb_rounded_box_border = "#CDCDCD";
        $bkb_rounded_box_hover_bg = "#EEEEEE";
        $bkb_rounded_box_view_all_bg = "#F9F9F9";


        if (isset($bkb_data['bkb_rounded_box_text_color']) && $bkb_data['bkb_rounded_box_text_color'] != "") {
            $bkb_rounded_box_text_color = $bkb_data['bkb_rounded_box_text_color'];
        }

        if (isset($bkb_data['bkb_rounded_box_bg']) && $bkb_data['bkb_rounded_box_bg'] != "") {
            $bkb_rounded_box_bg = $bkb_data['bkb_rounded_box_bg'];
        }

        if (isset($bkb_data['bkb_rounded_box_border']) && $bkb_data['bkb_rounded_box_border'] != "") {
            $bkb_rounded_box_border = $bkb_data['bkb_rounded_box_border'];
        }

        if (isset($bkb_data['bkb_rounded_box_hover_bg']) && $bkb_data['bkb_rounded_box_hover_bg'] != "") {
            $bkb_rounded_box_hover_bg = $bkb_data['bkb_rounded_box_hover_bg'];
        }

        if (isset($bkb_data['bkb_rounded_box_view_all_bg']) && $bkb_data['bkb_rounded_box_view_all_bg'] != "") {
            $bkb_rounded_box_view_all_bg = $bkb_data['bkb_rounded_box_view_all_bg'];
        }

        $custom_theme .= 'div.bkb-box-layout{ background: ' . $bkb_rounded_box_bg . '; border-color: ' . $bkb_rounded_box_border . ' !important;}';
        $custom_theme .= 'div.bkb-box-layout p.bkb-category-description{ color: ' . $bkb_rounded_box_text_color . ' !important;}';
        $custom_theme .= 'div.bkb-box-layout:hover{ background: ' . $bkb_rounded_box_bg . '; border-color: ' . $bkb_rounded_box_border . ' !important;}';
        $custom_theme .= '.bkb-category-view-all-box{background: ' . $bkb_rounded_box_view_all_bg . ' !important;}';

        // Custom heading separator in boxed view layout.

        if (!isset($bkb_data['bkb_box_heading_separator_status']) || $bkb_data['bkb_box_heading_separator_status'] != 1) {

            $custom_theme .= 'h2.bkb-box-style-category-title:after {background: ' . $bkb_heading_link_color . ' !important; bottom: -25px !important; content: ""; height: 2px; left: 0; margin: 10px auto; position: absolute; width: 20px; -webkit-transition: all .5s ease-out; -moz-transition: all .5s ease-out; -ms-transition: all .5s ease-out; -o-transition: all .5s ease-out; transition: all .5s ease-out;}';
            $custom_theme .= 'div.bkb-box-layout a:hover h2.bkb-box-style-category-title:after {background: ' . $bkb_heading_link_hover_color . ' !important;}';
        }

        /*------------------------------Tab Border Settings ---------------------------------*/



        $bkb_tab_container_bg = (isset($bkb_data['bkb_tab_container_bg']) && $bkb_data['bkb_tab_container_bg'] != "") ? $bkb_data['bkb_tab_container_bg'] : "#FAFAFA";
        $bkb_tab_container_border = (isset($bkb_data['bkb_tab_container_border']) && $bkb_data['bkb_tab_container_border'] != "") ? $bkb_data['bkb_tab_container_border'] : "#CCCCCC";

        //Container & Active Tab BG
        $custom_theme .= '.bkb-content-wrapper, bwl-kb-content-wrapper-ver { background: ' . $bkb_tab_container_bg . ' !important; border-color: ' . $bkb_tab_container_border . ' !important;}';
        $custom_theme .= '.bkb-wrapper ul.bkb-tabs li.active a{ background: ' . $bkb_tab_container_bg . ' !important; border-color: ' . $bkb_tab_container_border . ' !important;}';

        //Full Container Border.



        //Active Tab Border Color
        $bkb_tab_border_color = (isset($bkb_data['bkb_tab_border_color']) && $bkb_data['bkb_tab_border_color'] != "") ? $bkb_data['bkb_tab_border_color'] : "#2C2C2C";
        $custom_theme .= '.bkb-wrapper ul.bkb-tabs li.active { border-color: ' . $bkb_tab_border_color . ' !important;}';
        $custom_theme .= '.bkb-wrapper ul.bwl-kb-tabs-ver{ border-color: ' . $bkb_tab_container_border . ' !important;}';
        $custom_theme .= '.bkb-wrapper ul.bwl-kb-tabs-ver li.active a{ border-color: ' . $bkb_tab_border_color . ' !important;}';


        /*------------------------------Table of Content Settings ---------------------------------*/

        $bkb_toc_bg = "#FBFBFB";
        $bkb_toc_link_color = "#0074A2";
        $bkb_toc_link_hover_color = "#004F6C";

        if (isset($bkb_data['bkb_toc_bg']) && $bkb_data['bkb_toc_bg'] != "") {
            $bkb_toc_bg = $bkb_data['bkb_toc_bg'];
        }
        if (isset($bkb_data['bkb_toc_link_color']) && $bkb_data['bkb_toc_link_color'] != "") {
            $bkb_toc_link_color = $bkb_data['bkb_toc_link_color'];
        }
        if (isset($bkb_data['bkb_toc_link_hover_color']) && $bkb_data['bkb_toc_link_hover_color'] != "") {
            $bkb_toc_link_hover_color = $bkb_data['bkb_toc_link_hover_color'];
        }

        $custom_theme .= '.bkb_toc_wrapper{ background: ' . $bkb_toc_bg . ' !important;}';
        $custom_theme .= '.bkb-toc-top i, .bkb_toc_wrapper ol li a { color: ' . $bkb_toc_link_color . ' !important;}';
        $custom_theme .= '.bkb-toc-top:hover i, .bkb_toc_wrapper ol li a:hover { color: ' . $bkb_toc_link_hover_color . ' !important;}';

        /*------------------------------  Boxed Style Layout ---------------------------------*/



        /*------------------------------ Taxonomy Icon Styling  ---------------------------------*/

        $bkb_box_view_icon_size = '32';

        if (isset($bkb_data['bkb_box_view_icon_size']) && $bkb_data['bkb_box_view_icon_size'] != "") {
            $bkb_box_view_icon_size = $bkb_data['bkb_box_view_icon_size'];

            $custom_theme .= 'div.bkb-box-layout a span.bkb-icon-container { font-size: ' . $bkb_box_view_icon_size . 'px !important;}';
        }

        /*------------------------------ Taxonomy Images Styling  ---------------------------------*/


        $bkb_list_view_thumb_size = "16";
        $bkb_list_view_thumb_width = "16px";
        $bkb_list_view_thumb_height = "16px";

        if (isset($bkb_data['bkb_list_view_thumb_size']) && $bkb_data['bkb_list_view_thumb_size'] != "") {
            $bkb_list_view_thumb_size = bkb_get_custom_taxonomy_img_size($bkb_data['bkb_list_view_thumb_size']);

            $bkb_list_view_thumb_width = $bkb_list_view_thumb_size['width'];
            $bkb_list_view_thumb_height = $bkb_list_view_thumb_size['height'];
        }

        $custom_theme .= '.bkb_taxonomy_img_lists { width: ' . $bkb_list_view_thumb_width . '; height: ' . $bkb_list_view_thumb_width . ';}';

        $bkb_box_view_thumb_size = "64";
        $bkb_box_view_thumb_width = "64px";
        $bkb_box_view_thumb_height = "64px";

        if (isset($bkb_data['bkb_box_view_thumb_size']) && $bkb_data['bkb_box_view_thumb_size'] != "") {
            $bkb_box_view_thumb_size = bkb_get_custom_taxonomy_img_size($bkb_data['bkb_box_view_thumb_size']);

            $bkb_box_view_thumb_width = $bkb_box_view_thumb_size['width'];
            $bkb_box_view_thumb_height = $bkb_box_view_thumb_size['height'];
        }

        $custom_theme .= '.bkb_taxonomy_img_box { width: ' . $bkb_box_view_thumb_width . '; height: ' . $bkb_box_view_thumb_height . ';}';


        // Template Part.
        // @Templify KB

        if (class_exists('BKBM_Template_Manager')) {


            // Setting Widget Title Font Size.

            if (isset($bkb_data['bkb_tpl_widget_heading_font_size']) && $bkb_data['bkb_tpl_widget_heading_font_size'] != "") {


                $custom_theme .= 'aside.bkb-custom-sidebar .widget-title{ font-size: ' . $bkb_data['bkb_tpl_widget_heading_font_size'] . ' !important; }';
            }


            // Adding Custom Padding For Content & Widget Layout.

            if (isset($bkb_data['bkb_tpl_content_padding']) && $bkb_data['bkb_tpl_content_padding'] != "") {

                $custom_theme .= '.bkb-tpl-content-pad{ padding: ' . $bkb_data['bkb_tpl_content_padding'] . ' !important; }';
            }

            if (isset($bkb_data['bkb_tpl_sidebar_padding']) && $bkb_data['bkb_tpl_sidebar_padding'] != "") {

                $custom_theme .= '.bkb-tpl-sidebar-pad{ padding: ' . $bkb_data['bkb_tpl_sidebar_padding'] . ' !important; }';
            }

            // Adding Custom Margin On Content & Widget Layout.

            if (isset($bkb_data['bkb_tpl_layout_margin']) && $bkb_data['bkb_tpl_content_padding'] != "") {

                $custom_theme .= '.bkb_tpl_custom_margin{ margin-top: ' . $bkb_data['bkb_tpl_layout_margin'] . ' !important; }';
            }

            // Adding Custom Padding On Template Content & Widget Layout.

            $custom_theme .= '@media only screen and (min-width: 0px) and (max-width: 479px) {';
            $custom_theme .= '.bkb_tpl_custom_margin{ margin-top: 5px !important; }';
            $custom_theme .= '.bkb-tpl-content-pad{ padding: 0 12px !important; }';
            $custom_theme .= '.bkb-tpl-sidebar-pad{ padding: 0 12px !important; }';
            $custom_theme .= '}';

            $custom_theme .= '@media only screen and (min-width: 480px) and (max-width: 1000px) {';
            $custom_theme .= '.bkb-tpl-content-pad{ padding: 0 12px !important; }';
            $custom_theme .= '.bkb-tpl-sidebar-pad{ padding: 0 12px !important; }';
            $custom_theme .= '}';
        }


        /*---------------------------- Custom CSS -----------------------------------*/

        $bkb_custom_css = "";

        if (isset($bkb_data['bkb_custom_css']) && $bkb_data['bkb_custom_css'] != "") {
            $bkb_custom_css = $bkb_data['bkb_custom_css'];
        }

        $custom_theme .= $bkb_custom_css;

        $custom_theme .= '</style>';

        echo $custom_theme;
    }


    add_action('wp_head', 'bkb_custom_theme');
}