<?php

//Integrate sorting section in Menu//

add_action('admin_menu', 'bkb_sort_page_add');

function bkb_sort_page_add()
{

    $bkb_sort_menu_link = (defined('BWL_KB_OPT_MENU') && BWL_KB_OPT_MENU == "") ? 'edit.php' : 'edit.php?post_type=' . BWL_KB_OPT_MENU;

    add_submenu_page(
        $bkb_sort_menu_link,
        esc_attr__('KB Sort', 'bwl-kb'),
        esc_attr__('KB Sort', 'bwl-kb'),
        'activate_plugins',
        'bkb_sort',
        'bkb_sort_page'
    );
}

function bkb_sort_page()
{

    $sort_filter = "";

    if (isset($_GET['sort_filter']) && trim($_GET['sort_filter']) == "tags") {

        $bkb_filter_page = "tags";
        $bkb_filter_page_title = esc_attr__('KB Sorting By Topics', 'bwl-kb');
    } else {

        // Default category wise sorting.

        $bkb_filter_page = "category";
        $bkb_filter_page_title = esc_attr__('KB Sorting By Category', 'bwl-kb');
    }

    $bkb_filter_page_subtitle = esc_attr__('Sorting KB posts using Drag & Drop. Items at the top will be appear in first.', 'bwl-kb');



?>
<div class="wrap" id="bkb_sorting_container">

  <div id="icon-edit-pages" class="icon32 icon32-posts-page"><br /></div>

  <h2><?php echo $bkb_filter_page_title; ?></h2>

  <?php
        include_once 'part-sort-menu.php';
        ?>

  <p id="sort-status" data-sort_subtitle="<?php echo $bkb_filter_page_subtitle; ?>">
    <?php echo $bkb_filter_page_subtitle; ?></p>

  <div class="bkb-sort-container">

    <?php


            if ($bkb_filter_page == 'tags') :

                include_once 'part-tags-kb-sort.php';

            else :

                include_once 'part-categories-kb-sort.php';

            endif;

            ?>

    <input type="button" value="Save" class="button button-primary" id="bkb_save_sorting" name="bkb_save_sorting"
      data-sort_filter="<?php echo $bkb_filter_page; ?>">

  </div> <!-- end .bkb-sort-container  -->

</div> <!--  end .wrap  -->

<?php


}



function bkb_get_sorting_data()
{


    $bkb_sort_filter = $_POST['bkb_sort_filter']; // get category slug.
    $bkb_category = $_POST['bkb_category_slug']; // get category slug.
    $bkb_term_id = $_POST['bkb_term_id']; // get category id
    $post_type = BWL_KB_CPT;

    $args = array(
        'post_status'       => 'publish',
        'post_type'         => $post_type,
        'posts_per_page' => -1
    );

    if ($bkb_sort_filter == "tags") {

        $bkb_sort_prefix = PREFIX_BKB_TAG;
        $taxonomy = BWL_KB_TAX_TAG;
    } else {

        $bkb_sort_prefix = PREFIX_BKB_CAT;
        $taxonomy = BWL_KB_TAX_CAT;
    }

    $args['tax_query']  = array(                     //(array) - use taxonomy parameters (available with Version 3.1).
        'relation' => 'AND',                      //(string) - Possible values are 'AND' or 'OR' and is the equivalent of ruuning a JOIN for each taxonomy
        array(
            'taxonomy' => $taxonomy,                //(string) - Taxonomy.
            'field' => 'slug',                    //(string) - Select taxonomy term by ('id' or 'slug')
            'terms' => $bkb_category,    //(int/string/array) - Taxonomy term(s).
            'include_children' => 0,           //(bool) - Whether or not to include children for hierarchical taxonomies. Defaults to true.
            'operator' => 'IN'                    //(string) - Operator to test. Possible values are 'IN', 'NOT IN', 'AND'.
        )
    );


    $loop = new WP_Query($args);

    $bkb_cat_all_posts_id = array();

    $output = "";

    if ($loop->have_posts()) :

        while ($loop->have_posts()) :

            $loop->the_post();

            $bkb_cat_all_posts_id[] = get_the_ID();

        endwhile;

    endif;

    wp_reset_query();

    $bkb_cat_sorted_posts_id = explode(',', get_option($bkb_sort_prefix . $bkb_term_id)); // call db for post meta.

    if (sizeof($bkb_cat_sorted_posts_id) == 0) {
        $bkb_cat_sorted_posts_id = array();
    }

    $bkb_cat_final_sorted_posts_id = array_values(array_unique(array_merge($bkb_cat_sorted_posts_id, $bkb_cat_all_posts_id)));

    $args = array(
        'post_status'       => 'publish',
        'post__in'            => $bkb_cat_final_sorted_posts_id,
        'post_type'         => $post_type,
        'orderby'             => 'post__in',
        'posts_per_page' => -1
    );

    if ($bkb_sort_filter == "tags") {

        $args[BWL_KB_TAX_TAG] = $bkb_category;
    } else {

        $args[BWL_KB_TAX_CAT] = $bkb_category;
    }

    $query = new WP_Query($args);

    $post_data = array();

    if ($query->have_posts()) : while ($query->have_posts()) : $query->the_post();

            $post_data['status'] = 1;
            $post_data['data'][] = array(
                'post_id' => get_the_ID(),
                'post_title' => get_the_title()
            );

        endwhile;

    else :
        $post_data['status'] = 0;
    endif;

    wp_reset_query();

    echo json_encode($post_data);

    die();
}

add_action('wp_ajax_bkb_get_sorting_data', 'bkb_get_sorting_data');

add_action('wp_ajax_nopriv_bkb_get_sorting_data', 'bkb_get_sorting_data');


function bkb_apply_sort()
{

    global $wpdb;

    $bkb_sort_filter_type = $_POST['bkb_sort_filter_type'];
    $bkb_sort_data = trim($_POST['bkb_sort_data']);
    $bkb_term_id = trim($_POST['bkb_term_id']);

    if ($bkb_sort_filter_type == "category") {

        update_option(PREFIX_BKB_CAT . $bkb_term_id, $bkb_sort_data);
    } else  if ($bkb_sort_filter_type == "tags") {

        $bkb_topics_unique_option_id = PREFIX_BKB_TAG . $bkb_term_id;
        update_option($bkb_topics_unique_option_id, $bkb_sort_data);
    } else if ($bkb_sort_filter_type == "all") {

        // Save All Sorting Data (menu_order)

        $order = explode(',', $bkb_sort_data);
        $counter = 0;

        foreach ($order as $bkb_id) {

            $wpdb->update($wpdb->posts, array('menu_order' => $counter), array('ID' => $bkb_id));
            $counter++;
        }
    } else {
        // Do nothing.
    }

    $post_data['status'] = 1;

    wp_reset_query();

    echo json_encode($post_data);

    die();
}

add_action('wp_ajax_bkb_apply_sort', 'bkb_apply_sort');

add_action('wp_ajax_nopriv_bkb_apply_sort', 'bkb_apply_sort');


function bkb_custom_admin_js()
{

    $output = '<script type="text/javascript">';
    $output .= ' var bkb_text_loading = "' . esc_attr__('Loading .....', 'bwl-kb') . '";';
    $output .= ' var bkb_text_saved = "' . esc_attr__('Saved', 'bwl-kb') . '";';
    $output .= '</script>';

    echo $output;
}

add_action('admin_head', 'bkb_custom_admin_js');