<?php


function bkb_welcome()
{

    require_once 'views/plugin_info.php';
}

function bkb_addons()
{

    require_once 'views/addons.php';
}

/**
 * Add the welcome page to the admin menu
 */
function bkb_welcome_submenu()
{

    $bkb_options_menu_link = (defined('BWL_KB_OPT_MENU') && BWL_KB_OPT_MENU == "") ? 'edit.php' : 'edit.php?post_type=' . BWL_KB_OPT_MENU;


    $sub_pages = [
        [

            'page_title' => esc_attr__('About BWL Knowledge Base Manager WordPress Plugin', 'bwl-kb'),
            'menu_title' => esc_attr__('Plugin Info', 'bwl-kb'),
            'menu_slug' => 'bkb-welcome',
            'cb' => 'bkb_welcome'
        ],

        [

            'page_title' => esc_attr__('BWL Knowledge Base Manager Addons', 'bwl-kb'),
            'menu_title' => esc_attr__('Plugin Addons', 'bwl-kb'),
            'menu_slug' => 'bkb-addons',
            'cb' => 'bkb_addons'
        ]


    ];

    foreach ($sub_pages as $sub_page) {
        add_submenu_page(
            $bkb_options_menu_link,
            $sub_page['page_title'],
            $sub_page['menu_title'],
            'manage_options',
            $sub_page['menu_slug'],
            $sub_page['cb']
        );
    }
}

add_action('admin_menu', 'bkb_welcome_submenu');