<?php

add_shortcode('bkb_ques_form', 'bkb_ques_front_end_form');

function bkb_ques_front_end_form($atts)
{

    $atts = shortcode_atts(array(
        'form_heading' => '',
        'inline' => 0,
        'layout' => '', // layout_2 value will hide all the label of form field and display instruction in placeholder .
        'animation' => '',
        'cont_ext_class' => ''

    ), $atts);

    extract($atts);

    global $bkb_data;

    $captcha_status = 1;

    if (isset($bkb_data['bkb_ques_captcha_status'])) {

        $captcha_status = $bkb_data['bkb_ques_captcha_status'];
    }

    $login_required = FALSE; // Default we required logged in to post a new KB.


    if (isset($bkb_data['bkb_login_status'])) {

        if ($bkb_data['bkb_login_status'] == 1) {

            if (is_user_logged_in()) {

                $login_required = FALSE;
            }
        } else {

            $login_required = FALSE;
        }
    }


    if ($login_required == FALSE) :

        /*--  Start Loading Question Form Scripts --*/

        wp_enqueue_script('bkb-ques-form-script');

        /*-- End Loading Question Form Scripts  --*/

        // Question Input Text.
        // Added in version 1.1.9

        if ($layout == 'layout_2') {

            $bkbm_label_title_text = '';
            $bkbm_placeholder_title_text = esc_attr__('Question Title ', 'bwl-kb');
        } else {

            $bkbm_label_title_text = '<label for="title">' . esc_attr__('Question Title: ', 'bwl-kb') . '</label>';
            $bkbm_placeholder_title_text = '';
        }

        // Question Category.
        // Added in version 1.1.9

        if ($layout == 'layout_2') {

            $bkbm_label_category_text = '';
        } else {

            $bkbm_label_category_text = '<label for="cat">' . esc_attr__('Category:', 'bwl-kb') . '</label>';
        }

        // Question Captcha.
        // Added in version 1.1.9

        if ($layout == 'layout_2') {

            $bkbm_label_captcha_text = '';
        } else {

            $bkbm_label_captcha_text = '<label for="captcha">' . esc_attr__('Captcha:', 'bwl-kb') . '</label>';
        }

        // Post Type Checking.
        $bkb_post_type = BWL_KB_CPT;
        $bkb_cat_taxonomy = BWL_KB_TAX_CAT;

        if (defined('BKB_WP_POST')) {
            $bkb_post_type = 'post';
            $bkb_cat_taxonomy = 'category';
        }


        $bwl_kb_categories_counter = get_categories('post_type=' . $bkb_post_type . '&taxonomy=' . $bkb_cat_taxonomy . '&orderby=name&order=ASC');

        if (count($bwl_kb_categories_counter) == 0) {

            wp_insert_term(
                'General', // the term 
                BWL_KB_TAX_CAT, // the taxonomy
                array(
                    'description' => 'First KB Category.',
                    'slug' => 'general',
                    'parent' => 0
                )
            );
        }

        $args = array(
            'post_type' => $bkb_post_type,
            'show_option_none' => esc_attr__('- Select Category -', 'bwl-kb'),
            'taxonomy' => $bkb_cat_taxonomy,
            'option_none_value' => '-1',
            'orderby' => 'title',
            'order' => 'ASC',
            'show_count' => 1,
            'hide_empty' => 0,
            'child_of' => 0,
            'echo' => 0,
            'selected' => 0,
            'hierarchical' => 1,
            'name' => 'cat',
            'class' => 'postform',
            'depth' => 0,
            'tab_index' => 3,
            'hide_if_empty' => false,
            'value_field' => 'term_id'
        );

        $bwl_kb_categories = wp_dropdown_categories($args);

        $bkb_ques_form_id = wp_rand();


        if (is_user_logged_in() && isset($bkb_data['bkb_disable_captcha_status']) && $bkb_data['bkb_disable_captcha_status'] == 1) {

            $captcha_status = 0;
        }

        if ($captcha_status == 1) :

            $bwl_captcha_generator = '<p>
                                                    ' . $bkbm_label_captcha_text . '
                                                    <input id="num1" class="sum" type="text" name="num1" value="' . rand(1, 4) . '" readonly="readonly" /> +
                                                    <input id="num2" class="sum" type="text" name="num2" value="' . rand(5, 9) . '" readonly="readonly" /> =
                                                    <input id="captcha" class="captcha" type="text" name="captcha" maxlength="2"   tabindex="5"/>
                                                    <input id="captcha_status" type="hidden" name="captcha_status" value="' . $captcha_status . '"/>
                                                <span id="spambot"> ' . esc_attr__('Verify Human or Spambot ?', 'bwl-kb') . '</span>
                                            </p>';

        else :

            $bwl_captcha_generator = '<input id="captcha_status" type="hidden" name="captcha_status" value="' . $captcha_status . '" />';

        endif;


        $bkb_user_email_field = "";

        $bkb_user_email_value = "";

        if (is_user_logged_in()) {

            $current_user_info = wp_get_current_user();

            if (!empty($current_user_info->data)) {

                $current_user_info = (array) $current_user_info->data;
                $bkb_user_email_value = $current_user_info['user_email'];
            }
        }


        if (isset($bkb_data['bkb_ask_user_email_status']) && $bkb_data['bkb_ask_user_email_status'] == 1) {

            // Added In Version 1.1.9

            if ($layout == 'layout_2') {

                $bkbm_label_email = '';
                $bkbm_placeholder_email = esc_attr__('Your Email', 'bwl-kb');
            } else {

                $bkbm_label_email = '<label for="email">' . esc_attr__('Your Email: ', 'bwl-kb') . '</label>';
                $bkbm_placeholder_email = '';
            }

            $bkb_user_email_field_hints = apply_filters('bkb_user_email_field_hints', esc_attr__('You will receive an email when your question will be answered.', 'bwl-kb'));

            $bkb_user_email_field = '<p>' .
                $bkbm_label_email
                . '<input type="text" id="email" data-value="' . esc_attr($bkb_user_email_value) . '" value="' . esc_attr($bkb_user_email_value) . '" name="email"  tabindex="4" placeholder="' . $bkbm_placeholder_email . '"/> <small>' . $bkb_user_email_field_hints . '</small>
                                                </p>';
        }

        // You can change form title using shortcode.
        // Added in version 1.1.9

        // Default from heading.
        $bkb_ask_question_title = esc_attr__('Add A Knowledge Base Question !', 'bwl-kb');

        if (isset($form_heading) && $form_heading != "") {

            // Custom form heading set by user.

            $bkb_ask_question_title = $form_heading;
        } else if (isset($bkb_data['bkb_ask_question_title']) && $bkb_data['bkb_ask_question_title'] != "" && $bkb_ask_question_title != trim($bkb_data['bkb_ask_question_title'])) {

            // Custom form heading set from option panel.

            $bkb_ask_question_title = trim($bkb_data['bkb_ask_question_title']);
        } else {

            //

        }

        // Question Description Field.
        // @Since: 1.1.2

        $bkb_ask_question_details = "";

        if (isset($bkb_data['bkb_desc_conditinal_fields']['enabled']) && $bkb_data['bkb_desc_conditinal_fields']['enabled'] == 'on') {

            // Added In Version 1.1.9

            if ($layout == 'layout_2') {

                $bkbm_label_question_details = '';
                $bkbm_placeholder_question_details = esc_attr__('Question Details: ', 'bwl-kb');
            } else {

                $bkbm_label_question_details = '<label for="details">' . esc_attr__('Question Details: ', 'bwl-kb') . '</label>';
                $bkbm_placeholder_question_details = '';
            }

            $bkb_ask_question_details .= '<p>'
                . $bkbm_label_question_details .
                '<textarea id="details" name="details"  tabindex="2" placeholder="' . $bkbm_placeholder_question_details . '"></textarea>                                   
                                                         </p>';
        }


        // Question Frontend Attachments.
        // @Since: 1.3.7

        $bkb_attachment_field = "";

        if (isset($bkb_data['bkb_frontend_attachment_status']) && $bkb_data['bkb_frontend_attachment_status'] == 1 && shortcode_exists('bkb_ques_attachments')) {

            $bkb_attachment_field .= do_shortcode('[bkb_ques_attachments inline="' . $inline . '"]');
        }


        // Question Description Field.
        // @Since: 1.1.2

        $bkb_form_privacy_html = "";

        if (isset($bkb_data['bkb_privacy_conditinal_fields']['enabled']) && $bkb_data['bkb_privacy_conditinal_fields']['enabled'] == 'on' && class_exists('BKB_Aaqf')) {

            $bkb_kb_form_privacy_text = 'I agree to the <a href="#">terms of service</a>.';

            if (
                isset($bkb_data['bkb_privacy_conditinal_fields']['bkb_kb_form_privacy_text']) &&
                $bkb_data['bkb_privacy_conditinal_fields']['bkb_kb_form_privacy_text'] != "" &&
                $bkb_kb_form_privacy_text != $bkb_data['bkb_privacy_conditinal_fields']['bkb_kb_form_privacy_text']
            ) {

                $bkb_kb_form_privacy_text = $bkb_data['bkb_privacy_conditinal_fields']['bkb_kb_form_privacy_text'];
            }

            $bkb_form_privacy_html .= '<p><input type="checkbox" id="bkb_privacy" name="bkb_privacy"><span class="checkmark"></span> '
                .  str_replace("\\", "", $bkb_kb_form_privacy_text) .                                                            '
                                                         </p>';
        }


        // Form Class.

        $bkb_ques_form_class =  'bkb-ques-form-container';

        // Animation.

        $bkb_form_animation = "";

        if (defined('WPB_VC_VERSION')) {

            if (isset($animation) && $animation != "") {
                $animate_class = new WPBakeryShortCode_BKB_VC_Animation(array('base' => 'bkb_ques_form'));
                $bkb_form_animation = " " . $animate_class->getCSSAnimation($animation);
            }
        }

        //Extra Class.
        $cont_ext_class = (isset($cont_ext_class) && $cont_ext_class != "") ?  " " . $cont_ext_class : '';

        $bkb_ques_form_class = $bkb_ques_form_class . $bkb_form_animation . $cont_ext_class;


        $bkb_ques_form_body = '<section class="' . $bkb_ques_form_class . '" id="' . $bkb_ques_form_id . '">
                    
                                        <h2>' . $bkb_ask_question_title . ' </h2>

                                        <div class="bkb-ques-form-message-box"></div>
                                            
                                        <form id="bkb_ques_form" class="bkb_ques_form" name="bkb_ques_form" method="post" action="#"> 
                                        
                                                <p>        
                                                    ' . $bkbm_label_title_text . '
                                                    <input type="text" id="title" value="" name="title"  tabindex="1" placeholder="' . $bkbm_placeholder_title_text . '"/>                                      
                                               </p>
                                               
                                               ' . $bkb_ask_question_details . '
                                                
                                               
                                               <p>'
            . $bkbm_label_category_text
            . $bwl_kb_categories .
            '</p>

                                                ' . $bkb_user_email_field . '
                                                ' . $bkb_attachment_field . '
                                                ' . $bwl_captcha_generator . '
                                                ' . $bkb_form_privacy_html . '

                                                <p class="bkb_question_submit_container">
                                                    <input type="submit" value="' . esc_attr__('Submit', 'bwl-kb') . '" tabindex="7" id="submit" name="submit" bkb_ques_form_id= "' . $bkb_ques_form_id . '" />
                                                </p>

                                                <input type="hidden" name="post_type" id="post_type" value="' . $bkb_post_type . '" />

                                                <input type="hidden" name="action" value="bkb_ques" />'

            . wp_nonce_field('name_of_my_action', 'name_of_nonce_field') .

            '</form>

                                        </section>';

    else :

        $bkb_ques_form_body = '<p>' . esc_attr__("Log In is required for submitting new question.", 'bwl-kb') . '</p>';

    endif;


    if (isset($inline) && $inline == 1) {

        return $bkb_ques_form_body;
    } else if (isset($bkb_data['bkb_display_question_submission_form']) && $bkb_data['bkb_display_question_submission_form'] == 1) {

        $bkb_ques_form_body = "";
    } else {
    }

    return $bkb_ques_form_body;
}

function bkb_ques_save_post_data()
{

    if (empty($_REQUEST) || !wp_verify_nonce($_REQUEST['name_of_nonce_field'], 'name_of_my_action')) {

        $status = array(
            'bwl_kb_add_status' => 0
        );
    } else {

        $sender_email = trim($_REQUEST['email']); // Sender Email. 

        $post = array(
            'post_title'            =>   sanitize_text_field($_REQUEST['title']),
            //            'tax_input'            => array('bkb_category' => $_REQUEST['cat']), // Usable for custom taxonomies too 
            'post_status'        => 'pending', // Choose: publish, preview, future, etc.
            'post_type'          => $_REQUEST['post_type']  // Use a custom post type if you want to
        );

        $post_id = wp_insert_post($post);

        // Fixed in version 1.6.6
        // Post Type Checking.
        $bkb_cat_taxonomy = BWL_KB_TAX_CAT;

        if (defined('BKB_WP_POST')) {
            $bkb_cat_taxonomy = 'category';
        }


        $bkb_category = get_term_by('id', $_REQUEST['cat'], $bkb_cat_taxonomy);
        wp_set_object_terms($post_id, $bkb_category->slug, $bkb_cat_taxonomy, true);

        $status = array(
            'bwl_kb_add_status' => 1
        );

        // Keep track that it is user submitted question.
        // Added in version 1.1.2

        add_post_meta($post_id, 'bkb_user_ques', 1);

        // Add user question details.
        // Added in version 1.1.2

        $bkb_user_ques_details = "";

        if (isset($_REQUEST['details']) && $_REQUEST['details'] != "") {

            add_post_meta($post_id, 'bkb_user_ques_details', wp_strip_all_tags($_REQUEST['details']));

            $bkb_user_ques_details = sanitize_textarea_field($_REQUEST['details']);
        }

        // Add Post Meta For user email..

        if ($sender_email != "") {

            add_post_meta($post_id, 'bkb_ques_user_email', wp_strip_all_tags($sender_email));
        }

        // Update Attachment Meta

        if (isset($_REQUEST['bkb_attachments']) && $_REQUEST['bkb_attachments'] != "") {

            $bkb_attachments = explode(',', rtrim($_REQUEST['bkb_attachments'], ','));
            update_post_meta($post_id, 'bkb_attachment_files', $bkb_attachments);
        }

        //Send Email to administrator.

        $bwl_send_email_status = TRUE; // Initally We send email when user post a new KB.

        global $bkb_data;

        if (isset($bkb_data['bwl_advanced_email_notification_status']) && $bkb_data['bwl_advanced_email_notification_status'] == 0) {

            $bwl_send_email_status = FALSE;
        }

        if ($bwl_send_email_status == TRUE) {

            $to =  get_bloginfo('admin_email');

            if (isset($bkb_data['bkb_feedback_admin_email']) && $bkb_data['bkb_feedback_admin_email'] != "") {

                $to =  $bkb_data['bkb_feedback_admin_email'];
            }

            $subject = esc_attr__('New Question Submited!', 'bwl-kb');
            $sender_email = "user@email.com";
            $edit_kb_url =  get_admin_url() . "post.php?post&#61;$post_id&#38;action&#61;edit";

            $body = "<p>" . esc_attr__("Hello Administrator", 'bwl-kb') . ",<br>" . esc_attr__("A new question has been submitted.", 'bwl-kb') . "</p>";
            $body .= "<h3>" . esc_attr__("Submitted Question", 'bwl-kb') . "</h3><hr />";
            $body .= "<p><strong>" . esc_attr__("Title", 'bwl-kb') . ":</strong><br />" . sanitize_text_field($_REQUEST['title']) . "</p>";

            if ($bkb_user_ques_details != "") {

                $body .= "<p><strong>" . esc_attr__("Details", 'bwl-kb') . ":</strong><br /><em>" . $bkb_user_ques_details . "</em></p>";
            }
            $body .= "<p><strong>" . esc_attr__("Post Status", 'bwl-kb') . ":</strong> " . esc_attr__("Pending", 'bwl-kb') . "</p>";
            $body .= "<p><strong>" . esc_attr__("Review Post", 'bwl-kb') . ":</strong> " . $edit_kb_url . "</p>";
            $body .= "<p>" . esc_attr__("Thank You!", 'bwl-kb') . "</p>";

            $headers[] = "From: New Question <$sender_email>";

            add_filter('wp_mail_content_type', 'bkb_ques_set_html_content_type');

            wp_mail($to, $subject, $body, $headers);

            remove_filter('wp_mail_content_type', 'bkb_ques_set_html_content_type');
        }
    }

    echo json_encode($status);

    die();
}

/**
 * @Description: Add A filter for sending HTML email.
 * @Created At: 08-04-2013
 * @Last Edited AT: 30-06-2013
 * @Created By: Mahbub
 **/

function bkb_ques_set_html_content_type()
{
    return 'text/html';
}

add_action('wp_ajax_bkb_ques_save_post_data', 'bkb_ques_save_post_data');

add_action('wp_ajax_nopriv_bkb_ques_save_post_data', 'bkb_ques_save_post_data');