<?php

// If this file is called directly, abort.

if (!defined('WPINC')) {
    die;
}

function bkb_dynamic_sort_args($bkb_cat_all_posts_id, $bkb_sort_prefix, $bkb_sort_filter, $bkb_term_id, $bkb_category, $limit)
{

    $bkb_cat_sorted_posts_id = explode(',', get_option($bkb_sort_prefix . $bkb_term_id)); // call db for post meta.

    $bkb_cat_final_sorted_posts_id = array_values(array_unique(array_merge($bkb_cat_sorted_posts_id, $bkb_cat_all_posts_id)));

    $bkb_cat_final_sorted_posts_id = array_filter($bkb_cat_final_sorted_posts_id);

    $args = array(
        'post_type'         => BWL_KB_CPT,
        'post_status'       => 'publish',
        'post__in'            => $bkb_cat_final_sorted_posts_id,
        'orderby'             => 'post__in',
        'posts_per_page'  => $limit
    );

    if ($bkb_sort_filter == "tags") {

        $id_prefix = "tags-";
        $args[BWL_KB_TAX_TAG] = $bkb_category;
    } else {

        $id_prefix = "category-";
        $args[BWL_KB_TAX_CAT] = $bkb_category;
    }

    return $args;
}

// @Description: Main KB Shortcode.
// @since: version 1.0.0

add_shortcode('bwl_kb', 'cb_bwl_kb');

// @Description: Callback function for bwl_kb shortcode.

function cb_bwl_kb($atts)
{

    $id_prefix = wp_rand();

    $atts = shortcode_atts(array(
        'post_type'     => BWL_KB_CPT,
        'meta_key'         => '',
        'meta_value'         => '',
        'orderby'         => 'ID',
        'order'            => 'DESC',
        'limit'              => -1,
        'bkb_cat_title' => '',
        'bkb_category' => '',
        'bkb_tags'     => '',
        'taxonomy'     => BWL_KB_TAX_CAT,
        'posts_count'   => 0,
        'bkb_col_class' => 'bkbcol-1-1',
        'cont_ext_class' => '',
        'sbox'            => 1,
        'bkb_tabify'    => 0,
        'list'       => 0,
        'single' => 0,
        'fpid' => 0,
        'box_view' => 0, // 0=list view, 1=box view
        'box_view_class' => '', // 0=list view, 1=box view
        'box_view_icon' => '', // deafult font awesome icon, img_icon
        'box_view_icon_size' => '', // set value auto to keep it's original size.
        'bkb_desc' => 0,
        'bkb_list_type' => '', // rectangle/iconized/rounded/none/accordion
        'suppress_filters' => 0,
        'show_title' => 1,
        'paginate' => 0, // Pagination introduced in version 1.0.1 of Templify Addon default is 0
        'posts_per_page' => 5,
        'paged' => 1,
        'count_info' => 0,
        'total_count_info' => 0
    ), $atts);

    extract($atts);

    // Post Type Checking.
    if (defined('BKB_WP_POST')) {
        $post_type = 'post';
        $taxonomy = ($bkb_tags != "") ? 'post_tag' : 'category';
    }

    $output = "";

    global $bkb_data;

    $args = array(
        'post_status'       => 'publish',
        'meta_key'         => $meta_key,
        'meta_value'       => $meta_value,
        'post_type'         => $post_type,
        'orderby'             => $orderby,
        'order'                => $order,
        'posts_per_page' => $limit,
        //        'bkb_category'      => $bkb_category,
        //        'bkb_tags'          => $bkb_tags
    );


    /*-------- Added New Taxonomy Code In Version 1.1.8 -----------*/

    if ($bkb_tabify == 0) {

        if ($bkb_tags != "") {
            $bkb_category = $bkb_tags;
        }

        $args['tax_query']  = array(                     //(array) - use taxonomy parameters (available with Version 3.1).
            'relation' => 'AND',                      //(string) - Possible values are 'AND' or 'OR' and is the equivalent of ruuning a JOIN for each taxonomy
            array(
                'taxonomy' => $taxonomy,                //(string) - Taxonomy.
                'field' => 'slug',                    //(string) - Select taxonomy term by ('id' or 'slug')
                'terms' => $bkb_category,    //(int/string/array) - Taxonomy term(s).
                'include_children' => 0,           //(bool) - Whether or not to include children for hierarchical taxonomies. Defaults to true.
                'operator' => 'IN'                    //(string) - Operator to test. Possible values are 'IN', 'NOT IN', 'AND'.
            )
        );
    }
    /*-------- End Taxonomy Code In Version 1.1.8 -----------*/


    if ($paginate == 1) {

        $args['posts_per_page'] = $posts_per_page;
        $args['paged'] = $paged;
    }

    // We are going to set a filter in here for Restriction Addon.
    $args = apply_filters('bkb_rkb_query_filter', $args);

    $loop = new WP_Query($args);

    // We are going to set another filter for dynamic sorting.

    if (isset($orderby) && $orderby == "custom_order") {

        //        if( $bkb_category != "" ) {
        if ($bkb_category != "") {
            $id_prefix = "category-";
            $bkb_sort_prefix = PREFIX_BKB_CAT;
            $bkb_sort_filter = 'category';
        }

        if ($bkb_tags != "") {
            $id_prefix = "tags-";
            $bkb_sort_prefix = PREFIX_BKB_TAG;
            $bkb_sort_filter = 'tags';
        }

        //        // We need to change argument query in here.

        $bkb_cat_all_posts_id = array();
        $bkb_term_id = 0;

        if ($loop->have_posts()) :

            while ($loop->have_posts()) :

                $loop->the_post();

                if ($bkb_tags != "") {
                    $category_info = get_term_by('slug', $bkb_tags, 'bkb_' . $bkb_sort_filter);
                } else {
                    $category_info = get_term_by('slug', $bkb_category, 'bkb_' . $bkb_sort_filter);
                }

                $bkb_term_id = $category_info->term_id;
                $bkb_cat_all_posts_id[] = get_the_ID();

            endwhile;

        endif;

        wp_reset_query();

        $args = bkb_dynamic_sort_args($bkb_cat_all_posts_id, $bkb_sort_prefix, $bkb_sort_filter, $bkb_term_id, $bkb_category, $limit);

        if ($paginate == 1) {

            $args['posts_per_page'] = $posts_per_page;
            $args['paged'] = $paged;
        }

        $loop = new WP_Query($args);
    }

    // Custom Pagination For Templify KB Addon.
    // @Since: version 1.0.9

    $pagination_output = "";

    if (function_exists('bkb_tpl_pagination') && $paginate == 1) :
        $pagination_output = bkb_tpl_pagination($loop);
    endif;

    /*----- Start Font Awesome Category & Content Icons  -----*/

    $bkb_fa_icon = "fa fa-file-o"; // Default Icon for Categories/Tags
    $bkb_list_fa_icon = $bkb_fa_icon; // Default Icon for Lists.
    $bkb_kb_post_default_icon = $bkb_fa_icon; // Default Icon for Single Post.

    if ($bkb_tags != "") {

        $taxonomy = BWL_KB_TAX_TAG;
        $bkb_fa_icon = "fa fa-th";

        if (isset($bkb_data['bkb_tag_icon']) && $bkb_data['bkb_tag_icon'] != "") {
            $bkb_fa_icon = $bkb_data['bkb_tag_icon'];
            $bkb_list_fa_icon = $bkb_fa_icon;
        }
    } else {

        if (isset($bkb_data['bkb_cat_icon']) && $bkb_data['bkb_cat_icon'] != "") {
            $bkb_fa_icon = $bkb_data['bkb_cat_icon'];
            $bkb_list_fa_icon = $bkb_fa_icon;
        }
    }

    /*----- KB Post Default Icon -----*/

    if (isset($bkb_data['bkb_post_icon']) && $bkb_data['bkb_post_icon'] != "") {
        $bkb_kb_post_default_icon = $bkb_data['bkb_post_icon'];
    }

    /*------ End Font Awesome Category & Content Icons-----*/

    if ($bkb_tabify == 0) {

        $bkb_taxonomy_title = $bkb_cat_title;

        $bkb_taxonomy_info = get_term_by('name', $bkb_taxonomy_title, $taxonomy);

        $taxonomy_id = $bkb_taxonomy_info->slug;

        $bkb_taxonomy_cat_link = get_term_link($taxonomy_id, $taxonomy);

        $output .= '<div class="' . $bkb_col_class . '">
                                 <div class="bkb-content">';

        $bkb_custom_fa_icon = get_tax_meta($bkb_taxonomy_info->term_id, 'bkb_fa_id'); // change term_taxonomy_id to term_id in version 1.1.6

        $bkb_upload_icon_status = get_tax_meta($bkb_taxonomy_info->term_id, 'bkb_upload_icon_status');

        // Forced Image Icon.
        // Added in version 1.2.2

        if (isset($box_view_icon) && $box_view_icon == "img_icon") {

            $bkb_upload_icon_status = 'on';
        }

        $box_view_icon_size_class = "";

        if (isset($box_view_icon_size) && $box_view_icon_size == "auto") {

            $box_view_icon_size_class = ' style="width: auto !important; height: auto !important;"';
        }

        // End of image icon code.

        $bkb_uploaded_icon = get_tax_meta($bkb_taxonomy_info->term_id, 'bkb_uploaded_icon');

        if ($bkb_custom_fa_icon != "") {

            $bkb_fa_icon = $bkb_custom_fa_icon;
        }

        $bkb_fa_icon = '<i class="' . $bkb_fa_icon . '"></i>';

        if ($bkb_upload_icon_status == "on" && isset($bkb_uploaded_icon['url']) && $bkb_uploaded_icon['url'] != "") {

            $bkb_taxonomy_img_class = "bkb_taxonomy_img_lists";

            if ($box_view == 1) {
                $bkb_taxonomy_img_class = "bkb_taxonomy_img_box";
            }


            $bkb_fa_icon = '<img src="' . $bkb_uploaded_icon['url'] . '" class="' . $bkb_taxonomy_img_class . '" ' . $box_view_icon_size_class . '/>';
        }


        $bkb_posts_count_string = ""; // Initialize KB Post Count.
        $bkb_taxonomy_description = ""; // Initialize KB Taxonomy Description.


        $bkb_accordion_html = "";

        // Get KB posts count.
        if ($posts_count == 1) {

            $bkb_posts_count_string = ' <span class="items-counter"> ' . $bkb_taxonomy_info->count . ' </span>';
        }

        // Get Category/Topic description.

        if ($bkb_taxonomy_info->description != "" && $bkb_desc == 1) {

            //Genereate taxonomy string if description is available and display status is 1.
            $bkb_taxonomy_description .= '<p class="bkb-category-description">' . $bkb_taxonomy_info->description . '</p>';
        }
        //            echo $bkb_taxonomy_description;
        $bkb_taxonomy_all_posts = '<p class="bkb-category-view-all-box" style=""> <a href="' . $bkb_taxonomy_cat_link . '" title="' . $bkb_taxonomy_title . '" >View All</a></p>';


        if ($box_view == 1) {


            $box_view_class = (isset($box_view_class) && $box_view_class != "") ? 'bkb-box-layout ' . $box_view_class : 'bkb-box-layout';


            // Box View.
            $output .= '<div class="' . $box_view_class . '"><a href="' . $bkb_taxonomy_cat_link . '" title="' . $bkb_taxonomy_title . '" ><span class="bkb-icon-container">' . $bkb_fa_icon . '</span> <h2 class="bkb-box-style-category-title">' . ucfirst($bkb_cat_title) . $bkb_posts_count_string . '</h2></a>';

            $output .= $bkb_taxonomy_description;

            $output .= $bkb_taxonomy_all_posts;

            $output .= '</div>';
        } else {

            // Regular View.
            // @added in version 1.0.8

            if ($show_title == 1) {

                $output .= '<h2 class="bwl-kb-category-title"><a href="' . $bkb_taxonomy_cat_link . '" title="' . $bkb_taxonomy_title . '" >' . $bkb_fa_icon . ' ' . ucfirst($bkb_cat_title) . $bkb_posts_count_string . '</a></h2>';
            }

            $output .= $bkb_taxonomy_description;
        }
    }


    if ($loop->have_posts() && $box_view == 0) :

        $bkb_list_iconized_status = FALSE;
        $bkb_list_iconized_string = "";

        // List type styling classes.
        // 4 types of list styles available in KB.
        // Default: Rounded List.

        if (isset($bkb_data['bkb_list_style_type']) && $bkb_data['bkb_list_style_type'] == "rectangle") {

            $bkb_list_style_class = "rectangle-list";
        } else if (isset($bkb_data['bkb_list_style_type']) && $bkb_data['bkb_list_style_type'] == "iconized") {

            $bkb_list_style_class = "iconized-list";
            $bkb_list_iconized_status = TRUE;
        } else if (isset($bkb_data['bkb_list_style_type']) && $bkb_data['bkb_list_style_type'] == "none") {

            $bkb_list_style_class = "none-list";
        } else {

            $bkb_list_style_class =  "rounded-list";
        }

        /*----- Just A Quick Check For List Type Settings -----*/

        if (isset($bkb_list_type) && $bkb_list_type != "") {

            $bkb_list_style_class = $bkb_list_type . "-list";

            if ($bkb_list_style_class == "iconized-list") {
                $bkb_list_iconized_status = TRUE;
            } else {
                $bkb_list_iconized_status = FALSE;
            }
        }

        //Starting The Accordion Block.

        if ($bkb_list_type == 'accordion') {

            //Fixed in version 1.1.3

            if ($show_title == 1) {

                $bkb_accordion_html .= '<h2 class="bwl-kb-category-title"><a href="' . $bkb_taxonomy_cat_link . '" title="' . $bkb_taxonomy_title . '" >' . $bkb_fa_icon . ' ' . ucfirst($bkb_cat_title) . $bkb_posts_count_string . '</a></h2>';

                // Added in version 1.1.4

                if (isset($bkb_taxonomy_description) && $bkb_taxonomy_description != "") {

                    $bkb_accordion_html .= $bkb_taxonomy_description . '<br />';
                }
            }

            $bkb_accordion_html .= '<div class="smk_accordion acc_with_icon" id="bkb_accordion_' . wp_rand() . '">';
        }


        $output .= '<ol class="bwl-kb-categories ' . $bkb_list_style_class . '">';

        while ($loop->have_posts()) :

            $loop->the_post();

            $bkb_title = apply_filters("custom_rkb_title", get_the_title()); // Apply Filter custom_rkb_title to display lock icon.

            if ($bkb_list_iconized_status == TRUE) {

                $bkb_kb_post_icon = get_post_meta(get_the_ID(), "bkb_fa_id", true);

                if ($bkb_kb_post_icon != "") {

                    $bkb_list_fa_icon = $bkb_kb_post_icon;
                } else {

                    $bkb_list_fa_icon = $bkb_kb_post_default_icon;
                }

                $bkb_list_iconized_string = '<i class="' . $bkb_list_fa_icon . '"></i>';
            }


            // Accordion List Type Introduced in version 1.1.0
            // Accordion layout only work in boxed view.

            if ($bkb_list_type == 'accordion') {

                // Load Accordion Stylesheet.

                //                 wp_enqueue_style('bkb-accordion-styles');
                wp_enqueue_script('bkb-accordion-script');

                /***********************************************************************************************/
                /* Add Content Filter Feature In Accordion For "Restrict Access By User Role Addon" */
                /* @Since: version 1.1.0 */
                /* @Created: 15-11-2015 */
                /***********************************************************************************************/

                $bkb_rkb_post_access_result = 1;

                if (has_filter("bkb_rkb_post_access")) {

                    $bkb_rkb_post_access_result = apply_filters('bkb_rkb_post_access', get_the_ID());
                }


                if ($bkb_rkb_post_access_result == 1) {


                    // @Description: Show Hide Voting Button.
                    // @Since: Version 1.0.9

                    if (isset($bkb_data['bkb_acc_voting_btn_status']) && $bkb_data['bkb_acc_voting_btn_status'] == 1) {

                        $post_voting_interface = "";
                    } else {

                        $post_voting_interface = do_shortcode("[bkb_vm /]");
                    }

                    // @Description: Display KB Full Content
                    // @Since: Version 1.0.9

                    if (isset($bkb_data['bkb_acc_content_type']) && $bkb_data['bkb_acc_content_type'] == "summary") {

                        $bkb_item_content = get_the_excerpt() . $post_voting_interface;
                    } else {

                        // If attachment is available with the post then we are going to show that.
                        $bkb_attachment = do_shortcode("[bkb_attachment /]");

                        $bkb_item_content = apply_filters('the_content', get_the_content()) . $bkb_attachment . $post_voting_interface;
                    }
                } else {


                    $bkb_item_content = $bkb_rkb_post_access_result;
                }

                $bkb_accordion_html .= '<div class="accordion_in">
				<div class="acc_head"><div class="acc_icon_expand"></div><h4>' . $bkb_title . '</h4></div>
				<div class="acc_content" style="display: none;">' . $bkb_item_content  . '</div>
                                                        </div>';
            } else {

                //Regular Layout.

                $output .= '<li><a href="' . get_permalink() . '" title="' . get_the_title() . '">' . $bkb_list_iconized_string . $bkb_title . '</a></li>';
            }


        endwhile;

        $output .= '</ol>';

        if ($count_info == 1) {

            $output .= '<p class="bkb-count-info"><a href="' . esc_url($bkb_taxonomy_cat_link) . '">' . esc_html__(sprintf('Show all %d posts ', $total_count_info), 'bwl-kb') . ' <i class="fa fa-long-arrow-right"></i></a></p>';
        }

        $output .= $pagination_output;

    else :

        if ($box_view == 1) {

            // Box View.
            $output .= "";
        } else {

            // Regular View.
            $output .= "<p>" . esc_attr__('Sorry, No Knowledgebase Item Available!', 'bwl-kb') . "</p>";
        }

    endif;

    if ($bkb_tabify == 0) {

        $output .= '    </div>
                       </div>';


        // Here we close the accordion div.
        // @Since: version 1.1.0.

        if ($bkb_list_type == 'accordion') {

            $bkb_accordion_html .= '</div>';
            $output = $bkb_accordion_html;
        }
    } else {
        // Tabify Footer code sent in here.
    }



    wp_reset_query();

    return $output;
}

/*----- BKB CATEGORY SHORTCODE --------*/

add_shortcode('bkb_category', 'cb_bkb_get_category_contents');

function cb_bkb_get_category_contents($atts)
{

    $atts = shortcode_atts(array(
        'taxonomy'     => BWL_KB_TAX_CAT,
        'meta_key'     => '',
        'orderby'        => 'ID',
        'order'           => 'DESC',
        'limit'             => -1,
        'categories'    => '',
        'cols'             => 2,
        'posts_count' => 0,
        'bkb_list_type' => '', // rectangle/iconized/rounded/none,
        'bkb_desc' => 0,
        'box_view' => 0,
        'box_view_class' => '',
        'box_view_icon' => '', // deafult font awesome icon, img_icon
        'box_view_icon_size' => '', // set value auto to keep it's original size.
        'show_title' => 1,
        'paginate' => 0, // Pagination introduced in version 1.0.1 of Templify Addon default is 0
        'posts_per_page' => 5,
        'paged' => 1,
        'count_info' => 0,
        'carousel' => 0,
        'carousel_nav' => 1,
        'carousel_dots' => 0,
        'carousel_autoplay' => 'true',
        'carousel_autoplaytimeout' => 5000,
        'cont_ext_class' => '',
        'animation' => ''
    ), $atts);

    extract($atts);

    $count_info_status = $count_info; // Required for display count info. [DND]

    $output = '';

    // Only For VC.

    $bkb_column_animation = "";

    if (defined('WPB_VC_VERSION')) {

        if (isset($animation) && $animation != "") {
            $animate_class = new WPBakeryShortCode_BKB_VC_Animation(array('base' => BWL_KB_TAX_CAT));
            $bkb_column_animation = " " . $animate_class->getCSSAnimation($animation);
        }
    }

    // Only For POST.

    if (defined('BKB_WP_POST')) {
        $taxonomy = 'category';
    }

    // Starting div condition for carousel.

    if (isset($carousel) && $carousel == 1) {

        wp_enqueue_script('bkb-owl-carousel-script');

        $carousel_nav_status = ($carousel_nav == 1) ? 'false' : 'true';
        $carousel_dots_status = ($carousel_dots == 1) ? 'false' : 'true';

        $output .= '<div class="bkbm-carousel owl-carousel" data-carousel="1" data-items="' . $cols . '" data-nav="' . $carousel_nav_status . '" data-dots="' . $carousel_dots_status . '" data-autoplay="' . $carousel_autoplay . '" data-autoplaytimeout="' . $carousel_autoplaytimeout . '">';
    }

    $bkb_category_args = array(
        'taxonomy' => $taxonomy,
        'hide_empty' => 1,
        'orderby' => 'title',
        'order' => 'ASC'
    );

    $bkb_col_class = bkb_get_grid_col_class($cols) . $bkb_column_animation;

    $bkb_col_class = (isset($cont_ext_class) && $cont_ext_class != "") ?  $bkb_col_class . " " . $cont_ext_class : $bkb_col_class;

    if (trim($categories) == "") {

        // If there is no category filtering then first we pick all categories from database and then create a loop.

        $bkb_categories = get_categories($bkb_category_args);

        $total_bkb_categories = sizeof($bkb_categories);

        $counter = 0;

        $outer_loop = 1;

        $end_point = $cols - 1;

        foreach ($bkb_categories as $category) :

            $slug = $category->slug;

            $category_title = $category->name;

            $category_items = $category->count;

            // Category Count Info Added in Version 1.1.8
            // Display only in sub category section.
            // Show all links will only display if count_info value is 1 and total category item is greater than the post per page number.
            $total_count_info = $category_items;

            if ($count_info_status == 1) { // First we need to check if count info status is 1 or not. If 1 then we are going to check further conditions.
                if ($category_items <= $limit) { // If total number of post is less than or equal to limit, we are going to hide link.
                    $count_info = 0;
                } else {
                    $count_info = 1;
                }
            }


            if ($counter % $cols == 0) {

                $output .= '<div class="' . bkb_get_grid_container_class() . '">';
            }

            $output .= do_shortcode('[bwl_kb taxonomy="' . $taxonomy . '" bkb_cat_title="' . $category_title . '" bkb_col_class="' . $bkb_col_class . '" bkb_category="' . $slug . '" limit="' . $limit . '" orderby="' . $orderby . '" order="' . $order . '" posts_count="' . $posts_count . '" bkb_list_type="' . $bkb_list_type . '" box_view="' . $box_view . '" box_view_class="' . $box_view_class . '" box_view_icon="' . $box_view_icon . '" box_view_icon_size="' . $box_view_icon_size . '" bkb_desc="' . $bkb_desc . '" show_title="' . $show_title . '" paginate="' . $paginate . '" posts_per_page="' . $posts_per_page . '" paged="' . $paged . '" count_info="' . $count_info . '" total_count_info="' . $total_count_info . '" /]');


            if ($counter == $end_point || $total_bkb_categories == $outer_loop) {

                $output .= '</div><!-- end of .grid -->';

                $counter = 0;
            } else {

                $counter++;
            }

            $outer_loop++;

        endforeach;

        wp_reset_query();
    } else {


        // Here we get list of categories user want to display. 

        $categories = explode(',', $categories);

        if (sizeof($categories) > 0) {

            $total_bkb_categories = sizeof($categories);

            $counter = 0;

            $outer_loop = 1;

            $end_point = $cols - 1;

            foreach ($categories as $category_slug) {

                $category_info = get_term_by('slug', $category_slug, $taxonomy);

                $slug = $category_slug;

                $cat_slug_change_status = 0;

                if ($category_info == false) {

                    $category_info = new stdClass();
                    $category_info->name = $category_slug;
                    $category_info->slug = $category_slug;
                    $category_info->count = 0;
                    $slug = $category_info->slug;
                    $cat_slug_change_status = 1;
                }

                $category_title = $category_info->name;

                $category_items = $category_info->count;

                if ($counter % $cols == 0) {

                    $output .= '<div class="' . bkb_get_grid_container_class() . '">';
                }

                // Category Count Info Added in Version 1.1.8
                // Display only in sub category section.
                // Show all links will only display if count_info value is 1 and total category item is greater than the post per page number.
                $total_count_info = $category_items;

                if ($count_info_status == 1) { // First we need to check if count info status is 1 or not. If 1 then we are going to check further conditions.
                    if ($category_items <= $limit) { // If total number of post is less than or equal to limit, we are going to hide link.
                        $count_info = 0;
                    } else {
                        $count_info = 1;
                    }
                }

                if ($cat_slug_change_status == 1) {

                    $error_title = '<span>' . $slug . '</span>' . esc_attr__(" is an invalid category slug.", 'bwl-kb');
                    $notice_subtitle = '<strong>' . esc_attr__("Help Note: ", 'bwl-kb') . '</strong>' . esc_attr__("If you have changed/updated KB category slug, then please make sure you have updated new slug value in to shortcode too. <br />For example - old slug was 'old-demo' and new slug is 'new-demo'. Then shortcode will be [bkb_category categories='new-demo'] .<br />", 'bwl-kb');
                    $output .= sprintf('<div class="' . $bkb_col_class . '"><div class="bkb-content"><h2 class="bwl-kb-category-title error-slug">%1s</h2><p class="bkb-category-description">%2s</p><br/></div></div>', $error_title, $notice_subtitle);
                } else {

                    $output .= do_shortcode('[bwl_kb taxonomy="' . $taxonomy . '" bkb_cat_title="' . $category_title . '" bkb_col_class="' . $bkb_col_class . '" bkb_category="' . $slug . '" limit="' . $limit . '" orderby="' . $orderby . '" order="' . $order . '" posts_count="' . $posts_count . '" bkb_list_type="' . $bkb_list_type . '" box_view="' . $box_view . '" box_view_class="' . $box_view_class . '" box_view_icon="' . $box_view_icon . '" box_view_icon_size="' . $box_view_icon_size . '" bkb_desc="' . $bkb_desc . '" show_title="' . $show_title . '" paginate="' . $paginate . '" posts_per_page="' . $posts_per_page . '" paged="' . $paged . '"
                  count_info="' . $count_info . '" total_count_info="' . $total_count_info . '" /]');
                }
                if ($counter == $end_point || $total_bkb_categories == $outer_loop) {

                    $output .= '</div><!-- end of .grid -->';

                    $counter = 0;
                } else {

                    $counter++;
                }

                $outer_loop++;
            }
        }
    }

    if (isset($carousel) && $carousel == 1) {

        $output .= '</div>';
    }

    return $output;
}

/*----- BKB TAG SHORTCODE --------*/

add_shortcode('bkb_tags', 'cb_bkb_get_tag_contents');

function cb_bkb_get_tag_contents($atts)
{

    $atts = shortcode_atts(array(
        'taxonomy' => BWL_KB_TAX_TAG,
        'meta_key' => '',
        'orderby' => 'ID',
        'order' => 'DESC',
        'limit' => -1,
        'tags' => '',
        'cols' => 2,
        'posts_count' => 0,
        'bkb_list_type' => '', // rectangle/iconized/rounded/none
        'bkb_desc' => 0,
        'box_view' => 0,
        'box_view_class' => '',
        'box_view_icon' => '', // deafult font awesome icon, img_icon
        'box_view_icon_size' => '', // set value auto to keep it's original size.
        'show_title' => 1,
        'paginate' => 0, // Pagination introduced in version 1.0.1 of Templify Addon default is 0
        'posts_per_page' => 5,
        'paged' => 1,
        'count_info' => 0,
        'carousel' => 0,
        'carousel_nav' => 1,
        'carousel_dots' => 0,
        'carousel_autoplay' => 'true',
        'carousel_autoplaytimeout' => 5000,
        'cont_ext_class' => '',
        'animation' => ''
    ), $atts);

    extract($atts);

    $count_info_status = $count_info; // Required for display count info. [DND]

    $output = "";

    // Only For VC.

    $bkb_column_animation = "";

    if (defined('WPB_VC_VERSION')) {

        if (isset($animation) && $animation != "") {
            $animate_class = new WPBakeryShortCode_BKB_VC_Animation(array('base' => BWL_KB_TAX_TAG));
            $bkb_column_animation = " " . $animate_class->getCSSAnimation($animation);
        }
    }

    // Only For POST.

    if (defined('BKB_WP_POST')) {
        $taxonomy = 'post_tag';
    }

    // Starting div condition for carousel.

    if (isset($carousel) && $carousel == 1) {

        wp_enqueue_script('bkb-owl-carousel-script');

        $carousel_nav_status = ($carousel_nav == 1) ? 'false' : 'true';
        $carousel_dots_status = ($carousel_dots == 1) ? 'false' : 'true';

        $output .= '<div class="bkbm-carousel" data-carousel="1" data-items="' . $cols . '" data-nav="' . $carousel_nav_status . '" data-dots="' . $carousel_dots_status . '" data-autoplay="' . $carousel_autoplay . '" data-autoplaytimeout="' . $carousel_autoplaytimeout . '">';
    }

    $bkb_tags_args = array(
        'taxonomy' => $taxonomy,
        'hide_empty' => 1,
        'orderby' => 'title',
        'order' => 'ASC'
    );

    $bkb_col_class = bkb_get_grid_col_class($cols) . $bkb_column_animation;

    $bkb_col_class = (isset($cont_ext_class) && $cont_ext_class != "") ?  $bkb_col_class . " " . $cont_ext_class : $bkb_col_class;

    if (trim($tags) == "") {

        $tags = get_categories($bkb_tags_args);

        $total_bkb_tags = sizeof($tags);

        $counter = 0;

        $outer_loop = 1;

        $end_point = $cols - 1;

        foreach ($tags as $tag) :

            $slug = $tag->slug;

            $tag_title = $tag->name;

            $tag_items = $tag->count;

            // Tags Count Info Added in Version 1.1.8
            // Display only in sub category section.
            // Show all links will only display if count_info value is 1 and total category item is greater than the post per page number.
            $total_count_info = $tag_items;

            if ($count_info_status == 1) { // First we need to check if count info status is 1 or not. If 1 then we are going to check further conditions.
                if ($tag_items <= $limit) { // If total number of post is less than or equal to limit, we are going to hide link.
                    $count_info = 0;
                } else {
                    $count_info = 1;
                }
            }


            if ($counter % $cols == 0) {

                $output .= '<div class="' . bkb_get_grid_container_class() . '">';
            }

            $output .= do_shortcode('[bwl_kb taxonomy="' . $taxonomy . '" bkb_cat_title="' . $tag_title . '" bkb_col_class="' . $bkb_col_class . '" bkb_tags="' . $slug . '" limit="' . $limit . '" orderby="' . $orderby . '" order="' . $order . '" posts_count="' . $posts_count . '" bkb_list_type="' . $bkb_list_type . '"  box_view="' . $box_view . '" box_view_class="' . $box_view_class . '" box_view_icon="' . $box_view_icon . '" box_view_icon_size="' . $box_view_icon_size . '" bkb_desc="' . $bkb_desc . '" show_title="' . $show_title . '" paginate="' . $paginate . '" posts_per_page="' . $posts_per_page . '" paged="' . $paged . '" count_info="' . $count_info . '" total_count_info="' . $total_count_info . '" /]');

            if ($counter == $end_point || $total_bkb_tags == $outer_loop) {

                $output .= '</div><!-- end of .grid -->';

                $counter = 0;
            } else {

                $counter++;
            }

            $outer_loop++;

        endforeach;

        wp_reset_query();
    } else {

        $tags = explode(',', $tags);

        if (sizeof($tags) > 0) {

            $total_bkb_tags = sizeof($tags);

            $counter = 0;

            $outer_loop = 1;

            $end_point = $cols - 1;

            foreach ($tags as $tag_slug) {

                $tag_info = get_term_by('slug', $tag_slug, $taxonomy);

                $slug = $tag_slug;

                $tag_slug_change_status = 0;

                if ($tag_info == false) {

                    $tag_info = new stdClass();
                    $tag_info->name = $tag_slug;
                    $tag_info->slug = $tag_slug;
                    $tag_info->count = 0;
                    $slug = $tag_info->slug;
                    $tag_slug_change_status = 1;
                }

                $tag_title = $tag_info->name;

                $tag_items = $tag_info->count;

                if ($counter % $cols == 0) {

                    $output .= '<div class="' . bkb_get_grid_container_class() . '">';
                }

                // Tags Count Info Added in Version 1.1.8
                // Display only in sub category section.
                // Show all links will only display if count_info value is 1 and total category item is greater than the post per page number.
                $total_count_info = $tag_items;

                if ($count_info_status == 1) { // First we need to check if count info status is 1 or not. If 1 then we are going to check further conditions.
                    if ($tag_items <= $limit) { // If total number of post is less than or equal to limit, we are going to hide link.
                        $count_info = 0;
                    } else {
                        $count_info = 1;
                    }
                }


                if ($tag_slug_change_status == 1) {

                    $error_title = '<span>' . $slug . '</span>' . esc_attr__(" is an invalid tag slug.", 'bwl-kb');
                    $notice_subtitle = esc_attr__("If you have changed/updated KB tag slug, then please make sure you have updated new slug value in to shortcode too. <br />For example - old slug was 'old-demo' and new slug is 'new-demo'. Then shortcode will be [bkb_tags tags='new-demo'] .<br />", 'bwl-kb');
                    $output .= sprintf('<div class="' . $bkb_col_class . '"><div class="bkb-content"><h2 class="bwl-kb-category-title error-slug">%1s</h2><p class="bkb-category-description">%2s</p><br/></div></div>', $error_title, $notice_subtitle);
                } else {

                    $output .= do_shortcode('[bwl_kb taxonomy="' . $taxonomy . '" bkb_cat_title="' . $tag_title . '" bkb_col_class="' . $bkb_col_class . '" bkb_tags="' . $slug . '" limit="' . $limit . '" orderby="' . $orderby . '" order="' . $order . '" posts_count="' . $posts_count . '" bkb_list_type="' . $bkb_list_type . '"  box_view="' . $box_view . '" box_view_class="' . $box_view_class . '" box_view_icon="' . $box_view_icon . '" box_view_icon_size="' . $box_view_icon_size . '" bkb_desc="' . $bkb_desc . '" show_title="' . $show_title . '" paginate="' . $paginate . '" posts_per_page="' . $posts_per_page . '" paged="' . $paged . '" count_info="' . $count_info . '" total_count_info="' . $total_count_info . '" /]');
                }
                if ($counter == $end_point || $total_bkb_tags == $outer_loop) {

                    $output .= '</div><!-- end of .grid -->';

                    $counter = 0;
                } else {

                    $counter++;
                }

                $outer_loop++;
            }
        }
    }

    if (isset($carousel) && $carousel == 1) {

        $output .= '</div>';
    }

    return $output;
}

/*----- GET POLL ANSWER OPTIONS -----*/

add_shortcode('bkb_search', 'cb_bkb_live_search_field');

function cb_bkb_live_search_field($atts)
{

    // @User can add custom placeholder text using shortcode.
    // @Since: 1.1.2

    extract(shortcode_atts(array(
        'placeholder'     => esc_attr__('Search Keywords ..... ', 'bwl-kb'),
        'animation' => '',
        'cont_ext_class' => ''
    ), $atts));

    // @Description: Enqueue search script only when it's called.
    wp_enqueue_script('bkb-custom-search-script');

    $bkb_live_search_html = "";

    $search_box_unique_id = wp_rand();

    global $bkb_data;

    $bkb_max_search_result  = (isset($bkb_data['bkb_max_search_result']) && is_numeric($bkb_data['bkb_max_search_result']) && $bkb_data['bkb_max_search_result'] != "") ? $bkb_data['bkb_max_search_result'] : 10;
    $bkb_search_only_title_status  = (isset($bkb_data['bkb_disable_search_content']) && $bkb_data['bkb_disable_search_content'] == "on") ? 1 : 0;
    $bkb_search_both_tc_status  = (isset($bkb_data['bkb_search_both_tc_status']) && $bkb_data['bkb_search_both_tc_status'] == "on") ? 1 : 0;

    // Form Class.

    $bkb_live_search_form_class =  'bkb-live-search-form';

    // Animation.

    $bkb_search_animation = "";

    if (defined('WPB_VC_VERSION')) {

        if (isset($animation) && $animation != "") {
            $animate_class = new WPBakeryShortCode_BKB_VC_Animation(array('base' => 'bkb_search'));
            $bkb_search_animation = " " . $animate_class->getCSSAnimation($animation);
        }
    }

    //Extra Class.


    $cont_ext_class = (isset($cont_ext_class) && $cont_ext_class != "") ?  " " . $cont_ext_class : '';



    $bkb_live_search_form_class = $bkb_live_search_form_class . $bkb_search_animation . $cont_ext_class;


    $bkb_live_search_html .= '<form id="form" action="' . esc_url(get_home_url()) . '" autocomplete="off" class="' . $bkb_live_search_form_class . '">
                                                <div id="suggest" class="bkb_filter_container">
                                                    <input type="text" size="25" value="" id="s" name="s" class="s" placeholder="' . $placeholder . '" data-search-box-unique-id="' . $search_box_unique_id . '" data-search_limit="' . $bkb_max_search_result . '" data-search_only_title="' . $bkb_search_only_title_status . '" data-search_both_tc="' . $bkb_search_both_tc_status . '"/>
                                                    <span class="bkbm-btn-clear bkbm-dn"></span>
                                                    <div class="suggestionsBox" id="suggestions_' . $search_box_unique_id . '" style="display: none;">
                                                        <div class="suggestionList" id="suggestionsList_' . $search_box_unique_id . '"> &nbsp; </div>
                                                    </div> <!-- end suggestionsBox -->
                                                </div> <!-- end .bkb_filter_container -->
                                            </form><!--end .bkb-live-search-form -->';

    return $bkb_live_search_html;
}

/*-----Shortcode For Get Total No Of Post View -----*/

add_shortcode('bkb_vc', 'cb_bkb_vc');

function cb_bkb_vc()
{

    return bkb_post_views();
}

/*----- Shortcode For Voting Manager ----- -*/

add_shortcode('bkb_vm', 'cb_bkb_vm');

function cb_bkb_vm($atts)
{

    global $post;

    $post_id = get_the_ID();

    extract(shortcode_atts(array(
        'id' => $post_id,
        'status' => 1,
        'post_type' => get_post_type($post_id)

    ), $atts));

    if (isset($id) && $id != "") {

        $post_id = $id;
        $post_type = get_post_type($post_id);
        $status = get_post_meta($post_id, "bkb_display_status", true);
    }

    /**
     * @Description: Parameter Definition
     * @Status: Display voting manager or not. 0. Hide 1. Show, 2. Voting Close. 
     * @Post Type: You can add custom post type to display voting manager any where of your blog.
     * @Post ID: Current Post, page, custom post ID.
     **/
    $output = bkb_shortcode_html($status, $post_type, $post_id);

    return $output;
}


function bkb_shortcode_html($bkb_display_status, $post_type, $post_id)
{

    $content = "";
    $bkb_unique_id =  wp_rand();

    if ($bkb_display_status != "" && $bkb_display_status == 0) {

        return $content;
    }

    if ($bkb_display_status != "" && $bkb_display_status == 2) {


        /*----- BUILD INTERFACE -----*/

        $bkb_interface = '<section class="bkb_container bkb_clearfix">
                                  <p class="voting-closed-message"><i class="fa fa-info-circle"></i> ' . esc_attr__('Voting Closed !', 'bwl-kb') . '</p>
                                </section><!-- end .bkb_container -->';

        $content .= $bkb_interface;

        return $content;
    }

    // Display Voting Closed Message.

    $like_vote_counter = get_post_meta($post_id, "bkb_like_votes_count", true);

    if ($like_vote_counter == "") {
        $like_vote_counter = 0;
    }

    $dislike_vote_counter = get_post_meta($post_id, "bkb_dislike_votes_count", true);

    if ($dislike_vote_counter == "") {
        $dislike_vote_counter = 0;
    }

    $bkb_feedback_message_unique_id = 'bkb_feedback_list_' . $post_id; // so idea is we are going to add post id after vairable name

    $prev_bkb_feedback_message = get_post_meta($post_id, $bkb_feedback_message_unique_id);

    $total_vote_counter = $like_vote_counter + $dislike_vote_counter;

    $like_percentage = bkb_calculate_percentage($total_vote_counter, $like_vote_counter);
    $dislike_percentage = bkb_calculate_percentage($total_vote_counter, $dislike_vote_counter);

    global $bkb_data;

    /*----- Feedback Title -----*/

    $bkb_feedback_form_title = esc_attr__('Tell us how can we improve this post?', 'bwl-kb');

    if (isset($bkb_data['bkb_feedback_form_title']) && $bkb_data['bkb_feedback_form_title'] != "" && $bkb_feedback_form_title != trim($bkb_data['bkb_feedback_form_title'])) {

        $bkb_feedback_form_title = trim($bkb_data['bkb_feedback_form_title']);
    }

    /*----- Add Custom Icon For Like Button  -----*/

    if (isset($bkb_data['bkb_like_thumb_icon']) && $bkb_data['bkb_like_thumb_icon'] != "") {

        $bkb_like_thumb_icon = $bkb_data['bkb_like_thumb_icon'];

        $bkb_like_thumb_html = '<i class="fa ' . $bkb_like_thumb_icon . ' bkb_icon_like_color"></i>';
    } else {

        $bkb_like_thumb_icon = "fa-thumbs-o-up";

        $bkb_like_thumb_html = '<i class="fa ' . $bkb_like_thumb_icon . ' bkb_icon_like_color"></i>';
    }

    /*----- Add Custom Icon For Dislike Button  -----*/

    if (isset($bkb_data['bkb_dislike_thumb_icon']) && $bkb_data['bkb_dislike_thumb_icon'] != "") {

        $bkb_dislike_thumb_icon = $bkb_data['bkb_dislike_thumb_icon'];

        $bkb_dislike_thumb_html = '<i class="fa ' . $bkb_dislike_thumb_icon . ' bkb_icon_dislike_color"></i>';
    } else {

        $bkb_dislike_thumb_icon = "fa-thumbs-o-down";

        $bkb_dislike_thumb_html = '<i class="fa ' . $bkb_dislike_thumb_icon . ' bkb_icon_dislike_color"></i>';
    }

    /*----- Custom Image For Like Button -----*/

    if (isset($bkb_data['bkb_like_conditinal_fields']['enabled']) && $bkb_data['bkb_like_conditinal_fields']['enabled'] == 'on') {

        $bkb_custom_like_icon = $bkb_data['bkb_like_conditinal_fields']['bkb_custom_like_icon'];

        if (isset($bkb_custom_like_icon['src']) && $bkb_custom_like_icon['src'] != "") {

            $bkb_like_thumb_html = '<img src="' . $bkb_custom_like_icon['src'] . '" class="bkb-custom-icon"/>';
        }
    }


    /*----- Custom Image For Dislike Button -----*/

    if (isset($bkb_data['bkb_dislike_conditinal_fields']['enabled']) && $bkb_data['bkb_dislike_conditinal_fields']['enabled'] == 'on') {

        $bkb_custom_dislike_icon = $bkb_data['bkb_dislike_conditinal_fields']['bkb_custom_dislike_icon'];

        if (isset($bkb_custom_dislike_icon['src']) && $bkb_custom_dislike_icon['src'] != "") {

            $bkb_dislike_thumb_html = '<img src="' . $bkb_custom_dislike_icon['src'] . '" class="bkb-custom-icon"/>';
        }
    }


    /*----- Down Vote Status -----*/

    $bkb_disable_down_vote_status = 0;

    if (isset($bkb_data['bkb_disable_down_vote_status']) && $bkb_data['bkb_disable_down_vote_status'] == 1) {

        $bkb_disable_down_vote_status = 1;
    }

    /*----- ADD VOTE STATUS -----*/

    $vote_given_status = 0;

    // Like Bar Title.

    $bkb_tipsy_like_title = esc_attr__('Like The Post', 'bwl-kb');

    if (isset($bkb_data['bkb_tipsy_like_title']) && $bkb_data['bkb_tipsy_like_title'] != "" && $bkb_tipsy_like_title != $bkb_data['bkb_tipsy_like_title']) {

        $bkb_tipsy_like_title = trim($bkb_data['bkb_tipsy_like_title']);
    }

    // Dislike Bar Color.

    $bkb_tipsy_dislike_title = esc_attr__('Dislike The Post', 'bwl-kb');

    if (isset($bkb_data['bkb_tipsy_dislike_title']) && $bkb_data['bkb_tipsy_dislike_title'] != "" && $bkb_tipsy_dislike_title != $bkb_data['bkb_tipsy_dislike_title']) {

        $bkb_tipsy_dislike_title = trim($bkb_data['bkb_tipsy_dislike_title']);
    }


    if ($vote_given_status == 1) {

        $bkb_btn_container_html = '<div class="msg_container" id="msg_container_' . $post_id . '"> ' . esc_attr__('Loading .....', 'bwl-kb') . '</div>';
    } else {

        if ($bkb_disable_down_vote_status == 1) {

            $bkb_btn_container_html = '<div class="btn_like" title="' . $bkb_tipsy_like_title . '" vote_status="1" post_id="' . $post_id . '" bkb_unique_id="' . $bkb_unique_id . '">' . $bkb_like_thumb_html . '</div>';
        } else {

            $bkb_btn_container_html = '<div class="btn_like" title="' . $bkb_tipsy_like_title . '" vote_status="1" post_id="' . $post_id . '" bkb_unique_id="' . $bkb_unique_id . '">' . $bkb_like_thumb_html . '</div>
                                               <div class="btn_dislike" title="' . $bkb_tipsy_dislike_title . '" vote_status="0" post_id="' . $post_id . '" bkb_unique_id="' . $bkb_unique_id . '">' . $bkb_dislike_thumb_html . '</div>';
        }
    }


    /*----- BUILD INTERFACE -----*/


    $bkb_like_count_container_string = '<div class="like-count-container">' . $bkb_like_thumb_html . ' <span>' . $like_vote_counter . '</span></div>';
    $bkb_dislike_count_container_string = '<div class="dislike-count-container">' . $bkb_dislike_thumb_html . ' <span>' . $dislike_vote_counter . '</span></div>';

    if ($bkb_disable_down_vote_status == 1) {
        $bkb_dislike_count_container_string = "";
    }

    $bkb_interface = '<section class="bkb_container bkb_clearfix">
                                 <div class="bkb_btn_container bkb_clearfix" id="bkb_btn_container_' . $bkb_unique_id . '">
                                    ' . $bkb_btn_container_html . '
                                 </div>
                                <div class="stat-cnt" id="stat-cnt-' . $bkb_unique_id . '">
                                    <div class="total-vote-counter">' . esc_attr__('Total', 'bwl-kb') . ' <span>' . $total_vote_counter . '</span> ' . esc_attr__('Votes:', 'bwl-kb') . '</div>
                                    <div class="stat-bar">
                                        <div class="bg-green like_percentage" style="width:' . $like_percentage  . '%;"></div>
                                        <div class="bg-red dislike_percentage" style="width:' . $dislike_percentage  . '%;"></div>
                                    </div>
                                    ' . $bkb_dislike_count_container_string . $bkb_like_count_container_string . '
                                </div>
                            </section>';

    $content .= $bkb_interface;

    $bkb_form_id = "bkb_feedback_form_" . $bkb_unique_id;

    $captcha_status = 1;

    $bkb_captcha_generator = '<p>
                                                <label for="captcha">' . esc_attr__('Captcha:', 'bwl-kb') . '</label>
                                                    <input id="num1" class="sum" type="text" name="num1" value="' . rand(1, 4) . '" readonly="readonly" /> +
                                                    <input id="num2" class="sum" type="text" name="num2" value="' . rand(5, 9) . '" readonly="readonly" /> =
                                                    <input id="captcha" class="captcha" type="text" name="captcha" maxlength="2" />
                                                    <input id="captcha_status" type="hidden" name="captcha_status" value="' . $captcha_status . '" />
                                                <span id="spambot"> ' . esc_attr__('Verify Human or Spambot ?', 'bwl-kb') . '</span>
                                            </p>';

    $bkb_form_body = '<section class="bkb-feedback-form-container bkb_clearfix" id="' . $bkb_form_id . '">
                    
                                        <h2>' . $bkb_feedback_form_title . ' </h2>

                                        <div class="bwl_pro_form_error_message_box"></div>
                                            
                                        <form id="bkb_feedback_form" class="bkb_feedback_form" name="bkb_feedback_form" method="post" action="#"> 
                                        
                                                <p>        
                                                    <textarea id="feedback_message" class="feedback_message_box" placeholder="' . esc_attr__('Write feedback message ..... ', 'bwl-kb') . '"/></textarea>

                                                ' . $bkb_captcha_generator . '

                                                <p class="bkb_feedback_submit_container">
                                                    <input type="submit" value="' . esc_attr__('Submit', 'bwl-kb') . '" tabindex="6" id="submit" name="submit" bkb_feedback_form_id= "' . $bkb_form_id . '" post_id="' . $post_id . '"/>
                                                </p>

                                                <input type="hidden" name="post_type" id="post_type" value="bwl_pro_voting_manager" />

                                                <input type="hidden" name="action" value="bwl_pro_voting_manager" />'

        . wp_nonce_field('name_of_my_action', 'name_of_nonce_field') .

        '</form>

                                        </section>';

    $content .= $bkb_form_body;

    return $content;
}

/*
 * 
 * @Description: Shortcode to set custom ask a from modal window any where of your site. 
 * @since 1.0.3
 * @create date: 08-12-2014
 * @lasr update: 08-12-2014
 * @uses $shortcode_tags
 *
 * @param string $link Shortcode tag to be searched in post content.
 * @param callable $type Hook to run when shortcode is found.
 */
/***********************************************************************************************/

add_shortcode('bkb_ask_form', 'cb_bkb_ask_form');

function cb_bkb_ask_form($atts)
{

    extract(shortcode_atts(array(
        'title'     => esc_attr__('Add a Question', 'bwl-kb'),
        'type'         => 'link',
        'btn_class' => '',
        'btn_size' => '',
        'btn_animate' => '',
        'btn_border_style' => '',
        'btn_align' => 'bkb_btn_left'

    ), $atts));

    $bkb_modal_random_id = wp_rand();


    if (isset($btn_size) && $btn_size != "") {
        $btn_class .= ' ' . $btn_size;
    }

    if (isset($btn_animate) && $btn_animate != "") {
        $btn_class .= ' ' . $btn_animate;
    }

    if (isset($btn_border_style) && $btn_border_style != "") {
        $btn_class .= ' ' . $btn_border_style;
    }

    if (isset($btn_align) && $btn_align != "") {
        $btn_class .= ' ' . $btn_align;
    }

    //     $bkb_ask_ques_modal = '<div data-remodal-id="bkb_ask_ques_modal_'.$bkb_modal_random_id.'">'
    $bkb_ask_ques_modal = '<div data-remodal-id="bkb_inline_ask_ques_modal"><button data-remodal-action="close" class="remodal-close"></button>'
        .  do_shortcode("[bkb_ques_form inline=1/]") .
        '</div>';

    return $bkb_ask_ques_modal . '<a href="#" class="bkb_inline_ques_btn ' . $btn_class . '" data-modal_id="' . $bkb_modal_random_id . '">' . $title . '</a>';
}

/*
 * 
 * @Description: Shortcode to display sub category and tags. 
 * @since 1.1.8
 * @create date: 08-04-2017
 * @lasr update: 08-04-2017
 * @uses [bkb_nested_sub_taxonomy]
 */
/***********************************************************************************************/

add_shortcode('bkb_nested_sub_taxonomy', 'cb_bkb_nested_sub_taxonomy');

function cb_bkb_nested_sub_taxonomy($atts)
{

    // Default.

    $atts = shortcode_atts(array(
        'taxonomy' =>  BWL_KB_TAX_CAT,
        'orderby' => 'TITLE',
        'order' => 'ASC',
        'hide_empty' => 1,
        'show_count'   => 1,
        'show_icon'   => 1,
        'number'   => ''
    ), $atts);

    extract($atts);

    $bkb_category_args = array(
        'post_type' => BWL_KB_CPT,
        'taxonomy' => $taxonomy,
        'hide_empty' => 1,
        'orderby' => $orderby,
        'order' => $order
    );
    $bkb_categories = get_categories($bkb_category_args);

    $data_string = '';


    foreach ($bkb_categories as $category) :

        $bkb_kb_cat_default_icon = "fa fa-home";

        $bkb_kb_cat_icon = get_tax_meta($category->term_id, "bkb_fa_id");

        $bkb_upload_icon_status = get_tax_meta($category->term_id, 'bkb_upload_icon_status');

        if ($bkb_kb_cat_icon == "") {

            $bkb_kb_cat_icon = $bkb_kb_cat_default_icon;
        }

        if ($bkb_upload_icon_status == "on") {

            $bkb_uploaded_icon = get_tax_meta($category->term_id, 'bkb_uploaded_icon');

            if (isset($bkb_uploaded_icon['url']) && $bkb_uploaded_icon['url'] != "") {
                $bkb_kb_cat_icon = $bkb_uploaded_icon['url'];
            }
        }

        $data_string .= 'cat-item-' . $category->term_id . '|' . $bkb_kb_cat_icon . '@';

    endforeach;


    $data_string_length = strlen($data_string);

    if ($data_string_length > 0) {

        $data_string = substr($data_string, 0, $data_string_length - 1);
    }

    wp_reset_query();

    $hierarchical = 1; // 1 for yes, 0 for no
    $title = '';
    $args = array(
        'post_type' => BWL_KB_CPT,
        'taxonomy' => $taxonomy,
        'hide_empty' => 1,
        'orderby' => $orderby,
        'order' => $order,
        'show_count' => $show_count,
        'hierarchical' => $hierarchical,
        'pad_count' => FALSE,
        'style' => 'list',
        'title_li' => $title,
        'echo' => 0
    );

    //        $args = array(
    //            'post_type' => BWL_KB_CPT,
    //            'taxonomy' => $taxonomy,
    //            'hide_empty' => 1,
    //            'orderby' => $orderby,
    //            'order' => $order,
    //            'show_count' => $show_count,
    //            'hierarchical' => $hierarchical,
    //            'pad_count' => FALSE,
    //            'style' => 'list',
    //            'hide_empty' => 0,
    //            'title_li' => $title
    //        );

    if (isset($number) && $number != "") {
        $args['number'] = $number;
    }

    echo '<ul class="bkb-widget bkb-nested-category-list" data-bkb_category_icon="' . $data_string . '" data-show_icon="' . $show_icon . '" data-show_count="' . $show_count . '">';

    $links = wp_list_categories($args);
    $links = str_replace('</a> (', '</a> <span class="bkb_post_counts">(', $links);
    echo $links = str_replace(')', ')</span>', $links);

    echo "</ul>";
}