<?php

/**
 * @Description: Shortcode Editor Button
 * @Created At: 08-04-2013
 * @Last Edited AT: 03-02-2017
 * @Created By: Mahbub
 * */
add_action('admin_init', 'bkb_tinymce_shortcode_button');

function bkb_tinymce_shortcode_button()
{

    if (!current_user_can('edit_posts') && !current_user_can('edit_pages')) {
        return;
    }

    if (get_user_option('rich_editing') !== 'true') {
        return;
    }

    // WPML FIXING IN VERSION 1.1.8
    $current_lang = 'en';

    if (defined('ICL_SITEPRESS_VERSION') && isset($_GET['lang'])) {
        $current_lang = $_GET['lang'];
        set_transient('WPML_SELECTED_LANG', $current_lang);
    }

    add_filter('mce_external_plugins', 'add_bkb_shortcode_plugin');
    add_filter('mce_buttons', 'register_bkb_shortcode_button');
}

function register_bkb_shortcode_button($buttons)
{

    // Load TinyMCE shortcode buttons.
    // Fixed in version 1.1.2

    array_push($buttons, "bkb");
    return $buttons;
}

function add_bkb_shortcode_plugin($plugin_array)
{
    $plugin_array['bkb'] = BWL_KB_PLUGIN_DIR . 'tinymce/bkb_tinymce_button.js';
    return $plugin_array;
}

add_action('wp_ajax_bkb_sc_content', 'bkb_sc_content');
add_action('wp_ajax_nopriv_bkb_sc_content', 'bkb_sc_content');

function bkb_sc_content()
{
?>

<h3>
  BWL Knowledge Base Shortcode Editor
  <span class="btn_bkb_editor_close">X</span>
</h3>

<div id="bkb_editor_popup_content">
  <?php
        global $bkb_data;

        $bkb_tab_items = array(
            'featured' => esc_attr__('Featured KB', 'bwl-kb'),
            'popular' => esc_attr__('Popular KB', 'bwl-kb'),
            'recent' => esc_attr__('Recent KB', 'bwl-kb')
        );

        // WPML FIXING IN VERSION 1.1.8

        if (defined('ICL_SITEPRESS_VERSION')) {

            global $sitepress;
            $current_lang = $sitepress->get_current_language(); //save current language
            $new_lang = (get_transient('WPML_SELECTED_LANG') != "") ? get_transient('WPML_SELECTED_LANG') : 'en';
            $sitepress->switch_lang($new_lang);
        }

        // KB CATEGORY.

        $bkb_category_args = array(
            'taxonomy' => BWL_KB_TAX_CAT,
            'hide_empty' => 1,
            'orderby' => 'title',
            'order' => 'ASC',
            'suppress_filters' => FALSE
        );

        if (defined('BKB_WP_POST')) {

            $bkb_category_args['post_type'] = 'post';
            $bkb_category_args['taxonomy'] = 'category';
        }

        $bkb_categories = get_categories($bkb_category_args);


        // KB Tags

        $bkb_tags_args = array(
            'taxonomy' => BWL_KB_TAX_TAG,
            'hide_empty' => 1,
            'orderby' => 'title',
            'order' => 'ASC',
            'suppress_filters' => FALSE
        );

        if (defined('BKB_WP_POST')) {

            $bkb_tags_args['post_type'] = 'post';
            $bkb_tags_args['taxonomy'] = 'post_tag';
        }

        $bkb_tags = get_categories($bkb_tags_args);

        if (defined('ICL_SITEPRESS_VERSION')) {

            $sitepress->switch_lang($current_lang); //restore previous language
        }
        ?>

  <div class="row">

    <label for="bkb_ajax_sbox"><?php esc_attr_e('Search Box', 'bwl-kb') ?></label>
    <input type="checkbox" id="bkb_ajax_sbox" name="bkb_ajax_sbox" value="1" class="bkb_checkbox" />

  </div> <!-- end row  -->

  <hr class="bkb-shortcode-seperator" />

  <div class="row">

    <label for="bkb_display_tab_status"><?php esc_attr_e('Display Tab Items?', 'bwl-kb') ?></label>
    <input type="checkbox" id="bkb_display_tab_status" name="bkb_display_tab_status" value="1" class="bkb_checkbox" />

  </div> <!-- end row  -->

  <div class="row bkb_dn bkb_tab_row">

    <label for="bkb_tab_items"><?php esc_attr_e('TAB Items', 'bwl-kb'); ?></label>

    <select id="bkb_tab_items" name="bkb_tab_items">

      <?php
                foreach ($bkb_tab_items as $tab_items_key => $tab_items_value) :
                ?>
      <option value="<?php echo $tab_items_key; ?>"><?php echo $tab_items_value; ?></option>

      <?php
                endforeach;
                ?>

    </select>

  </div>

  <div class="row bkb_dn bkb_tab_row">
    <label for="bkb_tab_view_style"><?php esc_attr_e('KB List Settings', 'bwl-kb'); ?></label>

    <select id="bkb_tab_view_style" name="bkb_tab_view_style">
      <option value="" selected>- <?php esc_attr_e('Lists Style', 'bwl-kb'); ?> -</option>
      <option value="rounded"><?php esc_attr_e('Rounded', 'bwl-kb'); ?></option>
      <option value="rectangle"><?php esc_attr_e('Rectangle', 'bwl-kb'); ?></option>
      <option value="iconized"><?php esc_attr_e('Iconized', 'bwl-kb'); ?></option>
      <option value="none"><?php esc_attr_e('None', 'bwl-kb'); ?></option>
    </select>

  </div>

  <div class="row bkb_dn bkb_tab_row">
    <label for="bkb_no_of_tab_items"><?php esc_attr_e('No of Items', 'bwl-kb'); ?></label>
    <input type="text" id="bkb_no_of_tab_items" name="bkb_no_of_tab_items" value="5" style="width: 50px;" /> <small>e.g:
      Any number like 1,2,3 </small>
  </div>

  <hr class="bkb-shortcode-seperator" />

  <div class="row">

    <label for="bkb_display_category_status"><?php esc_attr_e('Display Category Items?', 'bwl-kb') ?></label>
    <input type="checkbox" id="bkb_display_category_status" name="bkb_display_category_status" value="1"
      class="bkb_checkbox" />

  </div> <!-- end row  -->

  <div class="row bkb_dn bkb_cat_row">

    <label for="bkb_category"><?php esc_attr_e('Select Categories', 'bwl-kb'); ?></label>

    <select id="bkb_category" name="bkb_category">

      <?php
                foreach ($bkb_categories as $category) :
                ?>

      <option value="<?php echo $category->slug ?>"><?php echo ucwords($category->name); ?> (
        <?php echo $category->count; ?> )</option>

      <?php
                endforeach;

                wp_reset_query();
                ?>

    </select>

  </div>

  <div class="row bkb_dn bkb_cat_row">
    <label for="bkb_no_of_cat_cols"><?php esc_attr_e('No of Columns', 'bwl-kb'); ?></label>
    <input type="radio" id="bkb_no_of_cat_cols" name="bkb_no_of_cat_cols" value="1" />1 &nbsp;
    <input type="radio" id="bkb_no_of_cat_cols" name="bkb_no_of_cat_cols" value="2" checked="checked" />2 &nbsp;
    <input type="radio" id="bkb_no_of_cat_cols" name="bkb_no_of_cat_cols" value="3" />3
  </div>

  <div class="row bkb_dn bkb_cat_row">
    <label for="bkb_no_of_category_items"><?php esc_attr_e('No of Items', 'bwl-kb'); ?></label>
    <input type="text" id="bkb_no_of_category_items" name="bkb_no_of_category_items" value="" style="width: 50px;" />
    <small>e.g: Any number like 1,2,3 </small>
  </div>

  <div class="row bkb_dn bkb_cat_row">
    <label for="bkb_category_orderby"><?php esc_attr_e('Order Settings', 'bwl-kb'); ?></label>
    <select id="bkb_category_orderby" name="bkb_category_orderby" style="width: 150px;">
      <option value="" selected>- <?php esc_attr_e('Order By', 'bwl-kb'); ?> -</option>
      <option value="ID"><?php esc_attr_e('ID', 'bwl-kb'); ?></option>
      <option value="title"><?php esc_attr_e('Title', 'bwl-kb'); ?></option>
      <option value="date"><?php esc_attr_e('Date', 'bwl-kb'); ?></option>
      <option value="modified"><?php esc_attr_e('Recent Modified', 'bwl-kb'); ?></option>
      <option value="rand"><?php esc_attr_e('Random Order', 'bwl-kb'); ?></option>
      <option value="custom_order"><?php esc_attr_e('Custom Sorting', 'bwl-kb'); ?></option>
    </select>

    <select id="bkb_category_order" name="bkb_category_order" style="width: 150px;">
      <option value="" selected>- <?php esc_attr_e('Order Type', 'bwl-kb'); ?> -</option>
      <option value="ASC"><?php esc_attr_e('Ascending', 'bwl-kb'); ?></option>
      <option value="DESC"><?php esc_attr_e('Descending', 'bwl-kb'); ?></option>
    </select>
  </div>

  <div class="row bkb_dn bkb_cat_row">
    <label for="bkb_category_view_style"><?php esc_attr_e('Display Settings', 'bwl-kb'); ?></label>

    <select id="bkb_category_view_style" name="bkb_category_view_style" style="width: 150px;">
      <option value="" selected>- <?php esc_attr_e('View Type', 'bwl-kb'); ?> -</option>
      <option value="0"><?php esc_attr_e('Lists View', 'bwl-kb'); ?></option>
      <option value="1"><?php esc_attr_e('Boxed View', 'bwl-kb'); ?></option>
    </select>

    <select id="bkb_cat_list_type" name="bkb_cat_list_type" style="width: 150px;">
      <option value="rounded" selected>- <?php esc_attr_e('Lists Style', 'bwl-kb'); ?> -</option>
      <option value="rounded"><?php esc_attr_e('Rounded', 'bwl-kb'); ?> (<?php esc_attr_e('Default', 'bwl-kb'); ?>)
      </option>
      <option value="rectangle"><?php esc_attr_e('Rectangle', 'bwl-kb'); ?></option>
      <option value="iconized"><?php esc_attr_e('Iconized', 'bwl-kb'); ?></option>
      <option value="accordion"><?php esc_attr_e('Accordion', 'bwl-kb'); ?></option>
      <option value="none"><?php esc_attr_e('None', 'bwl-kb'); ?></option>
    </select>
  </div>


  <div class="row bkb_dn bkb_cat_row">

    <label for="bkb_category_posts_count">&nbsp;</label>

    <select id="bkb_category_posts_count" name="bkb_category_posts_count" style="width: 140px;">
      <option value="" selected>- <?php esc_attr_e('Post Count', 'bwl-kb'); ?> -</option>
      <option value="1"><?php esc_attr_e('Yes', 'bwl-kb'); ?></option>
      <option value="0"><?php esc_attr_e('No', 'bwl-kb'); ?></option>
    </select>

    <select id="bkb_display_category_desc" name="bkb_display_category_desc" style="width: 160px;">
      <option value="" selected>- <?php esc_attr_e('Show Description', 'bwl-kb'); ?> -</option>
      <option value="1"><?php esc_attr_e('Yes', 'bwl-kb'); ?></option>
      <option value="0"><?php esc_attr_e('No', 'bwl-kb'); ?></option>
    </select>

  </div> <!-- end row  -->


  <hr class="bkb-shortcode-seperator" />

  <div class="row">

    <label for="bkb_display_tag_status"><?php esc_attr_e('Display Tag Items?', 'bwl-kb') ?></label>
    <input type="checkbox" id="bkb_display_tag_status" name="bkb_display_tag_status" value="1" class="bkb_checkbox" />

  </div> <!-- end row  -->

  <div class="row bkb_dn bkb_tags_row">

    <label for="bkb_tags"><?php esc_attr_e('Select Tags', 'bwl-kb'); ?></label>

    <select id="bkb_tags" name="bkb_tags">

      <?php
                foreach ($bkb_tags as $tags) :
                ?>

      <option value="<?php echo $tags->slug ?>"><?php echo ucwords($tags->name); ?> ( <?php echo $tags->count; ?> )
      </option>

      <?php
                endforeach;

                wp_reset_query();
                ?>

    </select>

  </div>

  <div class="row bkb_dn bkb_tags_row">
    <label for="bkb_no_of_tag_cols"><?php esc_attr_e('No of Columns', 'bwl-kb'); ?></label>
    <input type="radio" id="bkb_no_of_tag_cols" name="bkb_no_of_tag_cols" value="1" />1 &nbsp;
    <input type="radio" id="bkb_no_of_tag_cols" name="bkb_no_of_tag_cols" value="2" checked="checked" />2 &nbsp;
    <input type="radio" id="bkb_no_of_tag_cols" name="bkb_no_of_tag_cols" value="3" />3
  </div>

  <div class="row bkb_dn bkb_tags_row">
    <label for="bkb_no_of_tag_items"><?php esc_attr_e('No of Items', 'bwl-kb'); ?></label>
    <input type="text" id="bkb_no_of_tag_items" name="bkb_no_of_tag_items" value="" style="width: 50px;" /> <small>e.g:
      Any number like 1,2,3 </small>
  </div>

  <div class="row bkb_dn bkb_tags_row">
    <label for="bkb_tag_orderby"><?php esc_attr_e('Order Settings', 'bwl-kb'); ?></label>
    <select id="bkb_tag_orderby" name="bkb_tag_orderby" style="width: 150px;">
      <option value="" selected>- <?php esc_attr_e('Order By', 'bwl-kb'); ?> -</option>
      <option value="ID"><?php esc_attr_e('ID', 'bwl-kb'); ?></option>
      <option value="title"><?php esc_attr_e('Title', 'bwl-kb'); ?></option>
      <option value="date"><?php esc_attr_e('Date', 'bwl-kb'); ?></option>
      <option value="modified"><?php esc_attr_e('Recent Modified', 'bwl-kb'); ?></option>
      <option value="rand"><?php esc_attr_e('Random Order', 'bwl-kb'); ?></option>
      <option value="custom_order"><?php esc_attr_e('Custom Sorting', 'bwl-kb'); ?></option>
    </select>

    <select id="bkb_tag_order" name="bkb_tag_order" style="width: 150px;">
      <option value="" selected>- <?php esc_attr_e('Order Type', 'bwl-kb'); ?> -</option>
      <option value="ASC"><?php esc_attr_e('Ascending', 'bwl-kb'); ?></option>
      <option value="DESC"><?php esc_attr_e('Descending', 'bwl-kb'); ?></option>
    </select>
  </div>

  <div class="row bkb_dn bkb_tags_row">
    <label for="bkb_tag_posts_count"><?php esc_attr_e('Display Settings', 'bwl-kb'); ?></label>

    <select id="bkb_tag_view_style" name="bkb_tag_view_style" style="width: 150px;">
      <option value="" selected>- <?php esc_attr_e('View Type', 'bwl-kb'); ?> -</option>
      <option value="0"><?php esc_attr_e('Lists View', 'bwl-kb'); ?></option>
      <option value="1"><?php esc_attr_e('Boxed View', 'bwl-kb'); ?></option>
    </select>

    <select id="bkb_tag_list_type" name="bkb_tag_list_type" style="width: 150px;">
      <option value="rounded" selected>- <?php esc_attr_e('Lists Style', 'bwl-kb'); ?> -</option>
      <option value="rounded"><?php esc_attr_e('Rounded', 'bwl-kb'); ?> (<?php esc_attr_e('Default', 'bwl-kb'); ?>)
      </option>
      <option value="rectangle"><?php esc_attr_e('Rectangle', 'bwl-kb'); ?></option>
      <option value="iconized"><?php esc_attr_e('Iconized', 'bwl-kb'); ?></option>
      <option value="accordion"><?php esc_attr_e('Accordion', 'bwl-kb'); ?></option>
      <option value="none"><?php esc_attr_e('None', 'bwl-kb'); ?></option>
    </select>
  </div>

  <div class="row bkb_dn bkb_tags_row">

    <label for="bkb_tag_list_type">&nbsp;</label>


    <select id="bkb_tag_posts_count" name="bkb_tag_posts_count" style="width: 140px;">
      <option value="" selected>- <?php esc_attr_e('Post Count', 'bwl-kb'); ?> -</option>
      <option value="1"><?php esc_attr_e('Yes', 'bwl-kb'); ?></option>
      <option value="0"><?php esc_attr_e('No', 'bwl-kb'); ?></option>
    </select>

    <select id="bkb_display_tag_desc" name="bkb_display_tag_desc" style="width: 160px;">
      <option value="" selected>- <?php esc_attr_e('Show Description', 'bwl-kb'); ?> -</option>
      <option value="1"><?php esc_attr_e('Yes', 'bwl-kb'); ?></option>
      <option value="0"><?php esc_attr_e('No', 'bwl-kb'); ?></option>
    </select>

  </div> <!-- end row  -->


  <div id="bkb_editor_popup_buttons">
    <input id="addShortCodebtn" name="addShortCodebtn" class="button-primary" type="button" value="Add Shortcode" />
    <input id="closeShortCodebtn" name="closeShortCodebtn" class="button" type="button" value="Close" />
  </div>

</div>

<?php
    die();
}