;(function ($) {
  // Editor Part

  function bkb_add_sc_action() {
    var $bkb_parent_container = $("#bkb_editor_popup_content")

    /*------------------------------Check Box ---------------------------------*/
    var bkb_display_tab_status = $bkb_parent_container.find("#bkb_display_tab_status"),
      bkb_display_category_status = $bkb_parent_container.find("#bkb_display_category_status"),
      bkb_tab_row = $bkb_parent_container.find(".bkb_tab_row"),
      bkb_cat_row = $bkb_parent_container.find(".bkb_cat_row"),
      bkb_tags_row = $bkb_parent_container.find(".bkb_tags_row"),
      bkb_display_tag_status = $bkb_parent_container.find("#bkb_display_tag_status")

    bkb_display_tab_status.click(function () {
      if (jQuery(this).is(":checked")) {
        bkb_tab_row.slideDown(function () {
          jQuery(this).removeClass("bkb_dn")
          bkb_sc_scroll_manager()
        })
      } else {
        bkb_tab_row.slideUp(function () {
          jQuery(this).addClass("bkb_dn")
          bkb_sc_scroll_manager()
        })
      }
    })

    bkb_display_category_status.click(function () {
      if (jQuery(this).is(":checked")) {
        bkb_cat_row.slideDown(function () {
          jQuery(this).removeClass("bkb_dn")
          bkb_sc_scroll_manager()
        })
      } else {
        bkb_cat_row.slideUp(function () {
          jQuery(this).addClass("bkb_dn")
          bkb_sc_scroll_manager()
        })
      }
    })

    bkb_display_tag_status.click(function () {
      if (jQuery(this).is(":checked")) {
        bkb_tags_row.slideDown(function () {
          jQuery(this).removeClass("bkb_dn")
          bkb_sc_scroll_manager()
        })
      } else {
        bkb_tags_row.slideUp(function () {
          jQuery(this).addClass("bkb_dn")
          bkb_sc_scroll_manager()
        })
      }
    })

    function bkb_sc_scroll_manager() {
      var bkb_is_display_scroll = bkb_display_category_status.is(":checked") && bkb_display_tag_status.is(":checked")

      if (bkb_is_display_scroll == true) {
        $bkb_parent_container.addClass("bkb_overflow")
        $("#bkb_editor_popup").animate(
          {
            scrollTop: $("#bkb_editor_popup_buttons").offset().top,
          },
          2000
        )
      } else {
        $bkb_parent_container.removeClass("bkb_overflow")
      }
    }

    $("#bkb_editor_popup").css({
      "margin-top": "40px",
    })

    $("#addShortCodebtn").click(function (event) {
      // Columns

      // INITIALIZE ALL SHORTCODE TEXT
      var bkb_shortcode = ""
      var sc_bkb_ajax_sbox = ""

      /*---------------------------Generate Search Box Shortcode ------------------------------------*/

      if ($bkb_parent_container.find("#bkb_ajax_sbox").is(":checked")) {
        sc_bkb_ajax_sbox += "[bkb_search /]"
      }

      /*-----------------------------Generate Tab Shortcode ----------------------------------*/

      var sc_bkb_tab = ""

      var sc_bkb_tab_limit_text = ""

      if ($bkb_parent_container.find("#bkb_display_tab_status").is(":checked")) {
        sc_bkb_tab += "[bkb_tabs]"

        /*----------------------------Tab List Style -----------------------------------*/

        if ($bkb_parent_container.find("#bkb_tab_view_style").val().length !== 0 && $bkb_parent_container.find("#bkb_tab_view_style").val() != "") {
          sc_bkb_tab_limit_text += ' bkb_list_type="' + $bkb_parent_container.find("#bkb_tab_view_style").val() + '" '
        }

        /*----------------------------LIMIT -----------------------------------*/

        if ($bkb_parent_container.find("#bkb_no_of_tab_items").val().length !== 0 && !isNaN($bkb_parent_container.find("#bkb_no_of_tab_items").val())) {
          sc_bkb_tab_limit_text += ' limit="' + $bkb_parent_container.find("#bkb_no_of_tab_items").val() + '" '
        }

        /*----------------------------- Conditions ----------------------------------*/

        var selected_bkb_tab = $bkb_parent_container.find("#bkb_tab_items").multipleSelect("getSelects", "text"),
          selected_bkb_tab_slug = $bkb_parent_container.find("#bkb_tab_items").multipleSelect("getSelects")

        if (selected_bkb_tab.length > 0) {
          for (var i = 0; i < selected_bkb_tab.length; i++) {
            if (selected_bkb_tab_slug[i] === "featured") {
              sc_bkb_tab += '[bkb_tab title="' + bkb_string_featured + '"] [bwl_kb bkb_tabify="1" meta_key="bkb_featured_status" meta_value="1" orderby="meta_value_num" order="ASC" ' + sc_bkb_tab_limit_text + "] [/bkb_tab]"
            }

            if (selected_bkb_tab_slug[i] === "popular") {
              sc_bkb_tab += '[bkb_tab title="' + bkb_string_popular + '"] [bwl_kb bkb_tabify="1" meta_key="bkbm_post_views" orderby="meta_value_num" order="DESC"' + sc_bkb_tab_limit_text + "] [/bkb_tab]"
            }

            if (selected_bkb_tab_slug[i] === "recent") {
              sc_bkb_tab += '[bkb_tab title="' + bkb_string_recent + '"] [bwl_kb bkb_tabify="1" orderby="ID" order="DESC" ' + sc_bkb_tab_limit_text + "] [/bkb_tab]"
            }
          }
        }

        sc_bkb_tab += "[/bkb_tabs]"
      }

      /*--------------------------- Generate Category Shortcode ------------------------------------*/

      var sc_bkb_category = ""

      if ($bkb_parent_container.find("#bkb_display_category_status").is(":checked")) {
        sc_bkb_category += "[bkb_category"

        /*----------------------------- Conditions ----------------------------------*/

        var selected_bkb_category = $bkb_parent_container.find("#bkb_category").multipleSelect("getSelects", "text"),
          selected_bkb_category_slug = $bkb_parent_container.find("#bkb_category").multipleSelect("getSelects")

        if (selected_bkb_category.length > 0) {
          sc_bkb_category += ' categories="'

          for (var i = 0; i < selected_bkb_category.length; i++) {
            sc_bkb_category += selected_bkb_category_slug[i] + ","
          }

          sc_bkb_category = sc_bkb_category.substr(0, sc_bkb_category.length - 1) + '"'
        }

        /*----------------------------LIMIT -----------------------------------*/

        if ($bkb_parent_container.find("#bkb_no_of_category_items").val().length !== 0 && !isNaN($bkb_parent_container.find("#bkb_no_of_category_items").val())) {
          sc_bkb_category += ' limit="' + $bkb_parent_container.find("#bkb_no_of_category_items").val() + '" '
        }

        /*----------------------------Order By -----------------------------------*/

        if ($bkb_parent_container.find("#bkb_category_orderby").val().length !== 0) {
          sc_bkb_category += ' orderby="' + $bkb_parent_container.find("#bkb_category_orderby").val() + '" '
        }

        /*----------------------------Order -----------------------------------*/

        if ($bkb_parent_container.find("#bkb_category_order").val().length !== 0) {
          sc_bkb_category += ' order="' + $bkb_parent_container.find("#bkb_category_order").val() + '" '
        }

        /*----------------------------Post Counts -----------------------------------*/

        if ($bkb_parent_container.find("#bkb_category_view_style").val().length !== 0 && $bkb_parent_container.find("#bkb_category_view_style").val() == 1) {
          sc_bkb_category += ' box_view="' + $bkb_parent_container.find("#bkb_category_view_style").val() + '" '
        }

        if ($bkb_parent_container.find("#bkb_display_category_desc").val().length !== 0 && $bkb_parent_container.find("#bkb_display_category_desc").val() == 1) {
          sc_bkb_category += ' bkb_desc="1" '
        }

        /*----------------------------Post Counts -----------------------------------*/

        if ($bkb_parent_container.find("#bkb_category_posts_count").val().length !== 0) {
          sc_bkb_category += ' posts_count="' + $bkb_parent_container.find("#bkb_category_posts_count").val() + '" '
        }

        /*----------------------------Category List Type -----------------------------------*/

        if ($bkb_parent_container.find("#bkb_cat_list_type").val().length !== 0) {
          sc_bkb_category += ' bkb_list_type="' + $bkb_parent_container.find("#bkb_cat_list_type").val() + '" '
        }

        /*----------------------------Cols -----------------------------------*/

        if ($bkb_parent_container.find("#bkb_no_of_cat_cols:checked").length === 1 && $bkb_parent_container.find("#bkb_cat_list_type").val().length !== 0 && $bkb_parent_container.find("#bkb_cat_list_type").val() !== "accordion") {
          sc_bkb_category += ' cols="' + $bkb_parent_container.find("#bkb_no_of_cat_cols:checked").val() + '" '
        }

        sc_bkb_category += " /]"
      }

      /*--------------------------- Generate Tag Shortcode ------------------------------------*/

      var sc_bkb_tag = ""

      if ($bkb_parent_container.find("#bkb_display_tag_status").is(":checked")) {
        sc_bkb_tag += "[bkb_tags"

        /*----------------------------- Conditions ----------------------------------*/

        var selected_bkb_tags = $bkb_parent_container.find("#bkb_tags").multipleSelect("getSelects", "text"),
          selected_bkb_tags_slug = $bkb_parent_container.find("#bkb_tags").multipleSelect("getSelects")

        if (selected_bkb_tags.length > 0) {
          sc_bkb_tag += ' tags="'

          for (var i = 0; i < selected_bkb_tags.length; i++) {
            sc_bkb_tag += selected_bkb_tags_slug[i] + ","
          }

          sc_bkb_tag = sc_bkb_tag.substr(0, sc_bkb_tag.length - 1) + '"'
        }

        /*----------------------------LIMIT -----------------------------------*/

        if ($bkb_parent_container.find("#bkb_no_of_tag_items").val().length !== 0 && !isNaN($bkb_parent_container.find("#bkb_no_of_tag_items").val())) {
          sc_bkb_tag += ' limit="' + $bkb_parent_container.find("#bkb_no_of_tag_items").val() + '" '
        }

        /*----------------------------Order By -----------------------------------*/

        if ($bkb_parent_container.find("#bkb_tag_orderby").val().length !== 0) {
          sc_bkb_tag += ' orderby="' + $bkb_parent_container.find("#bkb_tag_orderby").val() + '" '
        }

        /*----------------------------Order -----------------------------------*/

        if ($bkb_parent_container.find("#bkb_tag_order").val().length !== 0) {
          sc_bkb_tag += ' order="' + $bkb_parent_container.find("#bkb_tag_order").val() + '" '
        }

        /*----------------------------Post Counts -----------------------------------*/

        if ($bkb_parent_container.find("#bkb_tag_posts_count").val().length !== 0) {
          sc_bkb_tag += ' posts_count="' + $bkb_parent_container.find("#bkb_tag_posts_count").val() + '" '
        }

        /*----------------------------Tags List Type -----------------------------------*/

        if ($bkb_parent_container.find("#bkb_tag_view_style").val().length !== 0 && $bkb_parent_container.find("#bkb_tag_view_style").val() == 1) {
          sc_bkb_tag += ' box_view="' + $bkb_parent_container.find("#bkb_tag_view_style").val() + '" '
        }

        if ($bkb_parent_container.find("#bkb_display_tag_desc").val().length !== 0 && $bkb_parent_container.find("#bkb_display_tag_desc").val() == 1) {
          sc_bkb_tag += ' bkb_desc="1" '
        }

        if ($bkb_parent_container.find("#bkb_tag_list_type").val().length !== 0) {
          sc_bkb_tag += ' bkb_list_type="' + $bkb_parent_container.find("#bkb_tag_list_type").val() + '" '
        }

        /*----------------------------Tag -----------------------------------*/

        if ($bkb_parent_container.find("#bkb_no_of_tag_cols:checked").length === 1 && $bkb_parent_container.find("#bkb_tag_list_type").val().length !== 0 && $bkb_parent_container.find("#bkb_tag_list_type").val() !== "accordion") {
          sc_bkb_tag += ' cols="' + $bkb_parent_container.find("#bkb_no_of_tag_cols:checked").val() + '" '
        }

        sc_bkb_tag += " /]"
      }

      /*---------------------------Concate All Shortcodes ------------------------------------*/

      bkb_shortcode += sc_bkb_ajax_sbox + sc_bkb_tab + sc_bkb_category + sc_bkb_tag

      window.send_to_editor(bkb_shortcode)

      $("#bkb_editor_overlay").remove()

      return false
    })

    $("#closeShortCodebtn, .btn_bkb_editor_close").click(function (event) {
      $("#bkb_editor_overlay").remove()
      return false
    })

    /*---------------------------------TAB Items------------------------------*/

    $("select#bkb_tab_items").add("multiple", "multiple")

    $("select#bkb_tab_items").multipleSelect({
      placeholder: "- Select -",
      selectAll: true,
      filter: true,
    })

    $("select#bkb_tab_items").multipleSelect("checkAll")

    /*------------------------------ Category ---------------------------------*/

    $("select#bkb_category").add("multiple", "multiple")

    $("select#bkb_category").multipleSelect({
      placeholder: "- Select -",
      selectAll: true,
      filter: true,
    })

    $("select#bkb_category").multipleSelect("uncheckAll")

    /*------------------------------ Topics ---------------------------------*/

    $("select#bkb_tags").add("multiple", "multiple")

    $("select#bkb_tags").multipleSelect({
      placeholder: "- Select -",
      selectAll: true,
      filter: true,
    })

    $("select#bkb_tags").multipleSelect("uncheckAll")

    // Enable Drag Drop Of Editor

    $("#bkb_editor_popup").draggable({
      cursor: "move",
      drag: function () {
        $(this).css({
          height: "auto",
        })
      },
    })
  }

  function handle_bkb_sc_content() {
    return jQuery.ajax({
      url: ajaxurl,
      type: "POST",
      dataType: "HTML",
      data: {
        action: "bkb_sc_content", // action will be the function name
      },
    })
  }

  tinymce.PluginManager.add("bkb", function (editor, url) {
    // Add Button to Visual Editor Toolbar
    editor.addButton("bkb", {
      title: "BWL Knowledge Base Manager",
      cmd: "bkb",
      image: url + "/icons/bkb-editor.png",
    })

    editor.addCommand("bkb", function () {
      if ($("#shortcode_controle").length) {
        $("#shortcode_controle").remove()
      } else {
        var bkb_sc_loading_icon = '<img src="' + url + '/icons/load_icon.gif" class="bkb_sc_load_icon"></img>'

        $("body").append('<div id="bkb_editor_overlay"><div id="bkb_editor_popup">' + bkb_sc_loading_icon + "</div></div>")

        $.when(handle_bkb_sc_content()).done(function (data) {
          $("#bkb_editor_popup").html("").html(data).draggable({ cursor: "move" })
          bkb_add_sc_action()

          $("#bkb_editor_popup").css("margin-top", $(window).height() / 2 - $("#bkb_editor_popup").height() / 2)

          $(window).resize(function () {
            $("#bkb_editor_popup").css("margin-top", $(window).height() / 2 - $("#bkb_editor_popup").height() / 2)
          })
        })
      }

      return
    })
  })
})(jQuery)
